"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsUrlState = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _esQuery = require("@kbn/es-query");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana_timefilter_time = require("../../../../hooks/use_kibana_timefilter_time");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY = {
  language: 'kuery',
  query: ''
};
const DEFAULT_FROM_MINUTES_VALUE = 15;
const INITIAL_DATE_RANGE = {
  from: `now-${DEFAULT_FROM_MINUTES_VALUE}m`,
  to: 'now'
};
const INITIAL_HOSTS_STATE = {
  query: DEFAULT_QUERY,
  filters: [],
  panelFilters: [],
  dateRange: INITIAL_DATE_RANGE,
  limit: _constants.DEFAULT_HOST_LIMIT
};
const reducer = (state, action) => {
  switch (action.type) {
    case 'SET_DATE_RANGE':
      return {
        ...state,
        dateRange: action.dateRange
      };
    case 'SET_LIMIT':
      return {
        ...state,
        limit: action.limit
      };
    case 'SET_FILTERS':
      return {
        ...state,
        filters: action.filters
      };
    case 'SET_QUERY':
      return {
        ...state,
        query: action.query
      };
    case 'SET_PANEL_FILTERS':
      return {
        ...state,
        panelFilters: action.panelFilters
      };
    default:
      return state;
  }
};
const useHostsUrlState = () => {
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(INITIAL_DATE_RANGE);
  const [localStorageHostLimit, setLocalStorageHostLimit] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_HOST_LIMIT_KEY, INITIAL_HOSTS_STATE.limit);
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: {
      ...INITIAL_HOSTS_STATE,
      dateRange: getTime(),
      limit: localStorageHostLimit !== null && localStorageHostLimit !== void 0 ? localStorageHostLimit : INITIAL_HOSTS_STATE.limit
    },
    decodeUrlState,
    encodeUrlState,
    urlStateKey: '_a',
    writeDefaultState: true
  });
  const [search, setSearch] = (0, _react.useReducer)(reducer, urlState);
  if (!(0, _fastDeepEqual.default)(search, urlState)) {
    setUrlState(search);
    if (localStorageHostLimit !== search.limit) {
      setLocalStorageHostLimit(search.limit);
    }
  }
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(INITIAL_DATE_RANGE, urlState.dateRange, dateRange => setSearch({
    type: 'SET_DATE_RANGE',
    dateRange
  }));
  return [search, setSearch];
};
exports.useHostsUrlState = useHostsUrlState;
const HostsFilterRT = rt.intersection([rt.type({
  meta: rt.partial({
    alias: rt.union([rt.null, rt.string]),
    disabled: rt.boolean,
    negate: rt.boolean,
    controlledBy: rt.string,
    group: rt.string,
    index: rt.string,
    isMultiIndex: rt.boolean,
    type: rt.string,
    key: rt.string,
    params: rt.any,
    value: rt.any
  })
}), rt.partial({
  query: rt.record(rt.string, rt.any),
  $state: rt.type({
    store: (0, _securitysolutionIoTsTypes.enumeration)('FilterStateStore', _esQuery.FilterStateStore)
  })
})]);
const HostsFiltersRT = rt.array(HostsFilterRT);
const HostsQueryStateRT = rt.type({
  language: rt.string,
  query: rt.union([rt.string, rt.record(rt.string, rt.any)])
});
const StringDateRangeRT = rt.intersection([rt.type({
  from: rt.string,
  to: rt.string
}), rt.partial({
  mode: rt.union([rt.literal('absolute'), rt.literal('relative')])
})]);
const HostsStateRT = rt.type({
  filters: HostsFiltersRT,
  panelFilters: HostsFiltersRT,
  query: HostsQueryStateRT,
  dateRange: StringDateRangeRT,
  limit: rt.number
});
const encodeUrlState = HostsStateRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(HostsStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};