"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsCharts = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsCharts = ({
  dataViewId
}) => {
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('host');
    const {
      cpu,
      disk,
      memory,
      network
    } = await model.metrics.getCharts();
    return [cpu.xy.cpuUsage, cpu.xy.normalizedLoad1m, memory.xy.memoryUsage, memory.xy.memoryFree, disk.xy.diskSpaceAvailable, disk.xy.diskIORead, disk.xy.diskIOWrite, disk.xy.diskReadThroughput, disk.xy.diskWriteThroughput, network.xy.rx, network.xy.tx].map(chart => ({
      ...chart,
      layers: chart.layers.map(layer => layer.type === 'series' ? {
        ...layer,
        breakdown: {
          type: 'topValues',
          field: 'host.name',
          size: _constants.PAGE_SIZE_OPTIONS.at(-1)
        }
      } : layer),
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId]);
  return charts;
};
exports.useMetricsCharts = useMetricsCharts;