"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsViewContext = exports.useHostsView = exports.HostsViewProvider = exports.HostsView = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_unified_search = require("./use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_TABLE_METRICS = ['cpuV2', 'diskSpaceUsage', 'memory', 'memoryFree', 'normalizedLoad1m', 'rxV2', 'txV2'];
const BASE_INFRA_METRICS_PATH = '/api/metrics/infra';
const useHostsView = () => {
  var _data$nodes;
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    buildQuery,
    parsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const payload = (0, _react.useMemo)(() => JSON.stringify(createInfraMetricsRequest({
    dateRange: parsedDateRange,
    esQuery: buildQuery(),
    limit: searchCriteria.limit
  })), [buildQuery, parsedDateRange, searchCriteria.limit]);
  const {
    data,
    error,
    status
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const start = performance.now();
    const metricsResponse = await callApi(`${BASE_INFRA_METRICS_PATH}/host`, {
      method: 'POST',
      body: payload
    });
    const duration = performance.now() - start;
    telemetry.reportPerformanceMetricEvent('infra_hosts_table_load', duration, {
      key1: 'data_load',
      value1: duration
    }, {
      limit: searchCriteria.limit
    });
    return metricsResponse;
  }, [payload, searchCriteria.limit, telemetry]);
  return {
    loading: (0, _use_fetcher.isPending)(status),
    error,
    hostNodes: (_data$nodes = data === null || data === void 0 ? void 0 : data.nodes) !== null && _data$nodes !== void 0 ? _data$nodes : []
  };
};
exports.useHostsView = useHostsView;
const HostsView = exports.HostsView = (0, _constate.default)(useHostsView);
const [HostsViewProvider, useHostsViewContext] = HostsView;

/**
 * Helpers
 */
exports.useHostsViewContext = useHostsViewContext;
exports.HostsViewProvider = HostsViewProvider;
const createInfraMetricsRequest = ({
  esQuery,
  dateRange,
  limit
}) => ({
  query: esQuery,
  from: dateRange.from,
  to: dateRange.to,
  metrics: HOST_TABLE_METRICS,
  limit
});