"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamPageContentProviders = void 0;
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/logs-shared-plugin/public");
var _log_flyout = require("../../../containers/logs/log_flyout");
var _log_view_configuration = require("../../../containers/logs/log_view_configuration");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewLogInContext = ({
  children
}) => {
  const {
    startTimestamp,
    endTimestamp
  } = (0, _public.useLogPositionStateContext)();
  const {
    logViewReference
  } = (0, _public.useLogViewContext)();
  if (!startTimestamp || !endTimestamp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_view_log_in_context.ViewLogInContextProvider, {
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    logViewReference: logViewReference
  }, children);
};
const LogEntriesStateProvider = ({
  children,
  logStreamPageState
}) => {
  const {
    logViewReference
  } = (0, _public.useLogViewContext)();
  const {
    startTimestamp,
    endTimestamp,
    targetPosition
  } = (0, _public.useLogPositionStateContext)();
  const {
    context: {
      parsedQuery
    }
  } = logStreamPageState;

  // Don't render anything if the date range is incorrect.
  if (!startTimestamp || !endTimestamp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.LogStreamProvider, {
    logViewReference: logViewReference,
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp,
    query: parsedQuery,
    center: targetPosition !== null && targetPosition !== void 0 ? targetPosition : undefined
  }, children);
};
const LogHighlightsState = ({
  children,
  logStreamPageState
}) => {
  const {
    logViewReference,
    logView
  } = (0, _public.useLogViewContext)();
  const {
    topCursor,
    bottomCursor,
    entries
  } = (0, _public.useLogStreamContext)();
  const serializedParsedQuery = (0, _react.useMemo)(() => (0, _jsonStableStringify.default)(logStreamPageState.context.parsedQuery), [logStreamPageState.context.parsedQuery]);
  const highlightsProps = {
    logViewReference,
    sourceVersion: logView === null || logView === void 0 ? void 0 : logView.version,
    entriesStart: topCursor,
    entriesEnd: bottomCursor,
    centerCursor: entries.length > 0 ? entries[Math.floor(entries.length / 2)].cursor : null,
    size: entries.length,
    filterQuery: serializedParsedQuery
  };
  return /*#__PURE__*/_react.default.createElement(_public.LogHighlightsStateProvider, highlightsProps, children);
};
const LogStreamPageContentProviders = ({
  children,
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  return /*#__PURE__*/_react.default.createElement(_log_view_configuration.LogViewConfigurationProvider, null, /*#__PURE__*/_react.default.createElement(_log_flyout.LogEntryFlyoutProvider, null, /*#__PURE__*/_react.default.createElement(_public.LogPositionStateProvider, {
    logStreamPageState: logStreamPageState,
    logStreamPageCallbacks: logStreamPageCallbacks
  }, /*#__PURE__*/_react.default.createElement(ViewLogInContext, null, /*#__PURE__*/_react.default.createElement(LogEntriesStateProvider, {
    logStreamPageState: logStreamPageState
  }, /*#__PURE__*/_react.default.createElement(LogHighlightsState, {
    logStreamPageState: logStreamPageState
  }, children))))));
};
exports.LogStreamPageContentProviders = LogStreamPageContentProviders;