"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSourceConfigurationFormErrors = exports.LogSourceConfigurationFormError = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogSourceConfigurationFormErrors = ({
  errors
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "danger",
  iconType: "warning",
  title: logSourceConfigurationFormErrorsCalloutTitle
}, /*#__PURE__*/_react.default.createElement("ul", null, errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement("li", {
  key: errorIndex
}, /*#__PURE__*/_react.default.createElement(LogSourceConfigurationFormError, {
  error: error
})))));
exports.LogSourceConfigurationFormErrors = LogSourceConfigurationFormErrors;
const LogSourceConfigurationFormError = ({
  error
}) => {
  if (error.type === 'generic') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.message);
  } else if (error.type === 'empty_field') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.emptyFieldErrorMessage",
      defaultMessage: "The field ''{fieldName}'' must not be empty.",
      values: {
        fieldName: error.fieldName
      }
    });
  } else if (error.type === 'includes_spaces') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.includesSpacesErrorMessage",
      defaultMessage: "The field ''{fieldName}'' must not include spaces.",
      values: {
        fieldName: error.fieldName
      }
    });
  } else if (error.type === 'empty_column_list') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.emptyColumnListErrorMessage",
      defaultMessage: "The column list must not be empty."
    });
  } else if (error.type === 'child') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.childFormElementErrorMessage",
      defaultMessage: "At least one form field is in an invalid state."
    });
  } else if (error.type === 'missing_timestamp_field') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.missingTimestampFieldErrorMessage",
      defaultMessage: "The data view must be time-based."
    });
  } else if (error.type === 'missing_message_field') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.missingMessageFieldErrorMessage",
      defaultMessage: "The data view must contain a {messageField} field.",
      values: {
        messageField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "message")
      }
    });
  } else if (error.type === 'invalid_message_field_type') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.invalidMessageFieldTypeErrorMessage",
      defaultMessage: "The {messageField} field must be a text field.",
      values: {
        messageField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "message")
      }
    });
  } else if (error.type === 'rollup_index_pattern') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.rollupIndexPatternErrorMessage",
      defaultMessage: "The data view must not be a rollup index pattern."
    });
  } else if (error.type === 'missing_index_pattern') {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.missingDataViewErrorMessage",
      defaultMessage: "The data view {dataViewId} must exist.",
      values: {
        dataViewId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.indexPatternId)
      }
    });
  } else {
    return null;
  }
};
exports.LogSourceConfigurationFormError = LogSourceConfigurationFormError;
const logSourceConfigurationFormErrorsCalloutTitle = _i18n.i18n.translate('xpack.infra.logSourceConfiguration.logSourceConfigurationFormErrorsCalloutTitle', {
  defaultMessage: 'Inconsistent source configuration'
});