"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateMachinePlayground = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/logs-shared-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateMachinePlayground = () => {
  const {
    changeLogViewReference,
    revertToDefaultLogView,
    update,
    isLoading,
    logViewStateService
  } = (0, _public.useLogViewContext)();
  const switchToInlineLogView = (0, _react.useCallback)(() => {
    changeLogViewReference({
      type: 'log-view-inline',
      id: 'playground-log-view',
      attributes: {
        name: 'playground-log-view-name',
        description: 'from the state machine playground',
        logIndices: {
          type: 'index_name',
          indexName: 'logs-*'
        },
        logColumns: [{
          fieldColumn: {
            id: 'playground-field-column',
            field: 'event.dataset'
          }
        }]
      }
    });
  }, [changeLogViewReference]);
  const updateLogView = (0, _react.useCallback)(() => {
    update({
      name: 'Updated playground name'
    });
  }, [update]);
  const persistInlineLogView = (0, _react.useCallback)(() => {
    logViewStateService.send({
      type: 'PERSIST_INLINE_LOG_VIEW'
    });
  }, [logViewStateService]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && 'Is loading', /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => switchToInlineLogView()
  }, 'Switch to inline Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => persistInlineLogView()
  }, 'Persist inline Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => revertToDefaultLogView()
  }, 'Revert to default (persisted) Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => updateLogView()
  }, 'Update log view'));
};
exports.StateMachinePlayground = StateMachinePlayground;