"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceErrorPage = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _error_page = require("./error_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceErrorPage = ({
  errorMessage,
  retry
}) => /*#__PURE__*/_react.default.createElement(_error_page.ErrorPage, {
  shortMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceErrorPage.failedToLoadDataSourcesMessage",
    defaultMessage: "Failed to load data sources."
  }),
  detailedMessage: /*#__PURE__*/_react.default.createElement("pre", null, /*#__PURE__*/_react.default.createElement("code", null, errorMessage)),
  retry: retry
});
exports.SourceErrorPage = SourceErrorPage;