"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSearchControls = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var React = _interopRequireWildcard(require("react"));
var _log_search_buttons = require("./log_search_buttons");
var _log_search_input = require("./log_search_input");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogSearchControls extends React.PureComponent {
  render() {
    const {
      className,
      clearSearch,
      isLoadingSearchResults,
      previousSearchResult,
      nextSearchResult,
      jumpToTarget,
      search
    } = this.props;
    const classes = (0, _classnames.default)('searchControls', className);
    return /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      justifyContent: "flexStart",
      className: classes
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_log_search_input.LogSearchInput, {
      isLoading: isLoadingSearchResults,
      onClear: clearSearch,
      onSearch: search
    })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(_log_search_buttons.LogSearchButtons, {
      previousSearchResult: previousSearchResult,
      nextSearchResult: nextSearchResult,
      jumpToTarget: jumpToTarget
    })));
  }
}
exports.LogSearchControls = LogSearchControls;