"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSearchButtons = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var React = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogSearchButtons extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleJumpToPreviousSearchResult", () => {
      const {
        jumpToTarget,
        previousSearchResult
      } = this.props;
      if (previousSearchResult) {
        jumpToTarget(previousSearchResult);
      }
    });
    (0, _defineProperty2.default)(this, "handleJumpToNextSearchResult", () => {
      const {
        jumpToTarget,
        nextSearchResult
      } = this.props;
      if (nextSearchResult) {
        jumpToTarget(nextSearchResult);
      }
    });
  }
  render() {
    const {
      className,
      previousSearchResult,
      nextSearchResult
    } = this.props;
    const classes = (0, _classnames.default)('searchButtons', className);
    const hasPreviousSearchResult = !!previousSearchResult;
    const hasNextSearchResult = !!nextSearchResult;
    return /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      className: classes,
      gutterSize: "xs"
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraPreviousButton",
      onClick: this.handleJumpToPreviousSearchResult,
      iconType: "arrowLeft",
      iconSide: "left",
      isDisabled: !hasPreviousSearchResult,
      size: "s"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.search.previousButtonLabel",
      defaultMessage: "Previous"
    }))), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraNextButton",
      onClick: this.handleJumpToNextSearchResult,
      iconType: "arrowRight",
      iconSide: "right",
      isDisabled: !hasNextSearchResult,
      size: "s"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.search.nextButtonLabel",
      defaultMessage: "Next"
    }))));
  }
}
exports.LogSearchButtons = LogSearchButtons;