"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchMarkers = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _d3Scale = require("d3-scale");
var React = _interopRequireWildcard(require("react"));
var _search_marker = require("./search_marker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchMarkers extends React.PureComponent {
  render() {
    const {
      buckets,
      start,
      end,
      width,
      height,
      jumpToTarget,
      className
    } = this.props;
    const classes = (0, _classnames.default)('minimapSearchMarkers', className);
    if (start >= end || height <= 0 || Object.keys(buckets).length <= 0) {
      return null;
    }
    const yScale = (0, _d3Scale.scaleTime)().domain([start, end]).range([0, height]);
    return /*#__PURE__*/React.createElement("g", {
      transform: `translate(${width / 2}, 0)`,
      className: classes
    }, buckets.map(bucket => {
      var _yScale, _yScale2;
      return /*#__PURE__*/React.createElement("g", {
        key: `${bucket.representativeKey.time}:${bucket.representativeKey.tiebreaker}`,
        transform: `translate(0, ${yScale(bucket.start)})`
      }, /*#__PURE__*/React.createElement(_search_marker.SearchMarker, {
        bucket: bucket,
        height: ((_yScale = yScale(bucket.end)) !== null && _yScale !== void 0 ? _yScale : 0) - ((_yScale2 = yScale(bucket.start)) !== null && _yScale2 !== void 0 ? _yScale2 : 0),
        width: width,
        jumpToTarget: jumpToTarget
      }));
    }));
  }
}
exports.SearchMarkers = SearchMarkers;