"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogHighlightsMenu = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_visibility_state = require("../../hooks/use_visibility_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogHighlightsMenu = ({
  onChange,
  isLoading,
  activeHighlights,
  hasPreviousHighlight,
  goToPreviousHighlight,
  hasNextHighlight,
  goToNextHighlight
}) => {
  const {
    isVisible: isPopoverOpen,
    hide: closePopover,
    toggle: togglePopover
  } = (0, _use_visibility_state.useVisibilityState)(false);

  // Input field state
  const [highlightTerm, _setHighlightTerm] = (0, _react.useState)('');
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChange, 275), [onChange]);
  const setHighlightTerm = (0, _react.useCallback)(valueOrUpdater => _setHighlightTerm(previousHighlightTerm => {
    const newHighlightTerm = typeof valueOrUpdater === 'function' ? valueOrUpdater(previousHighlightTerm) : valueOrUpdater;
    if (newHighlightTerm !== previousHighlightTerm) {
      debouncedOnChange([newHighlightTerm]);
    }
    return newHighlightTerm;
  }), [debouncedOnChange]);
  const changeHighlightTerm = (0, _react.useCallback)(e => {
    const value = e.target.value;
    setHighlightTerm(value);
  }, [setHighlightTerm]);
  const clearHighlightTerm = (0, _react.useCallback)(() => setHighlightTerm(''), [setHighlightTerm]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraLogHighlightsMenuButton",
    color: "text",
    size: "xs",
    iconType: "brush",
    onClick: togglePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.highlights.highlightsPopoverButtonLabel",
    defaultMessage: "Highlights"
  }), activeHighlights ? /*#__PURE__*/_react.default.createElement(ActiveHighlightsIndicator, null) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(LogHighlightsMenuContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraLogHighlightsMenuFieldText",
    placeholder: termsFieldLabel,
    fullWidth: true,
    value: highlightTerm,
    onChange: changeHighlightTerm,
    isLoading: isLoading,
    "aria-label": termsFieldLabel
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraLogHighlightsMenuButton",
    "aria-label": goToPreviousHighlightLabel,
    iconType: "arrowUp",
    onClick: goToPreviousHighlight,
    title: goToPreviousHighlightLabel,
    isDisabled: !hasPreviousHighlight
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraLogHighlightsMenuButton",
    "aria-label": goToNextHighlightLabel,
    iconType: "arrowDown",
    onClick: goToNextHighlight,
    title: goToNextHighlightLabel,
    isDisabled: !hasNextHighlight
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraLogHighlightsMenuButton",
    "aria-label": clearTermsButtonLabel,
    color: "danger",
    isDisabled: highlightTerm === '',
    iconType: "trash",
    onClick: clearHighlightTerm,
    title: clearTermsButtonLabel
  })))));
};
exports.LogHighlightsMenu = LogHighlightsMenu;
const termsFieldLabel = _i18n.i18n.translate('xpack.infra.logs.highlights.highlightTermsFieldLabel', {
  defaultMessage: 'Terms to highlight'
});
const clearTermsButtonLabel = _i18n.i18n.translate('xpack.infra.logs.highlights.clearHighlightTermsButtonLabel', {
  defaultMessage: 'Clear terms to highlight'
});
const goToPreviousHighlightLabel = _i18n.i18n.translate('xpack.infra.logs.highlights.goToPreviousHighlightButtonLabel', {
  defaultMessage: 'Jump to previous highlight'
});
const goToNextHighlightLabel = _i18n.i18n.translate('xpack.infra.logs.highlights.goToNextHighlightButtonLabel', {
  defaultMessage: 'Jump to next highlight'
});
const ActiveHighlightsIndicator = (0, _common.euiStyled)(_eui.EuiIcon).attrs(({
  theme
}) => ({
  type: 'checkInCircleFilled',
  size: 'm',
  color: theme === null || theme === void 0 ? void 0 : theme.eui.euiColorAccent
}))`
  padding-left: ${props => props.theme.eui.euiSizeXS};
`;
const LogHighlightsMenuContent = _common.euiStyled.div`
  width: 300px;
`;