"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewsContext = exports.DataViewsProvider = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _constate = _interopRequireDefault(require("constate"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _metrics_source = require("../../../containers/metrics_source");
var _use_log_view_reference = require("../../../hooks/use_log_view_reference");
var _use_asset_details_render_props = require("./use_asset_details_render_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViews = () => {
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metricsView,
    loading: metricsDataViewLoading
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    logViewReference,
    getLogsDataView,
    loading: logsReferenceLoading
  } = (0, _use_log_view_reference.useLogViewReference)({
    id: 'asset-details-logs-view',
    name: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.logs.assetLogsWidgetName', {
      defaultMessage: 'Logs from {type} "{name}"',
      values: {
        name: asset.name,
        type: (0, _common.findInventoryModel)(asset.type).singularDisplayName
      }
    })
  });
  const {
    value: logsDataView,
    loading: logsDataViewLoading
  } = (0, _useAsync.default)(() => getLogsDataView(logViewReference), [logViewReference, getLogsDataView]);
  return {
    metrics: {
      dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference,
      loading: metricsDataViewLoading
    },
    logs: {
      dataView: logsDataView,
      reference: logViewReference,
      loading: logsReferenceLoading || logsDataViewLoading
    }
  };
};
const [DataViewsProvider, useDataViewsContext] = (0, _constate.default)(useDataViews);
exports.useDataViewsContext = useDataViewsContext;
exports.DataViewsProvider = DataViewsProvider;