"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateUniqueKey = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateUniqueKey = criterion => {
  const metric = criterion.metric ? `(${criterion.metric})` : '';
  return criterion.aggType + metric + criterion.comparator + criterion.threshold.join(',');
};
exports.generateUniqueKey = generateUniqueKey;