"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteApi = createChatCompleteApi;
var _callback_api = require("./callback_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteApi({
  request,
  actions,
  logger,
  anonymizationRulesPromise,
  regexWorker,
  esClient
}) {
  const callbackApi = (0, _callback_api.createChatCompleteCallbackApi)({
    request,
    actions,
    logger,
    anonymizationRulesPromise,
    regexWorker,
    esClient
  });
  return options => {
    const {
      connectorId,
      stream,
      abortSignal,
      retryConfiguration,
      maxRetries,
      ...rest
    } = options;
    return callbackApi({
      connectorId,
      stream,
      abortSignal,
      retryConfiguration,
      maxRetries
    }, () => {
      return rest;
    });
  };
}