"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorProvider = exports.getConnectorPlatform = exports.getConnectorFamily = exports.getConnectorDefaultModel = void 0;
var _model_provider = require("../model_provider");
var _connectors = require("./connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the default model as defined in the connector's config, if available.
 *
 * Note: preconfigured connectors only expose their config if their `exposeConfig` flag
 * is set to true.
 */
const getConnectorDefaultModel = connector => {
  var _connector$config$def, _connector$config, _connector$config$pro, _connector$config2, _connector$config2$pr;
  switch (connector.type) {
    case _connectors.InferenceConnectorType.OpenAI:
    case _connectors.InferenceConnectorType.Gemini:
    case _connectors.InferenceConnectorType.Bedrock:
      return (_connector$config$def = (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.defaultModel) !== null && _connector$config$def !== void 0 ? _connector$config$def : undefined;
    case _connectors.InferenceConnectorType.Inference:
      return (_connector$config$pro = (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : (_connector$config2$pr = _connector$config2.providerConfig) === null || _connector$config2$pr === void 0 ? void 0 : _connector$config2$pr.model_id) !== null && _connector$config$pro !== void 0 ? _connector$config$pro : undefined;
  }
};

/**
 * Returns the provider used for the given connector
 *
 * Inferred from the type for "legacy" connectors,
 * and from the provider config field for inference connectors.
 */
exports.getConnectorDefaultModel = getConnectorDefaultModel;
const getConnectorProvider = connector => {
  switch (connector.type) {
    case _connectors.InferenceConnectorType.OpenAI:
      return _model_provider.ModelProvider.OpenAI;
    case _connectors.InferenceConnectorType.Gemini:
      return _model_provider.ModelProvider.Google;
    case _connectors.InferenceConnectorType.Bedrock:
      return _model_provider.ModelProvider.Anthropic;
    case _connectors.InferenceConnectorType.Inference:
      return _model_provider.ModelProvider.Elastic;
  }
};

/**
 * Returns the platform for the given connector
 */
exports.getConnectorProvider = getConnectorProvider;
const getConnectorPlatform = connector => {
  var _connector$config3, _connector$config4;
  switch (connector.type) {
    case _connectors.InferenceConnectorType.OpenAI:
      return ((_connector$config3 = connector.config) === null || _connector$config3 === void 0 ? void 0 : _connector$config3.apiProvider) === 'OpenAI' ? _model_provider.ModelPlatform.OpenAI : ((_connector$config4 = connector.config) === null || _connector$config4 === void 0 ? void 0 : _connector$config4.apiProvider) === 'Azure OpenAI' ? _model_provider.ModelPlatform.AzureOpenAI : _model_provider.ModelPlatform.Other;
    case _connectors.InferenceConnectorType.Gemini:
      return _model_provider.ModelPlatform.GoogleVertex;
    case _connectors.InferenceConnectorType.Bedrock:
      return _model_provider.ModelPlatform.AmazonBedrock;
    case _connectors.InferenceConnectorType.Inference:
      return _model_provider.ModelPlatform.Elastic;
  }
};
exports.getConnectorPlatform = getConnectorPlatform;
const getConnectorFamily = (connector, _modelName) => {
  const provider = getConnectorProvider(connector);
  switch (provider) {
    case _model_provider.ModelProvider.Anthropic:
    case _model_provider.ModelProvider.Elastic:
      return _model_provider.ModelFamily.Claude;
    case _model_provider.ModelProvider.Google:
      return _model_provider.ModelFamily.Gemini;
    case _model_provider.ModelProvider.OpenAI:
      return _model_provider.ModelFamily.GPT;
  }
  return _model_provider.ModelFamily.GPT;
};
exports.getConnectorFamily = getConnectorFamily;