"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _component_templates = require("../../component_templates");
var _shared_imports = require("../../mappings_editor/shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepComponents.stepTitle",
    defaultMessage: "Component templates (optional)"
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepComponents.componentsDescription",
    defaultMessage: "Component templates let you save index settings, mappings and aliases and inherit from them in index templates."
  })
};
const StepComponents = ({
  defaultValue,
  onChange,
  esDocsBase
}) => {
  const [state, setState] = (0, _react.useState)({
    isLoadingComponents: true,
    components: []
  });
  const onComponentsLoaded = (0, _react.useCallback)(components => {
    setState({
      isLoadingComponents: false,
      components
    });
  }, []);
  const onComponentSelectionChange = (0, _react.useCallback)(components => {
    onChange({
      isValid: true,
      validate: async () => true,
      getData: () => components.length > 0 ? components : undefined
    });
  }, [onChange]);
  const showHeader = state.isLoadingComponents === true || state.components.length > 0;
  const docUri = _shared_imports.documentationService.getIndicesComponentTemplate();
  const renderHeader = () => {
    if (!showHeader) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "stepTitle"
    }, i18nTexts.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: docUri,
      target: "_blank",
      iconType: "question"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.formWizard.stepComponents.docsButtonLabel",
      defaultMessage: "Component templates docs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepComponents"
  }, renderHeader(), /*#__PURE__*/_react.default.createElement(_component_templates.ComponentTemplatesSelector, {
    defaultValue: defaultValue,
    onChange: onComponentSelectionChange,
    onComponentsLoaded: onComponentsLoaded,
    docUri: docUri,
    emptyPrompt: {
      text: i18nTexts.description,
      showCreateButton: false
    }
  }));
};
exports.StepComponents = StepComponents;