"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorToggleControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mappings_state_context = require("../../mappings_state_context");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* TODO: Review toggle controls UI */
const EditorToggleControls = ({
  editor
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fieldsJsonEditor
  } = (0, _mappings_state_context.useMappingsState)();
  const [showMaxDepthWarning, setShowMaxDepthWarning] = _react.default.useState(false);
  const [showValidityWarning, setShowValidityWarning] = _react.default.useState(false);
  const clearWarnings = () => {
    if (showMaxDepthWarning) {
      setShowMaxDepthWarning(false);
    }
    if (showValidityWarning) {
      setShowValidityWarning(false);
    }
  };
  if (editor === 'default') {
    clearWarnings();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        dispatch({
          type: 'documentField.changeEditor',
          value: 'json'
        });
      }
    }, "Use JSON Editor");
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => {
      clearWarnings();
      const {
        isValid
      } = fieldsJsonEditor;
      if (!isValid) {
        setShowValidityWarning(true);
      } else {
        const deNormalizedFields = fieldsJsonEditor.format();
        const {
          maxNestedDepth
        } = (0, _lib.normalize)(deNormalizedFields);
        const canUseDefaultEditor = (0, _lib.canUseMappingsEditor)(maxNestedDepth);
        if (canUseDefaultEditor) {
          dispatch({
            type: 'documentField.changeEditor',
            value: 'default'
          });
        } else {
          setShowMaxDepthWarning(true);
        }
      }
    }
  }, "Use Mappings Editor"), showMaxDepthWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, "Max depth for Mappings Editor exceeded") : null, showValidityWarning && !fieldsJsonEditor.isValid ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, "JSON is invalid") : null);
};
exports.EditorToggleControls = EditorToggleControls;