"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _shared_imports = require("../../../shared_imports");
var _api = require("../../services/api");
var _policies = require("../../lib/policies");
var _constants2 = require("../../constants");
var _edit_policy = require("./edit_policy");
var _edit_policy_context = require("./edit_policy_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditPolicy = ({
  match: {
    params: {
      policyName
    }
  }
}) => {
  var _existingPolicy$polic;
  const {
    services: {
      breadcrumbService,
      license
    }
  } = (0, _shared_imports.useKibana)();
  const {
    error,
    isLoading,
    data: policies,
    resendRequest
  } = (0, _api.useLoadPoliciesList)();
  (0, _react.useEffect)(() => {
    breadcrumbService.setBreadcrumbs('editPolicy');
  }, [breadcrumbService]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.policiesLoading",
        defaultMessage: "Loading policies..."
      })
    });
  }
  if (error || !policies) {
    const {
      statusCode,
      message
    } = error ? error : {
      statusCode: '',
      message: ''
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.lifecyclePoliciesLoadingFailedTitle",
        defaultMessage: "Unable to load existing lifecycle policies"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, message, " (", statusCode, ")"),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.lifecyclePoliciesReloadButton",
        defaultMessage: "Try again"
      }))
    });
  }
  const existingPolicy = (0, _policies.getPolicyByName)(policies, (0, _shared_imports.attemptToURIDecode)(policyName));
  return /*#__PURE__*/_react.default.createElement(_edit_policy_context.EditPolicyContextProvider, {
    value: {
      isNewPolicy: !(existingPolicy !== null && existingPolicy !== void 0 && existingPolicy.policy),
      policyName: (0, _shared_imports.attemptToURIDecode)(policyName),
      policy: (_existingPolicy$polic = existingPolicy === null || existingPolicy === void 0 ? void 0 : existingPolicy.policy) !== null && _existingPolicy$polic !== void 0 ? _existingPolicy$polic : _constants2.defaultPolicy,
      existingPolicies: policies,
      license: {
        canUseSearchableSnapshot: () => license.hasAtLeast(_constants.MIN_SEARCHABLE_SNAPSHOT_LICENSE)
      },
      indices: existingPolicy && existingPolicy.indices ? existingPolicy.indices : [],
      indexTemplates: existingPolicy && existingPolicy.indexTemplates ? existingPolicy.indexTemplates : []
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_policy.EditPolicy, null));
};
exports.EditPolicy = EditPolicy;