"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeUnits = exports.isUsingDownsamplePath = exports.isUsingDefaultRolloverPath = exports.isUsingCustomRolloverPath = exports.byteSizeUnits = exports.ROLLOVER_FORM_PATHS = exports.CLOUD_DEFAULT_REPO = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUsingCustomRolloverPath = exports.isUsingCustomRolloverPath = '_meta.hot.customRollover.enabled';
const isUsingDefaultRolloverPath = exports.isUsingDefaultRolloverPath = '_meta.hot.isUsingDefaultRollover';
const isUsingDownsamplePath = phase => `_meta.${phase}.downsample.enabled`;

/**
 * These strings describe the path to their respective values in the serialized
 * ILM form.
 */
exports.isUsingDownsamplePath = isUsingDownsamplePath;
const ROLLOVER_FORM_PATHS = exports.ROLLOVER_FORM_PATHS = {
  maxDocs: 'phases.hot.actions.rollover.max_docs',
  maxAge: 'phases.hot.actions.rollover.max_age',
  maxSize: 'phases.hot.actions.rollover.max_size',
  maxPrimaryShardSize: 'phases.hot.actions.rollover.max_primary_shard_size',
  maxPrimaryShardDocs: 'phases.hot.actions.rollover.max_primary_shard_docs'
};

/**
 * This repository is provisioned by Elastic Cloud and will always
 * exist as a "managed" repository.
 */
const CLOUD_DEFAULT_REPO = exports.CLOUD_DEFAULT_REPO = 'found-snapshots';

/*
 * Labels for byte size units
 */
const byteSizeUnits = exports.byteSizeUnits = [{
  value: 'gb',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.gigabytesLabel', {
    defaultMessage: 'gigabytes'
  })
}, {
  value: 'mb',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.megabytesLabel', {
    defaultMessage: 'megabytes'
  })
}, {
  value: 'b',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.bytesLabel', {
    defaultMessage: 'bytes'
  })
}, {
  value: 'kb',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.kilobytesLabel', {
    defaultMessage: 'kilobytes'
  })
}, {
  value: 'tb',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.terabytesLabel', {
    defaultMessage: 'terabytes'
  })
}, {
  value: 'pb',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.byteSizeUnits.petabytesLabel', {
    defaultMessage: 'petabytes'
  })
}];

/*
 * Labels for time units
 */
const timeUnits = exports.timeUnits = [{
  value: 'd',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.timeUnits.daysLabel', {
    defaultMessage: 'days'
  })
}, {
  value: 'h',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.timeUnits.hoursLabel', {
    defaultMessage: 'hours'
  })
}, {
  value: 'm',
  text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.timeUnits.minutesLabel', {
    defaultMessage: 'minutes'
  })
}];