"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlocklistForm = BlocklistForm;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_list_keys = require("./use_list_keys");
var _icon_renderer = require("../icon_renderer");
var _legacy_icon = require("./legacy_icon.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BlocklistForm({
  blocklistedNodes,
  unblockNode,
  unblockAll
}) {
  const getListKey = (0, _use_list_keys.useListKeys)(blocklistedNodes || []);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, blocklistedNodes && blocklistedNodes.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.graph.settings.blocklist.blocklistHelpText', {
    defaultMessage: 'These terms are not allowed in the graph.'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.blocklist.noEntriesDescription",
      defaultMessage: "You don't have any blocked terms. Select vertices and click {stopSign} in the control panel on the right to block them. Documents that match blocked terms are no longer explored and relationships to them are hidden.",
      values: {
        stopSign: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "eyeClosed"
        })
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), blocklistedNodes && blocklistedNodes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    bordered: true,
    maxWidth: false
  }, blocklistedNodes.map(node => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    icon: /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: node.icon,
      css: [_legacy_icon.legacyIconStyles.base(euiThemeContext), _legacy_icon.legacyIconStyles.list(euiThemeContext)]
    }),
    key: getListKey(node),
    label: node.label,
    extraAction: {
      iconType: 'trash',
      'aria-label': _i18n.i18n.translate('xpack.graph.blocklist.removeButtonAriaLabel', {
        defaultMessage: 'Delete'
      }),
      title: _i18n.i18n.translate('xpack.graph.blocklist.removeButtonAriaLabel', {
        defaultMessage: 'Delete'
      }),
      color: 'danger',
      onClick: () => unblockNode(node)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "graphUnblocklistAll",
    color: "danger",
    iconType: "trash",
    size: "s",
    fill: true,
    onClick: () => unblockAll()
  }, _i18n.i18n.translate('xpack.graph.settings.blocklist.clearButtonLabel', {
    defaultMessage: 'Delete all'
  }))));
}