"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverFooter = ({
  isMac
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.helpText.helpTextPrefix",
    defaultMessage: "Filter by"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "type:"), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.helpText.helpTextConjunction",
    defaultMessage: "or"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "tag:")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.shortcutDescription.shortcutDetail",
    defaultMessage: "{shortcutDescription} {commandDescription}",
    values: {
      shortcutDescription: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.globalSearchBar.searchBar.shortcutDescription.shortcutInstructionDescription",
        defaultMessage: "Shortcut"
      }),
      commandDescription: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, isMac ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.globalSearchBar.searchBar.shortcutDescription.macCommandDescription",
        defaultMessage: "Command + /"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.globalSearchBar.searchBar.shortcutDescription.windowsCommandDescription",
        defaultMessage: "Control + /"
      }))
    }
  })))));
};
exports.PopoverFooter = PopoverFooter;