/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.fleet_bundle_jsonpfunction=self.fleet_bundle_jsonpfunction||[]).push([[867],{28707:(e,t,a)=>{"use strict";a.r(t),a.d(t,{ALLOWED_JOB_CONTENT_TYPES:()=>s,AuthenticationExpiredError:()=>AuthenticationExpiredError,BrowserCouldNotLaunchError:()=>BrowserCouldNotLaunchError,BrowserScreenshotError:()=>BrowserScreenshotError,BrowserUnexpectedlyClosedError:()=>BrowserUnexpectedlyClosedError,CancellationToken:()=>CancellationToken,DisallowedOutgoingUrl:()=>DisallowedOutgoingUrl,ILM_POLICY_NAME:()=>k,INTERNAL_ROUTES:()=>L,InvalidLayoutParametersError:()=>InvalidLayoutParametersError,JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY:()=>f,JOB_STATUS:()=>v,KibanaShuttingDownError:()=>KibanaShuttingDownError,LICENSE_TYPE_BASIC:()=>r,LICENSE_TYPE_CLOUD_STANDARD:()=>u,LICENSE_TYPE_ENTERPRISE:()=>g,LICENSE_TYPE_GOLD:()=>d,LICENSE_TYPE_PLATINUM:()=>c,LICENSE_TYPE_TRIAL:()=>o,MissingAuthenticationError:()=>MissingAuthenticationError,PUBLIC_ROUTES:()=>O,PdfWorkerOutOfMemoryError:()=>PdfWorkerOutOfMemoryError,QueueTimeoutError:()=>QueueTimeoutError,REPORTING_MANAGEMENT_HOME:()=>E,REPORTING_MANAGEMENT_SCHEDULES:()=>y,REPORTING_REDIRECT_ALLOWED_LOCATOR_TYPES:()=>m,REPORTING_REDIRECT_APP:()=>x,REPORTING_REDIRECT_LOCATOR_STORE_KEY:()=>h,REPORT_TABLE_ID:()=>j,REPORT_TABLE_ROW_ID:()=>b,ReportingError:()=>ReportingError,SCHEDULED_REPORT_VALID_LICENSES:()=>p,UI_SETTINGS_CUSTOM_PDF_LOGO:()=>n,UI_SETTINGS_DATEFORMAT_TZ:()=>i,UI_SETTINGS_SEARCH_INCLUDE_FROZEN:()=>l,UnknownError:()=>UnknownError,VisualReportingSoftDisabledError:()=>VisualReportingSoftDisabledError,buildKibanaPath:()=>P,byteSizeValueToNumber:()=>C,durationToNumber:()=>T,numberToDuration:()=>w});const s=["application/json","application/pdf","text/csv","image/png","text/plain"],l="search:includeFrozen",n="xpackReporting:customPdfLogo",i="dateFormat:tz",o="trial",r="basic",u="standard",d="gold",c="platinum",g="enterprise",p=[o,u,d,c,g],f="xpack.reporting.jobCompletionNotifications",m=["DISCOVER_APP_LOCATOR","CANVAS_APP_LOCATOR","DASHBOARD_APP_LOCATOR","LENS_APP_LOCATOR","VISUALIZE_APP_LOCATOR"],x="/app/reportingRedirect",h="__REPORTING_REDIRECT_LOCATOR_STORE_KEY__",E="/app/management/insightsAndAlerting/reporting",y="/app/management/insightsAndAlerting/reporting/schedules",k="kibana-reporting";let v=function(e){return e.PENDING="pending",e.PROCESSING="processing",e.COMPLETED="completed",e.FAILED="failed",e.WARNINGS="completed_with_warnings",e}({});const j="reportJobListing",b="reportJobRow";var S=a(68915),M=a(75008);class ReportingError extends Error{constructor(e){super(),this.details=e}get message(){const e="ReportingError";return this.details?`${e}(code: ${this.code}) "${this.details}"`:`${e}(code: ${this.code})`}toString(){return this.message}}class InvalidLayoutParametersError extends ReportingError{get code(){return InvalidLayoutParametersError.code}}(0,S.default)(InvalidLayoutParametersError,"code","invalid_layout_parameters_error");class DisallowedOutgoingUrl extends ReportingError{get code(){return DisallowedOutgoingUrl.code}}(0,S.default)(DisallowedOutgoingUrl,"code","disallowed_outgoing_url_error");class AuthenticationExpiredError extends ReportingError{get code(){return AuthenticationExpiredError.code}}(0,S.default)(AuthenticationExpiredError,"code","authentication_expired_error");class MissingAuthenticationError extends ReportingError{get code(){return MissingAuthenticationError.code}}(0,S.default)(MissingAuthenticationError,"code","missing_authentication_header_error");class QueueTimeoutError extends ReportingError{get code(){return QueueTimeoutError.code}}(0,S.default)(QueueTimeoutError,"code","queue_timeout_error");class UnknownError extends ReportingError{get code(){return UnknownError.code}}(0,S.default)(UnknownError,"code","unknown_error");class PdfWorkerOutOfMemoryError extends ReportingError{get code(){return PdfWorkerOutOfMemoryError.code}humanFriendlyMessage(){return M.i18n.translate("reporting.common.pdfWorkerOutOfMemoryErrorMessage",{defaultMessage:"Can't generate a PDF due to insufficient memory. Try making a smaller PDF and retrying this report."})}}(0,S.default)(PdfWorkerOutOfMemoryError,"code","pdf_worker_out_of_memory_error");class BrowserCouldNotLaunchError extends ReportingError{get code(){return BrowserCouldNotLaunchError.code}humanFriendlyMessage(){return M.i18n.translate("reporting.common.browserCouldNotLaunchErrorMessage",{defaultMessage:"Can't generate screenshots because the browser did not launch. See the server logs for more information."})}}(0,S.default)(BrowserCouldNotLaunchError,"code","browser_could_not_launch_error");class BrowserUnexpectedlyClosedError extends ReportingError{get code(){return BrowserUnexpectedlyClosedError.code}}(0,S.default)(BrowserUnexpectedlyClosedError,"code","browser_unexpectedly_closed_error");class BrowserScreenshotError extends ReportingError{get code(){return BrowserScreenshotError.code}}(0,S.default)(BrowserScreenshotError,"code","browser_screenshot_error");class KibanaShuttingDownError extends ReportingError{get code(){return KibanaShuttingDownError.code}}(0,S.default)(KibanaShuttingDownError,"code","kibana_shutting_down_error");class VisualReportingSoftDisabledError extends ReportingError{get code(){return VisualReportingSoftDisabledError.code}humanFriendlyMessage(){return M.i18n.translate("reporting.common.cloud.insufficientSystemMemoryError",{defaultMessage:"Can't generate this report due to insufficient memory."})}}(0,S.default)(VisualReportingSoftDisabledError,"code","visual_reporting_soft_disabled_error");var F=a(51783),I=a.n(F);const T=e=>"number"==typeof e?e:e.asMilliseconds(),w=e=>"number"==typeof e?I().duration(e,"milliseconds"):e,C=e=>"number"==typeof e?e:e.getValueInBytes();var A=a(30770);class CancellationToken{constructor(){(0,S.default)(this,"_isCancelled",void 0),(0,S.default)(this,"_callbacks",void 0),(0,S.default)(this,"on",(e=>{if(!(0,A.isFunction)(e))throw new Error("Expected callback to be a function");this._isCancelled?e():this._callbacks.push(e)})),(0,S.default)(this,"cancel",(()=>{this._isCancelled=!0,this._callbacks.forEach((e=>e()))})),this._isCancelled=!1,this._callbacks=[]}isCancelled(){return this._isCancelled}}const P=({basePath:e,appPath:t,spaceId:a})=>void 0===a||"default"===a.toLowerCase()?`${e}${t}`:`${e}/s/${a}${t}`,_="/internal/reporting",L={MIGRATE:{MIGRATE_ILM_POLICY:_+"/deprecations/migrate_ilm_policy",GET_ILM_POLICY_STATUS:_+"/ilm_policy_status"},DIAGNOSE:{BROWSER:_+"/diagnose/browser",SCREENSHOT:_+"/diagnose/screenshot"},JOBS:{COUNT:_+"/jobs/count",LIST:_+"/jobs/list",INFO_PREFIX:_+"/jobs/info",DELETE_PREFIX:_+"/jobs/delete",DOWNLOAD_PREFIX:_+"/jobs/download"},DOWNLOAD_CSV:_+"/generate/immediate/csv_searchsource",SCHEDULED:{LIST:_+"/scheduled/list",BULK_DISABLE:_+"/scheduled/bulk_disable"},HEALTH:_+"/_health",GENERATE_PREFIX:_+"/generate",SCHEDULE_PREFIX:_+"/schedule"},D="/api/reporting",O={GENERATE_PREFIX:D+"/generate",JOBS:{DOWNLOAD_PREFIX:D+"/jobs/download",DELETE_PREFIX:D+"/jobs/delete"}}},34127:(e,t,a)=>{"use strict";a.r(t),a.d(t,{InternalApiClientProvider:()=>k,Job:()=>Job,ReportingAPIClient:()=>ReportingAPIClient,checkLicense:()=>w,jobCompletionNotifications:()=>E,useCheckIlmPolicyStatus:()=>b,useInternalApiClient:()=>v,useKibana:()=>A});var s=a(68915),l=a(51783),n=a.n(l),i=a(84286),o=a.n(i),r=a(81319),u=a(75008),d=a(28707),c=a(96791);const{COMPLETED:g,FAILED:p,PENDING:f,PROCESSING:m,WARNINGS:x}=d.JOB_STATUS;class Job{constructor(e){var t,a,l,n,i,o;(0,s.default)(this,"payload",void 0),(0,s.default)(this,"id",void 0),(0,s.default)(this,"index",void 0),(0,s.default)(this,"objectType",void 0),(0,s.default)(this,"title",void 0),(0,s.default)(this,"isDeprecated",void 0),(0,s.default)(this,"spaceId",void 0),(0,s.default)(this,"browserTimezone",void 0),(0,s.default)(this,"layout",void 0),(0,s.default)(this,"pagingStrategy",void 0),(0,s.default)(this,"version",void 0),(0,s.default)(this,"jobtype",void 0),(0,s.default)(this,"created_by",void 0),(0,s.default)(this,"created_at",void 0),(0,s.default)(this,"started_at",void 0),(0,s.default)(this,"completed_at",void 0),(0,s.default)(this,"status",void 0),(0,s.default)(this,"attempts",void 0),(0,s.default)(this,"max_attempts",void 0),(0,s.default)(this,"timeout",void 0),(0,s.default)(this,"kibana_name",void 0),(0,s.default)(this,"kibana_id",void 0),(0,s.default)(this,"size",void 0),(0,s.default)(this,"content_type",void 0),(0,s.default)(this,"csv_contains_formulas",void 0),(0,s.default)(this,"max_size_reached",void 0),(0,s.default)(this,"metrics",void 0),(0,s.default)(this,"warnings",void 0),(0,s.default)(this,"error_code",void 0),(0,s.default)(this,"locatorParams",void 0),(0,s.default)(this,"queue_time_ms",void 0),(0,s.default)(this,"execution_time_ms",void 0),(0,s.default)(this,"scheduled_report_id",void 0),this.id=e.id,this.index=e.index,this.payload=e.payload,this.jobtype=e.jobtype,this.objectType=e.payload.objectType,this.title=e.payload.title,this.layout=e.payload.layout,this.pagingStrategy=e.payload.pagingStrategy,this.version=e.payload.version,this.created_by=e.created_by,this.created_at=e.created_at,this.started_at=e.started_at,this.completed_at=e.completed_at,this.status=e.status,this.attempts=e.attempts,this.max_attempts=e.max_attempts,this.timeout=e.timeout,this.kibana_name=e.kibana_name,this.kibana_id=e.kibana_id,this.browserTimezone=e.payload.browserTimezone,this.size=null===(t=e.output)||void 0===t?void 0:t.size,this.content_type=null===(a=e.output)||void 0===a?void 0:a.content_type,this.isDeprecated=e.payload.isDeprecated||!1,this.spaceId=e.payload.spaceId,this.csv_contains_formulas=null===(l=e.output)||void 0===l?void 0:l.csv_contains_formulas,this.max_size_reached=null===(n=e.output)||void 0===n?void 0:n.max_size_reached,this.warnings=null===(i=e.output)||void 0===i?void 0:i.warnings,this.error_code=null===(o=e.output)||void 0===o?void 0:o.error_code,this.locatorParams=e.payload.locatorParams,this.metrics=e.metrics,this.queue_time_ms=e.queue_time_ms,this.execution_time_ms=e.execution_time_ms,this.scheduled_report_id=e.scheduled_report_id}isSearch(){return"search"===this.objectType}getStatusMessage(){const e=this.status;let t,a;return e===f?t=u.i18n.translate("reporting.jobStatusDetail.pendingStatusReachedText",{defaultMessage:"Waiting for job to process."}):e===m?t=u.i18n.translate("reporting.jobStatusDetail.attemptXofY",{defaultMessage:"Attempt {attempts} of {max_attempts}.",values:{attempts:this.attempts,max_attempts:this.max_attempts}}):this.getWarnings()?t=u.i18n.translate("reporting.jobStatusDetail.warningsText",{defaultMessage:"See report info for warnings."}):this.getError()&&(t=u.i18n.translate("reporting.jobStatusDetail.errorText",{defaultMessage:"See report info for error details."})),this.isDeprecated&&(a=(0,c.jsx)(r.EuiText,{size:"s"}," ",(0,c.jsx)(r.EuiTextColor,{color:"warning"},u.i18n.translate("reporting.jobStatusDetail.deprecatedText",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})))),t?(0,c.jsx)(o().Fragment,null,(0,c.jsx)(r.EuiText,{size:"s"},(0,c.jsx)(r.EuiTextColor,{color:"subdued"},t)),a||null):null}get prettyStatus(){var e;return null!==(e=h.get(this.status))&&void 0!==e?e:u.i18n.translate("reporting.jobStatusDetail.unknownText",{defaultMessage:"Unknown"})}get canLinkToKibanaApp(){return Boolean(this.locatorParams)}get isDownloadReady(){return this.status===d.JOB_STATUS.COMPLETED||this.status===d.JOB_STATUS.WARNINGS}get prettyJobTypeName(){switch(this.jobtype){case"printable_pdf":case"printable_pdf_v2":return u.i18n.translate("reporting.jobType.pdfOutputName",{defaultMessage:"PDF"});case"PNG":case"PNGV2":return u.i18n.translate("reporting.jobType.pngOutputName",{defaultMessage:"PNG"});case"csv_v2":case"csv_searchsource":return u.i18n.translate("reporting.jobType.csvOutputName",{defaultMessage:"CSV"});default:return}}get prettyTimeout(){if(null==this.timeout)return u.i18n.translate("reporting.jobStatusDetail.timeoutSecondsUnknown",{defaultMessage:"Unknown"});const e=this.timeout/1e3;return u.i18n.translate("reporting.jobStatusDetail.timeoutSeconds",{defaultMessage:"{timeout} seconds",values:{timeout:e}})}getCreatedAtDate(){return this.formatDate(this.created_at)}getCreatedBy(){return this.created_by||u.i18n.translate("reporting.jobCreatedBy.unknownUserPlaceholderText",{defaultMessage:"Unknown"})}getCreatedAtLabel(){return this.created_by?(0,c.jsx)(o().Fragment,null,(0,c.jsx)("div",null,this.formatDate(this.created_at)),(0,c.jsx)("span",null,this.created_by)):this.formatDate(this.created_at)}getError(){if(this.status===p)return this.warnings}getDeprecatedMessage(){if(this.isDeprecated)return u.i18n.translate("reporting.jobWarning.exportTypeDeprecated",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})}getWarnings(){var e;const t=[],a=this.getDeprecatedMessage();if(a&&t.push(a),this.csv_contains_formulas&&t.push(u.i18n.translate("reporting.jobWarning.csvContainsFormulas",{defaultMessage:"Your CSV contains characters that spreadsheet applications might interpret as formulas."})),this.max_size_reached&&t.push(u.i18n.translate("reporting.jobWarning.maxSizeReachedTooltip",{defaultMessage:"Your search reached the max size and contains partial data."})),this.status!==p&&null!==(e=this.warnings)&&void 0!==e&&e.length&&t.push(...this.warnings),t.length)return(0,c.jsx)("ul",null,t.map(((e,t)=>(0,c.jsx)("li",{key:`warning-key-${t}`},e))))}getPrettyStatusTimestamp(){return this.formatDate(this.getStatusTimestamp())}formatDate(e){try{return n()(e).format("YYYY-MM-DD @ hh:mm A")}catch(t){return e}}getStatusTimestamp(){const e=this.status;return e===m&&this.started_at?this.started_at:this.completed_at&&[g,p,x].includes(e)?this.completed_at:this.created_at}}const h=new Map([[f,u.i18n.translate("reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[m,u.i18n.translate("reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[g,u.i18n.translate("reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[x,u.i18n.translate("reporting.jobStatuses.warningText",{defaultMessage:"Completed"})],[p,u.i18n.translate("reporting.jobStatuses.failedText",{defaultMessage:"Failed"})]]);function E(){return{getPendingJobIds:function(){const e=[];for(const t in localStorage)if(0===t.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)){const a=t.replace(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-`,"");e.push(a)}return e},addPendingJobId:function(e){localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${e}`,e)},setPendingJobIds:function(e){for(const e in localStorage)0===e.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)&&localStorage.removeItem(e);for(let t=0;t<e.length;t++){const a=e[t];localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${a}`,a)}}}}const y=(0,i.createContext)(void 0),k=({apiClient:e,http:t,children:a})=>(0,c.jsx)(y.Provider,{value:{http:t,apiClient:e}},a),v=()=>{const e=(0,i.useContext)(y);if(!e)throw new Error('"useInternalApiClient" can only be used inside of "InternalApiClientContext"');return e};var j=a(18744);const b=()=>{const{services:{http:e}}=A();return(0,j.useRequest)(e,{path:d.INTERNAL_ROUTES.MIGRATE.GET_ILM_POLICY_STATUS,method:"get"})};var S=a(47400),M=a(45995),F=a.n(M),I=a(20151),T=a(43721);class ReportingAPIClient{constructor(e,t,a){(0,s.default)(this,"http",void 0),(0,s.default)(this,"addPendingJobId",E().addPendingJobId),(0,s.default)(this,"getManagementLink",(()=>this.http.basePath.prepend(d.REPORTING_MANAGEMENT_HOME))),(0,s.default)(this,"getDownloadLink",(e=>this.getReportURL(e))),(0,s.default)(this,"getServerBasePath",(()=>this.http.basePath.serverBasePath)),this.uiSettings=t,this.kibanaVersion=a,this.http=e}getKibanaAppHref(e){const t=(0,I.stringify)({jobId:e.id,...e.scheduled_report_id?{scheduledReportId:e.scheduled_report_id}:{}});return`${(0,d.buildKibanaPath)({basePath:this.http.basePath.serverBasePath,spaceId:e.spaceId,appPath:d.REPORTING_REDIRECT_APP})}?${t}`}getReportURL(e){return this.http.basePath.prepend(`${d.INTERNAL_ROUTES.JOBS.DOWNLOAD_PREFIX}/${e}?${S.SX}=true`)}downloadReport(e){const t=this.getReportURL(e);window.open(t)}async deleteReport(e){return await this.http.delete(`${d.INTERNAL_ROUTES.JOBS.DELETE_PREFIX}/${e}`)}async list(e=0,t=50,a=[]){const s={page:e,size:t};return a.length>0&&(s.ids=a.slice(0,t).join(",")),(await this.http.get(d.INTERNAL_ROUTES.JOBS.LIST,{query:s,asSystemRequest:!0})).map((e=>new Job(e)))}async total(){return await this.http.get(d.INTERNAL_ROUTES.JOBS.COUNT,{asSystemRequest:!0})}async getError(e){var t;const a=await this.getInfo(e);return null!==(t=a.warnings)&&void 0!==t&&t[0]?a.warnings[0]:u.i18n.translate("reporting.apiClient.unknownError",{defaultMessage:"Report job {job} failed. Error unknown.",values:{job:e}})}async getInfo(e){const t=await this.http.get(`${d.INTERNAL_ROUTES.JOBS.INFO_PREFIX}/${e}`);return new Job(t)}async getScheduledReportInfo(e,t=0,a=50){const{data:s=[]}=await this.http.get(`${d.INTERNAL_ROUTES.SCHEDULED.LIST}`,{query:{page:t,size:a}});return s.find((t=>t.id===e))}async findForJobIds(e){return(await this.http.fetch(d.INTERNAL_ROUTES.JOBS.LIST,{query:{page:0,ids:e.join(",")},method:"GET"})).map((e=>new Job(e)))}getReportingPublicJobPath(e,t){const a=(0,I.stringify)({jobParams:F().encode(t)});return`${this.http.basePath.prepend(d.PUBLIC_ROUTES.GENERATE_PREFIX)}/${e}?${a}`}async createReportingShareJob(e,t){const a=F().encode(t),s=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=s&&s.job)return this.addPendingJobId(s.job.id),new Job(s.job)}async createReportingJob(e,t){const a=F().encode(t);try{const t=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=t&&t.job)return this.addPendingJobId(t.job.id),new Job(t.job)}catch(e){var s;throw T.error(e),new Error(`${null===(s=e.body)||void 0===s?void 0:s.message}`)}}async createImmediateReport(e){const{objectType:t,...a}=e;return this.http.post(d.INTERNAL_ROUTES.DOWNLOAD_CSV,{asResponse:!0,body:JSON.stringify(a)})}getDecoratedJobParams(e){return{browserTimezone:"Browser"===this.uiSettings.get("dateFormat:tz")?n().tz.guess():this.uiSettings.get("dateFormat:tz"),version:this.kibanaVersion,...e}}verifyBrowser(){return this.http.get(d.INTERNAL_ROUTES.DIAGNOSE.BROWSER)}verifyScreenCapture(){return this.http.post(d.INTERNAL_ROUTES.DIAGNOSE.SCREENSHOT)}migrateReportingIndicesIlmPolicy(){return this.http.put(d.INTERNAL_ROUTES.MIGRATE.MIGRATE_ILM_POLICY)}}const w=e=>{switch(e.state){case"valid":default:return{showLinks:!0,enableLinks:!0,message:""};case"invalid":return{showLinks:!1,enableLinks:!1,message:"Your license does not support Reporting. Please upgrade your license."};case"unavailable":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because license information is not available at this time."};case"expired":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because your license has expired."}}};var C=a(20409);const A=()=>(0,C.useKibana)()},50867:(e,t,a)=>{"use strict";a.d(t,{renderApp:()=>Ci,teardownFleet:()=>Ai});var s=a(84286),l=a.n(s),n=a(22874),i=a.n(n),o=a(1493),r=a(30193),u=a(51155),d=a(3185),c=a(77880),g=a(81319),p=a(20482),f=a(75879),m=a(75008),x=a(13530),h=a(45692),E=a(44081),y=a(20409),k=a(15006),v=a(52137),j=a(13528),b=a(26333),S=a(66720),M=a(42413),F=a(42398),I=a(7975),T=a(99132),w=a(60547),C=a(26768),A=a.n(C),P=a(46787),_=a(83424);const L=A()(g.EuiFlyout).withConfig({displayName:"FlyoutWithHigherZIndex",componentId:"sc-1pwanx7-0"})(["z-index:",";"],(e=>e.theme.eui.euiZLevel5)),D=({onClose:e,as:t,...a})=>{const{notifications:n}=(0,u.WeA)(),i=(0,u.iO7)().fleet.allAgentPolicies,o=(0,b.I)(),[r,c]=(0,s.useState)((0,_.b)({namespace:o.defaultNamespace})),[p,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!0),y=(0,w.FS)(r,{allowedNamespacePrefixes:null==o?void 0:o.allowedNamespacePrefixes}),[k,v]=(0,s.useState)(!1),[j,F]=(0,s.useState)(!1),I=l().createElement(g.EuiFlyoutHeader,{hasBorder:!0,"aria-labelledby":"CreateAgentPolicyFlyoutTitle"},l().createElement(g.EuiTitle,{size:"m"},l().createElement("h2",{id:"CreateAgentPolicyFlyoutTitle","data-test-subj":"createAgentPolicyFlyoutTitle"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitle",defaultMessage:"Create agent policy"}))),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiText,{size:"s"},l().createElement("p",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitleDescription",defaultMessage:"Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents."})))),T=l().createElement(g.EuiFlyoutBody,null,l().createElement(w.Kb,{agentPolicy:r,updateAgentPolicy:e=>{c({...r,...e})},withSysMonitoring:h,updateSysMonitoring:e=>E(e),validation:y,updateAdvancedSettingsHasErrors:v,setInvalidSpaceError:F})),C=(0,s.useMemo)((()=>(0,P.gF)(r,h)),[r,h]),A=l().createElement(g.EuiFlyoutFooter,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexGroup,{gutterSize:"none"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(S.T_,{isDisabled:p||Object.keys(y).length>0||k||j,description:m.i18n.translate("xpack.fleet.createAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request creates a new agent policy."}),request:C})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{fill:!0,isLoading:p,isDisabled:!i||p||Object.keys(y).length>0||k||j,onClick:async()=>{x(!0);try{const{data:t,error:a}=await(async()=>await(0,u.iF6)(r,{withSysMonitoring:h}))();x(!1),t?(n.toasts.addSuccess(m.i18n.translate("xpack.fleet.createAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy ''{name}'' created",values:{name:r.name}})),e(t.item)):n.toasts.addDanger(a?a.message:m.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}catch(e){x(!1),n.toasts.addDanger(m.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}},"data-test-subj":"createAgentPolicyFlyoutBtn"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.submitButtonLabel",defaultMessage:"Create agent policy"})))))));return l().createElement(L,(0,d.default)({onClose:()=>e()},a,{maxWidth:M.MW}),I,T,A)};var O=a(96791);const R=()=>{var e,t;const{isSpaceAwarenessEnabled:a}=(0,u.YI3)();(0,u.ifo)("policies_list");const{getPath:n}=(0,u.iEg)(),i=(0,u.iO7)().fleet.allAgentPolicies,{agents:{enabled:r}}=(0,u.UKg)(),{urlParams:d,toUrlParams:c}=(0,u.zmo)(),[p,x]=(0,s.useState)(Array.isArray(d.kuery)?d.kuery[d.kuery.length-1]:null!==(e=d.kuery)&&void 0!==e?e:""),{pagination:h,pageSizeOptions:E,setPagination:y}=(0,u.WQC)(),{sorting:k,setSorting:v}=(0,u.KEg)({field:"updated_at",direction:"desc"}),j=(0,o.useHistory)(),b="create"in d,F=(0,s.useCallback)((e=>{if(e!==b)if(e)j.push(`${n("policies_list")}?${c({...d,create:null})}`);else{const{create:e,...t}=d;j.push(`${n("policies_list")}?${c(t)}`)}}),[n,j,b,c,d]),{isLoading:C,data:A,refetch:P}=(0,u.BOQ)({page:h.currentPage,perPage:h.pageSize,sortField:null==k?void 0:k.field,sortOrder:null==k?void 0:k.direction,kuery:p,noAgentCount:!1,full:!0}),_=(0,s.useMemo)((()=>{const e=[{field:"name",sortable:!0,name:m.i18n.translate("xpack.fleet.agentPolicyList.nameColumnTitle",{defaultMessage:"Name"}),width:"35%",render:(e,t)=>(0,O.jsx)(T.an,{policy:t,withDescription:!0})},{field:"updated_at",sortable:!0,name:m.i18n.translate("xpack.fleet.agentPolicyList.updatedOnColumnTitle",{defaultMessage:"Last updated on"}),render:e=>(0,O.jsx)(f.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})},{field:"agents",name:m.i18n.translate("xpack.fleet.agentPolicyList.agentsColumnTitle",{defaultMessage:"Unprivileged / Privileged"}),dataType:"number",render:(e,t)=>(0,O.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",justifyContent:"flexEnd"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",defaultMessage:"Unprivileged agents"})},(0,O.jsx)(w.Oy,{count:t.unprivileged_agents||0,agentPolicyId:t.id,showAgentText:!1,privilegeMode:"unprivileged"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},"/"),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",defaultMessage:"Privileged agents"})},(0,O.jsx)(w.Oy,{count:e-(t.unprivileged_agents||0),agentPolicyId:t.id,showAgentText:!1,privilegeMode:"privileged"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("span",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",defaultMessage:"({message})",values:{message:(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",defaultMessage:"Total agents"})},(0,O.jsx)(w.Oy,{count:e,agentPolicyId:t.id,showAgentText:!1}))}}))),(0,I.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})})))},{field:"package_policies",name:m.i18n.translate("xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle",{defaultMessage:"Integrations"}),dataType:"number",render:e=>e?e.length:0},{field:"actions",name:m.i18n.translate("xpack.fleet.agentPolicyList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,O.jsx)(w.Nu,{agentPolicy:e,onCopySuccess:()=>P()})}]}];return r?e:e.filter((e=>!("field"in e)||"agents"!==e.field))}),[r,P]),L=(0,s.useMemo)((()=>(0,O.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!i,onClick:()=>F(!0),"data-test-subj":"createAgentPolicyButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[i,F]),R=(0,s.useMemo)((()=>(0,O.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!i,onClick:()=>F(!0),"data-test-subj":"emptyPromptCreateAgentPolicyButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[i,F]),B=(0,s.useMemo)((()=>(0,O.jsx)(g.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",defaultMessage:"No agent policies"})),actions:R})),[R]);return(0,O.jsx)(l().Fragment,null,b?(0,O.jsx)(D,{onClose:()=>{F(!1),P()}}):null,(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,O.jsx)(g.EuiFlexItem,{grow:4},(0,O.jsx)(S.IW,{value:p,indexPattern:M.yb,fieldPrefix:a?M.ke:M.mm,onChange:e=>{y({...h,currentPage:1}),x(e)},dataTestSubj:"agentPolicyList.queryInput"})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{color:"primary",iconType:"refresh",onClick:()=>P()},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",defaultMessage:"Reload"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},L)),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiBasicTable,{loading:C,"data-test-subj":"agentPoliciesTable",noItemsMessage:C?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",defaultMessage:"Loading agent policies…"}):p.trim()||0!==(null!==(t=null==A?void 0:A.total)&&void 0!==t?t:0)?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",defaultMessage:"No agent policies found. {clearFiltersLink}",values:{clearFiltersLink:(0,O.jsx)(g.EuiLink,{onClick:()=>x("")},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):B,items:A?A.items:[],itemId:"id",columns:_,pagination:{pageIndex:h.currentPage-1,pageSize:h.pageSize,totalItemCount:A?A.total:0,pageSizeOptions:E},sorting:{sort:k},onChange:e=>{const t={...h,currentPage:e.page.index+1,pageSize:e.page.size};y(t),v(e.sort)}}))};var B=a(5850),N=a(46048),z=a(53684);const U=(e,t)=>e.localeCompare(t),H=e=>({name:e,value:e}),W=({packagePolicies:e,agentPolicy:t,...a})=>{var n,i;const{application:o}=(0,u.WeA)(),r=(0,u.iO7)(),c=r.integrations.writeIntegrationPolicies,p=r.fleet.readAgentPolicies,x=r.integrations.readIntegrationPolicies,{isPackagePolicyUpgradable:h}=(0,u.hhZ)(),{getHref:E}=(0,u.iEg)(),{canUseMultipleAgentPolicies:y}=(0,u.phy)(),k=(0,u.B6B)(),v=!(null!==(n=k.data)&&void 0!==n&&n.success)&&"MISSING_SECURITY"===(null===(i=k.data)||void 0===i?void 0:i.error),[j,b]=(0,s.useMemo)((()=>{const t=new Set;return[e.map((e=>{var a,s,l,n,i,o;e.namespace&&t.add(e.namespace);const r=h(e);return{...e,packageName:null!==(a=null===(s=e.package)||void 0===s?void 0:s.name)&&void 0!==a?a:"",packageTitle:null!==(l=null===(n=e.package)||void 0===n?void 0:n.title)&&void 0!==l?l:"",packageVersion:null!==(i=null===(o=e.package)||void 0===o?void 0:o.version)&&void 0!==i?i:"",hasUpgrade:r}})),[...t].sort(U).map(H)]}),[e,h]),M=(0,s.useCallback)((e=>e.policy_ids.length||0),[]),{data:F,isLoading:I}=(0,u.Eiq)(),{output:T}=(0,u.OmG)(),w=(0,s.useMemo)((()=>{var e;return(null!==(e=null==F?void 0:F.items)&&void 0!==e?e:[]).reduce(((e,t)=>(e[t.id]=t.name,e)),{})}),[F]),C=(0,s.useMemo)((()=>[{field:"name",sortable:!0,truncateText:!0,name:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle",{defaultMessage:"Integration policy"}),width:"35%",render:(e,a)=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableName",grow:!1},(0,O.jsx)(g.EuiLink,(0,d.default)({title:e},x?{href:E("edit_integration",{policyId:t.id,packagePolicyId:a.id})}:{disabled:!0}),(0,O.jsx)("span",{className:"eui-textTruncate"},e),a.description?(0,O.jsx)("span",null," ",(0,O.jsx)(g.EuiToolTip,{content:a.description},(0,O.jsx)(g.EuiIcon,{type:"question"}))):null)),y&&p&&x&&M(a)>1&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedTooltip",defaultMessage:"This integration is shared by {numberShared} agent policies",values:{numberShared:M(a)}})},(0,O.jsx)(g.EuiText,{"data-test-subj":"PackagePoliciesTableSharedLabel",color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedText",defaultMessage:"Shared"})," ",(0,O.jsx)(g.EuiIcon,{type:"info"})))))},{field:"packageTitle",sortable:!0,name:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle",{defaultMessage:"Integration"}),render:(e,a)=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableLink",grow:!1},(0,O.jsx)(g.EuiLink,{href:a.package&&E("integration_details_overview",{pkgkey:(0,z.Ku)(a.package)})},(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},a.package&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(S.qD,{packageName:a.package.name,version:a.package.version,size:"m",tryApi:!0})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},e),a.package&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",defaultMessage:"v{version}",values:{version:a.package.version}})))))),a.hasUpgrade&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.upgradeAvailable",{defaultMessage:"Upgrade Available"})},(0,O.jsx)(g.EuiIcon,{type:"warning",color:"warning"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{"data-test-subj":"PackagePoliciesTableUpgradeButton",size:"s",minWidth:"0",isDisabled:!c,href:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:a.id})}?from=fleet-policy-list`},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",defaultMessage:"Upgrade"})))))},{field:"namespace",name:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,O.jsx)(g.EuiBadge,{color:"hollow"},e):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiBadge,{color:"default"},t.namespace),(0,O.jsx)(g.EuiIconTip,{content:"Namespace defined in parent agent policy",position:"right",type:"info",color:"subdued"}))},{field:"output_id",name:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputColumnTitle",{defaultMessage:"Output"}),render:e=>I?null:e?(0,O.jsx)(g.EuiBadge,{color:"hollow"},w[e]||e):t.data_output_id?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiBadge,{color:"default"},w[t.data_output_id]||t.data_output_id)," ",(0,O.jsx)(g.EuiIconTip,{content:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromParentPolicyText",{defaultMessage:"Output defined in parent agent policy"}),position:"right",type:"info",color:"subdued"})):T?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiBadge,{color:"default"},w[T.id]||T.id)," ",(0,O.jsx)(g.EuiIconTip,{content:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromFleetSettingsText",{defaultMessage:"Output defined in Fleet settings"}),position:"right",type:"info",color:"subdued"})):void 0},{name:m.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle",{defaultMessage:"Actions"}),width:"70px",actions:[{render:e=>c?(0,O.jsx)(S.Py,{agentPolicies:[t],from:"fleet-policy-list",packagePolicy:e,upgradePackagePolicyHref:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:e.id})}?from=fleet-policy-list`}):(0,O.jsx)(l().Fragment,null)}]}]),[x,E,t,y,p,M,c,I,T,w]);return(0,O.jsx)(g.EuiInMemoryTable,(0,d.default)({itemId:"id",items:j,columns:C,sorting:{sort:{field:"name",direction:"asc"}}},a,{search:{toolsRight:t.is_managed||t.supports_agentless?[]:[(0,O.jsx)(S.rj,{key:"addPackagePolicyButton",fill:!0,isDisabled:!c,iconType:"plusInCircle",onClick:()=>{o.navigateToApp(B.INTEGRATIONS_PLUGIN_ID,{path:N.tn.integrations_all({})[1],state:{forAgentPolicyId:t.id}})},"data-test-subj":"addPackagePolicyButton",tooltip:c?void 0:{content:v?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",defaultMessage:"To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator."}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",defaultMessage:"Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator."})}},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.addPackagePolicyButtonText",defaultMessage:"Add integration"}))],box:{incremental:!0,schema:!0},filters:[{type:"field_value_selection",field:"namespace",name:"Namespace",options:b,multiSelect:"or",operator:"exact"}]}}))},G=(0,s.memo)((({policyId:e})=>{const{application:t}=(0,u.WeA)(),a=(0,u.iO7)(),s=a.integrations.writeIntegrationPolicies&&a.fleet.allAgentPolicies;return(0,O.jsx)(g.EuiEmptyPrompt,{iconType:"plusInCircle",title:(0,O.jsx)("h3",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",defaultMessage:"Add your first integration"})),body:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",defaultMessage:"This policy does not have any integrations yet."}),actions:(0,O.jsx)(g.EuiButton,{iconType:"plusInCircle",isDisabled:!s,fill:!0,onClick:()=>t.navigateToApp(M.A7,{path:M.tn.integrations_all({})[1],state:{forAgentPolicyId:e}}),"data-test-subj":"addPackagePolicyButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",defaultMessage:"Add integration"}))})})),q=(0,s.memo)((({agentPolicy:e})=>((0,u.ifo)("policy_details",{policyName:e.name}),e.package_policies&&0!==e.package_policies.length?(0,O.jsx)(W,{agentPolicy:e,packagePolicies:e.package_policies}):(0,O.jsx)(G,{policyId:e.id}))));var V=a(30770),K=a(21254),$=a(4408);const Y=e=>{var t;return{...(0,V.pick)(e,["name","description","namespace","monitoring_enabled","unenroll_timeout","inactivity_timeout","data_output_id","monitoring_output_id","download_source_id","fleet_server_host_id","agent_features","is_protected","advanced_settings","global_data_tags","monitoring_pprof_enabled","monitoring_http","monitoring_diagnostics"]),...!(null!==(t=e.space_ids)&&void 0!==t&&t.includes($.eWz))&&{space_ids:e.space_ids}}},Q=A().div.withConfig({displayName:"FormWrapper",componentId:"sc-1lbh22t-0"})(["max-width:1200px;margin-right:auto;margin-left:auto;"]),X=(0,s.memo)((({agentPolicy:e})=>{(0,u.ifo)("policy_details",{policyName:e.name});const{notifications:t}=(0,u.WeA)(),{spaceId:a}=(0,u.YI3)(),{agents:{enabled:n}}=(0,u.UKg)(),{getPath:i}=(0,u.iEg)(),r=(0,u.iO7)().fleet.allAgentPolicies,d=(0,u.gCF)(),[c,p]=(0,s.useState)({...e}),x=(0,o.useHistory)(),h=(0,b.I)(),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),[j,M]=(0,s.useState)(0),[F,I]=(0,s.useState)(!0),T=(0,w.FS)(c,{allowedNamespacePrefixes:null==h?void 0:h.allowedNamespacePrefixes}),[C,A]=(0,s.useState)(!1),[_,L]=(0,s.useState)(!1),D=async()=>{y(!0);try{const{data:e,error:s}=await(0,u.Bs_)(c.id,Y(c));e?(t.toasts.addSuccess(m.i18n.translate("xpack.fleet.editAgentPolicy.successNotificationTitle",{defaultMessage:"Successfully updated ''{name}'' settings",values:{name:c.name}})),c.space_ids&&!c.space_ids.includes(null!=a?a:K.DEFAULT_SPACE_ID)?x.replace(i("policies_list")):(d(),v(!1))):t.toasts.addDanger(s?s.message:m.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}catch(e){t.toasts.addDanger(m.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}y(!1)},O=(0,s.useMemo)((()=>(0,P.Rq)(c.id,Y(c))),[c]);return l().createElement(Q,null,j?l().createElement(w.oR,{agentCount:j,agentPolicies:[c],onConfirm:()=>{M(0),D()},onCancel:()=>{M(0),y(!1)}}):null,l().createElement(w.Kb,{agentPolicy:c,updateAgentPolicy:e=>{p({...c,...e}),v(!0)},withSysMonitoring:F,updateSysMonitoring:e=>I(e),validation:T,isEditing:!0,updateAdvancedSettingsHasErrors:A,setInvalidSpaceError:L}),k?l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"xl"}),l().createElement(g.EuiSpacer,{size:"xl"}),l().createElement(g.EuiBottomBar,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.unsavedChangesText",defaultMessage:"You have unsaved changes"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",onClick:()=>{p({...e}),v(!1)}},l().createElement(f.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.cancelButtonText",defaultMessage:"Cancel"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(S.T_,{isDisabled:E||Object.keys(T).length>0||C||_,btnProps:{color:"text"},description:m.i18n.translate("xpack.fleet.editAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request updates an agent policy."}),request:O})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{onClick:async()=>{if(n){y(!0);const{data:e}=await(0,u.Wwg)({policyId:c.id});null!=e&&e.results.total?M(e.results.total):await D()}else await D()},isLoading:E,isDisabled:!r||E||Object.keys(T).length>0||C||_,"data-test-subj":"agentPolicyDetailsSaveButton",iconType:"save",color:"primary",fill:!0},E?l().createElement(f.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.savingButtonText",defaultMessage:"Saving…"}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.saveButtonText",defaultMessage:"Save changes"})))))))):null)})),J=({isLoading:e,policyId:t,agentPolicy:a})=>{const{getHref:s}=(0,u.iEg)();return(0,O.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:s("policies_list"),flush:"left",size:"xs"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.viewAgentListTitle",defaultMessage:"View all agent policies"}))),(0,O.jsx)(g.EuiFlexItem,null,e?(0,O.jsx)(S.Rh,null):(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",wrap:!0,responsive:!1,gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiTitle,null,(0,O.jsx)("h1",null,a&&a.name||(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.policyDetailsTitle",defaultMessage:"Policy ''{id}''",values:{id:t}})))),(null==a?void 0:a.is_managed)&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiIconTip,{title:"Hosted agent policy",content:m.i18n.translate("xpack.fleet.policyDetails.policyDetailsHostedPolicyTooltip",{defaultMessage:"This policy is managed outside of Fleet. Most actions related to this policy are unavailable."}),type:"lock",size:"l",color:"subdued"})))),a&&a.description?(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiText,{color:"subdued",size:"s",className:"eui-textBreakWord"},a.description)):null)};var Z=a(95030),ee=a(87086),te=a(8627);const ae=({agentPolicy:e,isManageAutoUpgradeAgentsModalOpen:t,setIsManageAutoUpgradeAgentsModalOpen:a})=>{var l,n,i;const{data:o}=(0,u.t$K)(e.id),r=(null!==(l=e.required_versions)&&void 0!==l?l:[]).map((e=>e.version)),d=(0,s.useMemo)((()=>null==o?void 0:o.currentVersions.filter((e=>r.includes(e.version))).some((e=>e.failedUpgradeAgents>0))),[o,r]);return(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"xs",justifyContent:"flexEnd",alignItems:"center",id:"auto-upgrade-manage-button"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiLink,{onClick:()=>{a(!t)}},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.autoUpgradeButton",defaultMessage:"Manage"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiNotificationBadge,{color:null!==(n=e.required_versions)&&void 0!==n&&n.length?"accent":"subdued"},(null===(i=e.required_versions)||void 0===i?void 0:i.length)||0)),d&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.manageAutoUpgradeAgents.failedUpgradeTooltip",defaultMessage:"Some agents failed to upgrade, click on Manage to see details."})},(0,O.jsx)(g.EuiIcon,{type:"warning",color:"danger"}))))},se=A().div.withConfig({displayName:"Divider",componentId:"sc-zpeocb-0"})(["width:0;height:100%;border-left:",";"],(e=>e.theme.eui.euiBorderThin)),le=({isLoading:e,agentPolicy:t,addAgent:a,onCancelEnrollment:n,isAddAgentHelpPopoverOpen:i,setIsAddAgentHelpPopoverOpen:r})=>{var d;const c=(0,u.iO7)(),{getPath:p}=(0,u.iEg)(),x=(0,o.useHistory)(),[h,E]=(0,s.useState)(!1),y=(0,u.gCF)(),k=(0,te.o)(),v=(0,s.useMemo)((()=>{var e;return null==t||null===(e=t.package_policies)||void 0===e?void 0:e.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===$.k7N}))}),[t]);if(!t)return null;const j=l().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.policyDetails.addFleetServerButton",defaultMessage:"Add Fleet Server"})),b=l().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.policyDetails.addAgentButton",defaultMessage:"Add agent"}));return l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd",direction:"row"},e||!t?null:[{label:m.i18n.translate("xpack.fleet.policyDetails.summary.revision",{defaultMessage:"Revision"}),content:null!==(d=t.revision)&&void 0!==d?d:0},{isDivider:!0},{label:m.i18n.translate("xpack.fleet.policyDetails.summary.integrations",{defaultMessage:"Integrations"}),content:l().createElement(g.EuiI18nNumber,{value:t.package_policies&&t.package_policies.length||0})},{isDivider:!0},...!c.fleet.readAgents||null!=t&&t.supports_agentless?[]:[{label:m.i18n.translate("xpack.fleet.policyDetails.summary.usedBy",{defaultMessage:"Agents"}),content:!t.agents&&v&&c.fleet.addFleetServers?l().createElement(S.xt,{button:j,isOpen:i,offset:15,closePopover:()=>{r(!1)}}):t.agents||v||!c.fleet.addAgents?l().createElement(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiToolTip,{content:l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"xs"},l().createElement(g.EuiFlexItem,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",defaultMessage:"{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",values:{count:t.unprivileged_agents||0}})),l().createElement(g.EuiFlexItem,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",defaultMessage:"{count, plural, one {# privileged agent} other {# privileged agents}}",values:{count:(t.agents||0)-(t.unprivileged_agents||0)}})))},l().createElement(w.Oy,{count:t.agents||0,agentPolicyId:t.id,showAgentText:!0}))),(0,I.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{type:"warning",color:"warning",content:l().createElement(f.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})}))):l().createElement(S.xt,{button:b,isOpen:i,offset:15,closePopover:()=>{r(!1)}})},{isDivider:!0}],{label:m.i18n.translate("xpack.fleet.policyDetails.summary.lastUpdated",{defaultMessage:"Last updated on"}),content:t&&l().createElement(f.FormattedDate,{value:null==t?void 0:t.updated_at,year:"numeric",month:"short",day:"2-digit"})||""},{isDivider:!0},...k&&c.fleet.allAgentPolicies?[{label:m.i18n.translate("xpack.fleet.policyDetails.summary.autoUpgrade",{defaultMessage:"Auto-upgrade agents"}),content:l().createElement(ae,{agentPolicy:t,isManageAutoUpgradeAgentsModalOpen:h,setIsManageAutoUpgradeAgentsModalOpen:E})},{isDivider:!0}]:[],{content:t&&l().createElement(w.Nu,{agentPolicy:t,fullButton:!0,onCopySuccess:e=>{x.push(p("policy_details",{policyId:e.id}))},onCancelEnrollment:n})}].map(((e,t)=>{var a;return l().createElement(g.EuiFlexItem,{grow:!1,key:t},null!==(a=e.isDivider)&&void 0!==a&&a?l().createElement(se,null):e.label?l().createElement(ne,{compressed:!0,textStyle:"reverse"},l().createElement(g.EuiDescriptionListTitle,{className:"eui-textNoWrap"},e.label),l().createElement(g.EuiDescriptionListDescription,{className:"eui-textNoWrap"},e.content)):e.content)}))),h&&l().createElement(g.EuiPortal,null,l().createElement(Z.i,{agentPolicy:t,agentCount:t.agents||0,onClose:e=>{E(!1),e&&y()}})),k?l().createElement(ee.i,{anchor:"#auto-upgrade-manage-button"}):null)};var ne=A()(g.EuiDescriptionList).withConfig({displayName:"_StyledEuiDescriptionList",componentId:"sc-zpeocb-1"})({textAlign:"right"});const ie=()=>{const{params:{policyId:e,tabId:t=""}}=(0,o.useRouteMatch)(),{getHref:a}=(0,u.iEg)(),n=(0,u.ZJQ)(e),i=n.data?n.data.item:null,{isLoading:r,error:d,sendRequest:c}=n,p=new URLSearchParams((0,o.useLocation)().search),x="true"===p.get("openEnrollmentFlyout"),h="true"===p.get("showAddAgentHelp"),[E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(x),[v,j]=(0,s.useState)(h),{application:{navigateToApp:b}}=(0,u.WeA)(),M=(0,u.g7J)(),{isReady:I}=(0,u.YI3)(),T=(0,s.useMemo)((()=>{if(M&&M.onDoneNavigateTo&&I){const[e,t]=M.onDoneNavigateTo;return()=>b(e,t)}}),[I,b,M]),w=(0,s.useCallback)((()=>{j(!1),k(!0)}),[]),C=(0,s.useMemo)((()=>[{id:"integrations",name:m.i18n.translate("xpack.fleet.policyDetails.subTabs.packagePoliciesTabText",{defaultMessage:"Integrations"}),href:a("policy_details",{policyId:e,tabId:"integrations"}),isSelected:""===t||"integrations"===t},{id:"settings",name:m.i18n.translate("xpack.fleet.policyDetails.subTabs.settingsTabText",{defaultMessage:"Settings"}),"data-test-subj":"agentPolicySettingsTab",href:a("policy_details",{policyId:e,tabId:"settings"}),isSelected:"settings"===t}]),[a,e,t]),A=(0,s.useMemo)((()=>E?(0,O.jsx)(o.Redirect,{to:"/"}):r?(0,O.jsx)(S.Rh,null):d?(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:d}):i?(0,O.jsx)(l().Fragment,null,y&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(S.rt,{agentPolicy:i,onClose:T||(()=>k(!1))})),(0,O.jsx)(oe,{agentPolicy:i})):(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:m.i18n.translate("xpack.fleet.policyDetails.policyNotFoundErrorTitle",{defaultMessage:"Policy ''{id}'' not found",values:{id:e}})})),[E,r,d,i,y,T,e]),P=(0,O.jsx)(J,{agentPolicy:i,policyId:e,isLoading:r}),_=(0,O.jsx)(le,{agentPolicy:i,onCancelEnrollment:T,isLoading:r,isAddAgentHelpPopoverOpen:v,setIsAddAgentHelpPopoverOpen:j,addAgent:w});return(0,O.jsx)(u.qfp.Provider,{value:{refresh:c}},(0,O.jsx)(F.QA,{leftColumn:P,rightColumn:_,tabs:C},A))},oe=({agentPolicy:e})=>((0,u.ifo)("policy_details",{policyName:e.name}),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.policy_details_settings,render:()=>(0,O.jsx)(X,{agentPolicy:e})}),(0,O.jsx)(r.Route,{path:M.X5.policy_details,render:()=>(0,O.jsx)(q,{agentPolicy:e})})));var re=a(70940);const ue=(0,s.memo)((()=>{const{params:{packagePolicyId:e,policyId:t}}=(0,o.useRouteMatch)(),{search:a}=(0,o.useLocation)(),s=new URLSearchParams(a).get("from");let l;return s&&"fleet-policy-list"===s?l="upgrade-from-fleet-policy-list":s&&"integrations-policy-list"===s&&(l="upgrade-from-integrations-policy-list"),(0,O.jsx)(re.R,{packagePolicyId:e,policyId:t,from:l,forceUpgrade:!0})})),de=()=>((0,u.ifo)("policies"),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.edit_integration},(0,O.jsx)(re.k,null)),(0,O.jsx)(r.Route,{path:M.X5.upgrade_package_policy},(0,O.jsx)(ue,null)),(0,O.jsx)(r.Route,{path:M.X5.policy_details},(0,O.jsx)(ie,null)),(0,O.jsx)(r.Route,{path:M.X5.policies_list},(0,O.jsx)(F.iW,{section:"agent_policies"},(0,O.jsx)(R,null)))));var ce=a(49358);const ge=(0,s.memo)((({datastream:e})=>{const{dashboards:t}=e,a=(0,u.e3j)(),s=(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardActionText",defaultMessage:"View dashboard"}),l=(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardsActionText",defaultMessage:"View dashboards"}),n=m.i18n.translate("xpack.fleet.dataStreamList.viewDashboardsPanelTitle",{defaultMessage:"View dashboards"}),i=m.i18n.translate("xpack.fleet.dataStreamList.viewInApmActionText",{defaultMessage:"View in APM"}),{isSuccessful:o,href:r}=(0,ce.V)(e);if(o&&r){const e=[{id:0,items:[{icon:"apmApp",href:r,name:i}]}];return(0,O.jsx)(S.AK,{panels:e})}if(!t||0===t.length){const e=[{id:0,items:[{icon:"dashboardApp",disabled:!0,name:s}]}];return(0,O.jsx)(S.AK,{panels:e})}if(1===t.length){var d;const e=[{id:0,items:[{icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null===(d=t[0])||void 0===d?void 0:d.id}||""),name:s}]}];return(0,O.jsx)(S.AK,{panels:e})}const c=[{id:0,items:[{icon:"dashboardApp",panel:1,name:l}]},{id:1,title:n,items:t.map((e=>({icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null==e?void 0:e.id}||""),name:e.title})))}];return(0,O.jsx)(S.AK,{panels:c})})),pe=()=>{(0,u.ifo)("data_streams");const{pagination:e,pageSizeOptions:t}=(0,u.WQC)(),{isLoading:a,data:n,resendRequest:i}=(0,u.FM)(),o=(0,s.useMemo)((()=>[{field:"dataset",sortable:!0,width:"25%",name:m.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"})},{field:"type",sortable:!0,name:m.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"})},{field:"namespace",sortable:!0,name:m.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,O.jsx)(g.EuiBadge,{color:"hollow"},e):""},{field:"package",sortable:!0,name:m.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),render:(e,t)=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},t.package_version&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(S.qD,{packageName:e,version:t.package_version,size:"m",tryApi:!0})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},e))},{field:"last_activity_ms",sortable:!0,width:"25%",dataType:"date",name:m.i18n.translate("xpack.fleet.dataStreamList.lastActivityColumnTitle",{defaultMessage:"Last activity"}),render:e=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedDate,{value:e,year:"numeric",month:"short",day:"numeric"}),(0,O.jsx)(l().Fragment,null," @ "),(0,O.jsx)(f.FormattedTime,{value:e,hour:"numeric",minute:"numeric",second:"numeric"}))},{field:"size_in_bytes",sortable:!0,name:m.i18n.translate("xpack.fleet.dataStreamList.sizeColumnTitle",{defaultMessage:"Size"}),render:(e,t)=>(0,O.jsx)(l().Fragment,null,t.size_in_bytes_formatted)},{name:m.i18n.translate("xpack.fleet.dataStreamList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,O.jsx)(ge,{datastream:e})}]}]),[]),r=(0,s.useMemo)((()=>(0,O.jsx)(g.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.noDataStreamsPrompt",defaultMessage:"No data streams"}))})),[]),d={dataset:[],type:[],namespace:[],package:[]};if(n&&n.data_streams.length){const e={dataset:[],type:[],namespace:[],package:[]};n.data_streams.forEach((t=>{const{dataset:a,type:s,namespace:l,package:n}=t;e.dataset.includes(a)||e.dataset.push(a),e.type.includes(s)||e.type.push(s),e.namespace.includes(l)||e.namespace.push(l),e.package.includes(n)||e.package.push(n)}));for(const t in e)d[t]&&(d[t]=e[t].sort().map((e=>({value:e,name:e}))))}return(0,O.jsx)(g.EuiInMemoryTable,{loading:a,tableLayout:"auto",message:a?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.loadingDataStreamsMessage",defaultMessage:"Loading data streams…"}):n&&!n.data_streams.length?r:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",defaultMessage:"No matching data streams found"}),items:n?n.data_streams:[],itemId:"index",columns:o,pagination:{initialPageSize:e.pageSize,pageSizeOptions:t},sorting:!0,search:{toolsRight:[(0,O.jsx)(g.EuiButton,{key:"reloadButton",color:"primary",iconType:"refresh",onClick:()=>i()},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.dataStreamList.reloadDataStreamsButtonText",defaultMessage:"Reload"}))],box:{placeholder:m.i18n.translate("xpack.fleet.dataStreamList.searchPlaceholderTitle",{defaultMessage:"Filter data streams"}),incremental:!0},filters:[{type:"field_value_selection",field:"dataset",name:m.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"}),multiSelect:"or",operator:"exact",options:d.dataset},{type:"field_value_selection",field:"type",name:m.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"}),multiSelect:"or",operator:"exact",options:d.type},{type:"field_value_selection",field:"namespace",name:m.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),multiSelect:"or",operator:"exact",options:d.namespace},{type:"field_value_selection",field:"package",name:m.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),multiSelect:"or",operator:"exact",options:d.package}]}})},fe=()=>(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.data_streams},(0,O.jsx)(F.iW,{section:"data_streams"},(0,O.jsx)(pe,null))));var me=a(30135),xe=a(86955),he=a(19573);const Ee=({onClose:e,agents:t,agentCount:a})=>{const{notifications:l}=(0,u.WeA)(),[n,i]=(0,s.useState)(!1),r=Array.isArray(t)&&1===t.length,{getPath:d}=(0,u.iEg)(),c=(0,o.useHistory)(),[p,x]=(0,s.useState)(!1);return(0,O.jsx)(g.EuiConfirmModal,{"data-test-subj":"requestDiagnosticsModal",title:r?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.singleTitle",defaultMessage:"Request diagnostics"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.multipleTitle",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),onCancel:e,onConfirm:async function(){try{i(!0);const a=p?[he.m_.CPU]:[],{error:s}=r?await(0,u.o6X)(t[0].id,{additional_metrics:a}):await(0,u.aJz)({agents:"string"==typeof t?t:t.map((e=>e.id)),additional_metrics:a});if(s)throw s;i(!1);const n=m.i18n.translate("xpack.fleet.requestDiagnostics.successSingleNotificationTitle",{defaultMessage:"Request diagnostics submitted"});if(l.toasts.addSuccess(n),r){const e=d("agent_details_diagnostics",{agentId:t[0].id});c.push(e)}e()}catch(e){i(!1),l.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle",{defaultMessage:"Error requesting diagnostics {count, plural, one {agent} other {agents}}",values:{count:a}})})}},cancelButtonText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:n,confirmButtonText:r?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",defaultMessage:"Request diagnostics"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),buttonColor:"primary"},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.description",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."})),(0,O.jsx)("p",null,(0,O.jsx)(g.EuiCheckbox,{id:"cpuMetricsCheckbox","data-test-subj":"cpuMetricsCheckbox",label:"Collect additional CPU metrics",checked:p,onChange:()=>x(!p)})))};function ye(e){return e.length>20?`${e.substring(0,20)}...`:e}function ke(e){return e.replace(/[^a-zA-Z0-9 \-_]/g,"").slice(0,20)}const ve=A().div.withConfig({displayName:"Wrapped",componentId:"sc-rnfjm9-0"})(["display:flex;.wrappedText{white-space:pre-wrap;}"]),je=({tags:e,color:t,size:a})=>l().createElement(l().Fragment,null,l().createElement(ve,null,l().createElement(g.EuiToolTip,{anchorClassName:"wrappedText",content:l().createElement("span",{"data-test-subj":"agentTagsTooltip"},e.join(", "))},l().createElement(g.EuiText,{size:a,color:t},l().createElement("span",{"data-test-subj":"agentTags"},(0,V.take)(e,3).map(ye).join(", "),e.length>3?` + ${e.length-3} more`:"")))));function be(e,t){return void 0!==(null==e?void 0:e.cpu_avg)?(0,O.jsx)(g.EuiToolTip,{content:`${(100*e.cpu_avg).toFixed(4)} %`},(0,O.jsx)(l().Fragment,null,(100*e.cpu_avg).toFixed(2)," %")):(0,O.jsx)(xe.DQ,{agentPolicy:t})}function Se(e,t){return null!=e&&e.memory_size_byte_avg?function(e,t=0){if(0===e)return"0 Bytes";const a=t<0?0:t,s=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,s)).toFixed(a))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][s]}(e.memory_size_byte_avg):(0,O.jsx)(xe.DQ,{agentPolicy:t})}var Me=a(51783),Fe=a.n(Me);function Ie(e){const t=Date.parse(e||"")-Date.now();return t<0?"":t<9e5?" The upgrade will start in less than 15 minutes.":t<18e5?" The upgrade will start in less than 30 minutes.":t<36e5?" The upgrade will start in less than 1 hour.":` The upgrade will start in less than ${Math.ceil(t/36e5)} hours.`}function Te(e){if(!e||void 0===e.download_percent&&void 0===e.download_rate)return"";let t="";return void 0!==e.download_percent&&(t=`${e.download_percent}%`),void 0!==e.download_rate&&(t+=` at ${we(e.download_rate)}`),` (${t.trim()})`}const we=e=>{let t=0;const a=[" Bps"," kBps"," MBps"," GBps"];for(;t<a.length-1&&!(e<1024);t++)e/=1024;return e.toFixed(1)+a[t]},Ce=e=>{if(!e)return"";const t=new Date(e).toISOString(),a=Date.parse(e)-Date.now(),s=Fe().utc(Fe().duration(a,"milliseconds").asMilliseconds()).format("HH:mm");return a>0?`Retrying until: ${t} (${s} remaining)`:""},Ae=({isAgentUpgradable:e,agent:t,latestAgentVersion:a})=>{var l,n;const i=(0,s.useMemo)((()=>t.upgrade_started_at&&!t.upgraded_at),[t.upgrade_started_at,t.upgraded_at]),o=(0,s.useMemo)((()=>function(e){var t,a,s;switch(null==e?void 0:e.state){case"UPG_REQUESTED":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"accent",iconType:"calendar"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRequested",defaultMessage:"Upgrade requested"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRequested",defaultMessage:"The agent has requested an upgrade."})};case"UPG_SCHEDULED":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"accent",iconType:"clock"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeScheduled",defaultMessage:"Upgrade scheduled"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeScheduled",defaultMessage:"The agent has been instructed to upgrade.{upgradeStartDelay}",values:{upgradeStartDelay:Ie(null===(t=e.metadata)||void 0===t?void 0:t.scheduled_at)}})};case"UPG_DOWNLOADING":var l,n;return null!=e&&null!==(a=e.metadata)&&void 0!==a&&a.retry_error_msg?{Badge:(0,O.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),WarningTooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloadingFailed",defaultMessage:"Upgrade failing: {retryMsg}. {retryUntil}",values:{retryMsg:null==e||null===(l=e.metadata)||void 0===l?void 0:l.retry_error_msg,retryUntil:Ce(null==e||null===(n=e.metadata)||void 0===n?void 0:n.retry_until)}})}:{Badge:(0,O.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloading",defaultMessage:"Downloading the new agent artifact version{downloadEstimate}.",values:{downloadEstimate:Te(null==e?void 0:e.metadata)}})};case"UPG_EXTRACTING":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"accent",iconType:"package"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeExtracting",defaultMessage:"Upgrade extracting"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeExtracting",defaultMessage:"The new agent artifact is extracting."})};case"UPG_REPLACING":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"warning",iconType:"copy"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeReplacing",defaultMessage:"Upgrade replacing"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeReplacing",defaultMessage:"Replacing the agent artifact version."})};case"UPG_RESTARTING":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"warning",iconType:"refresh"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRestarting",defaultMessage:"Upgrade restarting"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRestarting",defaultMessage:"The agent is restarting to apply the update."})};case"UPG_WATCHING":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"warning",iconType:"inspect"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeMonitoring",defaultMessage:"Upgrade monitoring"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeMonitoring",defaultMessage:"Monitoring the new agent version for errors."})};case"UPG_ROLLBACK":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"danger",iconType:"returnKey"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRolledBack",defaultMessage:"Upgrade rolled back"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRolledBack",defaultMessage:"Upgrade unsuccessful. Rolling back to previous version."})};case"UPG_FAILED":return{Badge:(0,O.jsx)(g.EuiBadge,{color:"danger",iconType:"error"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeFailed",defaultMessage:"Upgrade failed"})),TooltipText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeFailed",defaultMessage:"Upgrade failed: {errorMsg}.",values:{errorMsg:null==e||null===(s=e.metadata)||void 0===s?void 0:s.error_msg}})};default:return null}}(t.upgrade_details)),[t.upgrade_details]),r=(0,I.zm)(t,a),d=null!==(l=null===(n=(0,u.UKg)().autoUpgrades)||void 0===n?void 0:n.retryDelays)&&void 0!==l?l:$.Q2q;return t.upgrade_details&&o?(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,O.jsx)(g.EuiFlexItem,{grow:!1},o.Badge),o.TooltipText&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiIconTip,{type:"info",content:o.TooltipText,color:"subdued"})),o.WarningTooltipText&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiIconTip,{type:"warning",content:o.WarningTooltipText,color:"warning"}))):t.upgrade_attempts&&t.upgrade_attempts.length>1&&"updating"===t.status?(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiIconTip,{type:"warning",content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.retryingUpgrade",defaultMessage:"Retrying Upgrade ({retryCount}/{maxRetries} attempts)",values:{retryCount:t.upgrade_attempts.length,maxRetries:d.length}}),color:"subdued"}))):e&&(0,I.vJ)(t,a)?(0,O.jsx)(g.EuiBadge,{color:"hollow",iconType:"sortUp"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeAvailable",defaultMessage:"Upgrade available"})):i?(0,O.jsx)(g.EuiIconTip,{type:"info",content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDetailsNotAvailable",defaultMessage:"Detailed upgrade status is available for Elastic Agents on version {minVersion} and higher.",values:{minVersion:"8.12"}}),color:"subdued"}):!e&&r?(0,O.jsx)(g.EuiIconTip,{type:"info",content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.notUpgradeable",defaultMessage:"Agent not upgradeable: {reason}",values:{reason:r}}),color:"subdued"}):null},Pe=({hasFleetAddAgentsPrivileges:e,setEnrollmentFlyoutState:t})=>(0,O.jsx)(g.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.noAgentsPrompt",defaultMessage:"No agents enrolled"})),actions:e?(0,O.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>t({isOpen:!0})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})):null});function _e(e){return"string"!=typeof e?"-":e}const Le=e=>{const{agents:t,isLoading:a,agentPoliciesIndexedById:s,renderActions:l,sortField:n,sortOrder:i,onTableChange:o,onSelectionChange:r,selected:d,totalAgents:c=0,showUpgradeable:p,pagination:x,pageSizeOptions:h,isUsingFilter:E,setEnrollmentFlyoutState:y,clearFilters:k,isCurrentRequestIncremented:v}=e,j=(0,u.iO7)(),{displayAgentMetrics:b}=z.ZX.get(),{getHref:S}=(0,u.iEg)(),M=(0,u.JhS)(),F=e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=s[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))},I=a&&v?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.loadingAgentsMessage",defaultMessage:"Loading agents…"}):E?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.noFilteredAgentsPrompt",defaultMessage:"No agents found. {clearFiltersLink}",values:{clearFiltersLink:(0,O.jsx)(g.EuiLink,{onClick:()=>k()},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):(0,O.jsx)(Pe,{hasFleetAddAgentsPrivileges:j.fleet.addAgents,setEnrollmentFlyoutState:y}),w={sort:{field:n,direction:i}},C=[{field:"active",sortable:!1,width:"85px",name:m.i18n.translate("xpack.fleet.agentList.statusColumnTitle",{defaultMessage:"Status"}),render:(e,t)=>(0,O.jsx)(xe.u0,{agent:t})},{field:"local_metadata.host.hostname",sortable:!0,name:m.i18n.translate("xpack.fleet.agentList.hostColumnTitle",{defaultMessage:"Host"}),width:"185px",render:(e,t)=>{var a;return(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"none",direction:"column"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiLink,{href:S("agent_details",{agentId:t.id})},_e(e))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(je,{tags:null!==(a=t.tags)&&void 0!==a?a:[],color:"subdued",size:"xs"})))}},{field:"policy_id",sortable:!0,truncateText:!0,name:m.i18n.translate("xpack.fleet.agentList.policyColumnTitle",{defaultMessage:"Agent policy"}),width:"185px",render:(e,t)=>{const a=s[e],l=t.policy_revision&&(null==a?void 0:a.revision)>t.policy_revision;return(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"m",style:{minWidth:0},alignItems:"center"},a&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(T.an,{direction:"column",policy:a,agent:t})),l&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"warning"})," ",(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.outOfDateLabel",defaultMessage:"Outdated policy"}))))}},...b?[{field:"metrics",sortable:!1,name:(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)"})},(0,O.jsx)("span",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.cpuTitle",defaultMessage:"CPU"})," ",(0,O.jsx)(g.EuiIcon,{type:"info"}))),width:"75px",render:(e,t)=>be(t.metrics,t.policy_id?s[t.policy_id]:void 0)},{field:"metrics",sortable:!1,name:(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},(0,O.jsx)("span",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.memoryTitle",defaultMessage:"Memory"})," ",(0,O.jsx)(g.EuiIcon,{type:"info"}))),width:"90px",render:(e,t)=>Se(t.metrics,t.policy_id?s[t.policy_id]:void 0)}]:[],{field:"last_checkin",sortable:!0,name:m.i18n.translate("xpack.fleet.agentList.lastCheckinTitle",{defaultMessage:"Last activity"}),width:"180px",render:(e,t)=>e?(0,O.jsx)(f.FormattedRelative,{value:e}):null},{field:"local_metadata.elastic.agent.version",sortable:!0,width:"220px",name:m.i18n.translate("xpack.fleet.agentList.versionTitle",{defaultMessage:"Version"}),render:(e,t)=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"none",style:{minWidth:0},direction:"column"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",wrap:!0},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,{size:"s",className:"eui-textNoWrap"},_e(e))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Ae,{isAgentUpgradable:!(!F(t)||!(0,z._3)(t)),agent:t,latestAgentVersion:M})))))},{name:m.i18n.translate("xpack.fleet.agentList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:l}],width:"100px"}];return(0,O.jsx)(g.EuiBasicTable,{className:"fleet__agentList__table","data-test-subj":"fleetAgentListTable",loading:a,noItemsMessage:I,items:c?p?t.filter((e=>F(e)&&(0,z._3)(e))):t:[],itemId:"id",columns:C,pagination:{pageIndex:x.currentPage-1,pageSize:x.pageSize,totalItemCount:c,pageSizeOptions:h},selection:{selected:d,onSelectionChange:r,selectable:F,selectableMessage:(e,t)=>e?"":t.active?t.policy_id&&s[t.policy_id].is_managed?"This action is not available for agents enrolled in an externally managed agent policy":"":"This agent is not active"},onChange:o,sorting:w})},De=()=>{var e,t;const a=(0,u.UKg)();return(0,O.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutTitle",defaultMessage:"Max number of online agents reached"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutDescription",defaultMessage:"Fleet supports a maximum of {nbAgents} active agents. You need to unenroll some agents to ensure that all active agents are able to connect and new agents can be enrolled.",values:{nbAgents:(0,O.jsx)(f.FormattedNumber,{value:null!==(e=null===(t=a.internal)||void 0===t?void 0:t.activeAgentsSoftLimit)&&void 0!==e?e:25e3})}}))};var Oe=a(53803);const Re=(0,g.euiPaletteColorBlindBehindText)(),Be={default:Oe.euiLightVars.euiColorLightShade,primary:Re[1],success:Re[0],accent:Re[2],warning:Re[5],danger:Re[9],inactive:Oe.euiLightVars.euiColorDarkShade,lightest:Oe.euiLightVars.euiColorDisabled},Ne=["healthy","unhealthy","updating","offline","inactive","unenrolled"];function ze(e){switch(e){case"healthy":return Be.success;case"offline":return Be.default;case"inactive":return Be.inactive;case"unhealthy":return Be.warning;case"updating":return Be.primary;case"unenrolled":return Be.lightest;default:throw new Error(`Unsupported Agent status ${e}`)}}const Ue=A()(g.EuiColorPaletteDisplay).withConfig({displayName:"StyledEuiColorPaletteDisplay",componentId:"sc-1wvk6tr-0"})(["&.ingest-agent-status-bar{border:none;border-radius:0;&:after{border:none;}}"]),He=({agentStatus:e})=>{const t=(0,s.useMemo)((()=>Ne.reduce(((t,a)=>{const s=t.length>0?t[t.length-1].stop:0;return t.push({stop:s+(e[a]||0),color:ze(a)}),t}),[])),[e]);return 0===t[t.length-1].stop?l().createElement(g.EuiSpacer,{size:"s"}):l().createElement(Ue,{"data-test-subj":"agentStatusBar",className:"ingest-agent-status-bar",size:"s",palette:t})},We=()=>{var e;const{storage:t,uiSettings:a}=(0,u.WeA)(),[n,i]=(0,s.useState)({isOpen:!0}),o=a.get("hideAnnouncements",!1)||!1===(null===(e=t.get(M.EG.AGENT_EXPORT_CSV))||void 0===e?void 0:e.active);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTourStep,{content:(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourContent",defaultMessage:"Once you have selected the agents, click the action menu to download the CSV file."})),isStepOpen:!o&&n.isOpen,onFinish:()=>{i({isOpen:!1}),t.set(M.EG.AGENT_EXPORT_CSV,{active:!1})},minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourTitle",defaultMessage:"Download CSV file"}),anchorPosition:"upLeft",anchor:"#agentListSelectionText"}))},Ge=A().div.withConfig({displayName:"Divider",componentId:"sc-1e6bwq9-0"})(["width:0;height:",";border-left:",";"],(e=>e.theme.eui.euiSizeL),(e=>e.theme.eui.euiBorderThin)),qe=A()(g.EuiFlexItem).withConfig({displayName:"FlexItem",componentId:"sc-1e6bwq9-1"})(["height:",";"],(e=>e.theme.eui.euiSizeL)),Ve=A()(g.EuiButtonEmpty).withConfig({displayName:"Button",componentId:"sc-1e6bwq9-2"})([".euiButtonEmpty__text{font-size:",";}"],(e=>e.theme.eui.euiFontSizeXS)),Ke=({totalAgents:e,totalManagedAgents:t,selectableAgents:a,managedAgentsOnCurrentPage:s,selectionMode:n,setSelectionMode:i,selectedAgents:o,setSelectedAgents:r})=>{const u="manual"===n&&o.length>0||"query"===n&&e>0,d="manual"===n&&o.length===a&&a<e-s;return l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiText,{size:"xs",color:"subdued",id:"agentListSelectionText"},e>M.W?l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgentsWithLimit",defaultMessage:"Showing {count} of {total} agents",values:{count:l().createElement(f.FormattedNumber,{value:M.W}),total:l().createElement(f.FormattedNumber,{value:e})}}):l().createElement(l().Fragment,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgents",defaultMessage:"Showing {count, plural, one {# agent} other {# agents}}",values:{count:e}})," ",l().createElement(g.EuiIconTip,{type:"info",content:l().createElement(f.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsBreakDownTooltip",defaultMessage:" {totalAgents} total agents: {totalSelected} user-managed agents, {totalManagedAgents} on hosted policies",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),l().createElement(We,null)),u?l().createElement(l().Fragment,null,l().createElement(qe,{grow:!1},l().createElement(Ge,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiText,{size:"xs",color:"subdued","data-test-subj":"selectedAgentCountLabel"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.agentsSelected",defaultMessage:"{selectionMode, select, manual { {count, plural, one {# agent} other {# agents}} } other {All agents} } selected",values:{selectionMode:n,count:o.length}})," ","query"===n&&l().createElement(g.EuiIconTip,{type:"info",content:l().createElement(f.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsSelectedTooltip",defaultMessage:"{totalSelected} user-managed agents selected: {totalAgents} total agents, {totalManagedAgents} on hosted policies. Most actions are only available to user-managed agents.",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),d?l().createElement(l().Fragment,null,l().createElement(qe,{grow:!1},l().createElement(Ge,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Ve,{size:"xs",flush:"left","data-test-subj":"selectedEverythingOnAllPagesButton",onClick:()=>i("query")},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.selectAll",defaultMessage:"Select everything on all pages"})))):null,l().createElement(qe,{grow:!1},l().createElement(Ge,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Ve,{size:"xs",flush:"left","data-test-subj":"clearAgentSelectionButton",onClick:()=>{i("manual"),r([])}},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.clearSelection",defaultMessage:"Clear selection"})))):l().createElement(qe,{grow:!1})))},$e=(0,s.memo)((({agentStatus:e})=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"m"},Ne.map((t=>(0,O.jsx)(g.EuiFlexItem,{key:t,grow:!1},(0,O.jsx)(Ye,{status:t,count:e[t]||0}))))))),Ye=(0,s.memo)((({status:e,count:t})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiHealth,{color:ze(e)},(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},function(e){switch(e){case"healthy":return m.i18n.translate("xpack.fleet.agentStatus.healthyLabel",{defaultMessage:"Healthy"});case"offline":return m.i18n.translate("xpack.fleet.agentStatus.offlineLabel",{defaultMessage:"Offline"});case"inactive":return m.i18n.translate("xpack.fleet.agentStatus.inactiveLabel",{defaultMessage:"Inactive"});case"unenrolled":return m.i18n.translate("xpack.fleet.agentStatus.unenrolledLabel",{defaultMessage:"Unenrolled"});case"unhealthy":return m.i18n.translate("xpack.fleet.agentStatus.unhealthyLabel",{defaultMessage:"Unhealthy"});case"updating":return m.i18n.translate("xpack.fleet.agentStatus.updatingLabel",{defaultMessage:"Updating"});default:throw new Error(`Unsupported Agent status ${e}`)}}(e)),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiNotificationBadge,{size:"s",color:"subdued"},t))))))),Qe=({agentStatus:e,totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u,clearFilters:d,isUsingFilter:c})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Ke,{totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u})),c?(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiLink,{onClick:()=>d()},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.header.clearFiltersLinkText",defaultMessage:"Clear filters"}))):null),(0,O.jsx)(g.EuiFlexItem,{grow:!1},e&&(0,O.jsx)($e,{agentStatus:e}))),(0,O.jsx)(g.EuiSpacer,{size:"s"}),e&&(0,O.jsx)(He,{agentStatus:e}));var Xe=a(12845),Je=a(55964),Ze=a(7195),et=a(34127),tt=a(85228),at=a(25167);const st=({search:e,selectedAgentPolicies:t,selectedTags:a,selectedStatus:s,selectedAgentIds:l})=>{let n="";if(e&&(n=e.trim()),null!=t&&t.length&&(n&&(n=`(${n}) and`),n=`${n} ${M.Ah}.policy_id : (${t.map((e=>`"${e}"`)).join(" or ")})`),null!=a&&a.length&&(n&&(n=`(${n}) and`),n=`${n} ${M.Ah}.tags : (${a.map((e=>`"${e}"`)).join(" or ")})`),null!=l&&l.length&&(n&&(n=`(${n}) and`),n=`${n} ${M.Ah}.agent.id : (${l.map((e=>`"${e}"`)).join(" or ")})`),null!=s&&s.length){const e=s.map((e=>{switch(e){case"healthy":return z.ir.buildKueryForOnlineAgents();case"unhealthy":return z.ir.buildKueryForErrorAgents();case"offline":return z.ir.buildKueryForOfflineAgents();case"updating":return z.ir.buildKueryForUpdatingAgents();case"inactive":return z.ir.buildKueryForInactiveAgents();case"unenrolled":return z.ir.buildKueryForUnenrolledAgents()}})).filter((e=>void 0!==e)).join(" or ");n=n?`(${n}) and (${e})`:e}return n.trim()},lt="local_metadata.elastic.agent.version",nt="local_metadata.host.hostname",it=e=>[lt,nt].includes(e)?`${e}.keyword`:e;const ot=[{field:"agent.id",description:m.i18n.translate("xpack.fleet.exportCSV.agentIdField",{defaultMessage:"Agent ID"})},{field:"status",description:m.i18n.translate("xpack.fleet.exportCSV.statusField",{defaultMessage:"Status"})},{field:"local_metadata.host.hostname",description:m.i18n.translate("xpack.fleet.exportCSV.hostnameField",{defaultMessage:"Host Name"})},{field:"policy_id",description:m.i18n.translate("xpack.fleet.exportCSV.policyIdField",{defaultMessage:"Policy ID"})},{field:"last_checkin",description:m.i18n.translate("xpack.fleet.exportCSV.lastCheckinField",{defaultMessage:"Last Checkin Time"})},{field:"local_metadata.elastic.agent.version",description:m.i18n.translate("xpack.fleet.exportCSV.agentVersionField",{defaultMessage:"Agent Version"})}],rt=[{field:"active",description:m.i18n.translate("xpack.fleet.exportCSV.activeField",{defaultMessage:"Active"})},{field:"audit_unenrolled_reason",description:m.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledReasonField",{defaultMessage:"Audit Unenrolled Reason"})},{field:"audit_unenrolled_time",description:m.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledTimeField",{defaultMessage:"Audit Unenrolled Time"})},{field:"enrolled_at",description:m.i18n.translate("xpack.fleet.exportCSV.enrolledAtField",{defaultMessage:"Enrolled At"})},{field:"last_checkin_message",description:m.i18n.translate("xpack.fleet.exportCSV.lastCheckinMessageField",{defaultMessage:"Last Checkin Message"})},{field:"last_checkin_status",description:m.i18n.translate("xpack.fleet.exportCSV.lastCheckinStatusField",{defaultMessage:"Last Checkin Status"})},{field:"last_updated",description:m.i18n.translate("xpack.fleet.exportCSV.lastUpdatedField",{defaultMessage:"Last Updated Time"})},{field:"local_metadata.elastic.agent.build.original",description:m.i18n.translate("xpack.fleet.exportCSV.agentBuildOriginalField",{defaultMessage:"Agent Build Original"})},{field:"local_metadata.elastic.agent.log_level",description:m.i18n.translate("xpack.fleet.exportCSV.logLevelField",{defaultMessage:"Agent Log Level"})},{field:"local_metadata.elastic.agent.snapshot",description:m.i18n.translate("xpack.fleet.exportCSV.agentSnapshotField",{defaultMessage:"Agent Snapshot"})},{field:"local_metadata.elastic.agent.unprivileged",description:m.i18n.translate("xpack.fleet.exportCSV.agentUnprivilegedField",{defaultMessage:"Agent Unprivileged"})},{field:"local_metadata.elastic.agent.upgradeable",description:m.i18n.translate("xpack.fleet.exportCSV.agentUpgradeableField",{defaultMessage:"Agent Upgradeable"})},{field:"local_metadata.host.architecture",description:m.i18n.translate("xpack.fleet.exportCSV.hostArchitectureField",{defaultMessage:"Host Architecture"})},{field:"local_metadata.host.id",description:m.i18n.translate("xpack.fleet.exportCSV.hostIdField",{defaultMessage:"Host ID"})},{field:"local_metadata.host.ip",description:m.i18n.translate("xpack.fleet.exportCSV.hostIpField",{defaultMessage:"Host IP"})},{field:"local_metadata.host.mac",description:m.i18n.translate("xpack.fleet.exportCSV.hostMacField",{defaultMessage:"Host Mac"})},{field:"local_metadata.host.name",description:m.i18n.translate("xpack.fleet.exportCSV.hostNameField",{defaultMessage:"Host Name"})},{field:"local_metadata.os.family",description:m.i18n.translate("xpack.fleet.exportCSV.osFamilyField",{defaultMessage:"OS Family"})},{field:"local_metadata.os.full",description:m.i18n.translate("xpack.fleet.exportCSV.osFullField",{defaultMessage:"OS Full"})},{field:"local_metadata.os.kernel",description:m.i18n.translate("xpack.fleet.exportCSV.osKernelField",{defaultMessage:"OS Kernel"})},{field:"local_metadata.os.name",description:m.i18n.translate("xpack.fleet.exportCSV.osNameField",{defaultMessage:"OS Name"})},{field:"local_metadata.os.platform",description:m.i18n.translate("xpack.fleet.exportCSV.osPlatformField",{defaultMessage:"OS Platform"})},{field:"local_metadata.os.version",description:m.i18n.translate("xpack.fleet.exportCSV.osVersionField",{defaultMessage:"OS Version"})},{field:"tags",description:m.i18n.translate("xpack.fleet.exportCSV.tagsField",{defaultMessage:"Tags"})},{field:"unenrolled_at",description:m.i18n.translate("xpack.fleet.exportCSV.unenrolledAtField",{defaultMessage:"Unenrolled At"})},{field:"unenrolled_reason",description:m.i18n.translate("xpack.fleet.exportCSV.unenrolledReasonField",{defaultMessage:"Unenrolled Reason"})},{field:"unenrollment_started_at",description:m.i18n.translate("xpack.fleet.exportCSV.unenrolledStartedAtField",{defaultMessage:"Unenrolled Started At"})},{field:"unhealthy_reason",description:m.i18n.translate("xpack.fleet.exportCSV.unhealthyReasonField",{defaultMessage:"Unhealthy Reason"})},{field:"updated_at",description:m.i18n.translate("xpack.fleet.exportCSV.updatedAtField",{defaultMessage:"Updated At"})},{field:"upgrade_started_at",description:m.i18n.translate("xpack.fleet.exportCSV.upgradeStartedAtField",{defaultMessage:"Upgrade Started At"})},{field:"upgrade_status",description:m.i18n.translate("xpack.fleet.exportCSV.upgradeStatusField",{defaultMessage:"Upgrade Status"})},{field:"upgraded_at",description:m.i18n.translate("xpack.fleet.exportCSV.upgradedAtField",{defaultMessage:"Upgraded At"})},{field:"user_provided_metadata",description:m.i18n.translate("xpack.fleet.exportCSV.userProvidedMetadataField",{defaultMessage:"User Provided Metadata"})}],ut=({onClose:e,onSubmit:t,agentCount:a})=>{const[l,n]=(0,s.useState)(ot),i=(0,V.uniqBy)([...ot,...rt],"field"),o={selectable:()=>!0,onSelectionChange:e=>{n(e)},initialSelected:ot};return(0,O.jsx)(g.EuiConfirmModal,{"data-test-subj":"agentExportCSVModal",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTitle",defaultMessage:"Download table results as a CSV file"}),onCancel:e,onConfirm:()=>t(l.map((e=>({field:e.field})))),cancelButtonText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.exportCSV.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.exportCSV.confirmButtonLabel",defaultMessage:"Download CSV"})},(0,O.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.exportCSV.agentsCountText",defaultMessage:"Agents"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiNotificationBadge,{color:"subdued",size:"m"},a)))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSpacer,{size:"s"})),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTableDescription",defaultMessage:"Select the table columns to display in the CSV file"}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiInMemoryTable,{tableCaption:"Column",items:i,itemId:"field",columns:[{field:"field",name:"Field",truncateText:!0},{field:"description",name:"Description",truncateText:!0}],selection:o}))))},dt=()=>{const{notifications:e}=(0,u.WeA)(),t=(0,s.useCallback)((async(t,a,s,l)=>{try{const l=await t();if(l.error)throw l.error;const n=!l.data.actionId,i=null!=s?s:m.i18n.translate("xpack.fleet.updateAgentTags.successNotificationTitle",{defaultMessage:"Tag(s) updated"});e.toasts.addSuccess(i),a(n)}catch(t){const a=null!=l?l:m.i18n.translate("xpack.fleet.updateAgentTags.errorNotificationTitle",{defaultMessage:"Tag(s) update failed"});e.toasts.addError(t,{title:a})}}),[e.toasts]);return{updateTags:(0,s.useCallback)((async(e,a,s,l,n)=>{await t((async()=>await(0,u.FA$)(e,{tags:a})),s,l,n)}),[t]),bulkUpdateTags:(0,s.useCallback)((async(e,a,s,l,n,i)=>{await t((async()=>await(0,u.yX1)({agents:e,tagsToAdd:a,tagsToRemove:s,includeInactive:!0})),l,n,i)}),[t])}},ct="fleet.lastSeenInactiveAgentsCount";async function gt(){var e,t;const a=await(0,u.voy)({kuery:"status:online",perPage:0,showInactive:!1});if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0}const pt="fleet.missingEncryptionKeyCalloutHasBeenDismissed",ft=({tagName:e,isTagHovered:t,onTagsUpdated:a})=>{const[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(),[u,d]=(0,s.useState)(t),[c,p]=(0,s.useState)(e);(0,s.useEffect)((()=>{d(t||n)}),[t,n]),(0,s.useEffect)((()=>{p(e)}),[e]);const x=(e=!1)=>{i(!1),e?v():k(c)},h=dt(),E=h.bulkUpdateTags,y='tags:"{name}"',k=t=>{if(t===e||!t)return;const s=y.replace("{name}",e);E(s,[t],[e],(s=>a([t],[e],s)),m.i18n.translate("xpack.fleet.renameAgentTags.successNotificationTitle",{defaultMessage:"Tag renamed"}),m.i18n.translate("xpack.fleet.renameAgentTags.errorNotificationTitle",{defaultMessage:"Tag rename failed"}))},v=()=>{const t=y.replace("{name}",e);h.bulkUpdateTags(t,[],[e],(t=>a([],[e],t)),m.i18n.translate("xpack.fleet.deleteAgentTags.successNotificationTitle",{defaultMessage:"Tag deleted"}),m.i18n.translate("xpack.fleet.deleteAgentTags.errorNotificationTitle",{defaultMessage:"Tag delete failed"}))};return(0,O.jsx)(l().Fragment,null,u&&(0,O.jsx)(g.EuiButtonIcon,{iconType:"boxesHorizontal","aria-label":m.i18n.translate("xpack.fleet.tagOptions.tagOptionsToggleButtonLabel",{defaultMessage:"Tag Options"}),color:"text",onClick:e=>{r(e.currentTarget),i(!n)}}),n&&(0,O.jsx)(g.EuiWrappingPopover,{isOpen:!0,button:o,closePopover:x,anchorPosition:"downCenter"},(0,O.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart",gutterSize:"xs"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFieldText,{placeholder:m.i18n.translate("xpack.fleet.tagOptions.nameTextFieldPlaceholder",{defaultMessage:"Enter new name for tag"}),value:c,required:!0,onKeyDown:e=>{"Enter"===e.key&&x()},onChange:e=>{const t=e.currentTarget.value;p(ke(t))}})),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiButtonEmpty,{size:"s",color:"danger",onClick:()=>{x(!0)}},(0,O.jsx)(g.EuiIcon,{type:"trash"})," ",(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.tagOptions.deleteText",defaultMessage:"Delete tag"}))))))},mt=A()(g.EuiHighlight).withConfig({displayName:"TruncatedEuiHighlight",componentId:"sc-492jbf-0"})(["width:120px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"]),xt=({agentId:e,agents:t,allTags:a,selectedTags:n,button:i,onTagsUpdated:o,onClosePopover:r})=>{const u=(0,s.useCallback)(((e,t)=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,onFocusBadge:!1})))),[]),[d,c]=(0,s.useState)(u(a,n)),[p,x]=(0,s.useState)(void 0),[h,E]=(0,s.useState)(!0),[y,k]=(0,s.useState)({}),v=dt();(0,s.useEffect)((()=>{c(u(a,n))}),[a,u,n]);const j=(0,s.useMemo)((()=>d.some((e=>e.label===p))),[d,p]),b=(e,t,s=!0,l=!1)=>{if(s)return o(e);const n=d.filter((e=>"on"===e.checked)).map((e=>e.label)),i=(0,V.difference)(n,t).concat(e),r=(0,V.uniq)(a.concat(i)),g=l?(0,V.difference)(r,t):r;c(u(g,i))},S=async(a,s,l,i)=>{if(e){const t=(0,V.difference)(n,s).concat(a);v.updateTags(e,t,(()=>o(a)),l,i)}else v.bulkUpdateTags(t,a,s,(e=>b(a,s,e)),l,i)},M=l().createElement(g.EuiButtonEmpty,{color:"text","data-test-subj":"createTagBtn",onClick:()=>{p&&S([p],[],m.i18n.translate("xpack.fleet.createAgentTags.successNotificationTitle",{defaultMessage:"Tag created"}),m.i18n.translate("xpack.fleet.createAgentTags.errorNotificationTitle",{defaultMessage:"Tag creation failed"}))}},l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIcon,{type:"plus"})),l().createElement(g.EuiFlexItem,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.tagsAddRemove.createText",defaultMessage:'Create a new tag "{name}"',values:{name:p}}))));return l().createElement(l().Fragment,null,l().createElement(g.EuiWrappingPopover,{isOpen:h,button:i,closePopover:()=>{E(!1),r()},anchorPosition:"leftUp"},l().createElement(g.EuiSelectable,{onFocus:()=>{},"aria-label":m.i18n.translate("xpack.fleet.tagsAddRemove.selectableTagsLabel",{defaultMessage:"Add / remove tags"}),searchable:!0,searchProps:{"data-test-subj":"addRemoveTags",placeholder:m.i18n.translate("xpack.fleet.tagsAddRemove.findOrCreatePlaceholder",{defaultMessage:"Find or create tag..."}),onChange:e=>{x(ke(e))},value:null!=p?p:""},options:d,renderOption:(e,t)=>l().createElement(g.EuiFlexGroup,{gutterSize:"s",onMouseEnter:()=>k({...y,[e.label]:!0}),onMouseLeave:()=>k({...y,[e.label]:!1})},l().createElement(g.EuiFlexItem,null,l().createElement(mt,{search:t,onClick:()=>{const t="on"===e.checked?[]:[e.label],a="on"===e.checked?[e.label]:[];S(t,a)}},e.label)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ft,{tagName:e.label,isTagHovered:y[e.label],onTagsUpdated:(e,t,a)=>b(e,t,a,!0)})))},((e,t)=>l().createElement(s.Fragment,null,t,e))),j&&0!==d.length||""===p?null:M))},ht=({nAgentsInTable:e,totalManagedAgentIds:t,selectionMode:a,currentQuery:n,selectedAgents:i,agentsOnCurrentPage:o,refreshAgents:r,allTags:d,agentPolicies:c,sortField:p,sortOrder:x})=>{const h=(0,u.RR_)(),E=(0,u.iO7)(),y=h.hasAtLeast($.l7o),[k,v]=(0,s.useState)(!1),j=()=>v(!1),[b,S]=(0,s.useState)(!1),[M,F]=(0,s.useState)(!1),[I,T]=(0,s.useState)({isOpen:!1,isScheduled:!1,isUpdating:!1}),[w,C]=(0,s.useState)(!1),[A,P]=(0,s.useState)(!1),[_,L]=(0,s.useState)(!1),D=(0,s.useMemo)((()=>{if(t.length){const e=`${$.AhM}.agent.id : (${t.map((e=>`"${e}"`)).join(" or ")})`;return`(${n}) AND NOT (${e})`}return n}),[n,t]),R="manual"===a?i:D,N="manual"===a?i.length:e-(null==t?void 0:t.length),[U,H]=(0,s.useState)(),{diagnosticFileUploadEnabled:W,enableExportCSV:G}=z.ZX.get(),{generateReportingJobCSV:q}=function(e){const t=(0,at.WeA)(),{notifications:a,http:s,uiSettings:l}=t,n=(0,at.Q14)(),{data:i}=(0,at.VmO)({enabled:e}),o=i||'emit("")',r=new et.ReportingAPIClient(s,l,n);return{generateReportingJobCSV:(e,s,l)=>{const n=r.getDecoratedJobParams(((e,t,a)=>{var s,l;const n=new Ze.DataView({spec:{title:".fleet-agents",allowHidden:!0,runtimeFieldMap:{status:{type:"keyword",script:{source:o}}}},fieldFormats:{}});let i;i=Array.isArray(e)?`agent.id:(${e.map((e=>e.id)).join(" OR ")})`:e;const r=it(null!==(s=null==a?void 0:a.field)&&void 0!==s?s:"enrolled_at"),u=null!==(l=null==a?void 0:a.direction)&&void 0!==l?l:Ze.SortDirection.desc,d=(0,B.getSortConfig)(r,u),c={type:"search",query:{query:"",language:"kuery"},filter:{meta:{index:"fleet-agents",params:{}},query:(0,Je.toElasticsearchQuery)((0,Je.fromKueryExpression)((0,B.removeSOAttributes)(i)))},fields:t,index:n,sort:d};return{title:"Agent List",objectType:"search",columns:t.map((e=>e.field)),searchSource:c}})(e,s,l));return r.createReportingShareJob("csv_searchsource",n).then((()=>{a.toasts.addSuccess({title:m.i18n.translate("xpack.fleet.modalContent.successfullyQueuedReportNotificationTitle",{defaultMessage:"Queued report for CSV"}),text:(0,tt.Pv)((0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,O.jsx)("a",{href:r.getManagementLink()},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),t),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var t;a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.modalContent.notification.reportingErrorTitle",{defaultMessage:"Unable to create report"}),toastMessage:(0,O.jsx)("span",{dangerouslySetInnerHTML:{__html:null===(t=e.body)||void 0===t?void 0:t.message}})})}))}}}(G),K=[{id:0,items:[{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.addRemoveTags","data-test-subj":"agentBulkActionsAddRemoveTags",defaultMessage:"Add / remove tags"}),icon:(0,O.jsx)(g.EuiIcon,{type:"tag",size:"m"}),disabled:!E.fleet.allAgents,onClick:e=>{H(e.target.closest("button")),C(!w)}},{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.reassignPolicy","data-test-subj":"agentBulkActionsReassign",defaultMessage:"Assign to new policy"}),icon:(0,O.jsx)(g.EuiIcon,{type:"pencil",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),S(!0)}},{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.upgradeAgents","data-test-subj":"agentBulkActionsUpgrade",defaultMessage:"Upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),T({isOpen:!0,isScheduled:!1,isUpdating:!1})}},{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.scheduleUpgradeAgents","data-test-subj":"agentBulkActionsScheduleUpgrade",defaultMessage:"Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(g.EuiIcon,{type:"timeRefresh",size:"m"}),disabled:!E.fleet.allAgents||!y,onClick:()=>{j(),T({isOpen:!0,isScheduled:!0,isUpdating:!1})}},{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.restartUpgradeAgents","data-test-subj":"agentBulkActionsRestartUpgrade",defaultMessage:"Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),T({isOpen:!0,isScheduled:!1,isUpdating:!0})}},...W?[{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.requestDiagnostics","data-test-subj":"agentBulkActionsRequestDiagnostics",defaultMessage:"Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),disabled:!E.fleet.readAgents,icon:(0,O.jsx)(g.EuiIcon,{type:"download",size:"m"}),onClick:()=>{j(),P(!0)}}]:[],{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.unenrollAgents","data-test-subj":"agentBulkActionsUnenroll",defaultMessage:"Unenroll {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),disabled:!E.fleet.allAgents,icon:(0,O.jsx)(g.EuiIcon,{type:"trash",size:"m"}),onClick:()=>{j(),F(!0)}},...G?[{name:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.exportAgents","data-test-subj":"bulkAgentExportBtn",defaultMessage:"Export {agentCount, plural, one {# agent} other {# agents}} as CSV",values:{agentCount:N}}),disabled:!E.fleet.readAgents,icon:(0,O.jsx)(g.EuiIcon,{type:"exportAction",size:"m"}),onClick:()=>{j(),L(!0)}}]:[]]}],Y=(0,s.useMemo)((()=>((e,t,a)=>{const s=e=>e.reduce(((e,t)=>{var s,l;return(e=>{const t=a.find((t=>t.id===e.policy_id));return!!t&&t.is_managed})(t)?e:e.length<1?null!==(l=t.tags)&&void 0!==l?l:[]:(0,V.intersection)(null!==(s=t.tags)&&void 0!==s?s:[],e)}),[]);return Array.isArray(e)?s(t.length>0?t.filter((t=>e.find((e=>e.id===t.id)))):e):s(t)})(R,null!=o?o:[],c)),[R,o,c]);return(0,O.jsx)(l().Fragment,null,b&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.eN,{agents:R,onClose:()=>{S(!1),r()}})),M&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.VH,{agents:R,agentCount:N,onClose:()=>{F(!1),r({refreshTags:!0})}})),_&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(ut,{onSubmit:e=>{q(R,e,{field:p,direction:x}),L(!1)},onClose:()=>{L(!1)},agentCount:N})),I.isOpen&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.YF,{agents:R,agentCount:N,isScheduled:I.isScheduled,isUpdating:I.isUpdating,onClose:()=>{T({isOpen:!1,isScheduled:!1,isUpdating:!1}),r()}})),w&&(0,O.jsx)(xt,{agents:Array.isArray(R)?R.map((e=>e.id)):R,allTags:null!=d?d:[],selectedTags:Y,button:U,onTagsUpdated:()=>{r({refreshTags:!0})},onClosePopover:()=>{C(!1),j()}}),A&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Ee,{agents:R,agentCount:N,onClose:()=>{P(!1)}})),(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiPopover,{id:"agentBulkActionsMenu",button:(0,O.jsx)(g.EuiButton,{fill:!0,iconType:"arrowDown",iconSide:"right",onClick:()=>v(!k),"data-test-subj":"agentBulkActionsButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentBulkActions.actions",defaultMessage:"Actions"})),isOpen:k,closePopover:j,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,O.jsx)(g.EuiContextMenu,{initialPanelId:0,panels:K})))))},Et=({onClickAgentActivity:e,showAgentActivityTour:t})=>{var a;const{storage:n,uiSettings:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(t),d=i.get("hideAnnouncements",!1)||!1===(null===(a=n.get(M.EG.AGENT_ACTIVITY))||void 0===a?void 0:a.active);(0,s.useEffect)((()=>{r(t)}),[t,r]);const c=()=>{r({isOpen:!1}),n.set(M.EG.AGENT_ACTIVITY,{active:!1})};return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTourStep,{content:(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourContent",defaultMessage:"Review in progress, completed, and scheduled agent action activity history here anytime."})),isStepOpen:!d&&o.isOpen,onFinish:c,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourTitle",defaultMessage:"Agent activity history"}),anchorPosition:"upCenter",footerAction:(0,O.jsx)(g.EuiButtonEmpty,{onClick:c},"OK"),anchor:"#agentActivityButton"}),(0,O.jsx)(g.EuiButtonEmpty,{onClick:()=>{e(),r({isOpen:!1})},"data-test-subj":"agentActivityButton",iconType:"clock",id:"agentActivityButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityButton",defaultMessage:"Agent activity"})))};var yt=a(97050);const kt=[{status:"healthy",label:m.i18n.translate("xpack.fleet.agentList.statusHealthyFilterText",{defaultMessage:"Healthy"})},{status:"unhealthy",label:m.i18n.translate("xpack.fleet.agentList.statusUnhealthyFilterText",{defaultMessage:"Unhealthy"})},{status:"updating",label:m.i18n.translate("xpack.fleet.agentList.statusUpdatingFilterText",{defaultMessage:"Updating"})},{status:"offline",label:m.i18n.translate("xpack.fleet.agentList.statusOfflineFilterText",{defaultMessage:"Offline"})},{status:"inactive",label:m.i18n.translate("xpack.fleet.agentList.statusInactiveFilterText",{defaultMessage:"Inactive"})},{status:"unenrolled",label:m.i18n.translate("xpack.fleet.agentList.statusUnenrolledFilterText",{defaultMessage:"Unenrolled"})}],vt=A()(g.EuiNotificationBadge).withConfig({displayName:"LeftpaddedNotificationBadge",componentId:"sc-94zpuo-0"})(["margin-left:10px;"]),jt=({children:e,isOpen:t,setInactiveAgentsCalloutHasBeenDismissed:a})=>l().createElement(g.EuiTourStep,{content:l().createElement(g.EuiText,{size:"s"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepContent",defaultMessage:"Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents."})),isStepOpen:t,minWidth:300,step:1,stepsTotal:0,title:"",onFinish:()=>{},anchorPosition:"upCenter",maxWidth:280,footerAction:l().createElement(g.EuiLink,{onClick:()=>{a(!0)}},l().createElement(f.FormattedMessage,{id:"xpack.fleet.addAgentHelpPopover.footActionButton",defaultMessage:"Got it"}))},e),bt=e=>{const{euiTheme:t}=(0,g.useEuiTheme)(),{selectedStatus:a,onSelectedStatusChange:n,disabled:i,totalInactiveAgents:o,isOpenByDefault:r=!1}=e,[u,d]=(()=>{const{storage:e}=(0,at.WeA)(),[t,a]=(0,s.useState)(0);return(0,s.useEffect)((()=>{const t=e.get(ct);t&&a(parseInt(t,10))}),[e]),[t,t=>{e.set(ct,t.toString()),a(t)}]})(),{isHidden:c,dismiss:p}=(0,yt.w)("INACTIVE_AGENTS"),m=(0,s.useMemo)((()=>{const e=o-u;return e<0?0:e}),[u,o]);(0,s.useMemo)((()=>{a.length&&a.includes("inactive")&&m&&d(o)}),[a,m,d,o]),(0,s.useMemo)((()=>{o>0&&u>o&&d(o)}),[u,o,d]);const[x,h]=(0,s.useState)(r),E=e=>{e&&m>0&&!c&&p(),h(e)},y=(0,s.useCallback)((()=>kt.map((({label:e,status:t})=>({label:e,checked:a.includes(t)?"on":void 0,key:t,append:"inactive"===t&&m>0?l().createElement(vt,null,m):void 0})))),[a,m]),[k,v]=(0,s.useState)(y());(0,s.useEffect)((()=>{v(y())}),[y]);const j=(0,s.useCallback)((e=>{v(e),e.forEach(((e,t)=>{if(e.checked===k[t].checked);else{const t=e.key;"on"!==e.checked?n([...a.filter((e=>e!==t))]):n([...a,t])}}))}),[n,k,a]);return l().createElement(jt,{isOpen:m>0&&!c,setInactiveAgentsCalloutHasBeenDismissed:p},l().createElement(g.EuiPopover,{ownFocus:!0,zIndex:Number(t.levels.header)-1,button:l().createElement(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>E(!x),isSelected:x,hasActiveFilters:a.length>0,numActiveFilters:a.length,numFilters:kt.length,disabled:i,"data-test-subj":"agentList.statusFilter"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.statusFilterText",defaultMessage:"Status"})),isOpen:x,closePopover:()=>E(!1),panelPaddingSize:"none"},l().createElement(g.EuiSelectable,{options:k,onChange:j,"data-test-subj":"agentList.agentStatusFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e))))};function St(e=K.DEFAULT_SPACE_ID,t,a){var s,l,n,i,o;if("installed"!==(null==t||null===(s=t.item)||void 0===s?void 0:s.status))return a;const r=t.item.installationInfo;return r&&(null==r?void 0:r.installed_kibana_space_id)!==e&&null!==(l=null===(n=r.additional_spaces_installed_kibana)||void 0===n||null===(i=n[e])||void 0===i||null===(o=i.find((({originId:e})=>e===a)))||void 0===o?void 0:o.id)&&void 0!==l?l:a}const Mt=()=>{const{data:e}=(0,u.E1o)($.cOw),{spaceId:t}=(0,u.YI3)(),a=(0,u.e3j)(),s=e=>(null==a?void 0:a.getRedirectUrl({dashboardId:e}))||"",n=St(t,e,$.K$s.ELASTIC_AGENT_OVERVIEW),i=St(t,e,$.K$s.ELASTIC_AGENT_AGENT_INFO),{dashboardExists:o,loading:r}=(e=>{const{dashboard:t}=(0,u.WeA)(),{data:a,isLoading:s}=(0,x.useQuery)({queryKey:["dashboard_exists",e],queryFn:async()=>{try{const a=await t.findDashboardsService(),[s]=await a.findByIds([e]);return"success"===(null==s?void 0:s.status)}catch(e){return!1}}});return{dashboardExists:null!=a&&a,loading:s}})(n);return r||!o?null:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexStart"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(n),"data-test-subj":"ingestOverviewLinkButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.ingestOverviewlinkButton",defaultMessage:"Ingest Overview Metrics"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(i),"data-test-subj":"agentInfoLinkButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.agentInfoLinkButton",defaultMessage:"Agent Info Metrics"})))))},Ft=({selectedAgentPolicies:e,onSelectedAgentPoliciesChange:t,agentPolicies:a})=>{const{euiTheme:l}=(0,g.useEuiTheme)(),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>a.map((t=>({label:t.name,checked:e.includes(t.id)?"on":void 0,key:t.id,"data-test-subj":"agentList.agentPolicyFilterOption"})))),[a,e]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,O.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,O.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!n),isSelected:n,hasActiveFilters:e.length>0,numActiveFilters:e.length,numFilters:a.length,disabled:0===a.length,"data-test-subj":"agentList.policyFilter"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.policyFilterText",defaultMessage:"Agent policy"})),isOpen:n,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,O.jsx)(g.EuiSelectable,{options:r,onChange:a=>{u(a),a.forEach(((a,s)=>{if(a.checked===r[s].checked)var l;else{const s=a.key;"on"!==a.checked?(l=s,t(e.filter((e=>e!==l)))):(a=>{t([...e,a])})(s)}}))},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:200}}},(e=>e)))},It=({tags:e,selectedTags:t,onSelectedTagsChange:a})=>{const{euiTheme:l}=(0,g.useEuiTheme)(),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,key:e,"data-test-subj":"agentList.tagFilterOption"})))),[e,t]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,O.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,O.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!n),isSelected:n,hasActiveFilters:t.length>0,numActiveFilters:t.length,numFilters:e.length,disabled:0===e.length,"data-test-subj":"agentList.tagsFilter"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterText",defaultMessage:"Tags"})),isOpen:n,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,O.jsx)(g.EuiSelectable,{options:r,onChange:e=>{e.forEach(((e,s)=>{if(e.checked!==r[s].checked){const s=e.key;return"on"!==e.checked?void(e=>{a(t.filter((t=>t!==e)))})(s):void(e=>{a([...t,e])})(s)}})),u(e)},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e)),(0,O.jsx)(g.EuiHorizontalRule,{margin:"none"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"center",gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{iconType:"error",color:"danger","data-test-subj":"agentList.tagFilterClearAllBtn",onClick:()=>{a([])}},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterClearAllBtnText",defaultMessage:"Clear all"})))))},Tt=({recentErrors:e,onClick:t})=>0===e?null:(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.tooltip",defaultMessage:"{recentErrors, plural, one {There is # new agent activity error} other {There are # new agent activity errors}}. Click to view.",values:{recentErrors:e}})},(0,O.jsx)(g.EuiBadge,{color:"warning",onClick:t,onClickAriaLabel:"Open the Agent activity flyout",iconType:"warning",iconOnClick:t,iconOnClickAriaLabel:"Open the Agent activity flyout","data-test-subj":"agentActivityBadge"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.label",defaultMessage:"Review errors"}))),wt=({agentPolicies:e,draftKuery:t,onDraftKueryChange:a,onSubmitSearch:s,selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,selectedStatus:o,onSelectedStatusChange:r,showUpgradeable:d,onShowUpgradeableChange:c,tags:p,selectedTags:m,onSelectedTagsChange:x,nAgentsInTable:h,totalInactiveAgents:E,totalManagedAgentIds:y,selectionMode:k,currentQuery:v,selectedAgents:j,refreshAgents:b,onClickAddAgent:F,onClickAddFleetServer:I,agentsOnCurrentPage:T,onClickAgentActivity:w,showAgentActivityTour:C,latestAgentActionErrors:A,sortField:P,sortOrder:_})=>{const L=(0,u.iO7)(),{isFirstTimeAgentUser:D,isLoading:R}=(0,Xe.X)(),{cloud:B}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{direction:"column"},(0,O.jsx)(g.EuiFlexGroup,null,(0,O.jsx)(g.EuiFlexItem,null,!R&&!D&&(0,O.jsx)(Mt,null)),(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"flexEnd"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Tt,{recentErrors:A,onClick:w})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Et,{onClickAgentActivity:w,showAgentActivityTour:C})),!L.fleet.addFleetServers||null!=B&&B.isServerlessEnabled?null:(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton.tooltip",defaultMessage:"Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"})},(0,O.jsx)(g.EuiButton,{onClick:I,"data-test-subj":"addFleetServerButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton",defaultMessage:"Add Fleet Server"})))),L.fleet.addAgents?(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addAgentButton.tooltip",defaultMessage:"Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"})},(0,O.jsx)(g.EuiButton,{fill:!0,onClick:F,"data-test-subj":"addAgentButton"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})))):null)),(0,O.jsx)(g.EuiFlexItem,{grow:4},(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,{grow:6},(0,O.jsx)(S.IW,{value:t,fieldPrefix:M.Ah,indexPattern:M.QF,onChange:(e,t)=>{a(e),t&&s(e)},dataTestSubj:"agentList.queryInput"})),(0,O.jsx)(g.EuiFlexItem,{grow:2},(0,O.jsx)(g.EuiFilterGroup,null,(0,O.jsx)(bt,{selectedStatus:o,onSelectedStatusChange:r,totalInactiveAgents:E,disabled:0===e.length}),(0,O.jsx)(It,{tags:p,selectedTags:m,onSelectedTagsChange:x}),(0,O.jsx)(Ft,{selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,agentPolicies:e}),(0,O.jsx)(g.EuiFilterButton,{hasActiveFilters:d,onClick:()=>{c(!d)},"data-test-subj":"agentList.showUpgradeable"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.showUpgradeableFilterLabel",defaultMessage:"Upgrade available"})))),"manual"===k&&j.length||"query"===k&&h>0?(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(ht,{nAgentsInTable:h,totalManagedAgentIds:y,selectionMode:k,currentQuery:v,selectedAgents:j,agentsOnCurrentPage:T,refreshAgents:b,allTags:p,agentPolicies:e,sortField:P,sortOrder:_})):null))))};var Ct=a(7817);const At=({agent:e,agentPolicy:t,onReassignClick:a,onUnenrollClick:l,onGetUninstallCommandClick:n,onUpgradeClick:i,onAddRemoveTagsClick:o,onRequestDiagnosticsClick:r})=>{const{getHref:d}=(0,u.iEg)(),c=(0,Ct.i)(),p="unenrolling"===e.status,[m,x]=(0,s.useState)(!1),{diagnosticFileUploadEnabled:h,agentTamperProtectionEnabled:E}=z.ZX.get(),y=[(0,O.jsx)(g.EuiContextMenuItem,{icon:"inspect",href:d("agent_details",{agentId:e.id}),key:"viewAgent"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.viewActionText",defaultMessage:"View agent"}))];return c.fleet.allAgents&&!1===(null==t?void 0:t.is_managed)&&(y.push((0,O.jsx)(g.EuiContextMenuItem,{icon:"tag",onClick:e=>{o(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,O.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{a()},disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),key:"reassignPolicy"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,O.jsx)(g.EuiContextMenuItem,{key:"agentUnenrollBtn",disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),icon:"trash",onClick:()=>{l()}},p?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),(0,O.jsx)(g.EuiContextMenuItem,{key:"agentUpgradeBtn",icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==t?void 0:t.supports_agentless),onClick:()=>{i()},"data-test-subj":"upgradeBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))),c.fleet.allAgents&&(0,me.isStuckInUpdating)(e)&&y.push((0,O.jsx)(g.EuiContextMenuItem,{key:"agentRestartUpgradeBtn",icon:"refresh",onClick:()=>{i()},"data-test-subj":"restartUpgradeBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))),c.fleet.allAgents&&E&&e.policy_id&&(null==t||!t.supports_agentless)&&y.push((0,O.jsx)(g.EuiContextMenuItem,{icon:"minusInCircle",onClick:()=>{n(),x(!1)},disabled:!e.active,key:"getUninstallCommand","data-test-subj":"uninstallAgentMenuItem"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.getUninstallCommand",defaultMessage:"Uninstall agent"})))),c.fleet.readAgents&&h&&y.push((0,O.jsx)(g.EuiContextMenuItem,{key:"requestAgentDiagnosticsBtn",icon:"download","data-test-subj":"requestAgentDiagnosticsBtn",disabled:!(0,I.fx)(e),onClick:()=>{r()}},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))),(0,O.jsx)(S.AK,{isOpen:m,onChange:e=>x(e),items:y})};var Pt=a(21059),_t=a(17519),Lt=a(51718),Dt=a(86557),Ot=Pt.default,Rt=function(e){return"theme"!==e},Bt=function(e){return"string"==typeof e&&e.charCodeAt(0)>96?Ot:Rt},Nt=function(e,t,a){var s;if(t){var l=t.shouldForwardProp;s=e.__emotion_forwardProp&&l?function(t){return e.__emotion_forwardProp(t)&&l(t)}:l}return"function"!=typeof s&&a&&(s=e.__emotion_forwardProp),s},zt=function(e){var t=e.cache,a=e.serialized,s=e.isStringTag;return(0,_t.registerStyles)(t,a,s),(0,Dt.useInsertionEffectAlwaysWithSyncFallback)((function(){return(0,_t.insertStyles)(t,a,s)})),null},Ut=function e(t,a){var l,n,i=t.__emotion_real===t,o=i&&t.__emotion_base||t;void 0!==a&&(l=a.label,n=a.target);var r=Nt(t,a,i),u=r||Bt(o),c=!u("as");return function(){var g=arguments,p=i&&void 0!==t.__emotion_styles?t.__emotion_styles.slice(0):[];if(void 0!==l&&p.push("label:"+l+";"),null==g[0]||void 0===g[0].raw)p.push.apply(p,g);else{p.push(g[0][0]);for(var f=g.length,m=1;m<f;m++)p.push(g[m],g[0][m])}var x=(0,O.withEmotionCache)((function(e,t,a){var l=c&&e.as||o,i="",d=[],g=e;if(null==e.theme){for(var f in g={},e)g[f]=e[f];g.theme=s.useContext(O.ThemeContext)}"string"==typeof e.className?i=(0,_t.getRegisteredStyles)(t.registered,d,e.className):null!=e.className&&(i=e.className+" ");var m=(0,Lt.serializeStyles)(p.concat(d),t.registered,g);i+=t.key+"-"+m.name,void 0!==n&&(i+=" "+n);var x=c&&void 0===r?Bt(l):u,h={};for(var E in e)c&&"as"===E||x(E)&&(h[E]=e[E]);return h.className=i,h.ref=a,s.createElement(s.Fragment,null,s.createElement(zt,{cache:t,serialized:m,isStringTag:"string"==typeof l}),s.createElement(l,h))}));return x.displayName=void 0!==l?l:"Styled("+("string"==typeof o?o:o.displayName||o.name||"Component")+")",x.defaultProps=t.defaultProps,x.__emotion_real=x,x.__emotion_base=o,x.__emotion_styles=p,x.__emotion_forwardProp=r,Object.defineProperty(x,"toString",{value:function(){return"."+n}}),x.withComponent=function(t,s){return e(t,(0,d.default)({},a,s,{shouldForwardProp:Nt(x,s,!0)})).apply(void 0,p)},x}};const Ht={POLICY_REASSIGN:{inProgressText:"Reassigning",completedText:"assigned to a new policy",cancelledText:"assignment"},UPGRADE:{inProgressText:"Upgrading",completedText:"upgraded",cancelledText:"upgrade"},UNENROLL:{inProgressText:"Unenrolling",completedText:"unenrolled",cancelledText:"unenrollment"},FORCE_UNENROLL:{inProgressText:"Force unenrolling",completedText:"force unenrolled",cancelledText:"force unenrollment"},AUTOMATIC_FORCE_UNENROLL:{inProgressText:"Automatic unenrolling",completedText:"automatically unenrolled",cancelledText:"automatic unenrollment"},UPDATE_TAGS:{inProgressText:"Updating tags of",completedText:"updated tags",cancelledText:"update tags"},CANCEL:{inProgressText:"Cancelling",completedText:"cancelled",cancelledText:""},REQUEST_DIAGNOSTICS:{inProgressText:"Requesting diagnostics for",completedText:"requested diagnostics",cancelledText:"request diagnostics"},SETTINGS:{inProgressText:"Updating settings of",completedText:"updated settings",cancelledText:"update settings"},POLICY_CHANGE:{inProgressText:"Applying policy change on",completedText:"applied policy change",cancelledText:"policy change"},INPUT_ACTION:{inProgressText:"Input action in progress of",completedText:"input action completed",cancelledText:"input action"},ACTION:{inProgressText:"Actioning",completedText:"actioned",cancelledText:"action"}},Wt=(e,t)=>{var a;return null!=t&&t.includes("UnenrollInactiveAgentsTask-")?Ht.AUTOMATIC_FORCE_UNENROLL:null!==(a=Ht[null!=e?e:"ACTION"])&&void 0!==a?a:Ht.ACTION},Gt=(e,t)=>(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivity.inProgressTitle",defaultMessage:"{inProgressText} {nbAgents} {agents}{reassignText}{upgradeText}{failuresText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck>=e.nbAgentsActioned?e.nbAgentsAck:0===e.nbAgentsAck?e.nbAgentsActioned:e.nbAgentsActioned-e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",inProgressText:Wt(e.type,e.actionId).inProgressText,reassignText:"POLICY_REASSIGN"===e.type&&e.newPolicyId?` to ${e.newPolicyId}`:"",upgradeText:"UPGRADE"===e.type?` to version ${e.version}`:"",failuresText:e.nbAgentsFailed>0?`, has ${e.nbAgentsFailed} failure(s)`:"",automaticIcon:t?(0,O.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}})),qt=e=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.startedDescription",defaultMessage:"Started on {date}.",values:{date:Vt(e)}}),Vt=e=>e?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})," ",(0,O.jsx)(f.FormattedTime,{value:e})):null,Kt=({action:e,onClickViewAgents:t})=>{const a=(0,s.useMemo)((()=>e.nbAgentsActionCreated>1e3),[e]);if("UPDATE_TAGS"===e.type)return null;const l=(0,O.jsx)(g.EuiButtonEmpty,{size:"m",onClick:()=>t(e),"data-test-subj":"agentActivityFlyout.viewAgentsButton",disabled:a},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButton",defaultMessage:"View Agents"}));return a?(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",defaultMessage:"The view agents feature is only available for action impacting less than {agentCount} agents",values:{agentCount:1e3}})},l):"POLICY_CHANGE"===e.type?(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonPolicyChangeTooltip",defaultMessage:"View agents currently assigned to this policy"})},l):l},$t=Ut("div",{target:"egpilro0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),Yt=({action:e,abortUpgrade:t,onClickViewAgents:a,onClickManageAutoUpgradeAgents:n})=>{const{docLinks:i}=(0,u.WeA)(),o=e.is_automatic,[r,d]=(0,s.useState)(!1),c=(0,s.useCallback)((async()=>{try{d(!0),await t(e)}finally{d(!1)}}),[e,t]),p=(0,s.useMemo)((()=>{if(!e.startTime)return!1;const t=Date.now();return new Date(e.startTime).getTime()>t}),[e]),m=(0,s.useMemo)((()=>p||e.hasRolloutPeriod),[e,p]);return(0,O.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,O.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{color:"subdued","data-test-subj":"upgradeInProgressDescription"},(0,O.jsx)("p",null,p&&e.startTime?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduledDescription",defaultMessage:"Scheduled for "}),(0,O.jsx)("strong",null,Vt(e.startTime)),". "):(0,O.jsx)(l().Fragment,null,qt(e.creationTime)," ")))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},p?(0,O.jsx)(g.EuiIcon,{type:"clock"}):(0,O.jsx)(g.EuiLoadingSpinner,{size:"m"})),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{color:"#0077CC","data-test-subj":"upgradeInProgressTitle"},p&&e.startTime?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduleTitle",defaultMessage:"{nbAgents} agents scheduled to upgrade to version {version}",values:{nbAgents:e.nbAgentsActioned-e.nbAgentsAck,version:e.version}}):Gt(e,o))))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Kt,{action:e,onClickViewAgents:a})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)($t,null)),o&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>n(e),size:"m"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)($t,null))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,null,(0,O.jsx)(g.EuiLink,{href:i.links.fleet.upgradeElasticAgent,target:"_blank"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.guideLink",defaultMessage:"Learn more"}))))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},m?(0,O.jsx)(g.EuiButton,{size:"s",onClick:c,isLoading:r,"data-test-subj":"abortBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.abortUpgradeButtom",defaultMessage:"Cancel"})):null)))))};var Qt=a(57016);const Xt=({agentId:e,datasets:t,logLevels:a,userQuery:s})=>{const l=`${Qt.JQ.name}:${e}`,n=t.length?t.map((e=>`${Qt.Ep.name}:${e}`)).join(" or "):`${Qt.Ep.name}:${Qt.tO} or ${Qt.Ep.name}:${Qt.sn}`,i=a.map((e=>`${Qt.Jt.name}:${e}`)).join(" or "),o=`${l} and (${n})`,r=i?`${o} and (${i})`:o;return s?`(${r}) and (${s})`:r};var Jt=a(66764);const Zt=e=>new Date(e).getTime(),ea=({logStreamQuery:e,startTime:t,endTime:a})=>{const{share:l}=(0,u.WeA)(),{discoverLogsLocator:n}=(0,Jt.getLogsLocatorsFromUrlService)(l.url),i=(0,u.iO7)(),o=(0,s.useMemo)((()=>{const s=Fe()().toISOString(),l=Fe()().subtract(1,"day").toISOString(),i=Zt(l),o=Zt(s);return null==n?void 0:n.getRedirectUrl({time:a||o,timeRange:{from:(0,Jt.getTimeRangeStartFromTime)(t||i),to:(0,Jt.getTimeRangeEndFromTime)(a||o)},query:{language:"kuery",query:e}})}),[a,e,n,t]);return i.fleet.readAgents&&o?(0,O.jsx)(g.EuiButton,{href:o,iconType:"discoverApp","data-test-subj":"viewInLogsBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentLogs.openInDiscoverUiLinkText",defaultMessage:"Open in Discover"})):null},ta=A()(g.EuiText).withConfig({displayName:"TruncatedEuiText",componentId:"sc-1ioa7tn-0"})(["overflow:hidden;max-height:3rem;text-overflow:ellipsis;"]),aa=({action:e})=>{var t;const a=(0,u.WeA)(),s=[{field:"hostname",name:m.i18n.translate("xpack.fleet.agentList.viewErrors.hostnameColumnTitle",{defaultMessage:"Host Name"}),render:e=>l().createElement(g.EuiText,{size:"s","data-test-subj":"hostText"},e)},{field:"error",name:m.i18n.translate("xpack.fleet.agentList.viewErrors.errorColumnTitle",{defaultMessage:"Error Message"}),render:e=>l().createElement(g.EuiToolTip,{content:e},l().createElement(ta,{size:"s",color:"red","data-test-subj":"errorText"},e))},{field:"agentId",name:m.i18n.translate("xpack.fleet.agentList.viewErrors.actionColumnTitle",{defaultMessage:"Action"}),render:t=>{var s;const n=(null!==(s=e.latestErrors)&&void 0!==s?s:[]).find((e=>e.agentId===t));return l().createElement(k.V,{coreStart:a},((e,t)=>{const a=Fe()(t).subtract(5,"m").toISOString(),s=Fe()(t).add(5,"m").toISOString(),n=Zt(a),i=Zt(s),o=Xt({agentId:e,datasets:["elastic_agent"],logLevels:["error"],userQuery:""});return l().createElement(ea,{logStreamQuery:o,startTime:n,endTime:i})})(t,n.timestamp))}}];return l().createElement(l().Fragment,null,l().createElement(g.EuiAccordion,{id:e.actionId+"_errors",buttonContent:"Show errors"},l().createElement(g.EuiBasicTable,{items:null!==(t=e.latestErrors)&&void 0!==t?t:[],columns:s,tableLayout:"auto"})))},sa=Ut("div",{target:"eqazjax0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),la=({action:e,onClickViewAgents:t,onClickManageAutoUpgradeAgents:a})=>{const s=(0,g.useEuiTheme)(),n=e.is_automatic,i="POLICY_CHANGE"===e.type&&0===e.nbAgentsActioned?(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivity.policyChangeCompletedTitle",defaultMessage:"Policy changed"})):(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,null,(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivity.completedTitle",defaultMessage:"{nbAgents} {agents} {completedText}{versionText}{offlineText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck===e.nbAgentsActioned?e.nbAgentsAck:e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",completedText:Wt(e.type,e.actionId).completedText,offlineText:"ROLLOUT_PASSED"===e.status&&e.nbAgentsActioned-e.nbAgentsAck>0?`, ${e.nbAgentsActioned-e.nbAgentsAck} agent(s) offline during the rollout period`:"",versionText:e.version?` to version ${e.version}`:"",automaticIcon:e.is_automatic?(0,O.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}}))))),o=(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.completedDescription",defaultMessage:"Completed {date}",values:{date:"0001-01-01T00:00:00.000Z"===e.completionTime?null:Vt(e.completionTime)}}),r=(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.failureDescription",defaultMessage:"A problem occurred during this operation."})," ",qt(e.creationTime))),u={IN_PROGRESS:{icon:(0,O.jsx)(g.EuiLoadingSpinner,{size:"m"}),title:(0,O.jsx)(g.EuiText,null,Gt(e,e.is_automatic)),titleColor:s.euiTheme.colors.textPrimary,description:(0,O.jsx)(g.EuiText,{color:"subdued"},qt(e.creationTime))},ROLLOUT_PASSED:{icon:e.nbAgentsFailed>0?(0,O.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"red"}):(0,O.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"green"}),title:i,titleColor:e.nbAgentsFailed>0?"red":"green",description:e.nbAgentsFailed>0?r:(0,O.jsx)(g.EuiText,{color:"subdued"},o)},COMPLETE:{icon:(0,O.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"green"}),title:i,titleColor:"green",description:"POLICY_REASSIGN"===e.type&&e.newPolicyId?(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.reassignCompletedDescription",defaultMessage:"Assigned to {policy}.",values:{policy:e.newPolicyId}})," ",o)):"POLICY_CHANGE"===e.type?(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)("b",null,e.policyId)," ",(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.policyChangedDescription",defaultMessage:"changed to revision {rev} at {date}.",values:{rev:e.revision,date:Vt(e.creationTime)}}))):(0,O.jsx)(g.EuiText,{color:"subdued"},o)},FAILED:{icon:(0,O.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"red"}),title:i,titleColor:"red",description:r},CANCELLED:{icon:(0,O.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"grey"}),titleColor:"grey",title:(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledTitle",defaultMessage:"Agent {cancelledText} cancelled",values:{cancelledText:Wt(e.type,e.actionId).cancelledText}})),description:(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledDescription",defaultMessage:"Cancelled on {date}",values:{date:Vt(e.cancellationTime)}}))},EXPIRED:{icon:(0,O.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"grey"}),titleColor:"grey",title:(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredTitle",defaultMessage:"Agent {expiredText} expired",values:{expiredText:Wt(e.type,e.actionId).cancelledText}})),description:(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredDescription",defaultMessage:"Expired on {date}",values:{date:Vt(e.expiration)}}))}};return(0,O.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,O.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},u[e.status].icon),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{color:u[e.status].titleColor,"data-test-subj":"statusTitle"},u[e.status].title)))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{color:"subdued","data-test-subj":"statusDescription"},u[e.status].description)),(0,O.jsx)(g.EuiFlexItem,{grow:!1},"FAILED"===e.status&&e.latestErrors&&e.latestErrors.length>0?(0,O.jsx)(aa,{action:e}):null)),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Kt,{action:e,onClickViewAgents:t})),n&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(sa,null)),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>a(e),size:"m"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))))))},na=({title:e,actions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiPanel,{color:"subdued",hasBorder:!0,borderRadius:"none"},(0,O.jsx)(g.EuiText,null,(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},t.some((e=>"IN_PROGRESS"===e.status))&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiHealth,{color:"success"})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("b",null,e))))),t.map((e=>"UPGRADE"===e.type&&"IN_PROGRESS"===e.status?(0,O.jsx)(Yt,{action:e,abortUpgrade:a,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):(0,O.jsx)(la,{action:e,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n})))),ia=e=>(0,O.jsx)(g.EuiDatePicker,{"data-test-subj":"agentActivityFlyout.goToDateButton",selected:e.selectedDate,onChange:e.onChangeSelectedDate,maxDate:Fe()(),customInput:e.filledStyle?(0,O.jsx)(oa,e):(0,O.jsx)(ra,e)}),oa=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,O.jsx)(g.EuiButton,{fill:!0,onClick:e},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.goToDateButton",defaultMessage:"Go to date"})))),ra=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,O.jsx)(g.EuiButtonEmpty,{size:"m",flush:"left",onClick:e},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.goToDateButton",defaultMessage:"Go to date"})))),ua=()=>(new Date).toISOString().substring(0,10),da=A()(g.EuiFlyoutBody).withConfig({displayName:"FullHeightFlyoutBody",componentId:"sc-1p58nye-0"})([".euiFlyoutBody__overflowContent{height:100%;}"]),ca=A()(g.EuiFlexGroup).withConfig({displayName:"ButtonsFlexGroup",componentId:"sc-1p58nye-1"})(["padding-left:24px;"]),ga=A().div.withConfig({displayName:"ScrollAnchor",componentId:"sc-1p58nye-2"})(["height:0;margin:0;padding:0;"]),pa=({isFirstLoading:e,currentActions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n,areActionsFullyLoaded:i,onClickShowMore:o,dateFilter:r,onChangeDateFilter:u})=>{const d=l().useRef(null);if(l().useEffect((()=>{var e;null!==(e=d.current)&&void 0!==e&&e.scrollIntoView&&d.current.scrollIntoView()}),[r]),e)return l().createElement(da,null,l().createElement(g.EuiFlexGroup,{direction:"row",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(g.EuiFlexItem,null,l().createElement(xe.Rh,null))));if(0===t.length)return l().createElement(da,null,l().createElement(ga,{ref:d}),l().createElement(g.EuiFlexGroup,{direction:"column",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiEmptyPrompt,{iconType:"clock",iconColor:"default",title:l().createElement("h2",null," ",l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityText",defaultMessage:"No activity to display"})),titleSize:"m",body:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityDescription",defaultMessage:"Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."})})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ia,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!0})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:()=>u(null)},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",defaultMessage:"Clear selected date"})))));const c=t.filter((e=>"IN_PROGRESS"===e.status)),p=t.filter((e=>"IN_PROGRESS"!==e.status)),m=p.filter((e=>e.creationTime.startsWith(ua()))),x=function(e){const t={};return e.filter((e=>!e.creationTime.startsWith(ua()))).forEach((e=>{const a=e.creationTime.substring(0,10);t[a]||(t[a]=[]),t[a].push(e)})),t}(p);return l().createElement(da,null,l().createElement(ga,{ref:d}),l().createElement(g.EuiFlexGroup,{direction:"column"},l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiFlexGroup,{direction:"column"},c.length>0?l().createElement(na,{title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.inProgressTitle",defaultMessage:"In progress"}),actions:c,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):null,m.length>0?l().createElement(na,{title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.todayTitle",defaultMessage:"Today"}),actions:m,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):null,Object.keys(x).map((e=>l().createElement(na,{key:e,title:l().createElement(f.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"}),actions:x[e],abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}))))),l().createElement(g.EuiFlexItem,null,l().createElement(ca,{direction:"row",gutterSize:"s",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{size:"m",onClick:o,disabled:i,flush:"left","data-test-subj":"agentActivityFlyout.showMoreButton"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.showMoreButton",defaultMessage:"Show more"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ia,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!1})),r&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{size:"m",onClick:()=>u(null),flush:"left","data-test-subj":"agentActivityFlyout.clearSelectedDateButton"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.clearSelectedDateutton",defaultMessage:"Clear selected date"})))))))},fa=A()(g.EuiFlyoutFooter).withConfig({displayName:"FlyoutFooterWPadding",componentId:"sc-7yfogs-0"})(["padding:16px 24px !important;"]),ma=({onClose:e,onAbortSuccess:t,refreshAgentActivity:a,setSearch:n,setSelectedStatus:i,openManageAutoUpgradeModal:o})=>{const{notifications:r}=(0,u.WeA)(),{data:d}=(0,u.$sk)({perPage:M.W}),[c,p]=(0,s.useState)(20),[x,h]=(0,s.useState)(null),{currentActions:E,abortUpgrade:y,isFirstLoading:k,areActionsFullyLoaded:v}=function(e,t,a,l){const[n,i]=(0,s.useState)(!0),[o,r]=(0,s.useState)([]),[d,c]=(0,s.useState)(0),[g,p]=(0,s.useState)(!1),{notifications:f,overlays:x}=(0,u.WeA)(),h=(0,s.useCallback)((async()=>{try{const e=await(0,u.RYf)({perPage:a,date:null==l?void 0:l.format()});if(i(!1),e.error)throw e.error;if(!e.data)throw new Error("No data");p(d<a),c(e.data.items.length),r(e.data.items)}catch(e){f.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.actionStatus.fetchRequestError",{defaultMessage:"An error happened while fetching action status"})})}}),[a,l,d,f.toasts]);return n&&h(),(0,s.useEffect)((()=>{t&&h()}),[h,t]),(0,s.useEffect)((()=>{h()}),[h,a]),{currentActions:o,abortUpgrade:(0,s.useCallback)((async t=>{try{if(!await x.openConfirm(m.i18n.translate("xpack.fleet.currentUpgrade.confirmDescription",{defaultMessage:"This action will cancel upgrade of {nbAgents, plural, one {# agent} other {# agents}}",values:{nbAgents:t.nbAgentsActioned-t.nbAgentsAck}}),{title:m.i18n.translate("xpack.fleet.currentUpgrade.confirmTitle",{defaultMessage:"Cancel upgrade?"})}))return;await(0,u.DRU)(t.actionId),await Promise.all([h(),e()])}catch(e){f.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.currentUpgrade.abortRequestError",{defaultMessage:"An error happened while cancelling upgrade"})})}}),[h,f.toasts,x,e]),isFirstLoading:n,areActionsFullyLoaded:g}}(t,a,c,x),j=(0,s.useCallback)((e=>{var t;const a=null==d?void 0:d.items.find((t=>t.id===e));return null!==(t=null==a?void 0:a.name)&&void 0!==t?t:e}),[d]),b=(0,s.useMemo)((()=>E.map((e=>{var t,a;return{...e,newPolicyId:j(null!==(t=e.newPolicyId)&&void 0!==t?t:""),policyId:e.policyId?e.policyId:j(null!==(a=e.newPolicyId)&&void 0!==a?a:"")}}))),[E,j]);return l().createElement(l().Fragment,null,l().createElement(g.EuiFlyout,{"data-test-subj":"agentActivityFlyout",onClose:()=>{a=!1,e()},paddingSize:"none",maxWidth:M.MW},l().createElement(g.EuiFlyoutHeader,{"aria-labelledby":"FleetAgentActivityFlyoutTitle"},l().createElement(g.EuiPanel,{borderRadius:"none",hasShadow:!1,hasBorder:!0},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiTitle,{size:"l"},l().createElement("h1",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.title",defaultMessage:"Agent activity"})))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{color:"subdued"},l().createElement("p",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.activityLogText",defaultMessage:"Activity log of Elastic Agent operations will appear here."}))))))),l().createElement(pa,{isFirstLoading:k,currentActions:b,abortUpgrade:y,onClickViewAgents:async t=>{try{var a;const{data:s}=await(0,u.DTC)({actionIds:[t.actionId]});if(null!=s&&null!==(a=s.items)&&void 0!==a&&a.length){const e=st({selectedAgentIds:s.items});n(e)}i(Ne),e()}catch(e){r.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.agentActivityFlyout.error",{defaultMessage:"Error viewing selected agents"})})}},onClickManageAutoUpgradeAgents:async t=>{e(),o(t.policyId)},areActionsFullyLoaded:v,onClickShowMore:()=>{p(c+10)},dateFilter:x,onChangeDateFilter:e=>{var t;h(null!==(t=null==e?void 0:e.startOf("day"))&&void 0!==t?t:null),p(20)}}),l().createElement(fa,null,l().createElement(g.EuiFlexGroup,{justifyContent:"flexStart"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:e},l().createElement(g.EuiText,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.closeBtn",defaultMessage:"Close"}))))))))},xa=()=>{var e;const{cloud:t}=(0,u.WeA)();(0,u.ifo)("agent_list");const[a,n]=(0,s.useState)([]),[i,r]=(0,s.useState)("manual"),[d,c]=(0,s.useState)({isOpen:!1}),[p,f]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(),v=(0,u.Wdf)(),[j,b]=(0,s.useState)(void 0),[F,T]=(0,s.useState)(void 0),[w,C]=(0,s.useState)(void 0),[A,P]=(0,s.useState)(void 0),[_,L]=(0,s.useState)(void 0),[D,R]=(0,s.useState)(),[B,N]=(0,s.useState)(!1),[U,H]=(0,s.useState)(void 0),[W,G]=(0,s.useState)({isOpen:!1}),{allTags:q,agentsOnCurrentPage:K,agentsStatus:$,isLoading:Y,nAgentsInTable:Q,totalInactiveAgents:X,totalManagedAgentIds:J,managedAgentsOnCurrentPage:ee,showUpgradeable:te,setShowUpgradeable:ae,search:se,setSearch:le,selectedAgentPolicies:ne,setSelectedAgentPolicies:ie,sortField:oe,setSortField:re,sortOrder:ue,setSortOrder:de,selectedStatus:ce,setSelectedStatus:ge,selectedTags:pe,setSelectedTags:fe,allAgentPolicies:he,agentPoliciesRequest:ye,agentPoliciesIndexedById:ke,pagination:ve,pageSizeOptions:je,setPagination:be,kuery:Se,draftKuery:Me,setDraftKuery:Fe,fetchData:Ie,currentRequestRef:Te,latestAgentActionErrors:we,setLatestAgentActionErrors:Ce}=function(){const e=function(){const e=(0,u.iO7)(),t=(0,s.useRef)({}),a=(0,s.useCallback)((async a=>{const s=a.reduce(((e,a)=>(t.current[a]||e.push(a),e)),[]);if(s.length){const a=await(0,u.IDi)(s,{full:e.fleet.readAgentPolicies,ignoreMissing:!0});if(a.error)throw a.error;if(!a.data)throw new Error("Invalid bulk GET agent policies response");a.data.items.forEach((e=>{t.current[e.id]=e}))}return a.reduce(((e,a)=>(t.current[a]&&e.push(t.current[a]),e)),[])}),[e.fleet.readAgentPolicies]);return(0,s.useMemo)((()=>({fetchPolicies:a})),[a])}(),{displayAgentMetrics:t}=z.ZX.get(),{notifications:a}=(0,u.WeA)(),l=(0,o.useHistory)(),{urlParams:n,toUrlParams:i}=(0,u.zmo)(),r=n.kuery||"",d="true"===n.showInactive,[c,g]=(0,s.useState)(!1),[p,f]=(0,s.useState)(r),[x,h]=(0,s.useState)(r),{pagination:E,pageSizeOptions:y,setPagination:k}=(0,u.WQC)(),[v,j]=(0,s.useState)("enrolled_at"),[b,S]=(0,s.useState)("desc"),[F,T]=(0,s.useState)([]),[w,C]=(0,s.useState)(["healthy","unhealthy","updating","offline",...d?["inactive"]:[]]),[A,P]=(0,s.useState)([]),_=(0,s.useMemo)((()=>w.some((e=>"inactive"===e))||0===w.length),[w]),L=(0,s.useMemo)((()=>w.some((e=>"unenrolled"===e))||0===w.length),[w]),D=(0,s.useCallback)((e=>{h(e),(""!==e.trim()||n.kuery)&&n.kuery!==e&&l.replace({search:i({...n,kuery:""===e?void 0:e})})}),[n,l,i]);let O=(0,s.useMemo)((()=>st({search:x,selectedAgentPolicies:F,selectedTags:A,selectedStatus:w})),[x,F,w,A]);O=L&&O?`status:* AND (${O})`:L?"status:*":O;const[R,B]=(0,s.useState)([]),[N,U]=(0,s.useState)(),[H,W]=(0,s.useState)(),[G,q]=(0,s.useState)(!1),[K,$]=(0,s.useState)(0),[Y,Q]=(0,s.useState)(0),[X,J]=(0,s.useState)([]),[Z,ee]=(0,s.useState)(0),[te,ae]=(0,s.useState)({}),[se,le]=(0,s.useState)([]),ne=(0,s.useRef)(!1),ie=(0,s.useRef)(0),oe=(0,s.useCallback)((({refreshTags:s=!1}={})=>{!async function(){if(ne.current)return;ie.current++;const l=ie.current;ne.current=!0;try{var n,i,o;q(!0);const[a,g,p,f,m]=await Promise.all([(0,u.voy)({page:E.currentPage,perPage:E.pageSize,kuery:O&&""!==O?O:void 0,sortField:it(v),sortOrder:b,showInactive:_,showUpgradeable:c,getStatusSummary:!0,withMetrics:t}),(0,u.Wwg)({kuery:z.ir.buildKueryForInactiveAgents()}),(0,u.cnO)({kuery:`${M.mm}.is_managed:true`,perPage:M.W,full:!1}),(0,u.n_W)({showInactive:_}),(0,u.RYf)({latest:35e3,perPage:100})]);if(ie.current!==l)return;if(a.error)throw a.error;if(!a.data)throw new Error("Invalid GET /agents response");if(!g.data)throw new Error("Invalid GET /agents_status response");if(p.error)throw new Error(p.error.message);if(f.error)throw f.error;if(!f.data)throw new Error("Invalid GET /agent/tags response");if(m.error)throw new Error("Invalid GET /agents/action_status response");const h=a.data.statusSummary;if(!h)throw new Error("Invalid GET /agents response - no status summary");const y=a.data.items.map((e=>e.policy_id)),k=await e.fetchPolicies(y);if(ne.current=!1,ie.current!==l)return;ae(k.reduce(((e,t)=>(e[t.id]=t,e)),{})),U((0,I.db)(h));const j=f.data.items;H&&!s&&(0,V.isEqual)(j,H)||W(j),B(a.data.items),$(a.data.total),Q(g.data.results.inactive||0);const S=null!==(n=null===(i=p.data)||void 0===i?void 0:i.items)&&void 0!==n?n:[];if(0===S.length)J([]),ee(0);else{var r,d;const e=st({search:x,selectedAgentPolicies:S.map((e=>e.id)),selectedTags:A,selectedStatus:w}),t=await(0,u.voy)({kuery:`${e}`,perPage:M.W,showInactive:_});if(t.error)throw new Error(t.error.message);const s=null!==(r=null===(d=t.data)||void 0===d?void 0:d.items)&&void 0!==r?r:[],l=null==s?void 0:s.map((e=>e.id));J(l),ee(a.data.items.map((e=>e.id)).filter((e=>l.includes(e))).length)}const F=(null===(o=m.data)||void 0===o?void 0:o.items.filter((e=>{var t,a;return null!==(t=null===(a=e.latestErrors)||void 0===a?void 0:a.length)&&void 0!==t&&t})).map((e=>e.actionId)))||[],T=[...new Set([...se,...F])];(0,V.isEqual)(se,T)||le(T)}catch(e){ne.current=!1,a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.agentList.errorFetchingDataTitle",{defaultMessage:"Error fetching agents"})})}q(!1)}()}),[E.currentPage,E.pageSize,O,v,b,_,c,t,e,H,se,x,A,w,a.toasts]);(0,s.useEffect)((()=>{oe();const e=setInterval((()=>{oe()}),3e4);return()=>clearInterval(e)}),[oe]);const re=(0,u.$sk)({page:1,perPage:M.W}),ue=(0,s.useMemo)((()=>{var e;return(null===(e=re.data)||void 0===e?void 0:e.items)||[]}),[re.data]);return{allTags:H,setAllTags:W,agentsOnCurrentPage:R,agentsStatus:N,isLoading:G,nAgentsInTable:K,totalInactiveAgents:Y,totalManagedAgentIds:X,managedAgentsOnCurrentPage:Z,showUpgradeable:c,setShowUpgradeable:g,search:x,setSearch:D,selectedAgentPolicies:F,setSelectedAgentPolicies:T,sortField:v,setSortField:j,sortOrder:b,setSortOrder:S,selectedStatus:w,setSelectedStatus:C,selectedTags:A,setSelectedTags:P,allAgentPolicies:ue,agentPoliciesRequest:re,agentPoliciesIndexedById:te,pagination:E,pageSizeOptions:y,setPagination:k,kuery:O,draftKuery:p,setDraftKuery:f,fetchData:oe,currentRequestRef:ie,latestAgentActionErrors:se,setLatestAgentActionErrors:le}}(),Ae=(0,s.useCallback)((e=>{le(e),be({...ve,currentPage:1})}),[le,ve,be]),Pe=!!(se.trim()||ne.length||ce.length||pe.length||te),_e=(0,s.useCallback)((()=>{Fe(""),le(""),ie([]),ge([]),fe([]),ae(!1)}),[Fe,le,ie,ge,fe,ae]),Oe=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=ke[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[ke]),Re=(0,s.useMemo)((()=>{if(!F||!F.policy_id)return!1;const e=ke[F.policy_id];return!!e&&(0,z.ob)(e)}),[F,ke]),[Be,Ne]=(()=>{const{missingOptionalFeatures:e}=(0,u.YI3)(),{storage:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=t.get(pt);e&&l(Boolean(e))}),[t]),[(0,s.useMemo)((()=>!(a||!e)&&e.includes("encrypted_saved_object_encryption_key_required")),[e,a]),(0,s.useCallback)((()=>{t.set(pt,"true"),l(!0)}),[t])]})(),{isUnhealthy:ze}=function(){const e=(0,u.iO7)(),{notifications:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!0),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((async()=>{try{var e;const t=await(0,u.eK3)();if(t.error)throw t.error;null!==(e=t.data)&&void 0!==e&&e.fleet_server.has_active||i(!0),l(!1)}catch(e){t.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.fleetServerUnhealthy.requestError",{defaultMessage:"An error happened while fetching fleet server status"})}),l(!1)}}),[t.toasts]);return(0,s.useEffect)((()=>{e.fleet.addAgents||e.fleet.addFleetServers?o():l(!1)}),[o,e.fleet.addAgents,e.fleet.addFleetServers]),{isLoading:a,isUnhealthy:n}}(),{isFleetServerStandalone:Ue}=(0,u.GER)(),He=ze&&!Ue,{shouldDisplayAgentSoftLimit:We}=function(){var e;const t=null===(e=(0,u.UKg)().internal)||void 0===e?void 0:e.activeAgentsSoftLimit,{data:a}=(0,x.useQuery)(["fetch-total-online-agents"],gt,{enabled:void 0!==t});return{shouldDisplayAgentSoftLimit:!(!t||!a)&&a>t}}(),Ge=(0,s.useCallback)((()=>{v.openFleetServerFlyout()}),[v]),qe=(0,s.useCallback)((()=>{f(!0),Ce([])}),[f,Ce]),Ve=({refreshTags:e=!1}={})=>{Ie({refreshTags:e}),G({isOpen:!0})},Ke=1===(null==Te?void 0:Te.current);return(0,O.jsx)(l().Fragment,null,p?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(ma,{onAbortSuccess:Ie,onClose:()=>f(!1),openManageAutoUpgradeModal:e=>{k(e),E(!0)},refreshAgentActivity:Y,setSearch:le,setSelectedStatus:ge})):null,h?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Z.i,{key:y,onClose:()=>E(!1),agentPolicy:he.find((e=>e.id===y))})):null,d.isOpen?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(S.rt,{agentPolicy:he.find((e=>e.id===d.selectedPolicyId)),onClose:()=>{c({isOpen:!1}),Ie(),ye.resendRequest()}})):null,j&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.eN,{agents:[j],onClose:()=>{b(void 0),Ve()}})),F&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.VH,{agents:[F],agentCount:1,onClose:()=>{T(void 0),Ve({refreshTags:!0})},useForceUnenroll:"unenrolling"===F.status,hasFleetServer:Re})),(null==w?void 0:w.policy_id)&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(S.pc,{target:"agent",policyId:w.policy_id,onClose:()=>{C(void 0),Ve({refreshTags:!0})}})),A&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.YF,{agents:[A],agentCount:1,onClose:()=>{P(void 0),Ve()},isUpdating:(0,me.isStuckInUpdating)(A)})),U&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Ee,{agents:[U],agentCount:1,onClose:()=>{H(void 0)}})),B&&(0,O.jsx)(xt,{agentId:null==_?void 0:_.id,allTags:null!=q?q:[],selectedTags:null!==(e=null==_?void 0:_.tags)&&void 0!==e?e:[],button:D,onTagsUpdated:e=>{Ve({refreshTags:!0}),e.length>0&&("No Tags"===pe[0]||Se.includes("not tags:*"))&&N(!1)},onClosePopover:()=>{N(!1)}}),He&&(0,O.jsx)(l().Fragment,null,null!=t&&t.deploymentUrl?(0,O.jsx)(xe.XL,{deploymentUrl:t.deploymentUrl}):(0,O.jsx)(xe.T5,{onClickAddFleetServer:Ge}),(0,O.jsx)(g.EuiSpacer,{size:"l"})),Be&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(xe.a4,{onClickHandler:Ne}),(0,O.jsx)(g.EuiSpacer,{size:"l"})),We&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(De,null),(0,O.jsx)(g.EuiSpacer,{size:"l"})),(0,O.jsx)(wt,{agentPolicies:he,draftKuery:Me,onDraftKueryChange:Fe,onSubmitSearch:Ae,selectedAgentPolicies:ne,onSelectedAgentPoliciesChange:e=>{"query"===i&&r("manual"),ie(e)},selectedStatus:ce,onSelectedStatusChange:e=>{"query"===i&&r("manual"),ge(e)},showUpgradeable:te,onShowUpgradeableChange:ae,tags:null!=q?q:[],selectedTags:pe,onSelectedTagsChange:fe,nAgentsInTable:Q,totalInactiveAgents:X,totalManagedAgentIds:J,selectionMode:i,currentQuery:Se,selectedAgents:a,refreshAgents:Ve,onClickAddAgent:()=>c({isOpen:!0}),onClickAddFleetServer:Ge,agentsOnCurrentPage:K,onClickAgentActivity:qe,showAgentActivityTour:W,latestAgentActionErrors:we.length,sortField:oe,sortOrder:ue}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Qe,{totalAgents:Q,totalManagedAgents:J.length||0,agentStatus:$,selectableAgents:(null==K?void 0:K.filter(Oe).length)||0,managedAgentsOnCurrentPage:ee,selectionMode:i,setSelectionMode:r,selectedAgents:a,setSelectedAgents:e=>{n(e),r("manual")},clearFilters:_e,isUsingFilter:Pe}),(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(Le,{agents:K,sortField:oe,pageSizeOptions:je,sortOrder:ue,isLoading:Y,agentPoliciesIndexedById:ke,renderActions:e=>{const t="string"==typeof e.policy_id?ke[e.policy_id]:void 0;return(null==_?void 0:_.id)!==e.id||(0,V.isEqual)(e.tags,_.tags)||L(e),(0,O.jsx)(At,{agent:e,agentPolicy:t,onReassignClick:()=>b(e),onUnenrollClick:()=>T(e),onUpgradeClick:()=>P(e),onAddRemoveTagsClick:t=>{R(t),L(e),N(!B)},onGetUninstallCommandClick:()=>C(e),onRequestDiagnosticsClick:()=>H(e)})},onSelectionChange:e=>{if("query"===i&&e.length<a.length){if(!(a.length>0&&0===(0,V.differenceBy)(a,K,"id").length))return n(K.filter((e=>Oe(e))));r("manual")}n(e)},selected:a,showUpgradeable:te,onTableChange:({page:e,sort:t})=>{const a={...ve,currentPage:e.index+1,pageSize:e.size};be(a),re(t.field),de(t.direction)},pagination:ve,totalAgents:Math.min(Q,M.W),isUsingFilter:Pe,setEnrollmentFlyoutState:c,clearFilters:_e,isCurrentRequestIncremented:Ke}))};var ha=a(43609),Ea=a(94655),ya=a(61215),ka=a(23833),va=a.n(ka),ja=a(60362),ba=a.n(ja);const Sa=function(e,t={}){const a=l().lazy(e);return l().forwardRef(((e,n)=>{var i;return(0,O.jsx)(s.Suspense,{fallback:null!==(i=t.fallback)&&void 0!==i?i:null},l().createElement(a,{...e,ref:n}))}))}((()=>a.e(741).then(a.bind(a,12741)).then((e=>({default:e.SavedSearchComponent})))));var Ma=a(61777);const Fa=(0,s.memo)((({selectedDatasets:e,onToggleDataset:t})=>{const{unifiedSearch:a,data:l}=(0,u.WeA)(),[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(!1),[d,c]=(0,s.useState)([Qt.tO]),p=(0,s.useCallback)((()=>i((e=>!e))),[i]),f=(0,s.useCallback)((()=>i(!1)),[i]),x=(0,s.useCallback)((t=>t.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t})))),[e]),[h,E]=(0,s.useState)(x(d));return(0,s.useEffect)((()=>{(async()=>{r(!0);try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Qt.Lr})).reduce(((e,t)=>(e[t.name]=t,e)),{}),t=await l.dataViews.create({title:Qt.Lr,fields:e}),s=await a.autocomplete.getValueSuggestions({indexPattern:t,field:Qt.Ep,query:""});s.length>0&&(c(s.sort()),E(x(s.sort())))}catch(e){c([Qt.tO]),E(x([Qt.tO]))}r(!1)})()}),[l.dataViews,a.autocomplete,x]),(0,O.jsx)(g.EuiPopover,{button:(0,O.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.datasetFilterBtn",iconType:"arrowDown",onClick:p,isSelected:n,isLoading:o,numFilters:d.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},m.i18n.translate("xpack.fleet.agentLogs.datasetSelectText",{defaultMessage:"Dataset"})),isOpen:n,closePopover:f,panelPaddingSize:"none"},(0,O.jsx)(g.EuiSelectable,{options:h,onChange:e=>{E(e),e.forEach(((e,a)=>{e.checked===h[a].checked||t(e.label)}))},"data-test-subj":"agentList.datasetFilterOptions",isLoading:o,listProps:{paddingSize:"s",style:{minWidth:220}}},(e=>e)))})),Ia=(0,s.memo)((({selectedLevels:e,onToggleLevel:t})=>{const[a,l]=(0,s.useState)(!1),n=(0,s.useCallback)((()=>l((e=>!e))),[]),i=(0,s.useCallback)((()=>l(!1)),[]),[o,r]=(0,s.useState)($.F$W.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t}))));return(0,O.jsx)(g.EuiPopover,{button:(0,O.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.logLevelFilterBtn",iconType:"arrowDown",onClick:n,isSelected:a,numFilters:o.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},m.i18n.translate("xpack.fleet.agentLogs.logLevelSelectText",{defaultMessage:"Log level"})),isOpen:a,closePopover:i,panelPaddingSize:"none"},(0,O.jsx)(g.EuiSelectable,{options:o,onChange:e=>{r(e),e.forEach(((e,a)=>{e.checked===o[a].checked||t(e.label)}))},"data-test-subj":"agentList.logLevelFilterOptions",listProps:{paddingSize:"s"}},(e=>e)))})),Ta=[Qt.JQ.name,Qt.Ep.name,Qt.Jt.name],wa=(0,s.memo)((({query:e,isQueryValid:t,onUpdateQuery:a})=>{const{data:l,unifiedSearch:{ui:{QueryStringInput:n}}}=(0,u.WeA)(),[i,o]=(0,s.useState)();return(0,s.useEffect)((()=>{(async()=>{try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Qt.Lr})||[]).filter((e=>!Ta.includes(e.name)));o(e)}catch(e){o(void 0)}})()}),[l.dataViews]),(0,O.jsx)(n,{iconType:"search",autoSubmit:!0,disableLanguageSwitcher:!0,indexPatterns:i?[{title:Qt.Lr,fields:i}]:[],query:{query:e,language:"kuery"},isInvalid:!t,disableAutoFocus:!0,placeholder:m.i18n.translate("xpack.fleet.agentLogs.searchPlaceholderText",{defaultMessage:"Search logs…"}),onChange:e=>{a(e.query)},onSubmit:e=>{a(e.query,!0)},appName:m.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"})})})),Ca=(0,s.memo)((({agent:e,agentPolicyLogLevel:t=$.OHG})=>{var a,n,i,o,r,d,c;const p=(0,u.iO7)(),{notifications:x}=(0,u.WeA)(),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),v=va()(null===(a=e.local_metadata)||void 0===a||null===(n=a.elastic)||void 0===n||null===(i=n.agent)||void 0===i?void 0:i.version,"8.15.0",!0),[j,b]=(0,s.useState)(null!==(o=null===(r=e.local_metadata)||void 0===r||null===(d=r.elastic)||void 0===d||null===(c=d.agent)||void 0===c?void 0:c.log_level)&&void 0!==o?o:$.OHG),[S,M]=(0,s.useState)(j),F=(0,s.useCallback)((()=>{k(!0),async function(){try{const a=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:null}}});if(a.error)throw a.error;b(t),M(t),x.toasts.addSuccess(m.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.successText",{defaultMessage:"Reset agent logging level to policy"}))}catch(e){x.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.errorTitleText",{defaultMessage:"Error resetting agent logging level"})})}k(!1)}()}),[e.id,t,x]),I=(0,s.useCallback)((()=>{E(!0),async function(){try{const t=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:S}}});if(t.error)throw t.error;b(S),x.toasts.addSuccess(m.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.successText",{defaultMessage:"Changed agent logging level to ''{logLevel}''",values:{logLevel:S}}))}catch(e){x.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.errorTitleText",{defaultMessage:"Error updating agent logging level"})})}E(!1)}()}),[x,S,e.id]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiFormLabel,{htmlFor:"selectAgentLogLevel"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Agent logging level"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiSelect,{disabled:h||!p.fleet.allAgents,compressed:!0,id:"selectAgentLogLevel","data-test-subj":"selectAgentLogLevel",value:S,onChange:e=>{M(e.target.value)},options:$.F$W.map((e=>({value:e,text:e})))})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!p.fleet.allAgents,isLoading:h||y,iconType:"check",onClick:I,"data-test-subj":"applyLogLevelBtn"},h?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentLogs.updateButtonLoadingText",defaultMessage:"Applying changes..."}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentLogs.updateButtonText",defaultMessage:"Apply changes"}))),v&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!p.fleet.allAgents,isLoading:h||y,iconType:"cross",onClick:F,"data-test-subj":"resetLogLevelBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentLogs.resetLogLevelLabelText",defaultMessage:"Reset to policy"})))))})),Aa=A()(g.EuiFlexGroup).withConfig({displayName:"WrapperFlexGroup",componentId:"sc-fcgfrk-0"})(["height:100%;"]),Pa=A()(g.EuiFlexItem).withConfig({displayName:"DatePickerFlexItem",componentId:"sc-fcgfrk-1"})(["max-width:312px;"]),_a=(0,ya.createStateContainerReactHelpers)(),La=({agentPolicy:e})=>{const{getHref:t}=(0,u.iEg)();return l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:"info",title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutTitle",defaultMessage:"Log collection is disabled"})},e.is_managed?null:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutDescription",defaultMessage:"Update the agent's policy {settingsLink} to enable logs collection.",values:{settingsLink:l().createElement(g.EuiLink,{href:t("policy_details",{policyId:e.id,tabId:"settings"})},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentLogs.settingsLink",defaultMessage:"settings"}))}})))},Da=(0,s.memo)((({agent:e,agentPolicy:t,state:a})=>{var n,i,o,r,d;const{application:c,logsDataAccess:{services:{logSourcesService:p}},embeddable:m,data:{search:{searchSource:x},query:{timefilter:{timefilter:h}},dataViews:E}}=(0,u.WeA)(),y=(0,Ma.A)(p.getFlattenedLogSources),{update:v}=_a.useTransitions(),j=(0,s.useCallback)((e=>{const{min:t,max:a}=h.calculateBounds(e);return t&&a?{start:t.valueOf(),end:a.valueOf()}:void 0}),[h]),b=(0,s.useCallback)((e=>{j(e)&&v({start:e.from,end:e.to})}),[j,v]),S=(0,s.useCallback)((e=>{try{return(0,Je.fromKueryExpression)(e),!0}catch(e){return!1}}),[]),[M,F]=(0,s.useState)(a.query),[I,T]=(0,s.useState)(S(a.query)),w=(0,s.useCallback)(((e,t)=>{F(e),S(e)?(T(!0),t&&v({query:e})):T(!1)}),[S,v]),C=(0,s.useMemo)((()=>({language:"kuery",query:Xt({agentId:e.id,datasets:a.datasets,logLevels:a.logLevels,userQuery:a.query})})),[e.id,a.datasets,a.logLevels,a.query]),A=null===(n=e.local_metadata)||void 0===n||null===(i=n.elastic)||void 0===i||null===(o=i.agent)||void 0===o?void 0:o.version;return(0,s.useMemo)((()=>{var e;if(!A)return!1;const t=null===(e=ba()(A))||void 0===e?void 0:e.version;return!!t&&va()(t,"7.11.0")}),[A])?l().createElement(Aa,{direction:"column",gutterSize:"m"},t&&!(null!==(r=t.monitoring_enabled)&&void 0!==r&&r.includes("logs"))&&l().createElement(La,{agentPolicy:t}),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexGroup,{gutterSize:"m"},l().createElement(g.EuiFlexItem,null,l().createElement(wa,{query:M,onUpdateQuery:w,isQueryValid:I})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFilterGroup,null,l().createElement(Fa,{selectedDatasets:a.datasets,onToggleDataset:e=>{const t=[...a.datasets],s=t.indexOf(e);s>=0?(t.splice(s,1),v({datasets:t})):v({datasets:[...a.datasets,e]})}}),l().createElement(Ia,{selectedLevels:a.logLevels,onToggleLevel:e=>{const t=[...a.logLevels],s=t.indexOf(e);s>=0?(t.splice(s,1),v({logLevels:t})):v({logLevels:[...a.logLevels,e]})}}))),l().createElement(Pa,{grow:!1},l().createElement(g.EuiSuperDatePicker,{showUpdateButton:!1,start:a.start,end:a.end,onTimeChange:({start:e,end:t})=>{b({from:e,to:t})}})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(k.V,{coreStart:{application:c}},l().createElement(ea,{logStreamQuery:C.query,startTime:Zt(a.start),endTime:Zt(a.end)}))))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiPanel,{paddingSize:"none",grow:!1},y.value?l().createElement(Sa,{dependencies:{embeddable:m,searchSource:x,dataViews:E},index:y.value,timeRange:{from:a.start,to:a.end},query:C,height:"60vh",displayOptions:{enableDocumentViewer:!0,enableFilters:!1},columns:["@timestamp","event.dataset","component.id","message","error.message"]}):null),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Ca,{agent:e,agentPolicyLogLevel:null==t||null===(d=t.advanced_settings)||void 0===d?void 0:d.agent_logging_level})))):l().createElement(g.EuiCallOut,{size:"m",color:"warning",title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentLogs.oldAgentWarningTitle",defaultMessage:"The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",values:{downloadLink:l().createElement(g.EuiLink,{href:"https://ela.st/download-elastic-agent",external:!0,target:"_blank"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentLogs.downloadLink",defaultMessage:"download"}))}})})})),Oa=(0,s.memo)((({agent:e,agentPolicy:t})=>{const a=(0,s.useMemo)((()=>(0,ya.createStateContainer)({...Qt.ky,...(0,ya.getStateFromKbnUrl)(Qt.CK,window.location.href,{getFromHashQuery:!1})},{update:e=>t=>({...e,...t})})),[]),l=(0,s.useMemo)((()=>_a.connect((e=>({state:e||Qt.ky})))(Da)),[]),[n,i]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=(0,ya.createKbnUrlStateStorage)({useHashQuery:!1,useHash:!1}),{start:t,stop:s}=(0,ya.syncState)({storageKey:Qt.CK,stateContainer:a,stateStorage:e});return t(),i(!0),()=>{s(),a.set(Qt.ky)}}),[a]),(0,O.jsx)(_a.Provider,{value:a},n?(0,O.jsx)(l,{agent:e,agentPolicy:t}):null)})),Ra=(0,s.memo)((({agent:e,onClose:t})=>{var a,s;const l=JSON.stringify(e,null,2),n="string"==typeof(null===(a=e.local_metadata)||void 0===a||null===(s=a.host)||void 0===s?void 0:s.hostname)?e.local_metadata.host.hostname:e.id,{docLinks:i}=(0,u.WeA)();return(0,O.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW},(0,O.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(g.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutTitle",defaultMessage:"''{name}'' agent details",values:{name:n}})))),(0,O.jsx)(g.EuiFlyoutBody,null,(0,O.jsx)(g.EuiText,null,(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDescription",defaultMessage:"The JSON below is the raw agent data tracked by Fleet. This data can be useful for debugging or troubleshooting Elastic Agent. For more information, see the {doc}.",values:{doc:(0,O.jsx)(g.EuiLink,{href:i.links.fleet.troubleshooting},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDocLink",defaultMessage:"troubleshooting documentation"}))}}))),(0,O.jsx)(g.EuiSpacer,null),(0,O.jsx)(g.EuiCodeBlock,{language:"json",isCopyable:!0},l)),(0,O.jsx)(g.EuiFlyoutFooter,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonFlyoutCloseButtonLabel",defaultMessage:"Close"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{iconType:"download",onClick:()=>{const e=document.createElement("a");e.href=`data:text/json;charset=utf-8,${encodeURIComponent(l)}`,e.download=`${n}-agent-details.json`,e.click()}},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonDownloadButtonLabel",defaultMessage:"Download JSON"}))))))})),Ba=(0,s.memo)((({agent:e,assignFlyoutOpenByDefault:t=!1,onCancelReassign:a,agentPolicy:n})=>{const i=(0,u.iO7)(),o=i.fleet.allAgents,r=(0,Ea.a)(),[d,c]=(0,s.useState)(t),[p,m]=(0,s.useState)(!1),[x,h]=(0,s.useState)(!1),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),j="unenrolling"===e.status,b=(0,me.isStuckInUpdating)(e),[M,F]=(0,s.useState)(!1),T=(0,s.useCallback)((e=>{F(e)}),[F]),w=n&&(0,z.ob)(n),{diagnosticFileUploadEnabled:C}=z.ZX.get(),A=(0,s.useMemo)((()=>a||(()=>c(!1))),[a,c]),P=[...!o||null!=n&&n.is_managed?[]:[(0,O.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{c(!0)},disabled:!e.active&&!n||!0===(null==n?void 0:n.supports_agentless),key:"reassignPolicy"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,O.jsx)(g.EuiContextMenuItem,{icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{h(!0)},key:"upgradeAgent","data-test-subj":"upgradeBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))],...o&&b?[(0,O.jsx)(g.EuiContextMenuItem,{icon:"refresh",onClick:()=>{h(!0)},key:"restartUpgradeAgent","data-test-subj":"restartUpgradeBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))]:[],(0,O.jsx)(g.EuiContextMenuItem,{icon:"inspect",onClick:()=>{F(!1),v(!k)},key:"agentDetailsJson","data-test-subj":"viewAgentDetailsJsonBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.viewAgentDetailsJsonText",defaultMessage:"View agent JSON"})),...i.fleet.readAgents&&C?[(0,O.jsx)(g.EuiContextMenuItem,{icon:"download",disabled:!(0,I.fx)(e),onClick:()=>{y(!0)},"data-test-subj":"requestAgentDiagnosticsBtn",key:"requestDiagnostics"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))]:[],...!o||null!=n&&n.is_managed?[]:[(0,O.jsx)(g.EuiContextMenuItem,{icon:"trash",disabled:!o||!e.active||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{m(!0)},key:"unenrollAgent"},j?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"}))]];return(0,O.jsx)(l().Fragment,null,d&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.eN,{agents:[e],onClose:A})),p&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.VH,{agents:[e],agentCount:1,onClose:()=>{m(!1),r()},useForceUnenroll:j,hasFleetServer:w})),x&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xe.YF,{agents:[e],agentCount:1,onClose:()=>{h(!1),r()},isUpdating:b})),E&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Ee,{agents:[e],agentCount:1,onClose:()=>{y(!1)}})),k&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Ra,{agent:e,onClose:()=>v(!1)})),(0,O.jsx)(S.AK,{isOpen:M,onChange:T,button:{props:{iconType:"arrowDown",iconSide:"right",color:"primary"},children:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.actionsButton",defaultMessage:"Actions"})},items:P}))})),Na=A()(g.EuiButton).withConfig({displayName:"EuiButtonCompressed",componentId:"sc-1y6vsns-0"})(["height:32px;"]),za=({agent:e,agentPolicy:t})=>{var a,s;const{isInstalled:n,link:i,isLoading:o}=function(e){const{isLoading:t,data:a}=(0,u.E1o)($.cOw),{spaceId:s}=(0,u.YI3)(),l=function(e,t){var a,s;if("installed"!==(null==t||null===(a=t.item)||void 0===a?void 0:a.status))return!1;const l=t.item.installationInfo;return!(!l||"installed"!==l.install_status)&&(l.installed_kibana_space_id===e||e&&(null===(s=l.additional_spaces_installed_kibana)||void 0===s?void 0:s[e]))}(s,a),n=(0,u.e3j)();return{isLoading:t,isInstalled:l,link:null==n?void 0:n.getRedirectUrl({dashboardId:St(s,a,$.K$s.ELASTIC_AGENT_AGENT_METRICS),query:{language:"kuery",query:`elastic_agent.id:${e.id}`}})}}(e),{getHref:r}=(0,u.iEg)(),c=null!==(a=null==t||null===(s=t.monitoring_enabled)||void 0===s?void 0:s.length)&&void 0!==a&&a,p=n&&!o&&c?{href:i}:{disabled:!0},m=l().createElement(Na,(0,d.default)({},p,{isLoading:o,color:"primary",iconType:"dashboardApp"}),l().createElement(f.FormattedMessage,{"data-test-subj":"agentDetails.viewMoreMetricsButton",id:"xpack.fleet.agentDetails.viewDashboardButtonLabel",defaultMessage:"View more agent metrics"}));return o||c||!t?n?m:l().createElement(g.EuiToolTip,{content:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoIntegrationTooltip",defaultMessage:"Agent dashboard not found, you need to install the elastic_agent integration."})},m):l().createElement(g.EuiToolTip,{content:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoLogsAndMetricsTooltip",defaultMessage:"Logs and metrics for agent are not enabled in the agent policy."})},l().createElement(Na,{"data-test-subj":"agentDetails.enableLogsAndMetricsButton",isLoading:o,color:"primary",href:r("policy_details",{policyId:t.id,tabId:"settings"}),disabled:null==t?void 0:t.is_managed},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.enableLogsAndMetricsLabel",defaultMessage:"Enable logs and metrics"})))},Ua=A()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1y4d0ny-0"})(["min-width:0px;"]),Ha=(0,s.memo)((({agent:e,agentPolicy:t})=>{var a,s,n,i,o,r,d,c,p,x,h,E,y,k,v,j,b,M,F;const I=(0,u.JhS)(),{displayAgentMetrics:T}=z.ZX.get();return l().createElement(g.EuiPanel,null,l().createElement(g.EuiDescriptionList,{compressed:!0},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},T&&l().createElement(g.EuiFlexGroup,null,l().createElement(Ua,{grow:5},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},[{title:l().createElement(g.EuiToolTip,{content:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes"})},l().createElement("span",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTitle",defaultMessage:"CPU"})," ",l().createElement(g.EuiIcon,{type:"info"}))),description:be(e.metrics,t)},{title:l().createElement(g.EuiToolTip,{content:l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},l().createElement("span",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTitle",defaultMessage:"Memory"})," ",l().createElement(g.EuiIcon,{type:"info"}))),description:Se(e.metrics,t)}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(g.EuiFlexGroup,null,l().createElement(Ua,{grow:8},l().createElement(g.EuiDescriptionListTitle,null,e)),l().createElement(Ua,{grow:4},l().createElement(g.EuiToolTip,{position:"top",content:a},l().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))),l().createElement(Ua,{grow:5},l().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(za,{agent:e,agentPolicy:t}))))),[{title:m.i18n.translate("xpack.fleet.agentDetails.statusLabel",{defaultMessage:"Status"}),description:l().createElement(xe.u0,{agent:e,fromDetails:!0})},{title:m.i18n.translate("xpack.fleet.agentDetails.lastActivityLabel",{defaultMessage:"Last activity"}),description:e.last_checkin?l().createElement(f.FormattedRelative,{value:new Date(e.last_checkin)}):"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.lastCheckinMessageLabel",{defaultMessage:"Last checkin message"}),description:e.last_checkin_message?e.last_checkin_message:"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.agentIdLabel",{defaultMessage:"Agent ID"}),description:e.id},{title:m.i18n.translate("xpack.fleet.agentDetails.agentPolicyLabel",{defaultMessage:"Agent policy"}),description:t?l().createElement(S.an,{policy:t,agent:e}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:m.i18n.translate("xpack.fleet.agentDetails.versionLabel",{defaultMessage:"Agent version"}),description:"string"==typeof(null===(a=e.local_metadata)||void 0===a||null===(s=a.elastic)||void 0===s||null===(n=s.agent)||void 0===n?void 0:n.version)?l().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",style:{minWidth:0}},l().createElement(g.EuiFlexItem,{grow:!1,className:"eui-textNoWrap"},e.local_metadata.elastic.agent.version),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Ae,{isAgentUpgradable:!(!0===(null==t?void 0:t.is_managed)||!(0,z._3)(e)),agent:e,latestAgentVersion:I}))):"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.hostNameLabel",{defaultMessage:"Host name"}),description:"string"==typeof(null===(i=e.local_metadata)||void 0===i||null===(o=i.host)||void 0===o?void 0:o.hostname)?e.local_metadata.host.hostname:"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.hostIdLabel",{defaultMessage:"Host ID"}),description:"string"==typeof(null===(r=e.local_metadata)||void 0===r||null===(d=r.host)||void 0===d?void 0:d.id)?e.local_metadata.host.id:"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.logLevel",{defaultMessage:"Logging level"}),description:"string"==typeof(null===(c=e.local_metadata)||void 0===c||null===(p=c.elastic)||void 0===p||null===(x=p.agent)||void 0===x?void 0:x.log_level)?e.local_metadata.elastic.agent.log_level:"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.privilegeModeLabel",{defaultMessage:"Privilege mode"}),description:!0===e.local_metadata.elastic.agent.unprivileged?l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModeUnprivilegedText",defaultMessage:"Running as non-root"}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Running as root"})},{title:m.i18n.translate("xpack.fleet.agentDetails.releaseLabel",{defaultMessage:"Agent release"}),description:"boolean"==typeof(null===(h=e.local_metadata)||void 0===h||null===(E=h.elastic)||void 0===E||null===(y=E.agent)||void 0===y?void 0:y.snapshot)?!0===e.local_metadata.elastic.agent.snapshot?"snapshot":"stable":"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"Platform"}),description:"string"==typeof(null===(k=e.local_metadata)||void 0===k||null===(v=k.os)||void 0===v?void 0:v.platform)?e.local_metadata.os.platform:"-"},{title:m.i18n.translate("xpack.fleet.agentDetails.monitorLogsLabel",{defaultMessage:"Monitor logs"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(j=t.monitoring_enabled)&&void 0!==j&&j.includes("logs")?l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsEnabledText",defaultMessage:"Enabled"}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsDisabledText",defaultMessage:"Disabled"}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:m.i18n.translate("xpack.fleet.agentDetails.monitorMetricsLabel",{defaultMessage:"Monitor metrics"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(b=t.monitoring_enabled)&&void 0!==b&&b.includes("metrics")?l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsEnabledText",defaultMessage:"Enabled"}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsDisabledText",defaultMessage:"Disabled"}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:m.i18n.translate("xpack.fleet.agentDetails.tagsLabel",{defaultMessage:"Tags"}),description:(null!==(M=e.tags)&&void 0!==M?M:[]).length>0?l().createElement(je,{tags:null!==(F=e.tags)&&void 0!==F?F:[]}):"-"}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(g.EuiFlexGroup,null,l().createElement(Ua,{grow:3},l().createElement(g.EuiDescriptionListTitle,null,e)),l().createElement(Ua,{grow:7},l().createElement(g.EuiToolTip,{position:"top",content:a},l().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))))}));var Wa=a(91785);const Ga=A()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1n7kbng-0"})(["min-width:0px;"]),qa=(0,s.memo)((({agent:e,agentPolicy:t})=>l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{alignItems:"flexStart"},l().createElement(Ga,null,l().createElement(g.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.overviewSectionTitle",defaultMessage:"Overview"}))),l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(Ha,{agent:e,agentPolicy:t})),l().createElement(Ga,null,l().createElement(g.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentDetails.integrationsSectionTitle",defaultMessage:"Integrations"}))),l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(Wa.P,{agent:e,agentPolicy:t})))))),Va=({agent:e})=>{const t=(0,u.iO7)(),{notifications:a}=(0,u.WeA)(),{getAbsolutePath:n}=(0,u.iEg)(),[i,o]=(0,s.useState)(!0),[r,d]=(0,s.useState)(!1),[c,p]=(0,s.useState)([]),[x,h]=(0,s.useState)([]),[E,y]=(0,s.useState)([]),[k,v]=(0,s.useState)(1e4),[j,b]=(0,s.useState)(!1),S=(0,s.useCallback)((async()=>{try{const t=await(0,u.uWX)(e.id),a=t.error;if(a)throw a;if(!t.data)throw new Error("No data");const s=t.data.items;h(s),o(!1),s.some((e=>"IN_PROGRESS"===e.status||"AWAITING_UPLOAD"===e.status))?v(3e3):v(1e4)}catch(e){a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle",{defaultMessage:"Error loading diagnostics uploads"})})}}),[e.id,a.toasts,v]);(0,s.useEffect)((()=>{S();const e=setInterval((async()=>{S()}),k);return()=>{e&&clearInterval(e)}}),[S,k]),(0,s.useEffect)((()=>{y(x),E.length>0&&x.filter((e=>{const t=E.find((t=>t.id===e.id));return"READY"===e.status&&(!t||"READY"!==(null==t?void 0:t.status))})).forEach((e=>{a.toasts.addSuccess({title:m.i18n.translate("xpack.fleet.requestDiagnostics.readyNotificationTitle",{defaultMessage:"Agent diagnostics {name} ready",values:{name:e.name}})},{toastLifeTimeMs:5e3})}))}),[E,x,a.toasts]),(0,s.useEffect)((()=>{p(r?x:x.filter((e=>"EXPIRED"!==e.status)))}),[x,r]);const M=[{field:"id",name:m.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.fileLabelText",{defaultMessage:"File"}),render:e=>{const t=x.find((t=>t.id===e));return"READY"===(null==t?void 0:t.status)?(0,O.jsx)(g.EuiLink,{href:n(null==t?void 0:t.filePath),download:!0,target:"_blank"},(0,O.jsx)(g.EuiIcon,{type:"download"}),"   ",null==t?void 0:t.name):"IN_PROGRESS"===(null==t?void 0:t.status)||"AWAITING_UPLOAD"===(null==t?void 0:t.status)?(0,O.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,O.jsx)(g.EuiLoadingSpinner,null),"  ",(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.generatingText",defaultMessage:"Generating diagnostics file..."})):(0,O.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center"},null!=t&&t.error?(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.errorGeneratingFileMessage",defaultMessage:"Error generating file: {reason}",values:{reason:t.error}})},(0,O.jsx)(g.EuiIcon,{type:"warning",color:"danger"}))):null!=t&&t.status?(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:t.status},(0,O.jsx)(g.EuiIcon,{type:"warning",color:"danger"}))):null,(0,O.jsx)(g.EuiFlexItem,null,null==t?void 0:t.name)))}},{field:"id",name:m.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.dateLabelText",{defaultMessage:"Date"}),dataType:"date",render:e=>{const t=x.find((t=>t.id===e));return(0,O.jsx)(g.EuiText,{size:"s",color:"READY"===(null==t?void 0:t.status)?"default":"subdued"},(0,g.formatDate)(null==t?void 0:t.createTime,"lll"))}},...t.fleet.allAgents?[{name:m.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.actionsLabelText",{defaultMessage:"Actions"}),width:"70px",actions:[{type:"icon",icon:"trash",color:"danger",name:m.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonText",{defaultMessage:"Delete"}),available:e=>"READY"===e.status,description:m.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonDesc",{defaultMessage:"Delete diagnostics file"}),onClick:e=>{var t;t=e.id,(0,u.A$L)(t).then((({data:e,error:t})=>{t||!1===(null==e?void 0:e.deleted)?a.toasts.addError(t||new Error("Request returned `deleted: false`"),{title:m.i18n.translate("xpack.fleet.requestDiagnostics.errorDeletingUploadNotificationTitle",{defaultMessage:"Error deleting diagnostics file"})}):a.toasts.addSuccess({title:m.i18n.translate("xpack.fleet.requestDiagnostics.successDeletingUploadNotificationTitle",{defaultMessage:"Diagnostics file deleted"})}),S()}))}}]}]:[]],F=(0,O.jsx)(g.EuiButton,{fill:!0,size:"s",onClick:()=>{b(!0)},disabled:!(0,I.fx)(e)||!t.fleet.readAgents},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}));return(0,O.jsx)(l().Fragment,null,j&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Ee,{agents:[e],agentCount:1,onClose:()=>{b(!1),S()}})),(0,O.jsx)(g.EuiText,{size:"s"},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.calloutText",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center",justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,I.fx)(e)?F:(0,O.jsx)(g.EuiToolTip,{content:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.notSupportedTooltip",defaultMessage:"Requesting agent diagnostics is not supported for agents before version {version}.",values:{version:I.dS}})},F)),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiSwitch,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.showExpiredFilesLabel",defaultMessage:"Show expired file requests"}),checked:r,onChange:e=>d(e.target.checked)}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),i?(0,O.jsx)(g.EuiSkeletonText,{lines:3}):(0,O.jsx)(g.EuiBasicTable,{items:c,columns:M}))},Ka=()=>{var e,t,a;const{params:{agentId:n,tabId:i=""}}=(0,o.useRouteMatch)(),{getHref:r}=(0,u.iEg)(),{displayAgentMetrics:d}=z.ZX.get(),{isLoading:c,isInitialRequest:p,error:x,data:h,resendRequest:E}=(0,u.rXq)(n,{pollIntervalMs:5e3,query:{withMetrics:d}}),{isLoading:y,data:k,sendRequest:v}=(0,u.ZJQ)(null==h||null===(e=h.item)||void 0===e?void 0:e.policy_id),{application:{navigateToApp:j}}=(0,u.WeA)(),b=(0,u.g7J)(),M="true"===new URLSearchParams((0,o.useLocation)().search).get("openReassignFlyout"),I=(0,s.useCallback)((()=>{b&&b.onDoneNavigateTo&&j(b.onDoneNavigateTo[0],b.onDoneNavigateTo[1])}),[b,j]),{diagnosticFileUploadEnabled:T}=z.ZX.get(),w=null==h||null===(t=h.item)||void 0===t||null===(a=t.local_metadata)||void 0===a?void 0:a.host,C=(0,s.useMemo)((()=>(0,O.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:r("agent_list"),flush:"left",size:"xs"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.viewAgentListTitle",defaultMessage:"View all agents"}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{className:"eui-textBreakWord"},(0,O.jsx)("h1",null,c&&p?(0,O.jsx)(S.Rh,null):"object"==typeof w&&"string"==typeof(null==w?void 0:w.hostname)?w.hostname:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsTitle",defaultMessage:"Agent ''{id}''",values:{id:n}})))))),[w,n,r,p,c]),A=(0,s.useMemo)((()=>h&&h.item?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd",alignItems:"center",gutterSize:"s",direction:"row"},!y&&(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(Ba,{agent:h.item,agentPolicy:null==k?void 0:k.item,assignFlyoutOpenByDefault:M,onCancelReassign:b&&b.onDoneNavigateTo?I:void 0})))):void 0),[k,h,r,y]),P=(0,s.useMemo)((()=>{const e=[{id:"details",name:m.i18n.translate("xpack.fleet.agentDetails.subTabs.detailsTab",{defaultMessage:"Agent details"}),href:r("agent_details",{agentId:n,tabId:"details"}),isSelected:!i||"details"===i},{id:"logs",name:m.i18n.translate("xpack.fleet.agentDetails.subTabs.logsTab",{defaultMessage:"Logs"}),href:r("agent_details_logs",{agentId:n,tabId:"logs"}),isSelected:"logs"===i}];return T&&e.push({id:"diagnostics",name:m.i18n.translate("xpack.fleet.agentDetails.subTabs.diagnosticsTab",{defaultMessage:"Diagnostics"}),href:r("agent_details_diagnostics",{agentId:n,tabId:"diagnostics"}),isSelected:"diagnostics"===i}),e}),[r,n,i,T]);return(0,O.jsx)(Ea.U.Provider,{value:{refresh:()=>{E(),v()}}},(0,O.jsx)(F.QA,{leftColumn:C,rightColumn:A,tabs:P},c&&p?(0,O.jsx)(S.Rh,null):x?(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.unexceptedErrorTitle",defaultMessage:"Error loading agent"}),error:x}):h&&h.item?(0,O.jsx)($a,{agent:h.item,agentPolicy:null==k?void 0:k.item}):(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentDetails.agentNotFoundErrorTitle",defaultMessage:"Agent not found"}),error:m.i18n.translate("xpack.fleet.agentDetails.agentNotFoundErrorDescription",{defaultMessage:"Cannot find agent ID {agentId}",values:{agentId:n}})})))},$a=({agent:e,agentPolicy:t})=>((0,u.ifo)("agent_details",{agentHost:"object"==typeof e.local_metadata.host&&"string"==typeof e.local_metadata.host.hostname?e.local_metadata.host.hostname:"-"}),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.agent_details_logs,render:()=>(0,O.jsx)(Oa,{agent:e,agentPolicy:t})}),(0,O.jsx)(r.Route,{path:M.X5.agent_details_diagnostics,render:()=>(0,O.jsx)(Va,{agent:e})}),(0,O.jsx)(r.Route,{path:M.X5.agent_details,render:()=>(0,O.jsx)(qa,{agent:e,agentPolicy:t})}))),Ya=(0,o.withRouter)((({actionSection:e,title:t,children:a})=>(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceAround"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiPageSection,{color:"transparent"},(0,O.jsx)(g.EuiEmptyPrompt,{color:"plain",iconType:"logoBeats",title:(0,O.jsx)("h2",null,t),body:a,actions:e})))))),Qa=(0,f.injectI18n)((({intl:e})=>(0,O.jsx)(Ya,{title:e.formatMessage({id:"xpack.fleet.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Elastic Fleet. To use Elastic Fleet, you need a user role that contains All permissions for this application."}))))),Xa=()=>{var e;(0,u.ifo)("agent_list");const{agents:t}=(0,u.UKg)(),a=(0,u.iO7)(),s=(0,u.YI3)(),n=(0,u.Wdf)();if(!t.enabled)return null;if(!s.missingRequirements&&s.isLoading)return(0,O.jsx)(S.Rh,null);if(s.error)return(0,O.jsx)(F.gv,null,(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.agentsInitializationErrorMessageTitle",defaultMessage:"Unable to initialize central management for Elastic Agents"}),error:s.error}));const i=1===(null==s||null===(e=s.missingRequirements)||void 0===e?void 0:e.length)&&"fleet_server"===s.missingRequirements[0],o=a.fleet.allAgents&&(s.forceDisplayInstructions||i);if(!i&&s.missingRequirements&&s.missingRequirements.length>0)return(0,O.jsx)(ha.O,{missingRequirements:s.missingRequirements});if(!a.fleet.readAgents)return(0,O.jsx)(Qa,null);const d=o?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>n.openEnrollmentFlyout(),"data-test-subj":"addAgentBtnTop"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addAgentButton",defaultMessage:"Add Agent"}))))):void 0;return(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.agent_details},(0,O.jsx)(Ka,null)),(0,O.jsx)(r.Route,{path:M.X5.agents},(0,O.jsx)(F.iW,{section:"agents",rightColumn:d},o?(0,O.jsx)(ha.Q,{showEnrollmentRecommendation:!1}):(0,O.jsx)(xa,null))))};var Ja=a(72945);const Za=e=>{const{discover:t}=(0,at.WeA)(),[a,l]=(0,s.useState)(null);return(0,s.useEffect)((()=>{(async()=>{if(t&&t.locator){const a=await t.locator.getUrl({indexPatternId:"logs-*",timeRange:{from:"now-1h",to:"now",mode:"relative"},filters:[{meta:{alias:"Recently enrolled agents",index:"logs-*"},query:{terms:{"agent.id":e}}}]});l(a)}})()}),[t,e]),a};var es=a(89700);const ts=A()("h1").withConfig({displayName:"CentralTitle",componentId:"sc-ve6hfp-0"})(["text-align:center;"]),as=({children:e})=>l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(g.EuiTitle,{size:"l"},l().createElement(ts,null,e)),l().createElement(g.EuiSpacer,{size:"xl"})),ss=A()(g.EuiText).withConfig({displayName:"SubtitleText",componentId:"sc-ve6hfp-1"})(["max-width:250px;margin:0 auto;text-align:center;"]),ls=A()(g.EuiStepNumber).withConfig({displayName:"CenteredEuiStepNumber",componentId:"sc-ve6hfp-2"})(["margin:0 auto;"]),ns=e=>l().createElement("div",{style:{margin:"0 auto"}},l().createElement(g.EuiImage,(0,d.default)({role:"presentation"},e))),is=({children:e})=>{const t=(0,g.useIsWithinMaxBreakpoint)("s");return l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:t?"xs":"l",alignItems:"center",justifyContent:"center",wrap:!0},e)},os=()=>{const{http:e}=(0,u.WeA)(),t=e.basePath.prepend("/plugins/fleet/assets/");return l().createElement(g.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceEvenly",gutterSize:"none"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(is,null,l().createElement(g.EuiFlexItem,null,l().createElement(ls,{status:"incomplete",number:1})),l().createElement(g.EuiFlexItem,null,l().createElement("div",{style:{margin:"0 auto"}},l().createElement(ns,{alt:"",src:t+"1_install_agent.svg"}))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",defaultMessage:"Install Elastic Agent"}))),l().createElement(ss,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStep",defaultMessage:"Install agents on the hosts that you want to connect to Elastic."}))))),l().createElement(g.EuiShowFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiSpacer,{size:"xl"}))),l().createElement(g.EuiHideFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ns,{alt:"",src:t+"arrow_right_curve_over.svg"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(is,null,l().createElement(g.EuiFlexItem,null,l().createElement(ls,{status:"incomplete",number:2})),l().createElement(g.EuiFlexItem,null,l().createElement(ns,{alt:"",src:t+"2_add_integration.svg"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",defaultMessage:"Add the integration"}))),l().createElement(ss,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",defaultMessage:"Make a few selections to finalize how Elastic receives your data."}))))),l().createElement(g.EuiShowFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiSpacer,{size:"xl"}))),l().createElement(g.EuiHideFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ns,{alt:"",src:t+"arrow_right_curve_under.svg"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(is,null,l().createElement(g.EuiFlexItem,null,l().createElement(ls,{status:"incomplete",number:3})),l().createElement(g.EuiFlexItem,null,l().createElement(ns,{alt:"",src:t+"3_confirm_data.svg"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",defaultMessage:"Confirm incoming data"}))),l().createElement(ss,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStep",defaultMessage:"Explore and analyze the incoming data."}))))))},rs=A()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-ve6hfp-3"})(["padding-bottom:100px;"]),us=()=>{const{docLinks:e}=(0,u.WeA)();return l().createElement(g.EuiFlexGroup,{justifyContent:"spaceAround"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiLink,{href:e.links.fleet.elasticAgent,target:"_blank"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.learnMoreLink",defaultMessage:"Learn more about installing Elastic Agent"}))))},ds=({integrationInfo:e,packageInfo:t,isLoading:a,error:s,cancelUrl:n,cancelClickHandler:i,onNext:o})=>{if(s)return l().createElement(S.$D,{title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:s});const r=l().createElement(as,null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.pageTitle",defaultMessage:"Ready to add your first integration?"}));return l().createElement(F.QA,{topContent:r},l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(os,null),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(rs,null,l().createElement(us,null)),l().createElement(fs,{cancelUrl:n,cancelMessage:l().createElement("span",{"data-test-subj":"skipAgentInstallation"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",defaultMessage:"Add integration only (skip agent installation)"})),cancelClickHandler:i,isLoading:a,onNext:o,noAnimation:!0,actionMessage:l().createElement(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentButton",defaultMessage:"Install Elastic Agent"})}),t&&l().createElement(es.I3,{pkgTitle:(null==e?void 0:e.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==e?void 0:e.name})))},cs=A()(g.EuiBottomBar).withConfig({displayName:"CenteredRoundedBottomBar",componentId:"sc-113t0u1-0"})(["max-width:820px;margin:0 auto !important;border-radius:8px 8px 0px 0px;"]),gs=A()(cs).withConfig({displayName:"NoAnimationCenteredRoundedBottomBar",componentId:"sc-113t0u1-1"})(["animation-delay:-99s;#stop bottom bar flying in on step change"]),ps=A()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-113t0u1-2"})(["padding-bottom:100px;"]),fs=({isLoading:e,loadingMessage:t,onNext:a,cancelClickHandler:s,cancelUrl:n,actionMessage:i,cancelMessage:o,isDisabled:r=!1,noAnimation:u=!1})=>{const d=u?gs:cs;return l().createElement(d,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:n,onClick:s},o||l().createElement(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",isDisabled:r,isLoading:!r&&e,onClick:a},e?t||l().createElement(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.loading",defaultMessage:"Loading..."}):i))))},ms=({onNext:e,cancelClickHandler:t,cancelUrl:a,noAnimation:s=!1})=>{const n=s?gs:cs;return l().createElement(n,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a,onClick:t},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",onClick:e},l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.viewIncomingDataBtn",defaultMessage:"View incoming data"})))))},xs=({pkgkey:e})=>{const t=e.includes(B.FLEET_KUBERNETES_PACKAGE),{getHref:a}=(0,at.iEg)(),{getAbsolutePath:s}=(0,at.iEg)();return l().createElement(cs,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a("integrations_all")},l().createElement(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.addAnotherIntegration",defaultMessage:"Add another integration"})))),!t&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:a("integration_details_assets",{pkgkey:e})},l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.viewDataAssetsButtonText'",defaultMessage:"View assets"}))),t&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:s("/app/dashboards#/view/kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c")},l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData. '",defaultMessage:"View Kubernetes metrics dashboards"})))))},hs=({troubleshootLink:e,agentIds:t,integration:a})=>{const s=Za(t);return l().createElement(cs,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:e,iconType:"popout",target:"_blank"},l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLinkBottomBar",defaultMessage:"Troubleshooting guide"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,href:null!=s?s:""},l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLogsLink",defaultMessage:"View incoming {integration} logs",values:{integration:null!=a?a:""}})))))},Es=e=>{const{packageInfo:t,integrationInfo:a,steps:s,currentStep:n,error:i}=e;if(i)return(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:i});const o=s[n].component,r=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"l",className:"eui-textCenter"},(0,O.jsx)("h1",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.multiPageTitle",defaultMessage:"Set up {title} integration",values:{title:t.title}}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(vs,{currentStep:n,steps:s.map((e=>e.title))}),(0,O.jsx)(g.EuiSpacer,{size:"xl"}));return(0,O.jsx)(F.QA,{topContent:r,restrictHeaderWidth:866,restrictWidth:866},(0,O.jsx)(o,e),t&&(0,O.jsx)(es.I3,{pkgTitle:(null==a?void 0:a.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==a?void 0:a.name}))},ys=A()(g.EuiStepsHorizontal).withConfig({displayName:"NumberlessHorizontalSteps",componentId:"sc-opcgc5-0"})([".euiStepNumber{color:transparent;width:16px;height:16px;outline-color:#07c;}.euiStepHorizontal::before{width:calc(50% - 8px);top:32px;}.euiStepHorizontal::after{width:calc(50% - 8px);top:32px;}.euiStepHorizontal{padding:25px 16px 16px;}.euiStepHorizontal[data-step-status='incomplete'] .euiStepHorizontal__title{color:#69707d;}"]),ks=(e,t,a)=>e===t?a?"complete":"current":e>t?"complete":"incomplete",vs=({steps:e,currentStep:t=0,currentStepComplete:a=!1})=>{const s=e.map(((e,s)=>({title:e,status:ks(t,s,a),onClick:()=>{}})));return l().createElement(ys,{steps:s})};var js=a(8683),bs=a(50152),Ss=a(4888);var Ms=A()(g.EuiCodeBlock).withConfig({displayName:"_StyledEuiCodeBlock",componentId:"sc-oz6m9j-1"})(["max-width:1100px;"]);const Fs=e=>{var t;const{cancelUrl:a,onNext:n,cancelClickHandler:i,setIsManaged:o,agentPolicy:r,enrollmentAPIKey:u,fleetServerHost:d,fleetProxy:c,enrolledAgentIds:p}=e,x=(0,at.WeA)(),{docLinks:h}=x,E=h.links.fleet.troubleshooting,y=(0,at.JhS)(),[k,v]=(0,s.useState)(!1),[j,b]=(0,s.useState)(!1);if(!u)return(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Enrollment API key not found"});const M="kubernetes"===e.packageInfo.name?"IS_KUBERNETES_MULTIPAGE":"IS_NOT_KUBERNETES",F=(0,Ss.w)({apiKey:u.api_key,fleetProxy:c,fleetServerHost:d,agentVersion:y||""}),T=[(0,bs.YD)({installCommand:F,apiKeyData:{item:u},enrollToken:u.api_key,isK8s:M,selectedApiKeyId:u.id,isComplete:k||!!p.length,fullCopyButton:!0,fleetServerHost:d,onCopy:()=>v(!0),rootIntegrations:(0,I.uo)(null!==(t=null==r?void 0:r.package_policies)&&void 0!==t?t:[])})];return"IS_KUBERNETES_MULTIPAGE"===M&&T.push((({isComplete:e,fullCopyButton:t,onCopy:a})=>{const[n,i]=(0,s.useState)(!1),o=A().pre.withConfig({displayName:"CommandCode",componentId:"sc-oz6m9j-0"})({overflow:"auto"});return{status:e?"complete":void 0,title:m.i18n.translate("xpack.fleet.agentEnrollment.stepKubernetesApplyManifest",{defaultMessage:"Run the apply command"}),children:l().createElement(l().Fragment,null,l().createElement(g.EuiText,null,l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(f.FormattedMessage,{id:"xpack.fleet.agentEnrollment.kubernetesCommandInstructions",defaultMessage:"From the directory where the manifest is downloaded, run the apply command."}),l().createElement(g.EuiSpacer,{size:"m"})),l().createElement(Ms,{onClick:()=>{a&&a()},fontSize:"m",isCopyable:!t,paddingSize:"m"},l().createElement(o,null,"kubectl apply -f elastic-agent-managed-kubernetes.yml")),l().createElement(g.EuiSpacer,{size:"s"}),t&&l().createElement(g.EuiCopy,{textToCopy:"kubectl apply -f elastic-agent-managed-kubernetes.yml"},(e=>l().createElement(g.EuiButton,{color:"primary",iconType:"copyClipboard",size:"m",onClick:()=>(e=>{e(),i(!0),a&&a()})(e)},n?l().createElement(f.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButtonClicked",defaultMessage:"Copied"}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButton",defaultMessage:"Copy to clipboard"})))))}})({isComplete:j||!!p.length,fullCopyButton:!0,onCopy:()=>b(!0)})),T.push((0,bs.nV)({selectedPolicyId:null==r?void 0:r.id,troubleshootLink:E,agentCount:p.length,showLoading:!0,poll:k})),y?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addIntegration.installAgentStepTitle",defaultMessage:"These steps configure and enroll the Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent. As an alternative to Fleet, advanced users can run agents in {standaloneLink}.",values:{standaloneLink:(0,O.jsx)(g.EuiLink,{onClick:()=>o(!1)},"standalone mode")}})),(0,O.jsx)(g.EuiSpacer,{size:"xl"}),(0,O.jsx)(g.EuiSteps,{steps:T}),!!p.length&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(ps,null),(0,O.jsx)(fs,{cancelUrl:a,cancelClickHandler:i,onNext:n,actionMessage:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationButton",defaultMessage:"Add the integration"})}))):(0,O.jsx)(g.EuiLoadingSpinner,null)};var Is=a(96104);const Ts=e=>{var t;const{setIsManaged:a,agentPolicy:n,cancelUrl:i,onNext:o,cancelClickHandler:r}=e,u=(0,at.Q14)(),[d,c]=(0,s.useState)(!1),[p,m]=(0,s.useState)(!1),{yaml:x,onCreateApiKey:h,isCreatingApiKey:E,apiKey:y,downloadYaml:k}=(0,Is.Pe)(n);if(!n)return(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Agent policy not provided"});const v=(0,Ss.p)({agentVersion:u}),j=[(0,bs.N9)({selectedPolicyId:null==n?void 0:n.id,yaml:x,downloadYaml:k,apiKey:y,onCreateApiKey:h,isCreatingApiKey:E,isComplete:p,onCopy:()=>m(!0)}),(0,bs.iR)({installCommand:v,isComplete:x&&d,fullCopyButton:!0,onCopy:()=>c(!0),rootIntegrations:(0,I.uo)(null!==(t=null==n?void 0:n.package_policies)&&void 0!==t?t:[])})];return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Os,{setIsManaged:a}),(0,O.jsx)(g.EuiSpacer,{size:"xl"}),(0,O.jsx)(g.EuiSteps,{steps:j}),d&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(ps,null),(0,O.jsx)(ms,{cancelUrl:i,onNext:o,cancelClickHandler:r})))};var ws=a(92604),Cs=a(74892),As=a(33342),Ps=a(49688),_s=a(43721);const Ls=({children:e})=>{const[t,a]=(0,s.useState)(!1);return(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"column"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"row"},(0,O.jsx)(g.EuiFlexItem,null),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{size:"s",iconType:t?"arrowUp":"arrowDown",iconSide:"right",onClick:()=>a(!t),flush:"left"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",defaultMessage:"Advanced options"}))))),t&&(0,O.jsx)(g.EuiFlexItem,null,e)))},Ds=({error:e,title:t})=>(0,O.jsx)(S.$D,{title:t||(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addIntegration.errorTitle",defaultMessage:"Error adding integration"}),error:e}),Os=({setIsManaged:e})=>(0,O.jsx)(g.EuiCallOut,{title:"Setting up to run Elastic Agent in standalone mode",color:"primary",iconType:"info"},(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addIntegration.standaloneWarning",defaultMessage:"Setting up integrations by running Elastic Agent in standalone mode is advanced. When possible, we recommend using {link} instead. ",values:{link:(0,O.jsx)(g.EuiLink,{href:"#"},"Fleet-managed agents")}})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiButton,{onClick:()=>e(!0),color:"primary"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.addIntegration.switchToManagedButton",defaultMessage:"Enroll in Fleet instead (recommended)"})));var Rs=a(69433),Bs=a(93230),Ns=a.n(Bs),zs=a(30276);const Us=({agentIds:e,troubleshootLink:t,packageInfo:a})=>{var s;const n=Za(e);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,null,(0,O.jsx)("h3",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.title",defaultMessage:"Confirming data is taking longer than expected"}))),(0,O.jsx)(g.EuiText,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.body",defaultMessage:"If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",values:{troubleshootLink:(0,O.jsx)(g.EuiLink,{external:!0,href:t,target:"_blank"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLink",defaultMessage:"troubleshooting guide"})),discoverLink:(0,O.jsx)(g.EuiLink,{external:!0,href:null!=n?n:"",target:"_blank"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLink",defaultMessage:"{integration} logs in Discover",values:{integration:null!==(s=null==a?void 0:a.title)&&void 0!==s?s:""}}))}})),(0,O.jsx)(ps,null),(0,O.jsx)(hs,{agentIds:e,troubleshootLink:t,integration:null==a?void 0:a.title}))},Hs=["agent.ephemeral_id","agent.id","elastic_agent.id","data_stream.namespace","@timestamp"],Ws=A()(g.EuiDescriptionList).withConfig({displayName:"CleanOverflowDescriptionList",componentId:"sc-6co0kl-0"})(["overflow:hidden;max-height:125px;word-break:break-all;white-space:pre-wrap;"]),Gs=A()("pre").withConfig({displayName:"CompressedPre",componentId:"sc-6co0kl-1"})(["&&&{background:none;padding:0 0;}"]),qs=({hit:e})=>{const t=Ns()((0,Rs.getFlattenedObject)(e._source),Hs),a=Object.entries(t).map((([e,t])=>({title:`${e}:`,description:JSON.stringify(t)})));return l().createElement("pre",null,l().createElement("code",null,l().createElement(Ws,{listItems:a,type:"inline",align:"left",compressed:!0})))},Vs=({hit:e})=>{const t=(null==e?void 0:e._source)||{},a=(null==t?void 0:t["@timestamp"])||"-";return l().createElement(g.EuiText,{size:"xs"},l().createElement(Gs,null,a?(0,g.formatDate)(a,"MMM D, YYYY @ HH:mm:ss.SSS"):"-"))},Ks=({dataPreview:e})=>{const t=e.slice(0,5);return l().createElement(l().Fragment,null,t.map((e=>l().createElement("div",{id:e._id},l().createElement(g.EuiFlexGroup,{gutterSize:"xs"},l().createElement(g.EuiFlexItem,{style:{minWidth:"220px"}},l().createElement(Vs,{hit:e})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(qs,{hit:e}))),l().createElement(g.EuiHorizontalRule,{margin:"s"})))))},$s=({agentIds:e,packageInfo:t,agentDataConfirmed:a,setAgentDataConfirmed:s,troubleshootLink:n})=>{const{incomingData:i,dataPreview:o,isLoading:r,hasReachedTimeout:u}=(0,zs.Tm)({agentIds:e,previewData:!0,stopPollingAfterPreviewLength:5}),{enrolledAgents:d,numAgentsWithData:c}=(0,zs.VK)(i,t),p=(0,at.df5)(null==t?void 0:t.name),{guidedOnboarding:x}=(0,at.WeA)();var h;return!r&&d>0&&c>0&&(s(!0),p&&(null==x||null===(h=x.guidedOnboardingApi)||void 0===h||h.completeGuidedOnboardingForIntegration(null==t?void 0:t.name))),a?l().createElement(l().Fragment,null,l().createElement(g.EuiCallOut,{"data-test-subj":"IncomingDataConfirmedCallOut",title:m.i18n.translate("xpack.fleet.confirmIncomingDataWithPreview.title",{defaultMessage:"Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.",values:{numAgentsWithData:c}}),color:"success",iconType:"check"}),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiText,null,l().createElement("h3",null,l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.previewTitle",defaultMessage:"Preview of incoming data:"}))),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(Ks,{dataPreview:o})):l().createElement(l().Fragment,null,l().createElement(g.EuiText,null,l().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:g.EuiLoadingSpinner,title:l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.listening",defaultMessage:"Listening for incoming data from enrolled agents..."})}),l().createElement(g.EuiSpacer,{size:"m"}),u?l().createElement(Us,{agentIds:e,troubleshootLink:n,packageInfo:t}):l().createElement(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.loading",defaultMessage:"It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",values:{link:l().createElement(g.EuiLink,{target:"_blank",external:!0,href:n},l().createElement(f.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiSkeletonText,{lines:10}))},Ys=({troubleshootLink:e})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,null,(0,O.jsx)(g.EuiCallOut,{size:"m",color:"primary",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.title",defaultMessage:"Data preview is not available for standalone agents. "})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.description",defaultMessage:"You can check for agent data in the integration asset tab. If you're having trouble seeing data, check out the {link}.",values:{link:(0,O.jsx)(g.EuiLink,{target:"_blank",external:!0,href:e},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})))),Qs={title:m.i18n.translate("xpack.fleet.createFirstPackagePolicy.installAgentStepTitle",{defaultMessage:"Install Elastic Agent"}),component:e=>{var t;const[a,l]=(0,s.useState)(e.isManaged),[n,i]=(0,s.useState)(!1),{enrolledAgentIds:o}=(0,js.X)((null===(t=e.agentPolicy)||void 0===t?void 0:t.id)||"",{noLowerTimeLimit:!0,pollImmediately:!0}),r=()=>{e.setEnrolledAgentIds(o),e.onNext()},u={...e,onNext:r,enrolledAgentIds:o,setIsManaged:n?l:e.setIsManaged};if(a)return(0,O.jsx)(Fs,u);const d={...e,onNext:r,enrolledAgentIds:o,setIsManaged:e=>{e&&i(!0),l(e)}};return(0,O.jsx)(Ts,d)}},Xs={title:m.i18n.translate("xpack.fleet.createFirstPackagePolicy.addIntegrationStepTitle",{defaultMessage:"Add the integration"}),component:e=>{var t;const{onNext:a,onBack:n,isManaged:i,setIsManaged:o,packageInfo:r,integrationInfo:d,agentPolicy:c}=e,[p,x]=(0,s.useState)(),{notifications:h}=(0,u.WeA)(),[E,y]=(0,s.useState)("VALID"),[k,v]=(0,s.useState)(),b=(0,j.wsd)(),[M,F]=(0,s.useState)({name:"",description:"",namespace:"",policy_id:"",policy_ids:[""],enabled:!0,inputs:[]}),T=(0,s.useCallback)((e=>{const t=(0,As.bS)({...M,...e},r,ws.Hh);return v(t),_s.debug("Package policy validation results",t),t}),[r,M]),w=(0,s.useCallback)((e=>{const t={...M,...e};F(t),_s.debug("Package policy updated",t);const a=T(t),s=t.package,l=!!a&&(0,As.nt)(a);y(s&&!l?"VALID":"INVALID")}),[M,T]),C=(0,s.useCallback)((async({force:e=!1}={})=>{const t=!!k&&(0,As.nt)(k);if("VALID"===E&&t)return void y("INVALID");y("LOADING");const{error:s}=await(async({newPackagePolicy:e,force:t})=>{y("LOADING");const{policy:a,forceCreateNeeded:s}=await(0,Ps.E)(e),l=await(0,u.H_o)({...a,force:s||t});return y("SUBMITTED"),l})({newPackagePolicy:M,force:e});if(s){if((0,Cs.G0)(s))return void(await b(r)?C({force:!0}):y("VALID"));h.toasts.addError(s,{title:"Error"}),y("VALID")}else a()}),[k,E,M,h.toasts,b,r,a]);(0,s.useEffect)((()=>{(async()=>{if(!c)return;const{packagePolicy:e,error:t}=await(async(e,t,a)=>{const{data:s,error:l}=await(0,u.TR6)({perPage:$.WaW,page:1,kuery:`${N.f$}.package.name:${t.name}`}),n={name:(0,I.sW)(t.name,null==s?void 0:s.items),description:"",namespace:"",policy_id:e,policy_ids:[e],enabled:!0,inputs:[]};return{packagePolicy:(0,z.eE)(t,e,n.namespace,n.name,n.description,a),error:l}})(c.id,r,null==d?void 0:d.name);t&&x(t),w(e)})()}),[]);const A=(0,u.fWy)(null!==(t=r.name)&&void 0!==t?t:"","package-policy-create-multi-step"),P=(0,s.useMemo)((()=>A&&(0,O.jsx)(S.BA,null,(0,O.jsx)(A.Component,null))),[A]),_=(0,s.useMemo)((()=>{if("endpoint"!==r.name)return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"l"}),(0,O.jsx)(es.lS,{packageInfo:r,showOnlyIntegration:null==d?void 0:d.name,packagePolicy:M,updatePackagePolicy:w,validationResults:k,submitAttempted:"INVALID"===E,noTopRule:!0}),k&&(0,O.jsx)(Ls,null,(0,O.jsx)(es.os,{packageInfo:r,packagePolicy:M,updatePackagePolicy:w,validationResults:k,submitAttempted:"INVALID"===E,noAdvancedToggle:!0})))}),[E,null==d?void 0:d.name,r,M,w,k]);return c?p?(0,O.jsx)(Ds,{error:p}):(0,O.jsx)(l().Fragment,null,i?null:(0,O.jsx)(Os,{setIsManaged:o}),_,P,(0,O.jsx)(ps,null),(0,O.jsx)(fs,{cancelClickHandler:i?n:()=>o(!0),onNext:C,isLoading:"LOADING"===E,isDisabled:"INVALID"===E,loadingMessage:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.savingPackagePolicy",defaultMessage:"Saving policy..."}),actionMessage:i?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.confirmIncomingDataButton",defaultMessage:"Confirm incoming data"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.installAgentButton",defaultMessage:"Save and continue"})})):(0,O.jsx)(Ds,{error:m.i18n.translate("xpack.fleet.addIntegration.noAgentPolicy",{defaultMessage:"Error creating agent policy."})})}},Js={title:m.i18n.translate("xpack.fleet.createFirstPackagePolicy.confirmDataStepTitle",{defaultMessage:"Confirm incoming data"}),component:e=>{const{enrolledAgentIds:t,packageInfo:a,isManaged:n}=e,i=(0,u.WeA)(),[o,r]=(0,s.useState)(!1),{docLinks:d}=i,c=d.links.fleet.troubleshooting,g=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(ps,null),(0,O.jsx)(xs,{pkgkey:`${a.name}-${a.version}`}));return n?(0,O.jsx)(l().Fragment,null,(0,O.jsx)($s,{agentIds:t,packageInfo:a,agentDataConfirmed:o,setAgentDataConfirmed:r,troubleshootLink:c}),!!o&&g):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Ys,{troubleshootLink:c}),g)}},Zs=[Qs,Xs,Js],el=[Xs,Qs,Js],tl=({queryParamsPolicyId:e,prerelease:t})=>{const{params:a}=(0,o.useRouteMatch)(),{pkgkey:l,policyId:n,integration:i}=a,{pkgName:r,pkgVersion:d}=(0,I.CB)(l),[c,g]=(0,s.useState)(!0),[p,f]=(0,s.useState)(0),[x,h]=(0,s.useState)(!0),{getHref:E}=(0,u.iEg)(),[y,k]=(0,s.useState)([]),v=n||e,{data:j,error:b,isLoading:S}=(0,u.E1o)(r,d,{prerelease:t,full:!0}),{agentPolicy:M,enrollmentAPIKey:F,error:T,isLoading:w}=function(e){const{spaceId:t,isSpaceAwarenessEnabled:a}=(0,at.YI3)(),[l,n]=(0,s.useState)(!0),[i,o]=(0,s.useState)(),[r,u]=(0,s.useState)(),[d,c]=(0,s.useState)(),[g,p]=(0,s.useState)(),f="fleet-first-agent-policy",x=(0,s.useMemo)((()=>a&&"default"!==t?`${t}:${f}`:f),[a,t]),h=(0,s.useMemo)((()=>Object.freeze((0,_.b)({id:x,name:m.i18n.translate("xpack.fleet.createPackagePolicy.firstAgentPolicyNameText",{defaultMessage:"My first agent policy"})}))),[x]);return(0,s.useEffect)((()=>{(async()=>{var t;n(!0);const a=e||x,{data:s,error:l}=await(async e=>{var t;let a,s;try{a=await(0,at.Ag1)(e),a.error&&(s=a.error)}catch(e){s=e}return s&&404!==s.statusCode?{error:s}:{data:null===(t=a)||void 0===t?void 0:t.data}})(a),i=null==s?void 0:s.item;if(e&&!i)return n(!1),void o(new Error(`Agent policy ${a} not found`));let r;if(l)return n(!1),void o(l);if(!i){const{data:e,error:t}=await at.iF6.bind(null,h)();if(t)return n(!1),void o(t);r=e.item,p(!0)}u(i||r);const{data:d,error:g}=await(0,at.d1z)({page:1,perPage:1,kuery:`policy_id:"${a}"`});g?(n(!1),o(g)):d&&null!==(t=d.items)&&void 0!==t&&t.length?(n(!1),c(d.items[0])):(n(!1),o(new Error(`No enrollment API key found for policy ${a}`)))})()}),[e,h,x]),{isLoading:l,error:i,agentPolicy:r,enrollmentAPIKey:d,created:g}}(v),C=(0,s.useMemo)((()=>null==j?void 0:j.item),[j]),A=(0,s.useMemo)((()=>{var e;if(i)return null==C||null===(e=C.policy_templates)||void 0===e?void 0:e.find((e=>e.name===i))}),[null==C?void 0:C.policy_templates,i]),{fleetServerHost:P,fleetProxy:L,downloadSource:D,isLoadingInitialRequest:R}=(0,u.Dc7)(M),B=E("add_integration_to_policy",{pkgkey:l,useMultiPageLayout:!1,...i?{integration:i}:{},...v?{agentPolicyId:v}:{}});if(c||!C)return(0,O.jsx)(ds,{isLoading:S||R||w,error:b||T,integrationInfo:A,packageInfo:C,cancelUrl:B,onNext:()=>{g(!1)}});const N=x?Zs:el;return(0,O.jsx)(Es,{fleetServerHost:P,fleetProxy:L,downloadSource:D,agentPolicy:M,enrollmentAPIKey:F,currentStep:p,steps:N,packageInfo:C,integrationInfo:A,cancelUrl:B,onNext:()=>{p!==N.length-1&&f(p+1)},onBack:()=>{0!==p&&f(p-1)},isManaged:x,setIsManaged:e=>{h(e),f(0)},setEnrolledAgentIds:k,enrolledAgentIds:y})},al=()=>{const{search:e}=(0,o.useLocation)(),{params:t}=(0,o.useRouteMatch)(),a=(0,s.useMemo)((()=>new URLSearchParams(e)),[e]),n=(0,s.useMemo)((()=>a.has("useMultiPageLayout")&&"false"!==a.get("useMultiPageLayout")),[a]),i=(0,s.useMemo)((()=>{var e;return null!==(e=a.get("policyId"))&&void 0!==e?e:void 0}),[a]),[r,d]=l().useState(!1),{data:c}=(0,u.ZwD)();(0,s.useEffect)((()=>{const e=Boolean(null==c?void 0:c.item.prerelease_integrations_enabled);null!=c&&c.item&&d(e)}),[null==c?void 0:c.item]);const g={from:"policyId"in t||i?"policy":"package",queryParamsPolicyId:i,prerelease:r};return n?(0,O.jsx)(tl,g):(0,O.jsx)(Ja.M,g)},sl=({apiKeyId:e,length:t,sendGetAPIKey:a,tokenGetter:l})=>{const{euiTheme:n}=(0,g.useEuiTheme)(),{notifications:i}=(0,at.WeA)(),[o,r]=(0,s.useState)("HIDDEN"),[u,d]=(0,s.useState)(),c=(0,s.useMemo)((()=>"•".repeat(t)),[t]);return(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiText,{color:"subdued",size:"xs",css:(0,O.css)("font-family:",n.font.familyCode,";",""),"data-test-subj":"apiKeyField"},"VISIBLE"===o?u:c)),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiToolTip,{content:"VISIBLE"===o?m.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):m.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"})},(0,O.jsx)(g.EuiButtonIcon,{"aria-label":"VISIBLE"===o?m.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):m.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),color:"text",onClick:async()=>{if("VISIBLE"===o)r("HIDDEN");else if("HIDDEN"===o)try{r("LOADING");const t=await a(e);if(t.error)throw t.error;d(l(t)),r("VISIBLE")}catch(e){i.toasts.addError(e,{title:"Error"}),r("HIDDEN")}},iconType:"VISIBLE"===o?"eyeClosed":"eye","data-test-subj":"showHideTokenButton"}))))};var ll=a(13788);const nl=e=>{const{onCancel:t,onConfirm:a,enrollmentKey:s}=e;return(0,O.jsx)(g.EuiConfirmModal,{title:m.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.title",{defaultMessage:"Revoke enrollment token"}),onCancel:t,onConfirm:a,cancelButtonText:m.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.cancelButton",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.deleteButton",{defaultMessage:"Revoke enrollment token"}),defaultFocusedButton:"confirm",buttonColor:"danger"},(0,O.jsx)(g.EuiCallOut,{title:m.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.description",{defaultMessage:"Are you sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.",values:{keyName:s.name}}),color:"danger"}))},il=({apiKey:e,refresh:t})=>{const{notifications:a}=(0,u.WeA)(),[n,i]=(0,s.useState)("CONFIRM_HIDDEN");return(0,O.jsx)(l().Fragment,null,"CONFIRM_VISIBLE"===n&&(0,O.jsx)(nl,{enrollmentKey:e,onCancel:()=>i("CONFIRM_HIDDEN"),onConfirm:async()=>{try{const t=await(0,u.TOj)(e.id);if(t.error)throw t.error}catch(e){a.toasts.addError(e,{title:"Error"})}i("CONFIRM_HIDDEN"),t()}}),(0,O.jsx)(g.EuiToolTip,{content:m.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"})},(0,O.jsx)(g.EuiButtonIcon,{"data-test-subj":"enrollmentTokenTable.revokeBtn","aria-label":m.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),onClick:()=>i("CONFIRM_VISIBLE"),iconType:"trash",color:"danger"})))},ol=()=>{var e,t,a;(0,u.ifo)("enrollment_tokens");const[l,n]=(0,s.useState)(!1),[i,o]=(0,s.useState)(""),{pagination:r,setPagination:d,pageSizeOptions:c}=(0,u.WQC)(),p=(0,u.c3w)({page:r.currentPage,perPage:r.pageSize,kuery:""!==i.trim()?i:void 0}),x=(0,u.$sk)({page:1,perPage:M.W}),h=x.data?x.data.items:[],E=h.reduce(((e,t)=>(e[t.id]=t,e)),{}),y=null!==(e=null==p||null===(t=p.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0,k=(null==p||null===(a=p.data)||void 0===a?void 0:a.items.filter((e=>{if(!h.length||!e.policy_id)return!1;const t=E[e.policy_id];return!(null!=t&&t.is_managed)})))||[],v=[{field:"name",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.nameTitle",{defaultMessage:"Name"}),render:e=>(0,O.jsx)("span",{className:"eui-textTruncate",title:e},e)},{field:"id",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.secretTitle",{defaultMessage:"Secret"}),width:"215px",render:e=>(0,O.jsx)(sl,{apiKeyId:e,sendGetAPIKey:u.aGY,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.api_key},length:60})},{field:"policy_id",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.policyTitle",{defaultMessage:"Agent policy"}),render:e=>{const t=E[e],a=t?t.name:e;return(0,O.jsx)("span",{className:"eui-textTruncate",title:a},a)}},{field:"created_at",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.createdAtTitle",{defaultMessage:"Created on"}),width:"150px",render:e=>e?(0,O.jsx)(f.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"active",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.activeTitle",{defaultMessage:"Active"}),width:"70px",align:"center",render:e=>(0,O.jsx)(g.EuiIcon,{size:"m",color:e?"success":"danger",type:"dot"})},{field:"actions",name:m.i18n.translate("xpack.fleet.enrollmentTokensList.actionsTitle",{defaultMessage:"Actions"}),width:"70px",render:(e,t)=>{const a=h.find((e=>e.id===t.policy_id));return t.active&&!(null!=a&&a.is_managed)&&(0,O.jsx)(il,{apiKey:t,refresh:()=>p.resendRequest()})}}],j=p.isLoading&&p.isInitialRequest||x.isLoading&&x.isInitialRequest;return(0,O.jsx)(F.iW,{section:"enrollment_tokens"},l&&(0,O.jsx)(S.jY,{agentPolicies:h,onClose:e=>{n(!1),p.resendRequest()}}),(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.pageDescription",defaultMessage:"Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data."})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(ll.I,{value:i,indexPattern:M.Al,fieldPrefix:M.w1,onChange:e=>{d({...r,currentPage:1}),o(e)},dataTestSubj:"enrollmentKeysList.queryInput"})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{"data-test-subj":"createEnrollmentTokenButton",fill:!0,iconType:"plusInCircle",onClick:()=>n(!0)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.newKeyButton",defaultMessage:"Create enrollment token"})))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiBasicTable,{"data-test-subj":"enrollmentTokenListTable",loading:j,noItemsMessage:j?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",defaultMessage:"Loading enrollment tokens..."}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.emptyMessage",defaultMessage:"No enrollment tokens found."}),items:y?k:[],itemId:"id",columns:v,pagination:{pageIndex:r.currentPage-1,pageSize:r.pageSize,totalItemCount:y,pageSizeOptions:c},onChange:({page:e})=>{const t={...r,currentPage:e.index+1,pageSize:e.size};d(t)}}))};var rl=a(50998),ul=a(1442);const dl=m.i18n.translate("xpack.fleet.uninstallTokenList.policyIdTitle",{defaultMessage:"Policy ID"}),cl=m.i18n.translate("xpack.fleet.uninstallTokenList.policyNameTitle",{defaultMessage:"Policy name"}),gl=m.i18n.translate("xpack.fleet.uninstallTokenList.createdAtTitle",{defaultMessage:"Created at"}),pl=m.i18n.translate("xpack.fleet.uninstallTokenList.tokenTitle",{defaultMessage:"Token"}),fl=m.i18n.translate("xpack.fleet.uninstallTokenList.actionsTitle",{defaultMessage:"Actions"}),ml=m.i18n.translate("xpack.fleet.uninstallTokenList.viewUninstallCommandLabel",{defaultMessage:"View uninstall command"}),xl=m.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNamePlaceholder",{defaultMessage:"Search by policy ID or policy name"}),hl=m.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNameHint",{defaultMessage:"If an Agent policy is deleted, its policy name is also deleted. Use the policy ID to search for uninstall tokens related to deleted Agent policies."}),El=({text:e,dataTestSubj:t})=>(0,O.jsx)(g.EuiText,{size:"s",className:"eui-textTruncate",title:e,"data-test-subj":t},e),yl=({onClick:e})=>(0,O.jsx)(g.EuiToolTip,{content:ml},(0,O.jsx)(g.EuiButtonIcon,{"data-test-subj":"uninstallTokensViewCommandButton","aria-label":ml,onClick:e,iconType:"inspect",color:"text"})),kl=({isLoading:e})=>e?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.loadingTokensMessage",defaultMessage:"Loading uninstall tokens..."}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.emptyMessage",defaultMessage:"No uninstall tokens found."}),vl=()=>{var e,t;(0,u.ifo)("uninstall_tokens");const[a,l]=(0,s.useState)(""),[n,i]=(0,s.useState)(null),{pagination:o,setPagination:r,pageSizeOptions:d}=(0,u.WQC)(),{isLoading:c,data:p}=(0,ul.oH)({perPage:o.pageSize,page:o.currentPage,search:a}),m=null!==(e=null==p?void 0:p.items)&&void 0!==e?e:[],x=null!==(t=null==p?void 0:p.total)&&void 0!==t?t:0,h=(0,s.useMemo)((()=>[{field:"policy_name",name:cl,render:e=>null===e?(0,O.jsx)(rl.C,null):(0,O.jsx)(El,{text:e})},{field:"policy_id",name:dl,render:e=>(0,O.jsx)(El,{text:e,dataTestSubj:"uninstallTokensPolicyIdField"})},{field:"created_at",name:gl,width:"130px",render:e=>e?(0,O.jsx)(f.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"id",name:pl,width:"300px",render:e=>(0,O.jsx)(sl,{apiKeyId:e,sendGetAPIKey:ul.Wz,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.token},length:32})},{field:"actions",name:fl,align:"center",width:"70px",render:(e,{id:t})=>(0,O.jsx)(yl,{onClick:()=>i(t)})}]),[]),E=(0,s.useCallback)((({page:e})=>{r((t=>({...t,currentPage:e.index+1,pageSize:e.size})))}),[r]),y=(0,s.useCallback)((e=>{l(e),r((e=>({...e,currentPage:1})))}),[r]);return(0,O.jsx)(F.iW,{section:"uninstall_tokens"},n&&(0,O.jsx)(S.pc,{onClose:()=>i(null),target:"agent",uninstallTokenId:n}),(0,O.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.pageDescription",defaultMessage:"An uninstall token allows you to use the uninstall command to remove Elastic Agent from a host."})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{direction:"row",alignItems:"center"},(0,O.jsx)(g.EuiFieldSearch,{onSearch:y,incremental:!0,fullWidth:!0,maxLength:50,placeholder:xl,"data-test-subj":"uninstallTokensPolicyIdSearchInput"}),(0,O.jsx)(g.EuiToolTip,{content:hl},(0,O.jsx)(g.EuiIcon,{type:"info"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiBasicTable,{"data-test-subj":"uninstallTokenListTable",items:m,columns:h,itemId:"id",loading:c,pagination:{pageIndex:o.currentPage-1,pageSize:o.pageSize,totalItemCount:x,pageSizeOptions:d},onChange:E,noItemsMessage:(0,O.jsx)(kl,{isLoading:c})}),(0,O.jsx)(g.EuiSpacer,{size:"xl"}))},jl=A()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-1t6qzy1-0"})(["max-width:250px;"]),bl=A()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-1t6qzy1-1"})(["min-width:0px;"]),Sl=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(jl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.managedTooltip",{defaultMessage:"This Fleet server host is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"host_urls",render:e=>l().createElement(bl,{direction:"column",gutterSize:"xs"},e.map((e=>l().createElement(g.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.hostUrlsColumnTitle",{defaultMessage:"Host URLs"})},{render:e=>e.is_default?l().createElement(g.EuiIcon,{type:"check","data-test-subj":"fleetServerHostTable.defaultIcon"}):null,width:"200px",name:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"fleetServerHostsTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_fleet_server_hosts",{itemId:e.id}),title:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"fleetServerHostsTable.edit.btn"})))},name:m.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[n,t,a.fleet.allSettings]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsFleetServerHostsTable"})},Ml=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{docLinks:s}=(0,u.WeA)(),{getHref:n}=(0,u.iEg)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h4",{"data-test-subj":"fleetServerHostHeader"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionTitle",defaultMessage:"Fleet server hosts"}))),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionSubtitle",defaultMessage:"Specify the URLs that your agents will use to connect to a Fleet Server. If multiple URLs exist, Fleet will show the first provided URL for enrollment purposes. For more information, see the {guideLink} .",values:{guideLink:(0,O.jsx)(g.EuiLink,{href:s.links.fleet.guide,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetUserGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Sl,{fleetServerHosts:e,deleteFleetServerHost:t}),a.fleet.addFleetServers?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:n("settings_create_fleet_server_hosts"),"data-test-subj":"settings.fleetServerHosts.addFleetServerHostBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostCreateButtonLabel",defaultMessage:"Add Fleet Server"}))):null,(0,O.jsx)(g.EuiSpacer,{size:"m"}))},Fl=({output:e,showBadge:t})=>{var a,n;const{notifications:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(),{data:d}=(0,x.useQuery)(["outputHealth",e.id],(()=>(0,u.IaD)(e.id)),{refetchInterval:1e4});(0,s.useEffect)((()=>{null!=d&&d.error&&i.toasts.addError(null==d?void 0:d.error,{title:m.i18n.translate("xpack.fleet.output.errorFetchingOutputHealth",{defaultMessage:"Error fetching output state"})}),r(null==d?void 0:d.data)}),[d,i.toasts]);const c={DEGRADED:(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger",iconType:"error","data-test-subj":"outputHealthDegradedCallout"},(0,O.jsx)("p",{className:"eui-textBreakWord"},m.i18n.translate("xpack.fleet.output.calloutText",{defaultMessage:'Unable to connect to "{name}" at {host}.',values:{name:e.name,host:null!==(a=null===(n=e.hosts)||void 0===n?void 0:n.join(","))&&void 0!==a?a:""}})),(0,O.jsx)("p",null,m.i18n.translate("xpack.fleet.output.calloutPromptText",{defaultMessage:"Please check the details are correct."}))),HEALTHY:(0,O.jsx)(g.EuiCallOut,{title:"Healthy",color:"success",iconType:"check","data-test-subj":"outputHealthHealthyCallout"},(0,O.jsx)("p",null,m.i18n.translate("xpack.fleet.output.successCalloutText",{defaultMessage:"Connection with remote output established."})))},p={DEGRADED:(0,O.jsx)(g.EuiBadge,{color:"danger","data-test-subj":"outputHealthDegradedBadge"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputHealth.degradedStatusText",defaultMessage:"Unhealthy"})),HEALTHY:(0,O.jsx)(g.EuiBadge,{color:"success","data-test-subj":"outputHealthHealthyBadge"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputHealth.healthyStatusText",defaultMessage:"Healthy"}))},h=new Date((null==o?void 0:o.timestamp)||0).getTime(),E=h?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputHealth.timestampTooltipText",defaultMessage:"Last reported {timestamp}",values:{timestamp:(0,O.jsx)(f.FormattedRelative,{value:h})}})):null,y=(null==o?void 0:o.state)&&p[null==o?void 0:o.state]||null;return t?E&&null!=o&&o.state?(0,O.jsx)(g.EuiToolTip,{position:"top",content:E,"data-test-subj":"outputHealthBadgeTooltip"},(0,O.jsx)(l().Fragment,null,y," ")):y:(null==o?void 0:o.state)&&c[o.state]||null},Il=l().memo((({output:e})=>{const t=(0,s.useMemo)((()=>{const t=[];return e.is_default&&t.push((0,O.jsx)(Tl,{key:"default-output"})),e.is_default_monitoring&&t.push((0,O.jsx)(wl,{key:"default-monitoring-output"})),t}),[e]);return(0,O.jsx)(g.EuiBadgeGroup,{gutterSize:"xs"},t.map(((e,t)=>e)))})),Tl=()=>(0,O.jsx)(g.EuiBadge,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultOutputBadgeTitle",defaultMessage:"Agent integrations"})),wl=()=>(0,O.jsx)(g.EuiBadge,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",defaultMessage:"Agent monitoring"})),Cl=A()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-uvxtm0-0"})(["max-width:250px;"]),Al=A()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-uvxtm0-1"})(["min-width:0px;"]),Pl=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Cl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:m.i18n.translate("xpack.fleet.settings.outputsTable.managedTooltip",{defaultMessage:"This output is managed outside of Fleet."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:m.i18n.translate("xpack.fleet.settings.outputsTable.nameColumnTitle",{defaultMessage:"Name"})},{width:"172px",render:e=>function(e){switch(e){case"elasticsearch":return m.i18n.translate("xpack.fleet.settings.outputsTable.elasticsearchTypeLabel",{defaultMessage:"Elasticsearch"});case"remote_elasticsearch":return m.i18n.translate("xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel",{defaultMessage:"Remote Elasticsearch"});default:return e}}(e.type),name:m.i18n.translate("xpack.fleet.settings.outputsTable.typeColumnTitle",{defaultMessage:"Type"})},{truncateText:!0,render:e=>l().createElement(Al,{direction:"column",gutterSize:"xs"},(e.hosts||[]).map((e=>l().createElement(g.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:m.i18n.translate("xpack.fleet.settings.outputsTable.hostColumnTitle",{defaultMessage:"Hosts"})},{render:e=>null!=e&&e.id&&"remote_elasticsearch"===e.type?l().createElement(Fl,{output:e,showBadge:!0}):null,name:m.i18n.translate("xpack.fleet.settings.outputsTable.statusColumnTitle",{defaultMessage:"Status"})},{render:e=>l().createElement(Il,{output:e}),width:"200px",name:m.i18n.translate("xpack.fleet.settings.outputSection.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_default_monitoring&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:m.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"})})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_outputs",{outputId:e.id}),title:m.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editOutputBtn"})))},name:m.i18n.translate("xpack.fleet.settings.outputSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsOutputsTable"})},_l=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.outputSectionTitle",defaultMessage:"Outputs"}))),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(g.EuiLink,{href:n.links.fleet.settings,external:!0,target:"_blank"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.outputSectionSubtitle",defaultMessage:"Specify where agents will send data."}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Pl,{outputs:e,deleteOutput:t}),a.fleet.allSettings&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_outputs"),"data-test-subj":"addOutputBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.outputCreateButtonLabel",defaultMessage:"Add output"}))))},Ll=A()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-xsf6c1-0"})(["max-width:250px;"]),Dl=A()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-xsf6c1-1"})(["min-width:0px;"]),Ol=({downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:a})=>{const{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Ll,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.name"},e.name))),width:"288px",name:m.i18n.translate("xpack.fleet.settings.downloadSourcesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,render:e=>l().createElement(Dl,{direction:"column",gutterSize:"xs"},l().createElement(g.EuiFlexItem,{key:e.host},l().createElement("p",{title:e.host,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.host"},e.host))),name:m.i18n.translate("xpack.fleet.settings.downloadSourcesTable.hostColumnTitle",{defaultMessage:"Host"})},{render:e=>e.is_default?l().createElement(g.EuiIcon,{type:"check","data-test-subj":"editDownloadSourceTable.defaultIcon"}):null,width:"200px",name:m.i18n.translate("xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&a;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:m.i18n.translate("xpack.fleet.settings.downloadSourceSection.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"editDownloadSourceTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_download_sources",{downloadSourceId:e.id}),title:m.i18n.translate("xpack.fleet.settings.downloadSourceSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editDownloadSourceTable.edit.btn"})))},name:m.i18n.translate("xpack.fleet.settings.downloadSourceSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"AgentDownloadSourcesTable"})},Rl=({downloadSources:e,deleteDownloadSource:t})=>{const{getHref:a}=(0,u.iEg)(),s=(0,u.iO7)().fleet.allSettings;return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Title",defaultMessage:"Agent Binary Download"}))),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Subtitle",defaultMessage:"List of sources used by Elastic agents to download their binaries. The default source applies to all agent policies that don't have a specific binary source specified."})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Ol,{downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:s}),s&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:a("settings_create_download_sources"),"data-test-subj":"addDownloadSourcesBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.CreateButtonLabel",defaultMessage:"Add agent binary source"}))))},Bl=A()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-czjc9c-0"})(["max-width:250px;"]),Nl=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Bl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"fleetProxiesTable.name"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.managedTooltip",{defaultMessage:"This proxy is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"url",name:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.urlColumnTitle",{defaultMessage:"Url"})},{width:"68px",render:e=>{const s=a.fleet.allSettings&&!e.is_preconfigured;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"fleetProxiesTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_fleet_proxy",{itemId:e.id}),title:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"fleetProxiesTable.edit.btn"})))},name:m.i18n.translate("xpack.fleet.settings.fleetProxiesTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"fleetProxiesTable"})},zl=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.title",defaultMessage:"Proxies"}))))),(0,O.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.subtitle",defaultMessage:"Specify any proxy URLs to be used in Fleet servers, Outputs or Agent binary download sources. For more information see our {docLink}.",values:{docLink:(0,O.jsx)(g.EuiLink,{target:"_blank",external:!0,href:n.links.fleet.proxiesSettings},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.link",defaultMessage:"docs"}))}})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Nl,{proxies:e,deleteFleetProxy:t}),a.fleet.allSettings&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_fleet_proxy"),"data-test-subj":"addProxyBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.CreateButtonLabel",defaultMessage:"Add proxy"}))))},Ul=({})=>{var e,t,a,n,i,o,r,d;const c=(0,u.iO7)(),{docLinks:p,notifications:x}=(0,u.WeA)(),h=null!==(e=null===(t=(0,u.ZwD)().data)||void 0===t||null===(a=t.item)||void 0===a||null===(n=a.delete_unenrolled_agents)||void 0===n?void 0:n.enabled)&&void 0!==e&&e,E=null!==(i=null===(o=(0,u.ZwD)().data)||void 0===o||null===(r=o.item)||void 0===r||null===(d=r.delete_unenrolled_agents)||void 0===d?void 0:d.is_preconfigured)&&void 0!==i&&i,[y,k]=l().useState(h),{mutateAsync:v}=(0,u.Zd9)();(0,s.useEffect)((()=>{h&&k(h)}),[h]);const j=(0,s.useCallback)((async e=>{try{k(e);const t=await v({delete_unenrolled_agents:{enabled:e,is_preconfigured:!1}});if(t.error)throw t.error}catch(t){k(!e),x.toasts.addError(t,{title:m.i18n.translate("xpack.fleet.errorUpdatingSettings",{defaultMessage:"Error updating settings"})})}}),[v,x.toasts]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h4",{"data-test-subj":"advancedHeader"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.advancedSectionTitle",defaultMessage:"Advanced Settings"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiForm,{component:"form"},(0,O.jsx)(g.EuiDescribedFormGroup,{title:(0,O.jsx)("h3",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"})),description:(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Switching on this setting will enable auto deletion of unenrolled agents. For more information see our {docLink}.",values:{docLink:(0,O.jsx)(g.EuiLink,{target:"_blank",external:!0,href:p.links.fleet.settings},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.link",defaultMessage:"docs"}))}}))},(0,O.jsx)(g.EuiFormRow,{label:""},(0,O.jsx)(g.EuiToolTip,{content:E?m.i18n.translate("xpack.fleet.settings.advancedSection.preconfiguredTitle",{defaultMessage:"This setting is preconfigured and cannot be updated."}):void 0},(0,O.jsx)(g.EuiSwitch,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"}),checked:y,onChange:e=>j(e.target.checked),disabled:!c.fleet.allSettings||E}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}))},Hl=({outputs:e,proxies:t,fleetServerHosts:a,deleteOutput:s,deleteFleetServerHost:n,downloadSources:i,deleteDownloadSource:o,deleteFleetProxy:r})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Ml,{fleetServerHosts:a,deleteFleetServerHost:n}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(_l,{outputs:e,deleteOutput:s}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Rl,{downloadSources:i,deleteDownloadSource:o}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(zl,{proxies:t,deleteFleetProxy:r}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Ul,null));var Wl=a(47907),Gl=a(54761);const ql=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":s,fullWidth:!0},t.props,{placeholder:a}))),Vl=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":s},t.props,{placeholder:a}))),Kl=()=>(0,O.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"s",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.proxyWarning.warningTitle",defaultMessage:"Be aware that changing the proxy settings may cause Elastic Agents to lose connectivity. Please ensure that agents have reachability to the proxy in the context that it is being used for."})});var $l=a(38684);const Yl=({onClose:e,fleetServerHost:t,defaultFleetServerHost:a,proxies:n})=>{const{docLinks:i,cloud:o}=(0,u.WeA)(),r=(0,$l.ao)(t,e,a),{inputs:c}=r,p=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]);return(0,O.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW},(0,O.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,t?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.editTitle",defaultMessage:"Edit Fleet Server"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.addTitle",defaultMessage:"Add Fleet Server"}))),!t&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiText,{color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",defaultMessage:"You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted."}))))),(0,O.jsx)(g.EuiFlyoutBody,null,t&&(0,O.jsx)(g.EuiCallOut,{size:"m",color:"warning",iconType:"warning",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",defaultMessage:"Changing these settings can break your agent connections"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",defaultMessage:"Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiForm,{onSubmit:r.submit},(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:c.nameInput,dataTestSubj:"fleetServerHostsFlyout.nameInput",placeholder:m.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",defaultMessage:"URL"})},(0,O.jsx)(l().Fragment,null,!(null!=o&&o.isServerlessEnabled)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{color:"subdued",size:"relative"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.description",defaultMessage:"Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",values:{link:(0,O.jsx)(g.EuiLink,{href:i.links.fleet.settingsFleetServerHostSettings,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,O.jsx)(g.EuiSpacer,{size:"m"})),(0,O.jsx)(Gl.G,(0,d.default)({},c.hostUrlsInput.props,{id:"fleet-server-inputs",placeholder:m.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder",{defaultMessage:"Specify host URL"}),isUrl:!0,helpText:(null==o?void 0:o.isServerlessEnabled)&&(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"fleetServerHostsFlyout.proxyIdInput"},c.proxyIdInput.props,{onChange:e=>{var t,a;return c.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==c.proxyIdInput.value?p.filter((e=>e.value===c.proxyIdInput.value)):[],options:p,singleSelection:{asPlainText:!0},isDisabled:c.proxyIdInput.props.disabled,isClearable:!0,placeholder:m.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(Kl,null))),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},c.isDefaultInput.formRowProps),(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"fleetServerHostsFlyout.isDefaultSwitch"},c.isDefaultInput.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this Fleet server the default one."})}))))),(0,O.jsx)(g.EuiFlyoutFooter,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{fill:!0,isLoading:r.isLoading,isDisabled:r.isDisabled,onClick:r.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Ql=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),Xl=({})=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalText",defaultMessage:"This action will change agent policies currently using that proxy. Are you sure you wish to continue?"});async function Jl(e){var t,a;let s=`${M.mm}.data_output_id:"${e.id}" or ${M.mm}.monitoring_output_id:"${e.id}"`;const l=`${M.f$}.output_id:"${e.id}"`;e.is_default&&(s+=` or (not ${M.mm}.data_output_id:*)`);const n=await(0,u.cnO)({kuery:s,page:1,perPage:M.W,noAgentCount:!0});if(n.error)throw n.error;const i=await(0,u.TR6)({kuery:l,page:1,perPage:M.W});if(i.error)throw n.error;const o=((null===(t=n.data)||void 0===t?void 0:t.items)||[]).map((e=>e.id)),r=((null===(a=i.data)||void 0===a?void 0:a.items)||[]).reduce(((e,t)=>[...e,...t.policy_ids||[]]),[]),d=new Set([...o,...r]),c=d.size;let g=0;if(c>0){var p,f;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:[...d].map((e=>`policy_id:"${e}"`)).join(" or ")});if(e.error)throw e.error;g=null!==(p=null===(f=e.data)||void 0===f?void 0:f.total)&&void 0!==p?p:0}return{agentPolicyCount:c,agentCount:g}}const Zl=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),en=({output:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalText",defaultMessage:"This action will delete {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTextWithCount",defaultMessage:"This action will delete {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name)}}),tn=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),an=({})=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalText",defaultMessage:"This action will change agent policies currently enrolled in this Fleet Server, to instead enroll in your default Fleet server. Are you sure you wish to continue?"});async function sn(e){var t,a,s;let l=`${M.mm}.download_source_id:"${e.id}"`;e.is_default&&(l+=` or (not ${M.mm}.download_source_id:*)`);const n=await(0,u.cnO)({kuery:l,page:1,perPage:M.W});if(n.error)throw n.error;const i=null!==(t=null===(a=n.data)||void 0===a||null===(s=a.items)||void 0===s?void 0:s.length)&&void 0!==t?t:0;let o=0;if(i>0){var r,d,c;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:null===(r=n.data)||void 0===r?void 0:r.items.map((e=>`policy_id:"${e.id}"`)).join(" or ")});if(e.error)throw e.error;o=null!==(d=null===(c=e.data)||void 0===c?void 0:c.total)&&void 0!==d?d:0}return{agentPolicyCount:i,agentCount:o}}const ln=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalText","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTextWithoutCount","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name)}});function nn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function on(e){try{if(!e)return[m.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.HostIsRequiredErrorMessage",{defaultMessage:"Host is required"})];const t=new URL(e);if(!["http:","https:"].includes(t.protocol))throw new Error("Invalid protocol")}catch(e){return[m.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.hostError",{defaultMessage:"Invalid URL"})]}}const rn=({onClose:e,downloadSource:t,proxies:a})=>{(0,u.ifo)("settings");const l=function(e,t){var a,l,n,i;const o=(0,u.iO7)(),[r,d]=(0,s.useState)(!1),{notifications:c}=(0,u.WeA)(),{confirm:g}=(0,Wl.fl)(),p=!o.fleet.allSettings,x=(0,u.Gez)(null!==(a=null==t?void 0:t.name)&&void 0!==a?a:"",nn,p),h=(0,u.MbH)(null!==(l=null==t?void 0:t.is_default)&&void 0!==l&&l,(null==t?void 0:t.is_default)||p),E=(0,u.Gez)(null!==(n=null==t?void 0:t.host)&&void 0!==n?n:"",on,p),y=(0,u.Gez)(null!==(i=null==t?void 0:t.proxy_id)&&void 0!==i?i:"",(()=>{}),p),k={nameInput:x,hostInput:E,defaultDownloadSourceInput:h,proxyIdInput:y},v=Object.values(k).some((e=>e.hasChanged)),j=(0,s.useCallback)((()=>{const e=x.validate(),t=E.validate();return e&&t}),[x,E]),b=(0,s.useCallback)((async()=>{try{if(!j())return;d(!0);const a={name:x.value.trim(),host:E.value.trim(),is_default:h.value,proxy_id:y.value||null};if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await sn(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),(0,O.jsx)(ln,{agentCount:a,agentPolicyCount:s,downloadSource:e}))}(t,g))return void d(!1);const e=await(0,u.liT)(t.id,a);if(e.error)throw e.error}else{const e=await(0,u.YLO)(a);if(e.error)throw e.error}e(),d(!1)}catch(e){d(!1),c.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.errorToastTitle",{defaultMessage:"Error while saving binary source"})})}}),[g,h.value,t,E.value,x.value,c.toasts,e,y.value,j]);return{inputs:k,submit:b,isLoading:r,isDisabled:r||t&&!v||p}}(e,t),n=l.inputs,{docLinks:i}=(0,u.WeA)(),o=(0,s.useMemo)((()=>a.map((e=>({value:e.id,label:e.name})))),[a]);return(0,O.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW},(0,O.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(g.EuiTitle,{size:"m"},(0,O.jsx)("h2",{id:"FleetEditDownloadSourcesFlyoutTitle"},t?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.editTitle",defaultMessage:"Edit agent binary source","data-test-subj":"editDownloadSourcesFlyout.edit.title"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.createTitle",defaultMessage:"Add new agent binary source","data-test-subj":"editDownloadSourcesFlyout.add.title"})))),(0,O.jsx)(g.EuiFlyoutBody,null,(0,O.jsx)(g.EuiForm,null,(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.nameInputLabel",defaultMessage:"Name"})},n.nameInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.nameInput",fullWidth:!0},n.nameInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,O.jsx)(f.FormattedMessage,{"data-test-subj":"editDownloadSourcesFlyout.hostHelpText",id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputDescription",defaultMessage:"Enter the address of the directory containing the binaries to download. {guideLink}",values:{guideLink:(0,O.jsx)(g.EuiLink,{href:i.links.fleet.settings,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostInputLabel",defaultMessage:"Host"})},n.hostInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.hostInput",fullWidth:!0},n.hostInput.props,{placeholder:"https://artifacts.elastic.co/downloads"}))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdLabel",defaultMessage:"Proxy"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyInputDescription",defaultMessage:"Proxy used for accessing the download source. Currently only the proxy URL is used, headers and certificates are not supported."})},(0,O.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},n.proxyIdInput.props,{onChange:e=>{var t,a;return n.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==n.proxyIdInput.value?o.filter((e=>e.value===n.proxyIdInput.value)):[],options:o,singleSelection:{asPlainText:!0},isDisabled:n.proxyIdInput.props.disabled,isClearable:!0,placeholder:m.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})}))),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(Kl,null),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},n.defaultDownloadSourceInput.formRowProps),(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.isDefaultSwitch"},n.defaultDownloadSourceInput.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.defaultSwitchLabel",defaultMessage:"Make this host the default for all agent policies."})}))))),(0,O.jsx)(g.EuiFlyoutFooter,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"editDownloadSourcesFlyout.cancelBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{fill:!0,isLoading:l.isLoading,isDisabled:l.isDisabled,onClick:l.submit,"data-test-subj":"editDownloadSourcesFlyout.submitBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},un=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),dn=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalText",defaultMessage:"This action will delete {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTextWithoutCount",defaultMessage:"This action will delete {downloadSourceName} agent binary source and it will update its related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name)}}),cn=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),gn=({})=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalText",defaultMessage:"This action will update agent policies using this proxy. This action can not be undone. Are you sure you wish to continue?"});function pn(e){return e&&""!==e?e.match($.lyu)?void 0:[m.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlError",{defaultMessage:"Invalid URL"})]:[m.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlRequired",{defaultMessage:"URL is required"})]}function fn(e){if(e&&""!==e){const t=(0,ws.Hh)(e);if("object"!=typeof t||Object.values(t).some((e=>{const t=typeof e;return"string"!==t&&"number"!==t&&"boolean"!==t})))return[m.i18n.translate("xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage",{defaultMessage:"Proxy headers is not a valid key: value object."})]}}function mn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}const xn=({onClose:e,fleetProxy:t})=>{const a=function(e,t){var a,l,n,i,o,r;const[d,c]=(0,s.useState)(!1),g=(0,u.iO7)(),{notifications:p}=(0,u.WeA)(),{confirm:f}=(0,Wl.fl)(),x=null!==(a=!g.fleet.allSettings||(null==e?void 0:e.is_preconfigured))&&void 0!==a&&a,h=(0,u.Gez)(null!==(l=null==e?void 0:e.name)&&void 0!==l?l:"",mn,x),E=(0,u.Gez)(null!==(n=null==e?void 0:e.url)&&void 0!==n?n:"",pn,x),y=(0,u.Gez)(null!=e&&e.proxy_headers?(0,ws.Bh)(e.proxy_headers):"",fn,x),k=(0,u.Gez)(null!==(i=null==e?void 0:e.certificate_authorities)&&void 0!==i?i:"",(()=>{}),x),v=(0,u.Gez)(null!==(o=null==e?void 0:e.certificate)&&void 0!==o?o:"",(()=>{}),x),j=(0,u.Gez)(null!==(r=null==e?void 0:e.certificate_key)&&void 0!==r?r:"",(()=>{}),x),b=(0,s.useMemo)((()=>({nameInput:h,urlInput:E,proxyHeadersInput:y,certificateAuthoritiesInput:k,certificateInput:v,certificateKeyInput:j})),[h,E,y,k,v,j]),S=(0,s.useCallback)((()=>(0,u.C11)(b)),[b]),M=(0,s.useCallback)((async()=>{try{if(!S())return;if(e&&!await f((0,O.jsx)(cn,null),(0,O.jsx)(gn,null)))return;c(!0);const a={name:h.value,url:E.value,proxy_headers:""===y.value?void 0:(0,ws.Hh)(y.value),certificate_authorities:k.value,certificate:v.value,certificate_key:j.value};if(e){const t=await(0,u.aCR)(e.id,a);if(t.error)throw t.error}else{const e=await(0,u.nJY)(a);if(e.error)throw e.error}p.toasts.addSuccess(m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.successToastTitle",{defaultMessage:"Fleet proxy saved"})),c(!1),await t()}catch(e){c(!1),p.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.errorToastTitle",{defaultMessage:"An error happened while saving Fleet Server host"})})}}),[e,h.value,E.value,y.value,k.value,v.value,j.value,S,p,f,t]),F=Object.values(b).some((e=>e.hasChanged));return{isLoading:d,isDisabled:d||!F||h.props.isInvalid||E.props.isInvalid,submit:M,inputs:b}}(t,e),{inputs:l}=a;return(0,O.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW},(0,O.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(g.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,t?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.editTitle",defaultMessage:"Edit Proxy"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.addTitle",defaultMessage:"Add Proxy"})))),(0,O.jsx)(g.EuiFlyoutBody,null,(0,O.jsx)(Kl,null),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiForm,{onSubmit:a.submit},(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:l.nameInput,"data-test-subj":"fleetProxyFlyout.nameInput",placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.urlInputLabel",defaultMessage:"Proxy Url"}),dataTestSubj:"fleetProxyFlyout.urlInput",inputProps:l.urlInput,placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.urlInputPlaceholder",{defaultMessage:"Specify proxy url"})}),(0,O.jsx)(Vl,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.proxyHeadersLabel",defaultMessage:"Proxy headers"}),dataTestSubj:"fleetProxyFlyout.proxyHeadersInput",inputProps:l.proxyHeadersInput,placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.proxyHeadersPlaceholder",{defaultMessage:"Specify proxy headers"})}),(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesLabel",defaultMessage:"Certificate authorities"}),dataTestSubj:"fleetProxyFlyout.certificateAuthoritiesInput",inputProps:l.certificateAuthoritiesInput,placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesPlaceholder",{defaultMessage:"Specify certificate authorities"})}),(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateLabel",defaultMessage:"Certificate"}),dataTestSubj:"fleetProxyFlyout.certificateInput",inputProps:l.certificateInput,placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificatePlaceholder",{defaultMessage:"Specify certificate"})}),(0,O.jsx)(ql,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateKeyLabel",defaultMessage:"Certificate key"}),dataTestSubj:"fleetProxyFlyout.certificateKeyInput",inputProps:l.certificateKeyInput,placeholder:m.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateKeyPlaceholder",{defaultMessage:"Specify certificate key"})}))),(0,O.jsx)(g.EuiFlyoutFooter,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{fill:!0,isLoading:a.isLoading,isDisabled:a.isDisabled,onClick:a.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))};var hn=a(2912);const En=({inputs:e})=>{const t=(0,s.useMemo)((()=>$.HDJ.map((e=>({label:e,value:e})))),[]);return(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaTopicsPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",defaultMessage:"Topics"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},(0,O.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"editOutputFlyout.kafkaTopicsRadioInput",options:$.HV8,compressed:!0},e.kafkaTopicsInput.props))),(()=>{switch(e.kafkaTopicsInput.value){case $.LXo.Static:return(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},e.kafkaStaticTopicInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaStaticTopicInput",fullWidth:!0},e.kafkaStaticTopicInput.props)));case $.LXo.Dynamic:return(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicHelptext",{defaultMessage:"Select a topic from the list. If a topic is not available, create a custom one."}),label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicLabel",defaultMessage:"Topic from field"})},e.kafkaDynamicTopicInput.formRowProps),(0,O.jsx)(g.EuiComboBox,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaDynamicTopicInput",fullWidth:!0,isClearable:!0,options:t,customOptionText:"Use custom field (not recommended)",singleSelection:{asPlainText:!0}},e.kafkaDynamicTopicInput.props)))}})(),(0,O.jsx)(g.EuiSpacer,{size:"m"}))},yn=e=>{const{inputs:t}=e,{props:{onChange:a},value:l,formRowProps:{error:n}}=t.kafkaHeadersInput,[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)(((e,t,s)=>{const n=l.map(((a,l)=>l===e?{...a,[t]:s}:a));a(n)}),[l,a]),u=(0,s.useCallback)((()=>{o(!0);const e=[...l,{key:"",value:""}];a(e)}),[l,a]),c=(0,s.useCallback)((e=>{const t=l.filter(((t,a)=>a!==e));a(t)}),[l,a]),p=1===l.length,x=1===l.length&&(""===l[0].key||""===l[0].value),h=e=>null!=e&&e.length?e.map(((e,t)=>(0,O.jsx)(g.EuiFormErrorText,{key:t},e))):null,E=(0,s.useMemo)((()=>(e,t)=>null==n?void 0:n.filter((a=>a.index===e&&("key"===t?a.hasKeyError:a.hasValueError))).map((e=>e.message))),[n]),y=(0,s.useMemo)((()=>n&&n.filter((e=>void 0===e.index)).map((({message:e})=>e))),[n]);return(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaHeadersPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeadersTitle",defaultMessage:"Headers"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),l.map(((e,t)=>{var a,s;const l=E(t,"key"),n=E(t,"value");return(0,O.jsx)("div",{key:t},t>0&&(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart",gutterSize:"none",style:{gap:30}},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderKeyInputLabel",defaultMessage:"Key"}),error:h(l),isInvalid:(null!==(a=null==l?void 0:l.length)&&void 0!==a?a:0)>0},(0,O.jsx)(g.EuiFieldText,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersKeyInput${t}`,fullWidth:!0,value:e.key,onChange:e=>r(t,"key",e.target.value),autoFocus:i}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderValueInputLabel",defaultMessage:"Value"}),error:h(n),isInvalid:(null!==(s=null==n?void 0:n.length)&&void 0!==s?s:0)>0},(0,O.jsx)(g.EuiFieldText,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersValueInput${t}`,fullWidth:!0,value:e.value,onChange:e=>r(t,"value",e.target.value)}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1,style:{marginTop:28}},(0,O.jsx)(g.EuiButtonIcon,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersDeleteButton${t}`,color:"text",onClick:()=>c(t),iconType:"cross",disabled:p,"aria-label":m.i18n.translate("xpack.fleet.kafkaHeadersInput.deleteButton",{defaultMessage:"Delete row"})}))))})),h(y),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiButtonEmpty,{"data-test-subj":"kafkaHeaders.multiRowInput.addRowButton",disabled:x,size:"xs",flush:"left",iconType:"plusInCircle",onClick:u},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.kafkaHeadersInput.addRow",defaultMessage:"Add header"})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaClientIdLabel",defaultMessage:"Client ID"})},t.kafkaClientIdInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaClientIdInput",fullWidth:!0},t.kafkaClientIdInput.props))))},kn=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Array.from({length:6},((e,t)=>10*(t+1))).map((e=>({text:e,label:`${e} seconds`})))),[]),l=e=>{switch(e){case $.NAW.DoNotWait:return"No response";case $.NAW.Replica:return"Wait for all replicas to commit";default:case $.NAW.Commit:return"Wait for local commit"}},n=(0,s.useMemo)((()=>Object.keys($.NAW).map((e=>({text:$.NAW[e],label:l($.NAW[e])})))),[]);return(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaBrokerSettingsPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaBrokerSettings"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",defaultMessage:"Broker settings"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",defaultMessage:"Broker timeout"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",defaultMessage:"Define how long a Kafka server waits for data in the same cluster."})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerTimeoutInput"},t.kafkaBrokerTimeoutInput.props,{options:a}))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",defaultMessage:"Broker reachability timeout"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",defaultMessage:"Define how long an Agent would wait for a response from Kafka broker."})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"},t.kafkaBrokerReachabilityTimeoutInput.props,{options:a}))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",defaultMessage:"ACK Reliability"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",defaultMessage:"Reliability level required from the broker."})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"},t.kafkaBrokerAckReliabilityInput.props,{options:n}))))},vn=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Object.keys($.jZS).filter((e=>"None"!==e)).map((e=>({text:$.jZS[e],label:$.jZS[e]})))),[]),n=(0,s.useMemo)((()=>Array.from({length:9},((e,t)=>t+1)).map((e=>({text:e,label:e.toString()})))),[]);return(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaCompressionPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaCompression"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionTitle",defaultMessage:"Compression"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaCompressionSwitch"},t.kafkaCompressionInput.props,{onChange:e=>{e.target.checked||t.kafkaCompressionCodecInput.setValue($.jZS.None),t.kafkaCompressionInput.setValue(e.target.checked)},label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionSwitchLabel",defaultMessage:"Enable compression"})})),t.kafkaCompressionInput.value?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionCodecInputLabel",defaultMessage:"Codec"})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaCompressionCodecInput"},t.kafkaCompressionCodecInput.props,{options:a}))),t.kafkaCompressionCodecInput.value===$.jZS.Gzip&&(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionLevelInputLabel",defaultMessage:"Level"})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0},t.kafkaCompressionLevelInput.props,{"data-test-subj":"settingsOutputsFlyout.kafkaCompressionLevelInput",options:n})))):null)},jn=[{id:$.BwZ.Random,label:"Random","data-test-subj":"kafkaPartitionRandomRadioButton"},{id:$.BwZ.RoundRobin,label:"Round robin","data-test-subj":"kafkaPartitionRoundRobinRadioButton"},{id:$.BwZ.Hash,label:"Hash","data-test-subj":"kafkaPartitionHashRadioButton"}],bn=e=>{const{inputs:t}=e;return(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaPartitionPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaPartitionTitle"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",defaultMessage:"Partitioning"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",defaultMessage:"Partitioning strategy"})},(0,O.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"settingsOutputsFlyout.kafkaPartitioningRadioInput",options:jn,compressed:!0},t.kafkaPartitionTypeInput.props))),(()=>{switch(t.kafkaPartitionTypeInput.value){case $.BwZ.Random:return(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRandomInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRandomInput",fullWidth:!0},t.kafkaPartitionTypeRandomInput.props)));case $.BwZ.RoundRobin:return(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRoundRobinInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",fullWidth:!0},t.kafkaPartitionTypeRoundRobinInput.props)));case $.BwZ.Hash:default:return(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",defaultMessage:"List of fields"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",defaultMessage:"Comma separated."})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeHashInput",fullWidth:!0},t.kafkaPartitionTypeHashInput.props))))}})())},Sn=({fullWidth:e,error:t,isInvalid:a,children:n,clear:i,title:o,initialValue:r,onToggleSecretStorage:u,cancelEdit:d,useSecretsStorage:c,isConvertedToSecret:p=!1,label:x,disabled:h})=>{const E=!!r,[y,k]=(0,s.useState)(p||!r),v=(0,O.jsx)(g.EuiPanel,{color:"subdued",borderRadius:"none",hasShadow:!1},h?(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputForm.secretValueHiddenAndDisabledMessage",defaultMessage:"The saved {varName} is hidden.",values:{varName:o}})):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputForm.secretValueHiddenMessage",defaultMessage:"The saved {varName} is hidden. You can only replace the {varName}.",values:{varName:o}})),(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiButtonEmpty,{onClick:()=>k(!0),color:"primary",iconType:"refresh",iconSide:"left",size:"xs"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.outputForm.editSecretValue",defaultMessage:"Replace {varName}",values:{varName:o}})))),j=(0,O.jsx)(g.EuiButtonEmpty,{onClick:()=>{k(!1),d&&d()},color:"primary",iconType:"refresh",iconSide:"left",size:"xs"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSetCancelButton",defaultMessage:"Cancel {varName} change",values:{varName:o}})),b=(0,O.jsx)(l().Fragment,null,n,E&&!p&&(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd","data-test-subj":"secretCancelChangeBtn"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},j))),S=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiIcon,{type:"lock","data-test-subj":"lockIcon"})," ",o," ",(0,O.jsx)(g.EuiToolTip,{content:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTooltip",{defaultMessage:"This value will be stored as a secret, meaning once saved the value cannot be viewed again"})},(0,O.jsx)(g.EuiIcon,{type:"question"}))),M=(0,s.useMemo)((()=>h?null:p?(0,O.jsx)(g.EuiCallOut,{size:"s",color:"warning"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeySecretInputConvertedCalloutTitle",defaultMessage:"This field will be re-saved using secret storage from plain text storage. Secrets storage requires Fleet Server v8.12.0 and above. {revertLink}",values:{revertLink:(0,O.jsx)(g.EuiLink,{onClick:()=>u(!1),color:"primary"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",defaultMessage:"Click to use plain text storage instead"}))}})):r?void 0:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeySecretInputCalloutTitle",defaultMessage:"This field uses secret storage and requires Fleet Server v8.12.0 and above. {revertLink}",values:{revertLink:(0,O.jsx)(g.EuiLink,{onClick:()=>u(!1),color:"primary"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",defaultMessage:"Click to use plain text storage instead"}))}})),[h,r,p,u]),F=h?null:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.secretInputCalloutTitle",defaultMessage:"This field should be stored as a secret, currently it is set to be stored as plain text. {enableSecretLink}",values:{enableSecretLink:(0,O.jsx)(g.EuiLink,{onClick:()=>u(!0),color:"primary"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToSecretStorageLink",defaultMessage:"Click to use secret storage instead"}))}}),I=y?b:v;return c?(0,O.jsx)(g.EuiFormRow,{fullWidth:e,label:S,error:t,isInvalid:a,helpText:M},I):(0,O.jsx)(g.EuiFormRow,{fullWidth:e,error:t,isInvalid:a,label:x,helpText:F},I)},Mn=[{id:$.N9h.Plain,label:"Plain","data-test-subj":"kafkaSaslPlainRadioButton"},{id:$.N9h.ScramSha256,label:"SCRAM-SHA-256","data-test-subj":"kafkaSaslScramSha256RadioButton"},{id:$.N9h.ScramSha512,label:"SCRAM-SHA-512","data-test-subj":"kafkaSaslScramSha512RadioButton"}],Fn=[{id:$.NB8.None,label:"None","data-test-subj":"kafkaAuthenticationNoneRadioButton"},{id:$.NB8.Userpass,label:"Username / Password","data-test-subj":"kafkaAuthenticationUsernamePasswordRadioButton"},{id:$.NB8.Ssl,label:"SSL","data-test-subj":"kafkaAuthenticationSSLRadioButton"}],In=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,[i,o]=l().useState({kafkaAuthPassword:!1,kafkaSslKey:!1}),[r,u]=l().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&(t.kafkaAuthPasswordInput.value&&!t.kafkaAuthPasswordSecretInput.value&&(t.kafkaAuthPasswordSecretInput.setValue(t.kafkaAuthPasswordInput.value),t.kafkaAuthPasswordInput.clear(),o({...i,kafkaAuthPassword:!0})),t.kafkaSslKeyInput.value&&!t.kafkaSslKeySecretInput.value&&(t.kafkaSslKeySecretInput.setValue(t.kafkaSslKeyInput.value),t.kafkaSslKeyInput.clear(),o({...i,kafkaSslKey:!0}))))}),[a,t.kafkaAuthPasswordInput,t.kafkaAuthPasswordSecretInput,t.kafkaSslKeyInput,t.kafkaSslKeySecretInput,r,u,i]);const c=e=>{e?(t.kafkaAuthPasswordInput.clear(),t.kafkaSslKeyInput.clear()):(t.kafkaAuthPasswordSecretInput.setValue(""),t.kafkaSslKeySecretInput.setValue("")),o({kafkaAuthPassword:!1,kafkaSslKey:!1}),n(e)},p=(0,s.useMemo)((()=>Object.keys($.i36).map((e=>({text:$.i36[e],label:e})))),[]),x=(0,s.useMemo)((()=>Object.keys($.zPI).map((e=>({id:$.zPI[e],label:e,"data-test-subj":`kafkaConnectionType${e}RadioButton`})))),[]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationPanel"},(0,O.jsx)(g.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaAuthenticationTitle"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaAuthenticationTitle",defaultMessage:"Authentication"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0},(0,O.jsx)(g.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationRadioInput",options:Fn,compressed:!0},t.kafkaAuthMethodInput.props))),(()=>{switch(t.kafkaAuthMethodInput.value){case $.NB8.None:return(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaConnectionTypeLabel",defaultMessage:"Connection"})},(0,O.jsx)(g.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaConnectionTypeRadioInput",options:x,compressed:!0},t.kafkaConnectionTypeInput.props)));case $.NB8.Ssl:return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.kafkaSslCertificateInput.formRowProps),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslCertificateInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,title:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordSecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaSslKey,onToggleSecretStorage:c,cancelEdit:t.kafkaSslKeySecretInput.cancelEdit}),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":"kafkaSslKeySecretInput"},t.kafkaSslKeySecretInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslKeyInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))));default:case $.NB8.Userpass:return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaUsernameInputLabel",defaultMessage:"Username"})},t.kafkaAuthUsernameInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaUsernameInput",fullWidth:!0},t.kafkaAuthUsernameInput.props))),a?(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,title:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputtitle",{defaultMessage:"Password"})},t.kafkaAuthPasswordSecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaAuthPassword,onToggleSecretStorage:c,cancelEdit:t.kafkaAuthPasswordSecretInput.cancelEdit}),(0,O.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordSecretInput",fullWidth:!0},t.kafkaAuthPasswordSecretInput.props))):(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputLabel",defaultMessage:"Password"})},t.kafkaAuthPasswordInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,O.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordInput",fullWidth:!0},t.kafkaAuthPasswordInput.props))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaSaslInputLabel",defaultMessage:"SASL Mechanism"})},(0,O.jsx)(g.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaSaslInput",options:Mn,compressed:!0},t.kafkaSaslMechanismInput.props))))}})()),t.kafkaConnectionTypeInput.value!==$.zPI.Plaintext||t.kafkaAuthMethodInput.value!==$.NB8.None?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Gl.G,(0,d.default)({placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.kafkaSslCertificateAuthoritiesInput.props)),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVerificationModeInputLabel",defaultMessage:"Verification mode"})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVerificationModeInput"},t.kafkaVerificationModeInput.props,{options:p})))):null)},Tn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,{docLinks:i}=(0,at.WeA)(),o=(0,s.useMemo)((()=>$.y6d.map((e=>({text:e,label:e})))),[]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVersionInputLabel",defaultMessage:"Kafka version"})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVersionInput"},t.kafkaVersionInput.props,{options:o}))),(0,O.jsx)(Gl.G,(0,d.default)({placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!0,helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHostsInputDescription",defaultMessage:"Specify the URLs that your agents will use to connect to Kafka. {guideLink}.",values:{guideLink:(0,O.jsx)(g.EuiLink,{href:i.links.fleet.kafkaSettings,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.kafkaUserGuideLink",defaultMessage:"Learn more"}))}}),label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputLabel",{defaultMessage:"Hosts"})},t.kafkaHostsInput.props)),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(In,{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(bn,{inputs:t}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(En,{inputs:t}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(yn,{inputs:t}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(vn,{inputs:t}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(kn,{inputs:t}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputLabel",defaultMessage:"Key (optional)"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputHelpText",defaultMessage:"If configured, the event key can be extracted from the event using a format string."})},(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaKeyInput",fullWidth:!0},t.kafkaKeyInput.props))))};var wn=a(9424);const Cn=A().div.withConfig({displayName:"CodeEditorContainer",componentId:"sc-1u19e39-0"})(["min-height:0;position:relative;height:116px;"]),An=A()(g.EuiTextColor).attrs((e=>({color:"subdued",size:"xs"}))).withConfig({displayName:"CodeEditorPlaceholder",componentId:"sc-1u19e39-1"})(["position:absolute;top:0;left:0;font-family:Menlo,Monaco,'Courier New',monospace;font-size:12px;line-height:21px;pointer-events:none;"]),Pn={minimap:{enabled:!1},ariaLabel:m.i18n.translate("xpack.fleet.settings.yamlCodeEditor",{defaultMessage:"YAML Code Editor"}),scrollBeyondLastLine:!1,wordWrap:"on",wrappingIndent:"indent",automaticLayout:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,folding:!1,lineDecorationsWidth:0},_n=e=>{const{placeholder:t,disabled:a,...s}=e;return a?l().createElement(g.EuiCodeBlock,{style:{height:"116px"},language:"yaml",isCopyable:!1,paddingSize:"s"},l().createElement("pre",null,s.value)):l().createElement(Cn,null,l().createElement(wn.CodeEditor,(0,d.default)({languageId:"yaml",width:"100%",height:"116px",options:Pn},s)),(!s.value||""===s.value)&&l().createElement(An,null,t))},Ln=e=>t=>{if("object"!=typeof t)return e(null!=t?t:"")};function Dn(e){const t=[],a={};if(e.forEach(((e,s)=>{if(!e)return void t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostFieldRequiredError",{defaultMessage:"Host is required"})});const l=e.split(":");if(2!==l.length||!l[0]||!l[1])return void t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostPortError",{defaultMessage:'Invalid format. Expected "host:port" without protocol.'}),index:s});const n=parseInt(l[1],10);(isNaN(n)||n<1||n>65535)&&t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaPortError",{defaultMessage:"Invalid port number. Expected a number between 1 and 65535"}),index:s});const i=a[e]||[];a[e]=[...i,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function On(e){const t=[],a={},s=m.i18n.translate("xpack.fleet.settings.outputForm.elasticUrlRequiredError",{defaultMessage:"URL is required"});if(e.forEach(((e,l)=>{try{if(e){const a=new URL(e);["http:","https:"].includes(a.protocol)||t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"}),index:l})}else t.push({message:s,index:l})}catch(e){t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.elasticHostError",{defaultMessage:"Invalid URL"}),index:l})}const n=a[e]||[];a[e]=[...n,l]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.elasticHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:s}),t.length)return t}function Rn(e){const t=[],a={};if(e.forEach(((e,s)=>{try{if(e.match(/^http([s]){0,1}:\/\//))return void t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.logstashHostProtocolError",{defaultMessage:"Host address must begin with a domain name or IP address"}),index:s});if(new URL(`http://${e}`).host!==e.toLowerCase())throw new Error("Invalid host")}catch(a){0===e.length?t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"}),index:s}):t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.logstashHostError",{defaultMessage:"Invalid Host"}),index:s})}const l=a[e]||[];a[e]=[...l,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.logstashHostDuplicateError",{defaultMessage:"Duplicate Host"}),index:e})))})),0===e.length&&t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function Bn(e){try{return void(0,ws.Hh)(e)}catch(e){return[m.i18n.translate("xpack.fleet.settings.outputForm.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML: {reason}",values:{reason:e.message}})]}}function Nn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function zn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.kafkaUsernameIsRequired",{defaultMessage:"Username is required"})]}function Un(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.kafkaPasswordIsRequired",{defaultMessage:"Password is required"})]}const Hn=Ln(Un);function Wn(e){if(""!==e&&!e.match(/^[a-zA-Z0-9]+$/))return[m.i18n.translate("xpack.fleet.settings.outputForm.caTrusterdFingerprintInvalidErrorMessage",{defaultMessage:"CA trusted fingerprint should be valid HEX encoded SHA-256 of a CA certificate"})]}function Gn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.serviceTokenRequiredErrorMessage",{defaultMessage:"Service token is required"})]}const qn=Ln(Gn);function Vn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.sslCertificateRequiredErrorMessage",{defaultMessage:"SSL certificate is required"})]}function Kn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.sslKeyRequiredErrorMessage",{defaultMessage:"SSL key is required"})]}const $n=Ln(Kn);function Yn(e){if(!e||""===e)return[m.i18n.translate("xpack.fleet.settings.outputForm.kafkaDefaultTopicRequiredMessage",{defaultMessage:"Default topic is required"})]}function Qn(e){const t=[];if(e.forEach(((e,a)=>{e||t.push(m.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicFieldRequiredMessage",{defaultMessage:"Topic is required"}))})),0===e.length&&t.push(m.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicRequiredMessage",{defaultMessage:"Topic is required"})),t.length)return t}function Xn(e){return/^[A-Za-z0-9._-]+$/.test(e)?void 0:[m.i18n.translate("xpack.fleet.settings.outputForm.kafkaClientIdFormattingMessage",{defaultMessage:"Client ID is invalid. Only letters, numbers, dots, underscores, and dashes are allowed."})]}function Jn(e){return/^[0-9]+$/.test(e)?void 0:[m.i18n.translate("xpack.fleet.settings.outputForm.kafkaPartitioningGroupEventsFormattingMessage",{defaultMessage:"Number of events must be a number"})]}function Zn(e){const t=[],a=new Set;if(e.forEach(((e,s)=>{const{key:l,value:n}=e,i=!!l,o=!!n;i&&!o?t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingKeyError",{defaultMessage:'Missing value for key "{key}"',values:{key:l}}),index:s,hasKeyError:!1,hasValueError:!0}):!i&&o?t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingValueError",{defaultMessage:'Missing key for value "{value}"',values:{value:n}}),index:s,hasKeyError:!0,hasValueError:!1}):i&&o&&(a.has(l)?t.push({message:m.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersDuplicateKeyError",{defaultMessage:'Duplicate key "{key}"',values:{key:l}}),index:s,hasKeyError:!0,hasValueError:!1}):a.add(l))})),t.length)return t}const ei=()=>(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),ti=({output:e,agentCount:t,agentPolicyCount:a})=>(0,O.jsx)(l().Fragment,null,void 0!==t&&void 0!==a?(0,O.jsx)(f.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalText",defaultMessage:"This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(f.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalTextWithoutCount",defaultMessage:"This action will update {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name)}}),"logstash"===e.type?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"m",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningTitle",defaultMessage:"Logstash output for agent integration is not supported for fleet server and synthetics."})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningMessage",defaultMessage:"Fleet server and synthetics policies will keep using the existing ES output."}))," "):null);const ai=({enabled:e,inputs:t})=>{const{diskQueueEnabledInput:a,diskQueuePathInput:s,diskQueueMaxSizeInput:n,loadBalanceEnabledInput:i,diskQueueEncryptionEnabled:o,diskQueueCompressionEnabled:r,compressionLevelInput:u,memQueueEvents:c,queueFlushTimeout:p,maxBatchBytes:x}=t,{showExperimentalShipperOptions:h}=z.ZX.get();return e?(0,O.jsx)(g.EuiAccordion,{id:"advancedOutputOptions",arrowDisplay:"left",buttonContent:(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.advancedOptionsToggleLabel",defaultMessage:"Advanced options"})),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiBetaBadge,{label:"Experimental",color:"subdued"})))},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},x.formRowProps,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescriptionLabel",defaultMessage:"Maximum Batch Size"})}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFieldNumber,(0,d.default)({},x.props,{placeholder:"Batching Bytes",min:0}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescription",defaultMessage:"Data will be sent to the output when the agent has more events in the queue than this number."}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},p.formRowProps,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutLabel",defaultMessage:"Flush Timeout"})}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFieldNumber,(0,d.default)({},p.props,{placeholder:"Seconds",min:0}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutDescription",defaultMessage:"Upon expiry the output queue is flushed and data is written to the output."}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},c.formRowProps,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsLabel",defaultMessage:"Memory Queue Size"})}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFieldNumber,(0,d.default)({},c.props,{placeholder:"Events",min:0}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsSizeDescription",defaultMessage:"Maximum number of events that can be stored in the queue. Default is set to 4096. When this queue is full, new events are dropped."}))))),h&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiHorizontalRule,null),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},a.formRowProps),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueSwitch"},a.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchLabel",defaultMessage:"Disk Queue"})}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchDescription",defaultMessage:"Once enabled, events will be queued on disk if, for some reason, agent is not able to send them."}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.formRowProps),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueEncryption"},o.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionLabel",defaultMessage:"Disk Queue Encryption"})}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionDescription",defaultMessage:"Enable encryption of data written to the disk queue."}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueuePathLabel",defaultMessage:"Disk Queue Path"})},s.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.diskQueuePath"},s.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.diskQueuePathPlaceholder",{defaultMessage:"path_data/diskqueue"})}))),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},n.formRowProps,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSize",defaultMessage:"Maximum Disk Queue Size"})}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFieldNumber,(0,d.default)({},n.props,{placeholder:"Bytes",min:0}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSizeDescription",defaultMessage:"Limits the disk queue size for spooling of data. When data in the queue exceeds this limit, new events will be dropped."}))))),(0,O.jsx)(g.EuiHorizontalRule,null),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},i.formRowProps),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.loadBalancingSwitch"},i.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingSwitchLabel",defaultMessage:"Load Balancing"})}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingDescription",defaultMessage:"Once enabled, the agents will balance the load across all the hosts defined for this output. This will increase the number of connections opened by the agent."}))))),(0,O.jsx)(g.EuiHorizontalRule,null),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0},(0,O.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionSwitch"},r.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchLabel",defaultMessage:"Compression"})}))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiSelect,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionLevelSelect",id:"selectCompressionLevel","aria-label":"Use aria labels when no actual label is in use"},u.props))),(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchDescription",defaultMessage:"Level 1 compression is the fastest, Level 9 however would provide the most compression."})))))))):null},si=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,[i,o]=l().useState({serviceToken:!1}),[r,u]=l().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&t.serviceTokenInput.value&&!t.serviceTokenSecretInput.value&&(t.serviceTokenSecretInput.setValue(t.serviceTokenInput.value),t.serviceTokenInput.clear(),o({serviceToken:!0})))}),[a,t.serviceTokenInput,t.serviceTokenSecretInput,r,u,i]);const c=e=>{e?t.serviceTokenInput.clear():t.serviceTokenSecretInput.setValue(""),o({...i,serviceToken:!1}),n(e)};return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Gl.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),a?(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,title:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",{defaultMessage:"Service token"})},t.serviceTokenSecretInput.formRowProps,{cancelEdit:t.serviceTokenSecretInput.cancelEdit,useSecretsStorage:a,isConvertedToSecret:i.serviceToken,onToggleSecretStorage:c}),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"serviceTokenSecretInput",fullWidth:!0},t.serviceTokenSecretInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))):(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",defaultMessage:"Service token"})},t.serviceTokenInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,O.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"serviceTokenSecretInput"},t.serviceTokenInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCallOut,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",defaultMessage:"Generate a service token by running this API request in the Remote Kibana Console and copy the response value"}),"data-test-subj":"serviceTokenCallout"},(0,O.jsx)(g.EuiCodeBlock,{isCopyable:!0},'POST kbn:/api/fleet/service_tokens\n{\n  "remote": true\n}')),(0,O.jsx)(g.EuiSpacer,{size:"m"}))};var li=a(40622);const ni=()=>{const{docLinks:e}=(0,u.WeA)();return(0,O.jsx)(ii,{iconType:"info",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.calloutTitle",defaultMessage:"Additional Logstash configuration required"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.description",defaultMessage:"Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",values:{documentationLink:(0,O.jsx)(g.EuiLink,{external:!0,href:e.links.logstash.inputElasticAgent},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.documentationLink",defaultMessage:"Learn more"}))}}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(oi,null)))},ii=({children:e,...t})=>{const[a,n]=(0,s.useState)(!1),i=(0,u.iO7)().fleet.allSettings;return(0,O.jsx)(g.EuiCallOut,t,(0,O.jsx)(g.EuiSpacer,{size:"s"}),a?(0,O.jsx)(g.EuiButton,{onClick:()=>n(!1)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,O.jsx)(li.m,{missingPrivilege:i?void 0:"Settings All",position:"left"},(0,O.jsx)(g.EuiButton,{onClick:()=>n(!0),fill:!0,disabled:!i},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",defaultMessage:"View steps"}))),a&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),e))},oi=()=>{const{docLinks:e}=(0,u.WeA)(),t=function(){const[e,t]=(0,s.useState)(!1),[a,n]=(0,s.useState)(),i=(0,u.WeA)(),{notifications:o}=i,r=(0,s.useCallback)((async()=>{try{var e;t(!0);const a=await(0,u.waY)();if(a.error)throw a.error;n(null===(e=a.data)||void 0===e?void 0:e.api_key)}catch(e){403===e.statusCode?o.toasts.addDanger({title:m.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"}),text:(0,tt.Pv)((0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyPermissions",defaultMessage:"You need the cluster permissions: {clusterPermissions}{br} and the index permissions: {indexPermissions}{br}for indexes: {br}{indexes}",values:{clusterPermissions:(0,O.jsx)(g.EuiCode,null,$.pfJ.join(", ")),indexPermissions:(0,O.jsx)(g.EuiCode,null,$.MVu.join(", ")),indexes:$.xPW.map((e=>(0,O.jsx)(l().Fragment,{key:e},(0,O.jsx)(g.EuiCode,null,e),(0,O.jsx)("br",null)))),br:(0,O.jsx)("br",null)}}),i)},{}):o.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"})})}finally{t(!1)}}),[o.toasts,i]);return(0,s.useMemo)((()=>({isLoading:e,generateApiKey:r,apiKey:a})),[e,r,a])}(),a=(0,u.iO7)().fleet.allSettings,n=(0,s.useMemo)((()=>{return[{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",defaultMessage:"We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent."}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),t.apiKey?(0,O.jsx)(g.EuiCodeBlock,{paddingSize:"m"},(0,O.jsx)("h5",null,"API Key"),t.apiKey,(0,O.jsx)("div",{className:"euiCodeBlock__controls"},(0,O.jsx)("div",{className:"euiCodeBlock__copyButton"},(0,O.jsx)(g.EuiCopy,{textToCopy:t.apiKey},(e=>(0,O.jsx)(g.EuiButtonIcon,{onClick:e,iconType:"copyClipboard",color:"text",disabled:!a,"aria-label":m.i18n.translate("xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel",{defaultMessage:"Copy message"})})))))):(0,O.jsx)(g.EuiButton,{isLoading:t.isLoading,onClick:t.generateApiKey,disabled:!a},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",defaultMessage:"Generate API key"})),(0,O.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",defaultMessage:"Next, open the {pipelineConfFile} file and insert the following content:",values:{pipelineConfFile:(0,O.jsx)(g.EuiCode,null,"elastic-agent-pipeline.conf")}}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},(s=t.apiKey,'input {\n  elastic_agent {\n    port => 5044\n    ssl => true\n    ssl_certificate_authorities => ["<ca_path>"]\n    ssl_certificate => "<server_cert_path>"\n    ssl_key => "<server_cert_key_in_pkcs8>"\n    ssl_verify_mode => "force_peer"\n  }\n}\n\noutput {\n  elasticsearch {\n    hosts => "<es_host>"\n    api_key => "<api_key>"\n    data_stream => true\n    ssl => true\n    # cacert => "<elasticsearch_ca_path>"\n  }\n}'.replace("<api_key>",s||"<api_key>"))))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",defaultMessage:"In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",values:{pipelineFile:(0,O.jsx)(g.EuiCode,null,"pipelines.yml")}}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},'- pipeline.id: elastic-agent-pipeline\n  path.config: "/etc/path/to/elastic-agent-pipeline.conf"\n'))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.replaceStepDescription",defaultMessage:"Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",values:{documentationLink:(0,O.jsx)(g.EuiLink,{external:!0,href:e.links.fleet.secureLogstash},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.ourDocumentationLink",defaultMessage:"our documentation"}))}}),(0,O.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",defaultMessage:"Save the pipeline and restart Logstash so the changes take effect."}),(0,O.jsx)(g.EuiSpacer,{size:"m"}))}];var s}),[t,e,a]);return(0,O.jsx)("ol",null,n.map(((e,t)=>(0,O.jsx)("li",{key:t},e.children))))},ri=()=>{const{docLinks:e}=(0,u.WeA)();return(0,O.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutTitle",defaultMessage:"Additional setup required"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutDescription",defaultMessage:"You must configure an encryption key before configuring this output. {link}",values:{link:(0,O.jsx)(g.EuiLink,{href:e.links.kibana.secureSavedObject,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.link",defaultMessage:"Learn more"}))}}))},ui=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n,hasEncryptedSavedObjectConfigured:i}=e,{docLinks:o}=(0,u.WeA)(),[r,c]=l().useState(!0),[p,x]=l().useState({sslKey:!1});(0,s.useEffect)((()=>{r&&(c(!1),a&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),x({...p,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,r,c,p]);const h=e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),x({sslKey:!1}),n(e)};return(0,O.jsx)(l().Fragment,null,!i&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(ri,null)),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(ni,null),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(Gl.G,(0,d.default)({placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!1,helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",defaultMessage:"Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",values:{guideLink:(0,O.jsx)(g.EuiLink,{href:o.links.fleet.logstashSettings,target:"_blank",external:!0},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel",{defaultMessage:"Logstash hosts"})},t.logstashHostsInput.props)),(0,O.jsx)(Gl.G,(0,d.default)({placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.sslCertificateAuthoritiesInput.props)),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.sslCertificateInput.formRowProps),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslCertificateInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,title:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.sslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:p.sslKey,onToggleSecretStorage:h,cancelEdit:t.sslKeySecretInput.cancelEdit}),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslKeySecretInput.props,{"data-test-subj":"sslKeySecretInput",placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,O.jsx)(Sn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.sslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:h}),(0,O.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslKeyInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))))},di=e=>{const{inputs:t}=e,{cloud:a}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Gl.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0,helpText:(null==a?void 0:a.isServerlessEnabled)&&(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",defaultMessage:"Elasticsearch CA trusted fingerprint (optional)"})},t.caTrustedFingerprintInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0},t.caTrustedFingerprintInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder",{defaultMessage:"Specify Elasticsearch CA trusted fingerprint"})}))))},ci=({defaultOuput:e,onClose:t,output:a,proxies:n})=>{(0,u.ifo)("settings");const i=function(e,t,a){var l,n,i,o,r,d,c,g,p,f,x,h,E,y,k,v,j,b,S,M,F,I,T,w,C,A,P,_,L,D,R,B,N,U,H,W,G,q,V,K,Y,Q,X,J,Z,ee,te,ae,se,le,ne,ie,oe,re,ue,de,ce,ge,pe,fe,me,xe,he,Ee,ye,ke,ve,je,be,Se,Me,Fe;const Ie=(0,u.YI3)(),Te=(0,u.iO7)(),{showExperimentalShipperOptions:we}=z.ZX.get(),Ce=!(null!==(l=Ie.missingOptionalFeatures)&&void 0!==l&&l.includes("encrypted_saved_object_encryption_key_required")),[Ae,Pe]=(0,s.useState)(!1),{notifications:_e,cloud:Le}=(0,u.WeA)(),{confirm:De}=(0,Wl.fl)(),Oe=null!==(n=null==t?void 0:t.is_preconfigured)&&void 0!==n&&n,Re=null!==(i=null==t?void 0:t.allow_edit)&&void 0!==i?i:[];function Be(e){return!Te.fleet.allSettings||!!Oe&&!Re.includes(e)}const Ne=(0,u.Gez)(null!==(o=null==t?void 0:t.name)&&void 0!==o?o:"",Nn,Be("name")),ze=(0,u.Gez)(null!==(r=null==t?void 0:t.type)&&void 0!==r?r:"elasticsearch",void 0,Be("type")),Ue=(0,u.Gez)(null!==(d=null==t?void 0:t.config_yaml)&&void 0!==d?d:"",Bn,Be("config_yaml")),He=(0,u.MbH)(null!==(c=null==t?void 0:t.is_default)&&void 0!==c&&c,Be("is_default")||(null==t?void 0:t.is_default)),We=(0,u.MbH)(null!==(g=null==t?void 0:t.is_default_monitoring)&&void 0!==g&&g,Be("is_default_monitoring")||(null==t?void 0:t.is_default_monitoring)),Ge=(0,u.Gez)(null!==(p=null==t?void 0:t.ca_trusted_fingerprint)&&void 0!==p?p:"",Wn,Be("ca_trusted_fingerprint")),qe=null==Le?void 0:Le.isServerlessEnabled,Ve=!qe||null!=t&&t.hosts?(null==t?void 0:t.hosts)||[]:(null==a?void 0:a.hosts)||[],Ke=qe||Be("hosts"),$e=(0,u.U6y)("esHostsComboxBox",Ve,On,Ke),Ye=(0,u.Gez)(null!==(f=null==t?void 0:t.preset)&&void 0!==f?f:(0,hn.lX)(null!==(x=null==t?void 0:t.config_yaml)&&void 0!==x?x:"",ws.Hh),(()=>{}),Be("preset")),Qe=(0,u.Gez)(null!==(h=null==t?void 0:t.service_token)&&void 0!==h?h:"",Gn,Be("service_token")),Xe=(0,u.YZM)(null!==(E=null==t||null===(y=t.secrets)||void 0===y?void 0:y.service_token)&&void 0!==E?E:"",qn,Be("service_token")),Je=null!=t&&t.config_yaml?(0,ws.Hh)(null==t?void 0:t.config_yaml):{},Ze=!(null!=Je&&Je.shipper)||!1===(null==Je||null===(k=Je.shipper)||void 0===k?void 0:k.enabled),et=(0,u.MbH)(null!==(v=null==t||null===(j=t.shipper)||void 0===j?void 0:j.disk_queue_enabled)&&void 0!==v&&v),tt=(0,u.Gez)(null!==(b=null==t||null===(S=t.shipper)||void 0===S?void 0:S.disk_queue_path)&&void 0!==b?b:"",void 0,null!==(M=!et.value)&&void 0!==M&&M),at=(0,u.hp)(null!==(F=null==t||null===(I=t.shipper)||void 0===I?void 0:I.disk_queue_max_size)&&void 0!==F?F:4096,void 0,null!==(T=!et.value)&&void 0!==T&&T),st=(0,u.MbH)(null!==(w=null==t||null===(C=t.shipper)||void 0===C?void 0:C.disk_queue_encryption_enabled)&&void 0!==w&&w,null!==(A=!et.value)&&void 0!==A&&A),lt=(0,u.MbH)(null!==(P=null==t||null===(_=t.shipper)||void 0===_?void 0:_.disk_queue_enabled)&&void 0!==P&&P),nt=(0,u.MbH)(null!==(L=null==t||null===(D=t.shipper)||void 0===D?void 0:D.disk_queue_compression_enabled)&&void 0!==L&&L),it=Array.from(Array(10).keys()).slice(1).map((e=>({value:`${e}`,text:`Level ${e}`}))),ot=(0,u.aOf)(it,null!==(R=`${null==t||null===(B=t.shipper)||void 0===B?void 0:B.compression_level}`)&&void 0!==R?R:it[0].value,null!==(N=!nt.value)&&void 0!==N&&N),rt=(0,u.hp)((null==t||null===(U=t.shipper)||void 0===U?void 0:U.mem_queue_events)||void 0),ut=(0,u.hp)((null==t||null===(H=t.shipper)||void 0===H?void 0:H.queue_flush_timeout)||void 0),dt=(0,u.hp)((null==t||null===(W=t.shipper)||void 0===W?void 0:W.max_batch_bytes)||void 0),ct=Be("ssl"),gt=(0,u.U6y)("logstashHostsComboxBox",null!==(G=null==t?void 0:t.hosts)&&void 0!==G?G:[],Rn,Be("hosts")),pt=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(q=null==t||null===(V=t.ssl)||void 0===V?void 0:V.certificate_authorities)&&void 0!==q?q:[],void 0,ct),ft=(0,u.Gez)(null!==(K=null==t||null===(Y=t.ssl)||void 0===Y?void 0:Y.certificate)&&void 0!==K?K:"",Vn,ct),mt=(0,u.Gez)(null!==(Q=null==t||null===(X=t.ssl)||void 0===X?void 0:X.key)&&void 0!==Q?Q:"",Kn,ct),xt=(0,u.YZM)(null==t||null===(J=t.secrets)||void 0===J||null===(Z=J.ssl)||void 0===Z?void 0:Z.key,$n,ct),ht=(0,u.Gez)(null!==(ee=null==t?void 0:t.proxy_id)&&void 0!==ee?ee:"",(()=>{}),Be("proxy_id")),Et=t,yt=(0,u.Gez)(null!==(te=null==Et?void 0:Et.version)&&void 0!==te?te:"1.0.0",void 0,Be("version")),kt=(0,u.U6y)("kafkaHostsComboBox",null!==(ae=null==t?void 0:t.hosts)&&void 0!==ae?ae:[],Dn,Be("hosts")),vt=(0,u.RIP)(null!==(se=null==Et?void 0:Et.auth_type)&&void 0!==se?se:$.NB8.None,Be("auth_type")),jt=(0,u.RIP)(null!==(le=null==Et?void 0:Et.connection_type)&&void 0!==le?le:$.zPI.Plaintext,Be("connection_type")),bt=(0,u.Gez)(null==Et?void 0:Et.username,vt.value===$.NB8.Userpass?zn:void 0,Be("username")),St=(0,u.Gez)(null==Et?void 0:Et.password,vt.value===$.NB8.Userpass?Un:void 0,Be("password")),Mt=(0,u.YZM)(null==Et||null===(ne=Et.secrets)||void 0===ne?void 0:ne.password,vt.value===$.NB8.Userpass?Hn:void 0,Be("password")),Ft=(0,u.U6y)("kafkaSslCertificateAuthoritiesComboBox",null!==(ie=null==Et||null===(oe=Et.ssl)||void 0===oe?void 0:oe.certificate_authorities)&&void 0!==ie?ie:[],void 0,ct),It=(0,u.Gez)(null==Et||null===(re=Et.ssl)||void 0===re?void 0:re.certificate,vt.value===$.NB8.Ssl?Vn:void 0,ct),Tt=(0,u.Gez)(null==Et||null===(ue=Et.ssl)||void 0===ue?void 0:ue.key,vt.value===$.NB8.Ssl?Kn:void 0,ct),wt=(0,u.YZM)(null==Et||null===(de=Et.secrets)||void 0===de||null===(ce=de.ssl)||void 0===ce?void 0:ce.key,vt.value===$.NB8.Ssl?$n:void 0,ct),Ct=(0,u.Gez)(null!==(ge=null==Et||null===(pe=Et.ssl)||void 0===pe?void 0:pe.verification_mode)&&void 0!==ge?ge:$.i36.Full,void 0,ct),At=(0,u.RIP)(null!==(fe=null==Et||null===(me=Et.sasl)||void 0===me?void 0:me.mechanism)&&void 0!==fe?fe:$.N9h.Plain,Be("sasl")),Pt=(0,u.RIP)(null!==(xe=null==Et?void 0:Et.partition)&&void 0!==xe?xe:$.BwZ.Random,Be("partition")),_t=(0,u.Gez)(null!=Et&&null!==(he=Et.random)&&void 0!==he&&he.group_events?`${Et.random.group_events}`:"1",Pt.value===$.BwZ.Random?Jn:void 0,Be("partition")),Lt=(0,u.Gez)(null==Et||null===(Ee=Et.hash)||void 0===Ee?void 0:Ee.hash,void 0,Be("partition")),Dt=(0,u.Gez)(null!=Et&&null!==(ye=Et.round_robin)&&void 0!==ye&&ye.group_events?`${Et.round_robin.group_events}`:"1",Pt.value===$.BwZ.RoundRobin?Jn:void 0,Be("partition")),Ot=(0,u.RIP)(null!=Et&&Et.topics&&null!=Et&&null!==(ke=Et.topics[0].topic)&&void 0!==ke&&ke.includes("%{[")?$.LXo.Dynamic:$.LXo.Static,Be("topics")),Rt=(0,u.Gez)(null==(Bt=Et)||!Bt.topics||0===(null===(Nt=Bt.topics)||void 0===Nt?void 0:Nt.length)||Bt.topics&&(null==Bt?void 0:Bt.topics.length)>0&&null!==(zt=Bt.topics[0].topic)&&void 0!==zt&&zt.includes("%{[")?"":Bt.topics[Bt.topics.length-1].topic||"",Ot.value===$.LXo.Static?Yn:void 0,Be("topics"));var Bt,Nt,zt;const Ut=(0,u.whI)("kafkaDynamicTopicComboBox",function(e){var t,a,s;if(null==e||!e.topics||0===(null===(t=e.topics)||void 0===t?void 0:t.length)||e.topics&&(null===(a=e.topics[0])||void 0===a||null===(s=a.topic)||void 0===s||!s.includes("%{[")))return[];const l=e.topics[0].topic.match(/(%\{\[)(\S*)(\]\})/),n=null!=l&&l.length?l[2]:"";return[{label:n,value:n}]}(Et),Ot.value===$.LXo.Dynamic?Qn:void 0,Be("topics")),Ht=(0,u.kt3)("kafkaHeadersComboBox",null!==(ve=null==Et?void 0:Et.headers)&&void 0!==ve?ve:[{key:"",value:""}],Zn,Be("headers")),Wt=(0,u.Gez)(null!==(je=null==Et?void 0:Et.client_id)&&void 0!==je?je:"Elastic",Xn,Be("client_id")),Gt=(0,u.MbH)(!(null==Et||!Et.compression||Et.compression===$.jZS.None),Be("compression")),qt=(0,u.Gez)(`${null!==(be=null==Et?void 0:Et.compression_level)&&void 0!==be?be:4}`,void 0,Be("compression_level")),Vt=(0,u.Gez)(null!=Et&&Et.compression&&Et.compression!==$.jZS.None?Et.compression:$.jZS.Gzip,void 0,Be("compression")),Kt=(0,u.Gez)(`${null!==(Se=null==Et?void 0:Et.timeout)&&void 0!==Se?Se:30}`,void 0,Be("broker_timeout")),$t=(0,u.Gez)(`${null!==(Me=null==Et?void 0:Et.broker_timeout)&&void 0!==Me?Me:30}`,void 0,Be("timeout")),Yt=(0,u.Gez)(`${null!==(Fe=null==Et?void 0:Et.required_acks)&&void 0!==Fe?Fe:$.NAW.Commit}`,void 0,Be("required_acks")),Qt=(0,u.Gez)(null==Et?void 0:Et.key,void 0,Be("key")),Xt=ze.value===$.gf.Logstash,Jt=ze.value===$.gf.Kafka,Zt=ze.value===$.gf.RemoteElasticsearch,ea={nameInput:Ne,typeInput:ze,elasticsearchUrlInput:$e,diskQueueEnabledInput:et,diskQueuePathInput:tt,diskQueueEncryptionEnabled:st,diskQueueMaxSizeInput:at,diskQueueCompressionEnabled:nt,compressionLevelInput:ot,logstashHostsInput:gt,presetInput:Ye,additionalYamlConfigInput:Ue,defaultOutputInput:He,defaultMonitoringOutputInput:We,caTrustedFingerprintInput:Ge,serviceTokenInput:Qe,serviceTokenSecretInput:Xe,sslCertificateInput:ft,sslKeyInput:mt,sslKeySecretInput:xt,sslCertificateAuthoritiesInput:pt,proxyIdInput:ht,loadBalanceEnabledInput:lt,memQueueEvents:rt,queueFlushTimeout:ut,maxBatchBytes:dt,kafkaVersionInput:yt,kafkaHostsInput:kt,kafkaVerificationModeInput:Ct,kafkaAuthMethodInput:vt,kafkaConnectionTypeInput:jt,kafkaAuthUsernameInput:bt,kafkaAuthPasswordInput:St,kafkaAuthPasswordSecretInput:Mt,kafkaSaslMechanismInput:At,kafkaPartitionTypeInput:Pt,kafkaPartitionTypeRandomInput:_t,kafkaPartitionTypeHashInput:Lt,kafkaPartitionTypeRoundRobinInput:Dt,kafkaHeadersInput:Ht,kafkaClientIdInput:Wt,kafkaCompressionInput:Gt,kafkaCompressionLevelInput:qt,kafkaCompressionCodecInput:Vt,kafkaBrokerTimeoutInput:Kt,kafkaBrokerReachabilityTimeoutInput:$t,kafkaBrokerAckReliabilityInput:Yt,kafkaKeyInput:Qt,kafkaSslCertificateAuthoritiesInput:Ft,kafkaSslCertificateInput:It,kafkaSslKeyInput:Tt,kafkaSslKeySecretInput:wt,kafkaTopicsInput:Ot,kafkaStaticTopicInput:Rt,kafkaDynamicTopicInput:Ut},ta=Object.values(ea).some((e=>e.hasChanged)),aa=(0,s.useCallback)((()=>{const e=Ne.validate(),t=$e.validate(),a=kt.validate(),s=bt.validate(),l=St.validate(),n=Mt.validate(),i=Wt.validate(),o=It.validate(),r=Tt.validate(),u=wt.validate(),d=Ht.validate(),c=gt.validate(),g=Ue.validate(),p=Ge.validate(),f=Qe.validate(),m=Xe.validate(),x=ft.validate(),h=mt.validate(),E=xt.validate(),y=tt.validate(),k=_t.validate(),v=Dt.validate(),j=Rt.validate(),b=Ut.validate(),S=Tt.value?r:u,M=St.value?l:n;return Xt?c&&g&&e&&x&&(mt.value&&h||xt.value&&E):Jt?e&&a&&o&&S&&s&&M&&d&&g&&i&&k&&v&&j&&b:Zt?t&&g&&e&&(Qe.value&&f||Xe.value&&m):t&&g&&e&&p&&y}),[Ne,$e,kt,bt,St,Mt,Wt,It,Tt,wt,Ht,gt,Ue,Ge,Qe,Xe,ft,mt,xt,tt,_t,Dt,Rt,Ut,Xt,Jt,Zt]),sa=(0,s.useCallback)((async()=>{try{if(!aa())return;Pe(!0);let a={};Ze||(a={shipper:{mem_queue_events:rt.value?Number(rt.value):null,queue_flush_timeout:ut.value?Number(ut.value):null,max_batch_bytes:dt.value?Number(dt.value):null}}),!Ze&&we&&(a={...a,shipper:{disk_queue_enabled:et.value,disk_queue_path:et.value&&tt.value?tt.value:"",disk_queue_max_size:et.value&&at.value?at.value:null,disk_queue_encryption_enabled:et.value&&st.value,disk_queue_compression_enabled:nt.value,compression_level:nt.value?Number(ot.value):null,loadbalance:lt.value}});const s=""!==ht.value?ht.value:null,l=(()=>{const e=e=>{if(void 0!==e){const t=parseInt(e,10);if(!isNaN(t))return t}};switch(ze.value){case $.gf.Kafka:const t=Ft.value.filter((e=>""!==e)).length,l=function(e){const t={};return!e.kafkaSslKeyInput.value&&e.kafkaSslKeySecretInput.value&&(t.ssl={key:e.kafkaSslKeySecretInput.value}),!e.kafkaAuthPasswordInput.value&&e.kafkaAuthPasswordSecretInput.value&&(t.password=e.kafkaAuthPasswordSecretInput.value),Object.keys(t).length?t:null}({kafkaSslKeyInput:Tt,kafkaSslKeySecretInput:wt,kafkaAuthPasswordInput:St,kafkaAuthPasswordSecretInput:Mt});return{name:Ne.value,type:$.gf.Kafka,hosts:kt.value,is_default:He.value,is_default_monitoring:We.value,config_yaml:Ue.value,...jt.value!==$.zPI.Plaintext||vt.value!==$.NB8.None?{ssl:{...t?{certificate_authorities:Ft.value.filter((e=>""!==e))}:{},...vt.value===$.NB8.Ssl?{certificate:It.value,key:Tt.value}:{},verification_mode:Ct.value}}:{},proxy_id:s,client_id:Wt.value||void 0,version:yt.value,...Qt.value?{key:Qt.value}:{},compression:Gt.value?Vt.value:$.jZS.None,...Gt.value&&Vt.value===$.jZS.Gzip?{compression_level:e(qt.value)}:{},auth_type:vt.value,...vt.value===$.NB8.None?{connection_type:jt.value}:{},...vt.value===$.NB8.Userpass&&bt.value?{username:bt.value}:{},...vt.value===$.NB8.Userpass&&St.value?{password:St.value}:{},...vt.value===$.NB8.Userpass&&At.value?{sasl:{mechanism:At.value}}:{},partition:Pt.value,...Pt.value===$.BwZ.Random&&_t.value?{random:{group_events:e(_t.value)}}:{},...Pt.value===$.BwZ.RoundRobin&&Dt.value?{round_robin:{group_events:e(Dt.value)}}:{},...Pt.value===$.BwZ.Hash&&Lt.value?{hash:{hash:Lt.value}}:{},...Ot.value===$.LXo.Static&&Rt.value?{topics:[{topic:Rt.value}]}:Ot.value===$.LXo.Dynamic&&Ut.value?{topics:[{topic:`%{[${Ut.value}]}`}]}:{},headers:Ht.value,timeout:e(Kt.value),broker_timeout:e($t.value),required_acks:e(Yt.value),...a,...l?{secrets:l}:{}};case $.gf.Logstash:return{name:Ne.value,type:$.gf.Logstash,hosts:gt.value,is_default:He.value,is_default_monitoring:We.value,config_yaml:Ue.value,ssl:{certificate:ft.value,key:mt.value||void 0,certificate_authorities:pt.value.filter((e=>""!==e))},...!mt.value&&xt.value&&{secrets:{ssl:{key:xt.value}}},proxy_id:s,...a};case $.gf.RemoteElasticsearch:return{name:Ne.value,type:$.gf.RemoteElasticsearch,hosts:$e.value,is_default:He.value,is_default_monitoring:We.value,preset:Ye.value,config_yaml:Ue.value,service_token:Qe.value||void 0,...!Qe.value&&Xe.value&&{secrets:{service_token:Xe.value}},proxy_id:s,...a};case $.gf.Elasticsearch:default:return{name:Ne.value,type:$.gf.Elasticsearch,hosts:$e.value,is_default:He.value,is_default_monitoring:We.value,preset:Ye.value,config_yaml:Ue.value,ca_trusted_fingerprint:Ge.value,proxy_id:s,...a}}})();if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await Jl(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,O.jsx)(ei,null),(0,O.jsx)(ti,{agentCount:a,agentPolicyCount:s,output:e}))}(t,De))return void Pe(!1);const e=await(0,u.xEL)(t.id,l);if(e.error)throw e.error}else{const e=await(0,u.S6i)(l);if(e.error)throw e.error}e(),Pe(!1)}catch(e){Pe(!1),_e.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.outputForm.errorToastTitle",{defaultMessage:"Error while saving output"})})}}),[aa,Ze,we,ht.value,t,e,rt.value,ut.value,dt.value,et.value,tt.value,at.value,st.value,nt.value,ot.value,lt.value,ze.value,Ft.value,Tt,wt,St,Mt,Ne.value,kt.value,He.value,We.value,Ue.value,jt.value,vt.value,It.value,Ct.value,Wt.value,yt.value,Qt.value,Gt.value,Vt.value,qt.value,bt.value,At.value,Pt.value,_t.value,Dt.value,Lt.value,Ot.value,Rt.value,Ut.value,Ht.value,Kt.value,$t.value,Yt.value,gt.value,ft.value,mt.value,pt.value,xt.value,$e.value,Ye.value,Qe.value,Xe.value,Ge.value,De,_e.toasts]);return{inputs:ea,submit:sa,isLoading:Ae,hasEncryptedSavedObjectConfigured:Ce,isShipperEnabled:!Ze,isDisabled:Ae||t&&!ta||Xt&&!Ce}}(t,a,e),o=i.inputs,{docLinks:r,cloud:c}=(0,u.WeA)(),p=(0,u.YI3)(),x=!(null==c||!c.isServerlessEnabled),[h,E]=(0,s.useState)("disabled");void 0!==p.isSecretsStorageEnabled&&"disabled"===h&&E(p.isSecretsStorageEnabled);const y=e=>{"disabled"!==h&&E(e)},k=!0===h,v=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]),{kafkaOutput:j,remoteESOutput:b}=Cs.ZX.get(),S=o.typeInput.value===$.gf.RemoteElasticsearch,F=o.typeInput.value===$.gf.Elasticsearch,I=!!o.typeInput.value&&(0,hn.$N)(o.typeInput.value),T=!(null!=c&&c.isServerlessEnabled),w=[{value:$.gf.Elasticsearch,text:"Elasticsearch"},...b&&T?[{value:$.gf.RemoteElasticsearch,text:"Remote Elasticsearch"}]:[],{value:$.gf.Logstash,text:"Logstash"},...j?[{value:$.gf.Kafka,text:"Kafka"}]:[]];return(0,O.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW},(0,O.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(g.EuiTitle,{size:"m"},(0,O.jsx)("h2",{id:"FleetEditOutputFlyoutTitle"},a?(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.editTitle",defaultMessage:"Edit output"}):(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.createTitle",defaultMessage:"Add new output"})))),(0,O.jsx)(g.EuiFlyoutBody,null,(null==a?void 0:a.is_preconfigured)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiCallOut,{iconType:"lock",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",defaultMessage:"This output is managed outside of Fleet"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",defaultMessage:"Most actions related to this output are unavailable. Refer to your kibana config for more detail."})),(0,O.jsx)(g.EuiSpacer,{size:"m"})),(0,O.jsx)(g.EuiForm,null,(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.nameInputLabel",defaultMessage:"Name"})},o.nameInput.formRowProps),(0,O.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.nameInput",fullWidth:!0},o.nameInput.props,{placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.typeInputLabel",defaultMessage:"Type"}))},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.typeInput"},o.typeInput.props,{options:w})),F||S?(0,O.jsx)(l().Fragment,null,x?null:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(g.EuiCallOut,{"data-test-subj":`settingsOutputsFlyout.${o.typeInput.value}OutputTypeCallout`,title:(()=>{switch(o.typeInput.value){default:case $.gf.Elasticsearch:return m.i18n.translate("xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout",{defaultMessage:"This output type does not support connectivity to a remote Elasticsearch cluster, please use the Remote Elasticsearch type for that."});case $.gf.RemoteElasticsearch:return m.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESOutputTypeCallout",{defaultMessage:"Remote Elasticsearch output does not support connectivity to a serverless project."})}})(),iconType:"alert",color:"warning",size:"s",heading:"p"})),S?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiText,{size:"s"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteESTypeText",defaultMessage:"Enter your output hosts, service token for your remote cluster, and any advanced YAML configuration. Learn more about how to use these parameters in {doc}.",values:{doc:(0,O.jsx)(g.EuiLink,{href:r.links.fleet.remoteESOoutput,target:"_blank"},m.i18n.translate("xpack.fleet.settings.editOutputFlyout.docLabel",{defaultMessage:"our documentation"}))}}))):null):null)),(e=>{switch(e){case $.gf.Logstash:return(0,O.jsx)(ui,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y,hasEncryptedSavedObjectConfigured:i.hasEncryptedSavedObjectConfigured});case $.gf.Kafka:return j?(0,O.jsx)(Tn,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y}):null;case $.gf.RemoteElasticsearch:return b?(0,O.jsx)(si,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y}):null;case $.gf.Elasticsearch:default:return(0,O.jsx)(di,{inputs:o})}})(o.typeInput.value),S?null:(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},o.proxyIdInput.props,{onChange:e=>{var t,a;return o.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==o.proxyIdInput.value?v.filter((e=>e.value===o.proxyIdInput.value)):[],options:v,singleSelection:{asPlainText:!0},isDisabled:o.proxyIdInput.props.disabled,isClearable:!0,placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,O.jsx)(g.EuiSpacer,{size:"xs"}),(0,O.jsx)(Kl,null))),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultOutputInput.formRowProps),(0,O.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultOutputInput.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentIntegrations}.",values:{boldAgentIntegrations:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",defaultMessage:"agent integrations"}))}})}))),(0,O.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultMonitoringOutputInput.formRowProps),(0,O.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultMonitoringOutputInput.props,{label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentMonitoring}.",values:{boldAgentMonitoring:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",defaultMessage:"agent monitoring"}))}})}))),I&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"l"}),(0,O.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningLabel",defaultMessage:"Performance tuning"}),helpText:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpText",defaultMessage:"Performance tuning presets are curated output settings for common use cases. You can also select {custom} to specify your own settings in the Advanced YAML Configuration box below. For a detailed list of settings configured by each preset, see {link}.",values:{custom:(0,O.jsx)("strong",null,"Custom"),link:(0,O.jsx)(g.EuiLink,{href:r.links.fleet.performancePresets,external:!0,target:"_blank"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpTextLink",defaultMessage:"our documentation"}))}})},(0,O.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.presetInput"},o.presetInput.props,{onChange:e=>o.presetInput.setValue(e.target.value),disabled:o.presetInput.props.disabled||(0,hn.o8)(o.additionalYamlConfigInput.value,ws.Hh),options:[{value:"balanced",text:"Balanced"},{value:"custom",text:"Custom"},{value:"throughput",text:"Throughput"},{value:"scale",text:"Scale"},{value:"latency",text:"Latency"}]})))),I&&(0,hn.o8)(o.additionalYamlConfigInput.value,ws.Hh)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiCallOut,{color:"warning",iconType:"alert",size:"s",title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarning",defaultMessage:'Performance tuning preset must be "Custom" due to presence of reserved key in advanced YAML configuration'})},(0,O.jsx)(g.EuiAccordion,{id:"performanceTuningMustBeCustomWarningDetails",buttonContent:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarningDetails",defaultMessage:"Show reserved keys"})},(0,O.jsx)("ul",null,$.uhU.map((e=>(0,O.jsx)("li",{key:e},(0,O.jsx)(g.EuiCode,null,e)))))))),(0,O.jsx)(g.EuiSpacer,{size:"l"}),(0,O.jsx)(g.EuiFormRow,(0,d.default)({label:(0,O.jsx)(g.EuiLink,{href:r.links.fleet.esSettings,external:!0,target:"_blank"},m.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel",{defaultMessage:"Advanced YAML configuration"}))},o.additionalYamlConfigInput.formRowProps,{fullWidth:!0}),(0,O.jsx)(_n,{value:o.additionalYamlConfigInput.value,onChange:e=>{(0,hn.o8)(e,ws.Hh)&&o.presetInput.setValue("custom"),o.additionalYamlConfigInput.setValue(e)},disabled:o.additionalYamlConfigInput.props.disabled,placeholder:m.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder",{defaultMessage:"# YAML settings here will be added to the output section of each agent policy."})})),(0,O.jsx)(ai,{enabled:i.isShipperEnabled,inputs:o})),null!=a&&a.id&&"remote_elasticsearch"===a.type?(0,O.jsx)(Fl,{output:a}):null),(0,O.jsx)(g.EuiFlyoutFooter,null,(0,O.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{fill:!0,isLoading:i.isLoading,isDisabled:i.isDisabled,onClick:i.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},gi=(0,Wl.$H)((()=>{var e,t,a,l,n,i,d,c,p;(0,u.ifo)("settings");const f=(0,o.useHistory)(),x=(0,u.Wdf)(),{outputs:h,fleetServerHosts:E,downloadSources:y,proxies:k}={outputs:(0,u.Eiq)(),fleetServerHosts:(0,u.OVZ)(),downloadSources:(0,u.SFz)(),proxies:(0,u.qyb)()},v=null===(e=h.data)||void 0===e?void 0:e.items.filter((e=>!e.is_internal)),j=null===(t=E.data)||void 0===t?void 0:t.items.filter((e=>!e.is_internal)),{deleteOutput:b}=function(e){const{confirm:t}=(0,Wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteOutput:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await Jl(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,O.jsx)(Zl,null),(0,O.jsx)(en,{output:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:m.i18n.translate("xpack.fleet.settings.deleteOutputs.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.pE1)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.deleteOutputs.errorToastTitle",{defaultMessage:"Error deleting output"})})}}),[t,a.toasts,e])}}(h.resendRequest),{deleteDownloadSource:I}=function(e){const{confirm:t}=(0,Wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteDownloadSource:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await sn(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,O.jsx)(un,null),(0,O.jsx)(dn,{"data-test-subj":"editDownloadSourcesDeleteModal.confirmModalText",downloadSource:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:m.i18n.translate("xpack.fleet.settings.deleteDownloadSource.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.taj)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.deleteDownloadSource.errorToastTitle",{defaultMessage:"Error deleting agent binary source."})})}}),[t,a.toasts,e])}}(y.resendRequest),{deleteFleetServerHost:T}=function(e){const{confirm:t}=(0,Wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetServerHost:(0,s.useCallback)((async s=>{try{if(!await t((0,O.jsx)(tn,null),(0,O.jsx)(an,null),{buttonColor:"danger",confirmButtonText:m.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.D7A)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.errorToastTitle",{defaultMessage:"Error deleting Fleet Server hosts"})})}}),[t,a.toasts,e])}}(E.resendRequest),{deleteFleetProxy:w}=function(e){const{confirm:t}=(0,Wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetProxy:(0,s.useCallback)((async s=>{try{if(!await t((0,O.jsx)(Ql,null),(0,O.jsx)(Xl,null),{buttonColor:"danger",confirmButtonText:m.i18n.translate("xpack.fleet.settings.deleteFleetProxy.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.mwZ)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:m.i18n.translate("xpack.fleet.settings.deleteFleetProxy.errorToastTitle",{defaultMessage:"Error deleting proxy"})})}}),[t,a.toasts,e])}}(k.resendRequest),C=h.resendRequest,A=y.resendRequest,P=E.resendRequest,_=k.resendRequest,L=(0,s.useCallback)((()=>{x.closeFleetServerFlyout(),C(),A(),P(),_(),f.replace(M.tn.settings()[1])}),[x,C,A,P,_,f]),{cloud:D}=(0,u.WeA)();return h.isLoading&&h.isInitialRequest||!v||E.isLoading&&E.isInitialRequest||!j||y.isLoading&&y.isInitialRequest||null===(a=y.data)||void 0===a||!a.items||k.isLoading&&k.isInitialRequest||null===(l=k.data)||void 0===l||!l.items?(0,O.jsx)(F.iW,{section:"settings"},(0,O.jsx)(S.Rh,null)):(0,O.jsx)(F.iW,{section:"settings"},(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.settings_edit_fleet_server_hosts},(e=>{var t,a;const s=j.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return s?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(Yl,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,fleetServerHost:s})):(0,O.jsx)(o.Redirect,{to:M.X5.settings})})),(0,O.jsx)(r.Route,{path:M.X5.settings_create_fleet_server_hosts},(0,O.jsx)(g.EuiPortal,null,null!=D&&D.isServerlessEnabled?(0,O.jsx)(Yl,{proxies:null!==(n=null===(i=k.data)||void 0===i?void 0:i.items)&&void 0!==n?n:[],onClose:L,defaultFleetServerHost:null===(d=E.data)||void 0===d?void 0:d.items.find((e=>e.id===$.Z24))}):(0,O.jsx)(S.Jh,{onClose:L}))),(0,O.jsx)(r.Route,{path:M.X5.settings_create_outputs},(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(ci,{proxies:k.data.items,onClose:L,defaultOuput:null===(c=h.data)||void 0===c?void 0:c.items.find((e=>e.id===$.VE))}))),(0,O.jsx)(r.Route,{path:M.X5.settings_create_fleet_proxy},(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xn,{onClose:L}))),(0,O.jsx)(r.Route,{path:M.X5.settings_edit_fleet_proxy},(e=>{var t;const a=null===(t=k.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return a?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(xn,{onClose:L,fleetProxy:a})):(0,O.jsx)(o.Redirect,{to:M.X5.settings})})),(0,O.jsx)(r.Route,{path:M.X5.settings_edit_outputs},(e=>{var t,a,s;const l=v.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.outputId)===t.id}));return l?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(ci,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,output:l,defaultOuput:null===(s=h.data)||void 0===s?void 0:s.items.find((e=>e.id===$.VE))})):(0,O.jsx)(o.Redirect,{to:M.X5.settings})})),(0,O.jsx)(r.Route,{path:M.X5.settings_create_download_sources},(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(rn,{onClose:L,proxies:(null==k||null===(p=k.data)||void 0===p?void 0:p.items)||[]}))),(0,O.jsx)(r.Route,{path:M.X5.settings_edit_download_sources},(e=>{var t,a;const s=null===(t=y.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.downloadSourceId)===t.id}));return s?(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(rn,{onClose:L,downloadSource:s,proxies:(null==k||null===(a=k.data)||void 0===a?void 0:a.items)||[]})):(0,O.jsx)(o.Redirect,{to:M.X5.settings})}))),(0,O.jsx)(Hl,{deleteFleetProxy:w,proxies:k.data.items,outputs:v,fleetServerHosts:j,deleteOutput:b,deleteFleetServerHost:T,downloadSources:y.data.items,deleteDownloadSource:I}))})),pi=({value:e})=>(0,O.jsx)(wn.CodeEditor,{isCopyable:!0,languageId:"",height:"600px",width:"100%",options:{minimap:{enabled:!1},scrollBeyondLastLine:!1,readOnly:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,lineDecorationsWidth:0,overviewRulerBorder:!1},value:e}),fi=async()=>{const e=await(0,u.cnO)({full:!0,perPage:M.W,sortOrder:"asc"});if(e.error)throw new Error(e.error.message);return e};var mi=a(10885);const xi=async()=>{var e;const t=await(0,u.OQl)({prerelease:!0});if(t.error)throw new Error(t.error.message);return null===(e=t.data)||void 0===e?void 0:e.items.filter((({status:e})=>"installed"===e))},hi=({name:e,setName:t,type:a,setNamesStatus:l})=>{const{data:n,status:i}=(0,x.useQuery)(["debug-saved-object-names",a],(()=>(async e=>{var t;const a=await(0,u.w$b)({method:"post",path:I.xw.getSavedObjectNamesPath(),body:{type:e},version:$.BoD.internal.v1});if(a.error)throw new Error(a.error.message);return null===(t=a.data)||void 0===t?void 0:t.aggregations.names.buckets})(a)),{refetchOnWindowFocus:!1});(0,s.useEffect)((()=>{l(i)}),[i,l]);const o=(null!=n?n:[]).map((e=>({label:e.key,value:e.key}))),r=o.find((t=>t.value===e)),d=r?[r]:[];return(0,O.jsx)(g.EuiComboBox,{prepend:"Name","aria-label":m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),placeholder:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),fullWidth:!0,options:o,singleSelection:{asPlainText:!0},selectedOptions:d,isLoading:"loading"===i,onChange:e=>{e.length?t(e[0].value):t(void 0)}})},Ei=async()=>{var e,t;const a=`${M.mm}.is_preconfigured:true`,s=await(0,u.cnO)({kuery:a,perPage:M.W,full:!0});if(s.error)throw new Error(s.error.message);return null!==(e=null===(t=s.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},yi=async()=>{var e,t;const a=await(0,u.W1E)();if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},ki=new x.QueryClient,vi=[{title:m.i18n.translate("xpack.fleet.debug.HealthCheckStatus.title",{defaultMessage:"Health Check Status"}),id:"healthCheckStatus",component:(0,O.jsx)((()=>{var e;const[t,a]=(0,s.useState)(),{data:n}=(0,u.OVZ)(),i=(0,s.useMemo)((()=>{var e;return null!==(e=null==n?void 0:n.items)&&void 0!==e?e:[]}),[null==n?void 0:n.items]);(0,s.useEffect)((()=>{const e=i.find((e=>!0===e.is_default));e&&a(e)}),[i]);const o=(0,s.useMemo)((()=>(null==t?void 0:t.id)||""),[null==t?void 0:t.id]),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(),{data:m}=(0,x.useQuery)(["fleetServerHealth",o],(()=>(0,u.RUT)({id:o})),{refetchInterval:1e4,enabled:!!o});(0,s.useEffect)((()=>{d(null==m?void 0:m.data),null!=m&&m.error&&p(m.error)}),[m]);const h=(0,s.useMemo)((()=>[...i.map((e=>({inputDisplay:`${e.name} (${e.host_urls[0]})`,value:e.id})))]),[i]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.description",defaultMessage:"Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",values:{interval:10}}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(g.EuiSuperSelect,{fullWidth:!0,"data-test-subj":"fleetDebug.fleetServerHostsSelect",prepend:(0,O.jsx)(g.EuiText,{size:"relative",color:""},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",defaultMessage:"Fleet Server Hosts"})),onChange:e=>{d(void 0),a(i.find((t=>t.id===e)))},valueOfSelected:null==t?void 0:t.id,options:h})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},null!=r&&r.status&&o===(null==r?void 0:r.host_id)?(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.status",defaultMessage:"Status:"})),(0,O.jsx)(g.EuiFlexItem,null,(e=>{if(!e)return null;let t;switch(e){case"HEALTHY":t="success";break;case"UNHEALTHY":t="warning";break;default:t="subdued"}return(0,O.jsx)(g.EuiHealth,{color:t},e)})(null==r?void 0:r.status))):null)),c&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==c?void 0:c.message)&&void 0!==e?e:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fetchError",defaultMessage:"Message: {errorMessage}",values:{errorMessage:null==c?void 0:c.message}}))))}),null)},{title:m.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.title",{defaultMessage:"Agent Policy Debugger"}),id:"agentPolicyDebugger",component:(0,O.jsx)((()=>{var e,t;const{getHref:a}=(0,u.iEg)(),[n,i]=(0,s.useState)(),{data:o,status:r}=(0,x.useQuery)(["debug-agent-policies"],fi),d=null!==(e=null==o||null===(t=o.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[],c=d.map((e=>({label:`${e.name} - ${e.id}`,value:e.id}))),p=n?[c.find((e=>e.value===n))]:[],h=d.find((e=>e.id===n)),E=()=>{i(void 0),ki.invalidateQueries(["debug-agent-policies"])};return"error"===r?(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.fetchError",defaultMessage:"Error fetching Agent Policies"})):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.description",defaultMessage:"Search for an Agent Policy using its name or {codeId} value. Use the code block below to diagnose any potential issues with the policy's configuration.",values:{codeId:(0,O.jsx)(g.EuiCode,null,"id")}}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(g.EuiComboBox,{"aria-label":m.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),placeholder:m.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),fullWidth:!0,options:c,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===r,onChange:e=>{e.length?i(e[0].value):i(void 0)}})),n&&(0,O.jsx)(w.wq,{agentPolicy:h,hasFleetServer:(0,z.ob)(h)},(e=>(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(g.EuiButton,{color:"danger",onClick:()=>e(n,E)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.policyForm.deletePolicyActionText",defaultMessage:"Delete policy"}))))))),n&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiLink,{target:"_blank",href:a("policy_details",{policyId:n})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(pi,{value:JSON.stringify(h,null,2)})))}),null)},{title:m.i18n.translate("xpack.fleet.debug.integrationDebugger.title",{defaultMessage:"Integration Debugger"}),id:"integrationDebugger",component:(0,O.jsx)((()=>{var e,t,a,n,i;const{http:o,notifications:r}=(0,u.WeA)(),{getHref:d}=(0,u.iEg)(),[c,p]=(0,s.useState)(),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),v=(0,x.useQuery)(["debug-integrations"],xi),j=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)(e.name,e.version,!0);if(t.error)throw r.toasts.addError(t.error,{title:m.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.error",{defaultMessage:"Error uninstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),k(!1),new Error(t.error.message);return r.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.success",{defaultMessage:"Successfully uninstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),k(!1),ki.invalidateQueries(["debug-integrations"]),t.data})),b=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)(e.name,e.version,!0);if(t.error)throw r.toasts.addError(t.error,{title:m.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),E(!1),new Error(t.error.message);const a=await(0,u.Q8y)(e.name,e.version);if(a.error)throw r.toasts.addError(new Error(a.error.message),{title:m.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:a.error.message}),E(!1),new Error(a.error.message);return r.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.success",{defaultMessage:"Successfully reinstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),E(!1),ki.invalidateQueries(["debug-integrations"]),a.data}));if("error"===v.status)return(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.fetchError",defaultMessage:"Error fetching installed Integrations"}));const S=null!==(e=null===(t=v.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id,icon:(0,mi.d)(e,o.basePath)}))))&&void 0!==e?e:[],M=c?[S.find((e=>e.value===c))]:[],F=null===(a=v.data)||void 0===a?void 0:a.find((e=>e.id===c));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.description",defaultMessage:"Use this tool to uninstall or reinstall installed integrations."})),(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallationDescription",defaultMessage:"Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization."}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(g.EuiComboBox,{"aria-label":m.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),placeholder:m.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),fullWidth:!0,options:S,singleSelection:{asPlainText:!0},selectedOptions:M,isDisabled:"loading"===v.status,prepend:M.length>0?(0,O.jsx)(g.EuiButtonEmpty,null,(0,O.jsx)(g.EuiIcon,{type:null!==(n=null===(i=M[0])||void 0===i?void 0:i.icon)&&void 0!==n?n:"fleetApp"})):void 0,renderOption:(e,t,a)=>(0,O.jsx)("span",{className:a},(0,O.jsx)(g.EuiIcon,{type:e.icon})," ",(0,O.jsx)(g.EuiHighlight,{search:t},e.label)),onChange:e=>{e.length?p(e[0].value):p(void 0)}})),F&&(0,O.jsx)(g.EuiFlexGroup,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{color:"primary",onClick:()=>E(!0)},"Reinstall")),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)(g.EuiButton,{color:"danger",onClick:()=>k(!0)},"Uninstall")),h&&(0,O.jsx)(g.EuiConfirmModal,{title:`Reinstall ${F.title}`,onCancel:()=>E(!1),onConfirm:()=>b.mutate(F),isLoading:b.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelReinstall",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmReinstall",{defaultMessage:"Reinstall"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallModal",defaultMessage:"Are you sure you want to reinstall {integrationTitle}?",values:{integrationTitle:F.title}})),y&&(0,O.jsx)(g.EuiConfirmModal,{title:`Uninstall ${F.title}`,onCancel:()=>k(!1),onConfirm:()=>j.mutate(F),isLoading:j.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelUninstall",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmUninstall",{defaultMessage:"Uninstall"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.uninstallModal",defaultMessage:"Are you sure you want to uninstall {integrationTitle}?",values:{integrationTitle:F.title}})))),F&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiLink,{target:"_blank",href:d("integration_details_overview",{pkgkey:(0,z.Ku)({name:F.name,version:F.version})})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.viewIntegrationLink",defaultMessage:"View integration settings in Integrations UI"}))))}),null)},{title:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.title",{defaultMessage:"Saved Object Debugger"}),id:"savedObjectDebugger",component:(0,O.jsx)((()=>{const e=[{value:`${$.mm9}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.agentPolicyLabel",{defaultMessage:"Agent policy"})},{value:`${$.RNf}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packagePolicyLabel",{defaultMessage:"Integration policy"})},{value:`${$.Lmx}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.outputLabel",{defaultMessage:"Output"})},{value:`${$.fAG}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packageLabel",{defaultMessage:"Packages"})},{value:`${$.y_r}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.downloadSourceLabel",{defaultMessage:"Download Sources"})},{value:`${$.twQ}`,text:m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.fleetServerHostLabel",{defaultMessage:"Fleet Server Hosts"})}],[t,a]=(0,s.useState)(e[0].value),[n,i]=(0,s.useState)(),[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-saved-objects",t,n],(()=>(async(e,t)=>{var a;if(!e||!t)return[];const s=await(0,u.w$b)({method:"post",path:I.xw.getSavedObjectsPath(),body:{type:e,name:t},version:$.BoD.internal.v1});if(s.error)throw new Error(s.error.message);return null===(a=s.data)||void 0===a?void 0:a.saved_objects})(t,n)));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.description",defaultMessage:"Search for Fleet-related saved objects by selecting a type and name. Use the code block below to diagnose any potential issues."}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 300px;\n          "},(0,O.jsx)(g.EuiFormRow,null,(0,O.jsx)(g.EuiSelect,{prepend:"Type",id:"soType",options:e,value:t,onChange:e=>(e=>{a(e.target.value),i(void 0)})(e),"aria-label":m.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectTypeLabel",{defaultMessage:"Select saved object type"})}))),(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(g.EuiFormRow,null,(0,O.jsx)(hi,{name:n,setName:i,type:t,setNamesStatus:r})))),d&&("error"===c||"error"===o)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.fetchError",defaultMessage:"Error fetching Saved Objects"}))),(d||"loading"===c)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(pi,{value:JSON.stringify(d,null,2)})))}),null)},{title:m.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.title",{defaultMessage:"Fleet Index Debugger"}),id:"fleetIndexDebugger",component:(0,O.jsx)((()=>{var e,t,a,n;const i=[{label:B.AGENTS_INDEX,value:B.AGENTS_INDEX},{label:B.AGENT_ACTIONS_INDEX,value:B.AGENT_ACTIONS_INDEX},{label:M.Al,value:M.Al}],[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-indices",o],(()=>(async e=>e?await(0,u.w$b)({method:"post",path:I.xw.getIndexPath(),body:{index:e},version:B.API_VERSIONS.internal.v1}):null)(o)),{retry:!1}),p=o?[i.find((e=>e.value===o))]:[];return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.description",defaultMessage:"Search for the contents of Fleet indices. Use the code block below to diagnose any potential issues. "}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,null,(0,O.jsx)(g.EuiFlexItem,null,(0,O.jsx)(g.EuiFormRow,null,(0,O.jsx)(g.EuiComboBox,{prepend:"Index","aria-label":m.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),placeholder:m.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),fullWidth:!0,options:i,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===c,onChange:e=>{e.length?r(e[0].value):r(void 0)}})))),(null==d?void 0:d.error)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==d||null===(t=d.error)||void 0===t||null===(a=t.error)||void 0===a?void 0:a.reason)&&void 0!==e?e:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.fetchError",defaultMessage:"Error fetching index data"}))),d&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(pi,{value:JSON.stringify(null===(n=d.data)||void 0===n?void 0:n.hits,null,2)})))}),null)},{title:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.title",{defaultMessage:"Preconfiguration Debugger"}),id:"preconfigurationDebugger",component:(0,O.jsx)((()=>{var e,t,a,n;const{getHref:i}=(0,u.iEg)(),{notifications:o}=(0,u.WeA)(),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),y=(0,x.useQuery)(["debug-preconfigured-policies"],Ei),k=null!==(e=null===(t=y.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],v=r?[k.find((({value:e})=>e===r))]:[],j=null===(a=y.data)||void 0===a?void 0:a.find((e=>e.id===r)),b=(0,x.useMutation)((async e=>{const t=await(0,u.W$e)(e);if(t.error)throw o.toasts.addError(t.error,{title:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetError",{defaultMessage:"Error resetting policy"}),toastMessage:t.error.message}),new Error(t.error.message);return o.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetSuccess",{defaultMessage:"Successfully reset policy"})),ki.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),p(!1),t.data})),S=(0,x.useMutation)((async()=>{const e=await(0,u.Vg9)();if(e.error)throw o.toasts.addError(e.error,{title:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllError",{defaultMessage:"Error resetting policies"}),toastMessage:e.error.message}),new Error(e.error.message);return o.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess",{defaultMessage:"Successfully reset policies"})),ki.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),E(!1),e.data}));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.description",defaultMessage:"This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",values:{codeKibanaYml:(0,O.jsx)(g.EuiCode,null,"kibana.yml")}})),(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetInstructions",defaultMessage:'You may reset a single preconfigured policy or use the "Reset all" button to reset all preconfigured policies at once.'}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(g.EuiComboBox,{"aria-label":m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),placeholder:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),fullWidth:!0,options:k,singleSelection:{asPlainText:!0},selectedOptions:v,onChange:e=>{e.length?d(e[0].value):d(void 0)}})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(g.EuiButton,{color:"warning",isDisabled:!r,onClick:()=>p(!0)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetButton",defaultMessage:"Reset"})))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!==(n=y.data)&&void 0!==n&&n.length),onClick:()=>E(!0)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllButton",defaultMessage:"Reset all"}))))),c&&j&&r&&(0,O.jsx)(g.EuiConfirmModal,{title:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalTitle",{defaultMessage:"Reset {policyName}",values:{policyName:j.name}}),onCancel:()=>p(!1),onConfirm:()=>b.mutate(r),isLoading:b.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm",{defaultMessage:"Reset"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetModalBody",defaultMessage:"Are you sure you want to reset {policyName}?",values:{policyName:j.name}})),h&&(0,O.jsx)(g.EuiConfirmModal,{title:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle",{defaultMessage:"Reset all preconfigured policies"}),onCancel:()=>E(!1),onConfirm:()=>S.mutate(),isLoading:S.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm",{defaultMessage:"Reset all"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",defaultMessage:"Are you sure you want to reset all preconfigured policies?"})),r&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiLink,{target:"_blank",href:i("policy_details",{policyId:r})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(pi,{value:JSON.stringify(j,null,2)})))}),null)},{title:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title",{defaultMessage:"Orphaned Integration Policy Debugger"}),id:"orphanedIntegrationPolicyDebugger",component:(0,O.jsx)((()=>{var e;const{notifications:t}=(0,u.WeA)(),[a,n]=(0,s.useState)(),[i,o]=(0,s.useState)(!1),[r,d]=(0,s.useState)(!1),{data:c}=(0,x.useQuery)(["debug-orphaned-policies"],yi),p=null!==(e=null==c?void 0:c.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],h=a?[p.find((({value:e})=>e===a))]:[],E=null==c?void 0:c.find((e=>e.id===a)),y=(0,x.useMutation)((async e=>{const a=await(0,u.Ot1)({packagePolicyIds:[e],force:!0});if(a.error)throw t.toasts.addError(a.error,{title:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteError",{defaultMessage:"Error deleting policy"}),toastMessage:a.error.message}),new Error(a.error.message);return t.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteSuccess",{defaultMessage:"Successfully deleted orphaned policy"})),ki.invalidateQueries(["debug-orphaned-policies"]),n(void 0),o(!1),a.data})),k=(0,x.useMutation)((async()=>{const e=await(0,u.Ot1)({packagePolicyIds:null==c?void 0:c.map((e=>e.id)),force:!0});if(e.error)throw t.toasts.addError(e.error,{title:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllError",{defaultMessage:"Error deleting orphaned policies"}),toastMessage:e.error.message}),new Error(e.error.message);return t.toasts.addSuccess(m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllSuccess",{defaultMessage:"Successfully deleted all orphaned policies"})),ki.invalidateQueries(["debug-orphaned-policies"]),n(void 0),d(!1),e.data}));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.description",defaultMessage:'This tool can be used to delete "orphaned" integration policies that have been unlinked from their parent agent policy objects'})),(0,O.jsx)("p",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteOptions",defaultMessage:'You may delete a single orphaned integration policy or use the "Delete all" button to delete all orphaned integration policies at once.'}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiFlexGroup,null,(0,O.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(g.EuiComboBox,{"aria-label":m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),placeholder:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),fullWidth:!0,options:p,singleSelection:{asPlainText:!0},selectedOptions:h,onChange:e=>{e.length?n(e[0].value):n(void 0)}})),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(g.EuiButton,{color:"warning",isDisabled:!a,onClick:()=>o(!0)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteButton",defaultMessage:"Delete"})))),(0,O.jsx)(g.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!=c&&c.length),onClick:()=>d(!0)},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllButton",defaultMessage:"Delete all"}))))),i&&E&&a&&(0,O.jsx)(g.EuiConfirmModal,{title:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalTitle",{defaultMessage:"Delete {policyName}",values:{policyName:E.name}}),onCancel:()=>o(!1),onConfirm:()=>y.mutate(a),isLoading:y.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDelete",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDelete",{defaultMessage:"Delete"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalBody",defaultMessage:"Are you sure you want to delete {policyName}?",values:{policyName:E.name}})),r&&(0,O.jsx)(g.EuiConfirmModal,{title:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalTitle",{defaultMessage:"Delete all orphaned integration policies"}),onCancel:()=>d(!1),onConfirm:()=>k.mutate(),isLoading:k.isLoading,cancelButtonText:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDeleteAll",{defaultMessage:"Cancel"}),confirmButtonText:m.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDeleteAll",{defaultMessage:"Delete all"})},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalBody",defaultMessage:"Are you sure you want to delete all orphaned integration policies?"})),a&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(pi,{value:JSON.stringify(E,null,2)})))}),null)}],ji=({isInitialized:e,setupError:t})=>{const{chrome:a}=(0,u.WeA)(),{getHref:s}=(0,u.iEg)();return a.docTitle.change(["Debug","Fleet"]),(0,O.jsx)(x.QueryClientProvider,{client:ki},(0,O.jsx)(g.EuiPage,{paddingSize:"xl"},(0,O.jsx)(g.EuiPageBody,{panelled:!0},(0,O.jsx)(g.EuiPageSection,null,(0,O.jsx)(g.EuiPageHeader,{pageTitle:m.i18n.translate("xpack.fleet.debug.pageTitle",{defaultMessage:"Fleet Debugging Dashboard"}),iconType:"wrench"}),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Danger zone"},(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.description",defaultMessage:"This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",values:{strongDestructive:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.destructive",defaultMessage:"destructive"})),strongLossOfData:(0,O.jsx)("strong",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.lossOfData",defaultMessage:"loss of data"}))}}))),!e&&(null==t?void 0:t.message)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(g.EuiSpacer,{size:"s"}),(0,O.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Setup error"},(0,O.jsx)(g.EuiText,{grow:!1},(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.initializationError.description",defaultMessage:"{message}. You can use this page to debug the error.",values:{message:null==t?void 0:t.message}}))))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiPageSection,null,vi.map((({title:e,id:t,component:a})=>(0,O.jsx)("div",{key:t},(0,O.jsx)(g.EuiAccordion,{id:t,initialIsOpen:!0,buttonContent:(0,O.jsx)(g.EuiTitle,{size:"l"},(0,O.jsx)("h2",null,e))},(0,O.jsx)(g.EuiSpacer,{size:"m"}),a),(0,O.jsx)(g.EuiHorizontalRule,null)))),(0,O.jsx)(g.EuiTitle,{size:"l"},(0,O.jsx)("h2",null,(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.debug.usefulLinks.title",defaultMessage:"Useful links"}))),(0,O.jsx)(g.EuiSpacer,{size:"m"}),(0,O.jsx)(g.EuiListGroup,{listItems:[{label:m.i18n.translate("xpack.fleet.debug.usefulLinks.viewAgents",{defaultMessage:"View Agents in Fleet UI"}),href:s("agent_list"),iconType:"agentApp",target:"_blank"},{label:m.i18n.translate("xpack.fleet.debug.usefulLinks.troubleshootingGuide",{defaultMessage:"Troubleshooting Guide"}),href:"https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html",iconType:"popout",target:"_blank"}]})))),(0,O.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}))},bi=new x.QueryClient({defaultOptions:{queries:{networkMode:"always"},mutations:{networkMode:"always"}}}),Si=(0,s.memo)((({children:e})=>{(0,u.ifo)("base");const t=(0,u.WeA)(),{notifications:a}=t,n=(0,u.iO7)(),i=n.fleet.readEnrollmentTokens||n.fleet.readAgents||n.fleet.readAgentPolicies||n.fleet.readSettings,[r,d]=(0,s.useState)(!1),[c,g]=(0,s.useState)(),[p,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(null),y=!!(0,o.useRouteMatch)(M.X5.add_integration_to_policy),k=!!(0,o.useRouteMatch)(M.X5.debug);return(0,s.useEffect)((()=>{(async()=>{d(!1),g(void 0),x(!1),E(null);try{var e;d(!0);const n=await(0,u.nXS)();if(d(!1),null!==(e=n.data)&&void 0!==e&&e.success){try{var t,s;const e=await(0,u.i0)();e.error&&E(e.error),null!==(t=e.data)&&void 0!==t&&null!==(s=t.nonFatalErrors)&&void 0!==s&&s.length&&a.toasts.addError(e.data.nonFatalErrors[0],{title:m.i18n.translate("xpack.fleet.setup.uiPreconfigurationErrorTitle",{defaultMessage:"Configuration error"})}),i||g("MISSING_PRIVILEGES")}catch(e){E(e)}x(!0)}else{var l;g((null===(l=n.data)||void 0===l?void 0:l.error)||"REQUEST_ERROR")}}catch(e){g("REQUEST_ERROR")}})()}),[a.toasts,i]),r||c?(0,O.jsx)(F.x$,{isAddIntegrationsPath:y},r?(0,O.jsx)(S.Rh,null):(0,O.jsx)(F.LA,{error:c})):k?(0,O.jsx)(ji,{setupError:h,isInitialized:p}):!p||h?(0,O.jsx)(F.x$,{isAddIntegrationsPath:y},h?(0,O.jsx)(S.$D,{title:(0,O.jsx)(f.FormattedMessage,{id:"xpack.fleet.initializationErrorMessageTitle",defaultMessage:"Unable to initialize Fleet"}),error:h}):(0,O.jsx)(S.uq,null)):(0,O.jsx)(l().Fragment,null,e)})),Mi=(0,s.memo)((({children:e,startServices:t,config:a,history:s,kibanaVersion:l,extensions:n,routerHistory:i,fleetStatus:o})=>{const g=(0,c.A)(t.theme.theme$,t.theme.getTheme()).darkMode;return(0,O.jsx)(p.KibanaRenderContextProvider,(0,d.default)({},t,{theme:t.theme,modify:{breakpoint:{xxl:1600}}}),(0,O.jsx)(k.V,{coreStart:{application:t.application}},(0,O.jsx)(y.KibanaContextProvider,{services:{...t}},(0,O.jsx)(u.QOw.Provider,{value:a},(0,O.jsx)(u.g4O.Provider,{value:l},(0,O.jsx)(v.EuiThemeProvider,{darkMode:g},(0,O.jsx)(x.QueryClientProvider,{client:bi},(0,O.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}),(0,O.jsx)(u.K8T.Provider,{value:n},(0,O.jsx)(u.aOH,{defaultFleetStatus:o},(0,O.jsx)(b.M,null,(0,O.jsx)(r.Router,{history:s},(0,O.jsx)(j.hn1,{startServices:t},(0,O.jsx)(u.iGT,null,e)))))))))))))})),Fi=(0,s.memo)((({setHeaderActionMenu:e,isReadOnly:t})=>{const a=(0,u.WeA)(),{euiTheme:s}=(0,g.useEuiTheme)(),n=l().useMemo((()=>(0,E.css)("color:",s.colors.text,";","")),[s]),{TopNavMenu:i}=a.navigation.ui,o=[];return t&&o.push({label:m.i18n.translate("xpack.fleet.appNavigation.readOnlyBtn",{defaultMessage:"Read-only"}),disableButton:!0,className:n,iconType:"glasses",tooltip:m.i18n.translate("xpack.fleet.appNavigation.readOnlyTooltip",{defaultMessage:"You can view most Fleet settings, but your current privileges don't allow you to perform all actions."}),run:()=>{}}),o.push({label:m.i18n.translate("xpack.fleet.appNavigation.sendFeedbackButton",{defaultMessage:"Send feedback"}),iconType:"popout",run:()=>window.open("https://ela.st/fleet-feedback")}),(0,O.jsx)(i,{appName:m.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"}),config:o,setMenuMountPoint:e})})),Ii=({children:e,setHeaderActionMenu:t,isReadOnly:a})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Fi,{setHeaderActionMenu:t,isReadOnly:a}),e),Ti=(0,s.memo)((({setHeaderActionMenu:e})=>{var t;const a=(0,u.Wdf)(),s=(0,u.YI3)(),{agentTamperProtectionEnabled:n}=z.ZX.get(),i=(0,u.iO7)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:M.X5.agents,key:M.X5.agents},i.fleet.readAgents?(0,O.jsx)(Ii,{setHeaderActionMenu:e,isReadOnly:!i.fleet.allAgents},(0,O.jsx)(Xa,null)):(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents Read"})))),(0,O.jsx)(r.Route,{path:M.X5.policies},i.fleet.readAgentPolicies?(0,O.jsx)(Ii,{setHeaderActionMenu:e,isReadOnly:!i.fleet.allAgentPolicies},(0,O.jsx)(de,null)):(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agent policies Read"})))),(0,O.jsx)(r.Route,{path:M.X5.enrollment_tokens},i.fleet.allAgents?(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(ol,null)):(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),n&&(0,O.jsx)(r.Route,{path:M.X5.uninstall_tokens},i.fleet.allAgents?(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(vl,null)):(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,O.jsx)(r.Route,{path:M.X5.data_streams},(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(fe,null))),(0,O.jsx)(r.Route,{path:M.X5.settings},i.fleet.readSettings?(0,O.jsx)(Ii,{setHeaderActionMenu:e,isReadOnly:!i.fleet.allSettings},(0,O.jsx)(gi,null)):(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(Ii,{setHeaderActionMenu:e},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Settings Read"})))),(0,O.jsx)(r.Route,{path:M.X5.add_integration_to_policy},(0,O.jsx)(al,null)),(0,O.jsx)(r.Route,{render:({location:e})=>{if(!(""===e.pathname&&e.hash.length>0)){const e=i.fleet.readAgents?M.X5.agents:i.fleet.readAgentPolicies?M.X5.policies:M.X5.settings;return(0,O.jsx)(o.Redirect,{to:e})}const t=e.hash.replace(/^#(\/fleet)?/,"");return(0,O.jsx)(o.Redirect,{to:{...e,pathname:t,hash:void 0}})}})),a.isEnrollmentFlyoutOpen&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(S.rt,{defaultMode:!s.isReady||null!==(t=s.missingRequirements)&&void 0!==t&&t.includes("fleet_server")?"standalone":"managed",isIntegrationFlow:!0,onClose:()=>a.closeEnrollmentFlyout()})),a.isFleetServerFlyoutOpen&&(0,O.jsx)(g.EuiPortal,null,(0,O.jsx)(S.Jh,{onClose:()=>a.closeFleetServerFlyout()})))})),wi=({startServices:e,config:t,history:a,kibanaVersion:s,extensions:l,setHeaderActionMenu:n})=>(0,O.jsx)(Mi,{startServices:e,config:t,history:a,kibanaVersion:s,extensions:l},(0,O.jsx)(Si,null,(0,O.jsx)(Ti,{setHeaderActionMenu:n})));function Ci(e,{element:t,history:a,setHeaderActionMenu:s},l,n,o){return i().render((0,O.jsx)(wi,{startServices:e,config:l,history:a,kibanaVersion:n,extensions:o,setHeaderActionMenu:s}),t),()=>{i().unmountComponentAtNode(t)}}const Ai=e=>{e.chrome.docTitle.reset(),e.chrome.setBreadcrumbs([]),u.Fjq.stop()}},86557:(e,t,a)=>{e.exports=a(52497)(36295)},17519:(e,t,a)=>{e.exports=a(52497)(36873)},93230:(e,t,a)=>{e.exports=a(52497)(47027)},21059:(e,t,a)=>{e.exports=a(52497)(65811)},51718:(e,t,a)=>{e.exports=a(52497)(89779)}}]);