"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageIcon = exports.CardIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// when a custom SVG is used the logo is rendered with <img class="euiIcon euiIcon--small">
// this collides with some EuiText (+img) CSS from the EuiIcon component
// which  makes the button large, wide, and poorly layed out
// override those styles until the bug is fixed or we find a better approach
const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  width: '16px';
  margin-block-end: unset !important;
`;
const PackageIcon = ({
  packageName,
  integrationName,
  version,
  icons,
  tryApi,
  ...euiIconProps
}) => {
  const iconType = (0, _hooks.usePackageIconType)({
    packageName,
    integrationName,
    version,
    icons,
    tryApi
  });
  // @ts-expect-error loading="lazy" is not supported by EuiIcon
  return /*#__PURE__*/_react.default.createElement(Icon, (0, _extends2.default)({
    size: "s",
    type: iconType
  }, euiIconProps, {
    loading: "lazy"
  }));
};
exports.PackageIcon = PackageIcon;
const CardIcon = props => {
  const {
    icons
  } = props;
  if (icons && icons.length === 1 && icons[0].type === 'eui') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      size: 'xl',
      type: icons[0].src
    }, props));
  } else if (icons && icons.length === 1 && icons[0].type === 'svg') {
    // @ts-expect-error loading="lazy" is not supported by EuiIcon
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      size: 'xl',
      type: icons[0].src
    }, props, {
      loading: "lazy"
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(PackageIcon, props);
  }
};
exports.CardIcon = CardIcon;