"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationsStateContext = exports.IntegrationsStateContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationsStateContext = /*#__PURE__*/(0, _react.createContext)({
  getFromIntegrations: () => undefined
});
const IntegrationsStateContextProvider = ({
  children
}) => {
  const maybeState = (0, _hooks.useIntraAppState)();
  const fromIntegrationsRef = (0, _react.useRef)(maybeState === null || maybeState === void 0 ? void 0 : maybeState.fromIntegrations);
  const getFromIntegrations = (0, _react.useCallback)(() => {
    return fromIntegrationsRef.current;
  }, []);
  return /*#__PURE__*/_react.default.createElement(IntegrationsStateContext.Provider, {
    value: {
      getFromIntegrations
    }
  }, children);
};
exports.IntegrationsStateContextProvider = IntegrationsStateContextProvider;
const useIntegrationsStateContext = () => {
  const ctx = (0, _react.useContext)(IntegrationsStateContext);
  if (!ctx) {
    throw new Error('useIntegrationsStateContext can only be used inside of IntegrationsStateContextProvider');
  }
  return ctx;
};
exports.useIntegrationsStateContext = useIntegrationsStateContext;