"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAuditEvent = createAuditEvent;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getOutcome = (error, outcome) => {
  if (outcome) {
    return outcome;
  }
  return error ? 'failure' : 'success';
};
function createAuditEvent({
  message,
  action,
  error,
  outcome
}) {
  return {
    message,
    event: {
      action,
      outcome: getOutcome(error, outcome)
    },
    error: error && {
      message: error === null || error === void 0 ? void 0 : error.message
    }
  };
}