"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataDictionary = void 0;
var _mapValues = _interopRequireDefault(require("lodash/mapValues"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataDictionary {
  constructor(fields) {
    this.fields = fields;
  }
  getFields() {
    return this.fields;
  }
  pick(attributes) {
    return (0, _mapValues.default)(this.fields, field => field.pick(attributes));
  }
  toPlain() {
    return (0, _mapValues.default)(this.fields, field => field.toPlain());
  }
  static create(fields) {
    return new FieldsMetadataDictionary(fields);
  }
}
exports.FieldsMetadataDictionary = FieldsMetadataDictionary;