"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = executeAction;
exports.isActionCompatible = isActionCompatible;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _esqlUtils = require("@kbn/esql-utils");
var _esqlTypes = require("@kbn/esql-types");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function isESQLVariableType(value) {
  return Object.values(_esqlTypes.ESQLVariableType).includes(value);
}
async function isActionCompatible(core, variableType) {
  return core.uiSettings.get(_esqlUtils.ENABLE_ESQL) && isESQLVariableType(variableType);
}
const Fallback = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null);
async function executeAction({
  queryString,
  core,
  search,
  timefilter,
  variableType,
  esqlVariables,
  onSaveControl,
  onCancelControl,
  cursorPosition,
  initialState
}) {
  const isCompatibleAction = await isActionCompatible(core, variableType);
  if (!isCompatibleAction) {
    throw new _public.IncompatibleActionError();
  }
  const LazyControlFlyout = /*#__PURE__*/(0, _react.lazy)(async () => {
    const {
      ESQLControlsFlyout
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_flyout')));
    return {
      default: ESQLControlsFlyout
    };
  });
  const timeRange = timefilter.getTime();
  const deps = await (0, _kibana_services.untilPluginStartServicesReady)();
  const handle = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.cloneElement(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...deps
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(Fallback, null)
  }, /*#__PURE__*/_react.default.createElement(LazyControlFlyout, {
    queryString: queryString,
    search: search,
    initialVariableType: variableType,
    closeFlyout: () => {
      handle.close();
    },
    onSaveControl: onSaveControl,
    onCancelControl: onCancelControl,
    cursorPosition: cursorPosition,
    initialState: initialState,
    esqlVariables: esqlVariables,
    timeRange: timeRange
  })))), {
    closeFlyout: () => {
      handle.close();
    }
  }), core), {
    size: 's',
    'data-test-subj': 'create_esql_control_flyout',
    isResizable: true,
    type: 'push',
    paddingSize: 'm',
    hideCloseButton: true,
    onClose: overlayRef => {
      overlayRef.close();
    },
    outsideClickCloses: true,
    maxWidth: 800
  });
}