"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const supportedPromptTypes = ['text', 'keyword', 'unknown', 'param'];

/**
 * Validates the COMPLETION command:
 *
 * COMPLETION <prompt> WITH <inferenceId> (AS <targetField>)
 */
const validate = (command, references) => {
  const messages = [];
  const {
    prompt,
    location,
    targetField
  } = command;
  const promptExpressionType = (0, _helpers.getExpressionType)(prompt, references.fields, references.userDefinedColumns);
  if (!supportedPromptTypes.includes(promptExpressionType)) {
    messages.push({
      location: 'location' in prompt ? prompt === null || prompt === void 0 ? void 0 : prompt.location : location,
      text: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.validation.completionUnsupportedFieldType', {
        defaultMessage: '[COMPLETION] prompt must be of type [text] but is [{promptExpressionType}]',
        values: {
          promptExpressionType
        }
      }),
      type: 'error',
      code: 'completionUnsupportedFieldType'
    });
  }
  const targetName = (targetField === null || targetField === void 0 ? void 0 : targetField.name) || 'completion';

  // Sets the target field so the column is recognized after the command is applied
  references.userDefinedColumns.set(targetName, [{
    name: targetName,
    location: (targetField === null || targetField === void 0 ? void 0 : targetField.location) || command.location,
    type: 'keyword'
  }]);
  return messages;
};
exports.validate = validate;