"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSuggestion = exports.onSuggestion = exports.noPoliciesAvailableSuggestion = exports.modeSuggestions = exports.modeDescription = exports.getPosition = exports.buildMatchingFieldsDefinition = exports.Position = void 0;
var _i18n = require("@kbn/i18n");
var _commands_helpers = require("../../../definitions/commands_helpers");
var _ = require("../../../..");
var _factories = require("../../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let Position = exports.Position = /*#__PURE__*/function (Position) {
  Position["MODE"] = "mode";
  Position["POLICY"] = "policy";
  Position["AFTER_POLICY"] = "after_policy";
  Position["MATCH_FIELD"] = "match_field";
  Position["AFTER_ON_CLAUSE"] = "after_on_clause";
  Position["WITH_NEW_CLAUSE"] = "with_new_clause";
  Position["WITH_AFTER_FIRST_WORD"] = "with_after_first_word";
  Position["WITH_AFTER_ASSIGNMENT"] = "with_after_assignment";
  Position["WITH_AFTER_COMPLETE_CLAUSE"] = "with_after_complete_clause";
  return Position;
}({});
const getPosition = (innerText, command) => {
  if (command.args.length < 2) {
    if (innerText.match(/_[^:\s]*$/)) {
      return Position.MODE;
    }
    if (innerText.match(/(:|ENRICH\s+)\S*$/i)) {
      return Position.POLICY;
    }
    if (innerText.match(/:\s+$/)) {
      return undefined;
    }
    if (innerText.match(/\s+\S*$/)) {
      return Position.AFTER_POLICY;
    }
  }
  const lastArg = command.args[command.args.length - 1];
  if ((0, _.isSingleItem)(lastArg) && lastArg.name === 'on') {
    if (innerText.match(/on\s+\S*$/i)) {
      return Position.MATCH_FIELD;
    }
    if (innerText.match(/on\s+\S+\s+$/i)) {
      return Position.AFTER_ON_CLAUSE;
    }
  }
  if ((0, _.isSingleItem)(lastArg) && lastArg.name === 'with') {
    if (innerText.match(/[,|with]\s+\S*$/i)) {
      return Position.WITH_NEW_CLAUSE;
    }
    if (innerText.match(/[,|with]\s+\S+\s*=\s*\S+\s+$/i)) {
      return Position.WITH_AFTER_COMPLETE_CLAUSE;
    }
    if (innerText.match(/[,|with]\s+\S+\s+$/i)) {
      return Position.WITH_AFTER_FIRST_WORD;
    }
    if (innerText.match(/=\s+[^,\s]*$/i)) {
      return Position.WITH_AFTER_ASSIGNMENT;
    }
  }
};
exports.getPosition = getPosition;
const noPoliciesAvailableSuggestion = exports.noPoliciesAvailableSuggestion = {
  label: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.noPoliciesLabel', {
    defaultMessage: 'No available policy'
  }),
  text: '',
  kind: 'Issue',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.noPoliciesLabelsFound', {
    defaultMessage: 'Click to create'
  }),
  sortText: 'D',
  command: {
    id: 'esql.policies.create',
    title: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.createNewPolicy', {
      defaultMessage: 'Click to create'
    })
  }
};
const modeDescription = exports.modeDescription = _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqMode', {
  defaultMessage: 'Cross-cluster query mode'
});
const modeSuggestions = exports.modeSuggestions = _commands_helpers.ENRICH_MODES === null || _commands_helpers.ENRICH_MODES === void 0 ? void 0 : _commands_helpers.ENRICH_MODES.map(({
  name,
  description
}) => ({
  label: `_${name}`,
  text: `_${name}:$0`,
  asSnippet: true,
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqModeDoc', {
    defaultMessage: 'Cross-cluster query mode - ${description}',
    values: {
      description
    }
  }),
  sortText: 'D',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
}));
const onSuggestion = exports.onSuggestion = {
  label: 'ON',
  text: 'ON ',
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.onDoc', {
    defaultMessage: 'On'
  }),
  sortText: '1',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};
const withSuggestion = exports.withSuggestion = {
  label: 'WITH',
  text: 'WITH ',
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.withDoc', {
    defaultMessage: 'With'
  }),
  sortText: '1',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};
const buildMatchingFieldsDefinition = (matchingField, fields) => fields.map(label => ({
  label,
  text: (0, _factories.getSafeInsertText)(label) + ' ',
  kind: 'Variable',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.matchingFieldDefinition', {
    defaultMessage: `Use to match on {matchingField} on the policy`,
    values: {
      matchingField
    }
  }),
  sortText: 'D',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
}));
exports.buildMatchingFieldsDefinition = buildMatchingFieldsDefinition;