"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BinaryExpressionGroup = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The group name of a binary expression. Groups are ordered by precedence.
 */
let BinaryExpressionGroup = exports.BinaryExpressionGroup = /*#__PURE__*/function (BinaryExpressionGroup) {
  BinaryExpressionGroup[BinaryExpressionGroup["unknown"] = 0] = "unknown";
  BinaryExpressionGroup[BinaryExpressionGroup["additive"] = 10] = "additive";
  BinaryExpressionGroup[BinaryExpressionGroup["multiplicative"] = 20] = "multiplicative";
  BinaryExpressionGroup[BinaryExpressionGroup["assignment"] = 30] = "assignment";
  BinaryExpressionGroup[BinaryExpressionGroup["comparison"] = 40] = "comparison";
  BinaryExpressionGroup[BinaryExpressionGroup["regex"] = 50] = "regex";
  return BinaryExpressionGroup;
}({});