"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAndInstallIngestPipelines = createAndInstallIngestPipelines;
var _generate_component_id = require("./helpers/generate_component_id");
var _retry = require("./helpers/retry");
var _generate_latest_processors = require("./ingest_pipeline/generate_latest_processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAndInstallIngestPipelines(esClient, definition, logger) {
  try {
    const latestProcessors = (0, _generate_latest_processors.generateLatestProcessors)(definition);
    const latestId = (0, _generate_component_id.generateLatestIngestPipelineId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.putPipeline({
      id: latestId,
      processors: latestProcessors,
      _meta: {
        definition_version: definition.version,
        managed: definition.managed
      }
    }), {
      logger
    });
    return [{
      type: 'ingest_pipeline',
      id: latestId
    }];
  } catch (e) {
    logger.error(`Cannot create entity latest ingest pipelines for [${definition.id}] entity definition`);
    throw e;
  }
}