"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrgNameOnboarding = exports.OnboardingSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _telemetry = require("../../../shared/telemetry");
var _app_logic = require("../../app_logic");
var _share_circle = _interopRequireDefault(require("../../components/shared/assets/source_icons/share_circle.svg"));
var _content_section = require("../../components/shared/content_section");
var _routes = require("../../routes");
var _onboarding_card = require("./onboarding_card");
var _overview_logic = require("./overview_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingSourcesCard.title', {
  defaultMessage: 'Organizational sources'
});
const USERS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingUsersCard.title', {
  defaultMessage: 'Users & invitations'
});
const INVITE_FIRST_USERS_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingUsersCard.inviteFirstUsers.button', {
  defaultMessage: 'Invite users'
});
const INVITE_MORE_USERS_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingUsersCard.inviteMoreUsers.button', {
  defaultMessage: 'Invite more users'
});
const ONBOARDING_SOURCES_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingSourcesCard.description', {
  defaultMessage: 'Add organizational sources for your organization to start searching.'
});
const ADD_FIRST_SOURCES_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourcesOnboardingCard.addFirstSources.button', {
  defaultMessage: 'Add sources'
});
const ADD_MORE_SOURCES_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourcesOnboardingCard.addMoreSources.button', {
  defaultMessage: 'Add more sources'
});
const USERS_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewUsersCard.title', {
  defaultMessage: 'Nice, you’ve invited colleagues to search with you.'
});
const ONBOARDING_USERS_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingUsersCard.description', {
  defaultMessage: 'Invite your colleagues into this organization to search with you.'
});
const OnboardingSteps = () => {
  const {
    organization: {
      name,
      defaultOrgName
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    hasUsers,
    hasOrgSources,
    accountsCount,
    sourcesCount
  } = (0, _kea.useValues)(_overview_logic.OverviewLogic);
  const SOURCES_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourcesOnboardingCard.description', {
    defaultMessage: 'You have added {sourcesCount, number} organizational {sourcesCount, plural, one {source} other {sources}}. Happy searching.',
    values: {
      sourcesCount
    }
  });
  return /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_onboarding_card.OnboardingCard, {
    title: SOURCES_TITLE,
    testSubj: "orgSourcesButton",
    icon: _share_circle.default,
    description: hasOrgSources ? SOURCES_CARD_DESCRIPTION : ONBOARDING_SOURCES_CARD_DESCRIPTION,
    actionTitle: sourcesCount > 0 ? ADD_MORE_SOURCES_BUTTON : ADD_FIRST_SOURCES_BUTTON,
    actionPath: _routes.ADD_SOURCE_PATH,
    complete: hasOrgSources
  }), /*#__PURE__*/_react.default.createElement(_onboarding_card.OnboardingCard, {
    title: USERS_TITLE,
    testSubj: "usersButton",
    icon: "user",
    description: hasUsers ? USERS_CARD_DESCRIPTION : ONBOARDING_USERS_CARD_DESCRIPTION,
    actionTitle: accountsCount > 0 ? INVITE_MORE_USERS_BUTTON : INVITE_FIRST_USERS_BUTTON,
    actionPath: _routes.USERS_AND_ROLES_PATH,
    complete: hasUsers
  })), name === defaultOrgName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(OrgNameOnboarding, null)));
};
exports.OnboardingSteps = OnboardingSteps;
const OrgNameOnboarding = () => {
  const {
    sendWorkplaceSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const onClick = () => sendWorkplaceSearchTelemetry({
    action: 'clicked',
    metric: 'org_name_change_button'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-hideFor--xs eui-hideFor--s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentEdit",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.orgNameOnboarding.description",
    defaultMessage: "Before inviting your colleagues, name your organization to improve recognition."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: _routes.ORG_SETTINGS_PATH,
    onClick: onClick,
    "data-test-subj": "orgNameChangeButton",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.orgNameOnboarding.buttonLabel",
    defaultMessage: "Name your organization"
  })))));
};
exports.OrgNameOnboarding = OrgNameOnboarding;