"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupSubNav = void 0;
var _kea = require("kea");
var _layout = require("../../../../shared/layout");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _group_logic = require("../group_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGroupSubNav = () => {
  const {
    group: {
      id
    }
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  if (!id) return undefined;
  const navItems = [{
    id: 'groupOverview',
    name: _constants.NAV.GROUP_OVERVIEW,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getGroupPath)(id)
    })
  }, {
    id: 'groupSourcePrioritization',
    name: _constants.NAV.SOURCE_PRIORITIZATION,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getGroupSourcePrioritizationPath)(id)
    })
  }];
  return navItems;
};
exports.useGroupSubNav = useGroupSubNav;