"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultDetail = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _constants2 = require("./constants");
var _display_settings_logic = require("./display_settings_logic");
var _example_result_detail_card = require("./example_result_detail_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultDetail = () => {
  const {
    toggleFieldEditorModal,
    setDetailFields,
    openEditDetailField,
    removeDetailField
  } = (0, _kea.useActions)(_display_settings_logic.DisplaySettingsLogic);
  const {
    searchResultConfig: {
      detailFields
    },
    availableFieldOptions
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants2.VISIBLE_FIELDS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: toggleFieldEditorModal,
    disabled: availableFieldOptions.length < 1,
    "data-test-subj": "AddFieldButton"
  }, _constants.ADD_FIELD_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), detailFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: setDetailFields
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "visible_fields",
    className: "visible-fields-container",
    withPanel: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, detailFields.map(({
    fieldName,
    label
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    key: `${fieldName}-${index}`,
    index: index,
    draggableId: `${fieldName}-${index}`,
    customDragHandle: true,
    spacing: "m"
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", provided.dragHandleProps, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("div", null, "\u201C", label || '', "\u201D"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "EditFieldButton",
    "aria-label": _constants.EDIT_FIELD_LABEL,
    iconType: "pencil",
    onClick: () => openEditDetailField(index)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "RemoveFieldButton",
    "aria-label": _constants.REMOVE_FIELD_LABEL,
    iconType: "cross",
    onClick: () => removeDetailField(index)
  })))))))))) : /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "EmptyFieldsDescription"
  }, _constants2.EMPTY_FIELDS_DESCRIPTION))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants2.PREVIEW_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_example_result_detail_card.ExampleResultDetailCard, null)))));
};
exports.ResultDetail = ResultDetail;