"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureCustom = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../../shared/doc_links");
var _connection_illustration = _interopRequireDefault(require("../../../../../assets/connection_illustration.svg"));
var _constants = require("../../../constants");
var _add_source_header = require("../add_source_header");
var _constants2 = require("../constants");
var _add_custom_source_logic = require("./add_custom_source_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureCustom = ({
  sourceData
}) => {
  const {
    setCustomSourceNameValue,
    createContentSource
  } = (0, _kea.useActions)(_add_custom_source_logic.AddCustomSourceLogic);
  const {
    customSourceNameValue,
    buttonLoading
  } = (0, _kea.useValues)(_add_custom_source_logic.AddCustomSourceLogic);
  const handleFormSubmit = e => {
    e.preventDefault();
    createContentSource();
  };
  const handleNameChange = e => setCustomSourceNameValue(e.target.value);
  const {
    serviceType,
    baseServiceType,
    configuration: {
      documentationUrl,
      githubRepository
    },
    name,
    categories = []
  } = sourceData;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: baseServiceType !== null && baseServiceType !== void 0 ? baseServiceType : serviceType,
    categories: categories
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "stretch",
    direction: "row",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "adding-a-source__intro-image"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: _connection_illustration.default,
    alt: _constants2.CONFIG_INTRO_ALT_TEXT
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.title",
    defaultMessage: "How to add {name}",
    values: {
      name
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, serviceType === 'custom' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sources.helpText.custom",
    defaultMessage: "To create a Custom API Source, provide a human-readable and descriptive name. The name will appear as-is in the various search experiences and management interfaces."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.docs.link.description",
    defaultMessage: "{link} to learn more about Custom API Sources.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchCustomSources,
        target: "_blank"
      }, _constants2.CONFIG_CUSTOM_LINK_TEXT)
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.heading",
    defaultMessage: "The {name} connector is fully customizable, and will be self-managed on the infrastructure of your choice.",
    values: {
      name
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.description",
    defaultMessage: "To be prepared for configuration, review our {deploymentGuideLink} for all prerequisites needed to quickly deploy the connector package. Finalize your configuration in Enterprise Search with a descriptive name for the {name} content source, and update the connector config file with the source ID provided in the next step.",
    values: {
      name,
      deploymentGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: documentationUrl
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.linkLabel",
        defaultMessage: "documentation"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: `https://github.com/${githubRepository}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.githubRepoLinkLabel",
    defaultMessage: "Customize the connector here."
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: 'https://discuss.elastic.co/c/enterprise-search/84'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.discussLinkLabel",
    defaultMessage: "Questions? Discuss here."
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: 'https://www.elastic.co/kibana/feedback'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.deploymentGuide.feedbackLinkLabel",
    defaultMessage: "We're always looking to improve. Share your feedback  "
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.SOURCE_NAME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "source-name",
    required: true,
    "data-test-subj": "CustomSourceNameInput",
    value: customSourceNameValue,
    onChange: handleNameChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    type: "submit",
    isLoading: buttonLoading,
    "data-test-subj": "CreateCustomButton"
  }, serviceType === 'custom' ? _constants2.CONFIG_CUSTOM_BUTTON : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.configCustom.createNamedSourceButtonLabel",
    defaultMessage: "Configure {name}",
    values: {
      name
    }
  })))))));
};
exports.ConfigureCustom = ConfigureCustom;