"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _flash_messages = require("../../../../shared/flash_messages");
var _api_keys_logic = require("../api_keys_logic");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeyFlyout = () => {
  const {
    setNameInputBlurred,
    setApiKeyName,
    onApiFormSubmit,
    hideApiKeyForm
  } = (0, _kea.useActions)(_api_keys_logic.ApiKeysLogic);
  const {
    activeApiToken: {
      name
    },
    activeApiTokenRawName: rawName
  } = (0, _kea.useValues)(_api_keys_logic.ApiKeysLogic);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: hideApiKeyForm,
    hideCloseButton: true,
    ownFocus: true,
    size: "s",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, _constants2.API_KEY_FLYOUT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: e => {
      e.preventDefault();
      onApiFormSubmit();
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.API_KEY_FORM_LABEL,
    helpText: !!name && name !== rawName ? (0, _constants2.API_KEY_FORM_HELP_TEXT)(name) : '',
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "raw_name",
    id: "raw_name",
    placeholder: _constants2.API_KEY_NAME_PLACEHOLDER,
    "data-test-subj": "APIKeyField",
    value: rawName,
    onChange: e => setApiKeyName(e.target.value),
    onBlur: () => setNameInputBlurred(true),
    autoComplete: "off",
    maxLength: 64,
    required: true,
    fullWidth: true,
    autoFocus: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchApiKeyFlyoutButton",
    iconType: "cross",
    onClick: hideApiKeyForm
  }, _constants.CLOSE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApiFormSubmit,
    fill: true,
    "data-test-subj": "APIKeyActionButton"
  }, _constants.SAVE_BUTTON_LABEL))))));
};
exports.ApiKeyFlyout = ApiKeyFlyout;