"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewContentHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewContentHeader = ({
  title,
  titleSize = 'm',
  headingLevel = 2,
  description,
  action,
  alignItems = 'center'
}) => {
  let titleElement;
  switch (headingLevel) {
    case 1:
      titleElement = /*#__PURE__*/_react.default.createElement("h1", null, title);
      break;
    case 2:
      titleElement = /*#__PURE__*/_react.default.createElement("h2", null, title);
      break;
    default:
      titleElement = /*#__PURE__*/_react.default.createElement("h3", null, title);
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: alignItems,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: titleSize
  }, titleElement), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description))), action && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, action)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.ViewContentHeader = ViewContentHeader;