"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BodyRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell = require("./cell");
var _constants = require("./constants");
var Styles = _interopRequireWildcard(require("./styles"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BodyRow = ({
  additionalProps,
  ariaRowindex,
  columns,
  errors = [],
  item,
  leftAction,
  rowIdentifier
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  // Calculate column index offset based on presence of leftAction and rowIdentifier
  const columnIndexOffset = (leftAction ? 1 : 0) + (rowIdentifier ? 1 : 0);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reorderableTableRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    "data-test-subj": "row",
    alignItems: "center",
    role: "row",
    "aria-rowindex": ariaRowindex
  }, additionalProps || {}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: Styles.bodyRowItemStyles(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, leftAction && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    role: "cell",
    ariaColindex: 1
  }), leftAction), rowIdentifier && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    flexBasis: "24px",
    role: "cell",
    ariaColindex: leftAction ? 2 : 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
    size: "m",
    iconType: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, rowIdentifier))
  })), columns.map((column, columnIndex) => /*#__PURE__*/_react.default.createElement(_cell.Cell, {
    key: `table_row_cell_${columnIndex}`,
    alignItems: column.alignItems,
    flexBasis: column.flexBasis,
    flexGrow: column.flexGrow,
    role: "cell",
    ariaColindex: columnIndex + columnIndexOffset + 1
  }, column.render(item)))))), errors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, errors.map((errorMessage, errorMessageIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: errorMessageIndex
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    role: "alert",
    "aria-live": "polite",
    iconType: "warning",
    size: "s",
    color: "danger",
    title: errorMessage
  })))));
};
exports.BodyRow = BodyRow;