"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserFlyout = ({
  children,
  isNew,
  isComplete,
  disabled,
  formLoading,
  closeUserFlyout,
  handleSaveUser
}) => {
  const savedIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "success",
    size: "l",
    type: "checkInCircleFilled",
    style: {
      marginLeft: 5,
      marginTop: -5
    }
  });
  const IS_EDITING_HEADING = isNew ? _constants2.USERS_HEADING_LABEL : _constants2.UPDATE_USER_LABEL;
  const IS_EDITING_DESCRIPTION = isNew ? _constants2.NEW_USER_DESCRIPTION : _constants2.UPDATE_USER_DESCRIPTION;
  const USER_SAVED_HEADING = isNew ? _constants2.USER_ADDED_LABEL : _constants2.USER_UPDATED_LABEL;
  const IS_COMPLETE_HEADING = /*#__PURE__*/_react.default.createElement("span", null, USER_SAVED_HEADING, " ", savedIcon);
  const editingFooterActions = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeUserFlyout
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: disabled,
    isLoading: formLoading,
    onClick: handleSaveUser,
    fill: true
  }, isNew ? _constants2.ADD_USER_LABEL : _constants2.UPDATE_USER_LABEL)));
  const completedFooterAction = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: closeUserFlyout
  }, _constants.CLOSE_BUTTON_LABEL)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: closeUserFlyout,
    size: "s",
    "aria-labelledby": "userFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "userFlyoutTitle"
  }, isComplete ? IS_COMPLETE_HEADING : IS_EDITING_HEADING)), !isComplete && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, IS_EDITING_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, isComplete ? completedFooterAction : editingFooterActions)));
};
exports.UserFlyout = UserFlyout;