"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchDeprecationCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchDeprecationCallout = ({
  onDismissAction,
  learnMoreLinkUrl,
  restrictWidth = false
}) => {
  const maxWidth = restrictWidth ? '75%' : '100%';
  const cssStyles = {
    maxWidth,
    marginLeft: 'auto',
    marginRight: 'auto',
    marginTop: '16px',
    marginBottom: '16px'
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: cssStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: onDismissAction,
    iconType: 'warning',
    color: 'warning',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.enterpriseSearchDeprecationCallout.euiCallOut.title', {
      defaultMessage: 'Important Note'
    }),
    "data-test-subj": "EnterpriseSearchDeprecationCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.deprecationCallout.message",
    defaultMessage: "The standalone App Search and Workplace Search products remain available in maintenance mode. We recommend using our Elastic Stack tools to build new semantic and AI powered search experiences."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: learnMoreLinkUrl,
    color: "warning",
    iconType: "popout",
    iconSide: "right",
    target: "_blank",
    "data-test-subj": "ent-search-deprecation-callout-cta",
    fill: true
  }, "Learn more")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    onClick: onDismissAction,
    color: "warning",
    "data-test-subj": "dismiss-ent-search-deprecation-callout"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.deprecationCallout.dismissLink', {
    defaultMessage: 'Dismiss'
  }))))));
};
exports.EnterpriseSearchDeprecationCallout = EnterpriseSearchDeprecationCallout;