"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _kibana = require("../shared/kibana");
var _version_mismatch = require("../shared/version_mismatch");
var _product_selector = require("./components/product_selector");
var _setup_guide = require("./components/setup_guide");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchOverview = ({
  enterpriseSearchVersion,
  kibanaVersion
}) => {
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const incompatibleVersions = !!(config.host && (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion));
  const showView = () => {
    if (incompatibleVersions) {
      return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
        enterpriseSearchVersion: enterpriseSearchVersion,
        kibanaVersion: kibanaVersion
      });
    }
    return /*#__PURE__*/_react.default.createElement(_product_selector.ProductSelector, null);
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SETUP_GUIDE_PATH
  }, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH
  }, showView()));
};
exports.EnterpriseSearchOverview = EnterpriseSearchOverview;