"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrialCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _licensing = require("../../../shared/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrialCallout = () => {
  const {
    license,
    isTrial
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  if (!isTrial) return null;
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.trialCalloutTitle",
    defaultMessage: "Your Elastic Stack Trial license, which enables Platinum features, expires in {days, plural, one {# day} other {# days}}.",
    values: {
      days: (0, _moment.default)(license === null || license === void 0 ? void 0 : license.expiryDateInMillis).diff((0, _moment.default)({
        hours: 0
      }), 'days')
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/subscriptions",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement("u", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.trialCalloutLink",
    defaultMessage: "Learn more about Elastic Stack licenses."
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: title,
    iconType: "info",
    style: {
      margin: '0 auto'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
};
exports.TrialCallout = TrialCallout;