"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilteringRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilteringRulesTable = ({
  showOrder,
  filteringRules
}) => {
  const columns = [...(showOrder ? [{
    field: 'order',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.priority', {
      defaultMessage: 'Rule priority'
    })
  }] : []), {
    field: 'policy',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.policy', {
      defaultMessage: 'Policy'
    }),
    render: policy => (0, _searchConnectors.filteringPolicyToText)(policy)
  }, {
    field: 'field',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.field', {
      defaultMessage: 'field'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, value)
  }, {
    field: 'rule',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.rule', {
      defaultMessage: 'Rule'
    }),
    render: rule => (0, _searchConnectors.filteringRuleToText)(rule)
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.value', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, value)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: filteringRules.sort(({
      order
    }, {
      order: secondOrder
    }) => order - secondOrder)
  });
};
exports.FilteringRulesTable = FilteringRulesTable;