"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResearchConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResearchConfiguration = ({
  nativeConnector
}) => {
  const {
    docsUrl,
    externalDocsUrl,
    name
  } = nativeConnector;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.researchConfiguration.euiText.checkRequirementsLabel",
      defaultMessage: "Check Requirements"
    }),
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.researchConfiguration.p.referToTheDocumentationLabel",
    defaultMessage: "Refer to the documentation for this connector to learn about prerequisites for connecting to {serviceType} and configuration requirements.",
    values: {
      serviceType: name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchResearchConfigurationDocumentationLink",
    target: "_blank",
    href: docsUrl
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.researchConfiguration.connectorDocumentationLinkLabel', {
    defaultMessage: 'Documentation'
  }))), externalDocsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchResearchConfigurationNameDocumentationLink",
    target: "_blank",
    href: externalDocsUrl
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.researchConfiguration.serviceDocumentationLinkLabel', {
    defaultMessage: '{name} documentation',
    values: {
      name
    }
  }))))));
};
exports.ResearchConfiguration = ResearchConfiguration;