"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMapping = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _role_mapping = require("../../../shared/role_mapping");
var _app_logic = require("../../app_logic");
var _constants = require("./constants");
var _engine_assignment_selector = require("./engine_assignment_selector");
var _role_mappings_logic = require("./role_mappings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMapping = () => {
  const {
    myRole
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    handleAttributeSelectorChange,
    handleAttributeValueChange,
    handleRoleChange,
    handleSaveMapping,
    closeUsersAndRolesFlyout
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    accessAllEngines,
    attributeName,
    attributeValue,
    attributes,
    elasticsearchRoles,
    hasAdvancedRoles,
    roleMapping,
    roleType,
    selectedEngines,
    roleMappingErrors,
    formLoading
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  const isNew = !roleMapping;
  const hasEngineAssignment = selectedEngines.size > 0 || accessAllEngines;
  const attributeValueInvalid = attributeName !== 'role' && !attributeValue;
  const mapRoleOptions = ({
    id,
    description
  }) => ({
    id,
    description,
    disabled: !myRole.availableRoleTypes.includes(id)
  });
  const standardRoleOptions = _constants.STANDARD_ROLE_TYPES.map(mapRoleOptions);
  const advancedRoleOptions = _constants.ADVANCED_ROLE_TYPES.map(mapRoleOptions);
  const roleOptions = hasAdvancedRoles ? [...standardRoleOptions, ...advancedRoleOptions] : standardRoleOptions;
  return /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingFlyout, {
    disabled: attributeValueInvalid || !hasEngineAssignment,
    formLoading: formLoading,
    isNew: isNew,
    closeUsersAndRolesFlyout: closeUsersAndRolesFlyout,
    handleSaveMapping: handleSaveMapping
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: roleMappingErrors.length > 0,
    error: roleMappingErrors
  }, /*#__PURE__*/_react.default.createElement(_role_mapping.AttributeSelector, {
    attributeName: attributeName,
    attributeValue: attributeValue,
    attributeValueInvalid: attributeValueInvalid,
    attributes: attributes,
    elasticsearchRoles: elasticsearchRoles,
    disabled: !!roleMapping,
    handleAttributeSelectorChange: handleAttributeSelectorChange,
    handleAttributeValueChange: handleAttributeValueChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_role_mapping.RoleSelector, {
    roleType: roleType,
    roleOptions: roleOptions,
    onChange: handleRoleChange,
    label: "Role"
  }), hasAdvancedRoles && /*#__PURE__*/_react.default.createElement(_engine_assignment_selector.EngineAssignmentSelector, null)));
};
exports.RoleMapping = RoleMapping;