"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexStatusDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
require("./engine_creation.scss");
var _health_colors = require("../../../shared/constants/health_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexStatusDetails = ({
  option
}) => {
  var _option$health, _option$status, _option$count, _option$total$store$s, _option$total, _option$total$store;
  return !option ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "entSearch__indexListItem",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: option.health ? _health_colors.healthColorsMapSelectable[option.health] : ''
  }, (_option$health = option.health) !== null && _option$health !== void 0 ? _option$health : '-')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "optionStatus"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.status', {
    defaultMessage: 'Status'
  })), ":", /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "\xA0", (_option$status = option.status) !== null && _option$status !== void 0 ? _option$status : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "optionDocs"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.docCount', {
    defaultMessage: 'Docs count'
  })), ":", /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "\xA0", (_option$count = option.count) !== null && _option$count !== void 0 ? _option$count : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "optionStorage"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureForm.elasticsearchIndex.storage', {
    defaultMessage: 'Storage size'
  })), ":", /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "\xA0", (_option$total$store$s = (_option$total = option.total) === null || _option$total === void 0 ? void 0 : (_option$total$store = _option$total.store) === null || _option$total$store === void 0 ? void 0 : _option$total$store.size_in_bytes) !== null && _option$total$store$s !== void 0 ? _option$total$store$s : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "optionStorage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: option.badge.color,
    iconType: option.badge.icon
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    title: option.badge.toolTipTitle,
    content: option.badge.toolTipContent
  }, /*#__PURE__*/_react.default.createElement("p", null, option.badge.label)))));
};
exports.IndexStatusDetails = IndexStatusDetails;