"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsFlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _flash_messages = require("../../../../shared/flash_messages");
var _constants = require("../constants");
var _credentials_logic = require("../credentials_logic");
var _form_components = require("./form_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsFlyoutBody = () => {
  const {
    onApiTokenChange
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiToken,
    activeApiTokenExists
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: e => {
      e.preventDefault();
      onApiTokenChange();
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_form_components.FormKeyName, null), /*#__PURE__*/_react.default.createElement(_form_components.FormKeyType, null), activeApiToken.type === _constants.ApiTokenTypes.Private && /*#__PURE__*/_react.default.createElement(_form_components.FormKeyReadWriteAccess, null), activeApiToken.type !== _constants.ApiTokenTypes.Admin && /*#__PURE__*/_react.default.createElement(_form_components.FormKeyEngineAccess, null)), activeApiTokenExists && /*#__PURE__*/_react.default.createElement(_form_components.FormKeyUpdateWarning, null));
};
exports.CredentialsFlyoutBody = CredentialsFlyoutBody;