"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SitemapsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../../shared/flash_messages");
var _generic_endpoint_inline_editable_table = require("../../../../shared/tables/generic_endpoint_inline_editable_table");
var _crawler_single_domain_logic = require("../crawler_single_domain_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.addButtonLabel', {
  defaultMessage: 'Add sitemap'
});
const SitemapsTable = ({
  domain,
  engineName,
  items
}) => {
  const {
    updateSitemaps
  } = (0, _kea.useActions)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  const field = 'url';
  const columns = [{
    editingRender: (sitemap, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: sitemap[field],
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid
    }),
    render: sitemap => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, sitemap[field]),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.urlTableHead', {
      defaultMessage: 'URL'
    }),
    field
  }];
  const sitemapsRoute = `/internal/app_search/engines/${engineName}/crawler/domains/${domain.id}/sitemaps`;
  const getSitemapRoute = sitemap => `/internal/app_search/engines/${engineName}/crawler/domains/${domain.id}/sitemaps/${sitemap.id}`;
  return /*#__PURE__*/_react.default.createElement(_generic_endpoint_inline_editable_table.GenericEndpointInlineEditableTable, {
    addButtonText: ADD_BUTTON_LABEL,
    columns: columns,
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.description', {
      defaultMessage: 'Specify sitemap URLs for the crawler on this domain.'
    })),
    instanceId: "SitemapsTable",
    items: items,
    canRemoveLastItem: true,
    noItemsMessage: editNewItem => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.emptyMessageTitle', {
        defaultMessage: 'There are no existing sitemaps.'
      })),
      titleSize: "s",
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "Add a sitemap to specify an entry point for the crawler."),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: editNewItem
      }, ADD_BUTTON_LABEL)
    })),
    addRoute: sitemapsRoute,
    deleteRoute: getSitemapRoute,
    updateRoute: getSitemapRoute,
    dataProperty: "sitemaps",
    onAdd: (_, newSitemaps) => {
      updateSitemaps(newSitemaps);
      (0, _flash_messages.clearFlashMessages)();
    },
    onDelete: (_, newSitemaps) => {
      updateSitemaps(newSitemaps);
      (0, _flash_messages.clearFlashMessages)();
      (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.deleteSuccessToastMessage', {
        defaultMessage: 'The sitemap has been deleted.'
      }));
    },
    onUpdate: (_, newSitemaps) => {
      updateSitemaps(newSitemaps);
      (0, _flash_messages.clearFlashMessages)();
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.sitemapsTable.title', {
      defaultMessage: 'Sitemaps'
    }),
    disableReordering: true
  });
};
exports.SitemapsTable = SitemapsTable;