"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchGatePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _app_search_gate = require("./app_search_gate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppSearchGatePage = ({
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, {
    restrictWidth: true,
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.appSearch.gateForm.description",
        defaultMessage: "The standalone App Search product remains available in maintenance mode, but is not recommended for new search experiences. We recommend using native Elasticsearch tools, which offer flexibility and composability, and include exciting new search features. To help you choose the tools best suited for your use case, we\u2019ve created this recommendation wizard. Select the features you need, and we'll point you to corresponding Elasticsearch features. If you still want to use the standalone App Search product, you can do so after submitting the form."
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.gateForm.title', {
        defaultMessage: 'Before you begin...'
      })
    },
    solutionNav: {
      items: (0, _layout.useEnterpriseSearchNav)(),
      name: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME
    },
    isLoading: isLoading,
    hideEmbeddedConsole: true
  }, /*#__PURE__*/_react.default.createElement(_telemetry.SendAppSearchTelemetry, {
    action: "viewed",
    metric: "App Search Gate form"
  }), /*#__PURE__*/_react.default.createElement(_app_search_gate.AppSearchGate, null));
};
exports.AppSearchGatePage = AppSearchGatePage;