"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentQueries = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _ = require("..");
var _analytics_layout = require("../analytics_layout");
var _components = require("../components");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentQueries = () => {
  const {
    recentQueries
  } = (0, _kea.useValues)(_.AnalyticsLogic);
  return /*#__PURE__*/_react.default.createElement(_analytics_layout.AnalyticsLayout, {
    isAnalyticsView: true,
    title: _constants.RECENT_QUERIES,
    breadcrumbs: [_constants.RECENT_QUERIES]
  }, /*#__PURE__*/_react.default.createElement(_components.AnalyticsSearch, null), /*#__PURE__*/_react.default.createElement(_components.RecentQueriesTable, {
    items: recentQueries
  }));
};
exports.RecentQueries = RecentQueries;